/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.manager;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.http.Part;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.DistributedManager;
import org.apache.catalina.Manager;
import org.apache.catalina.Session;
import org.apache.catalina.manager.Constants;
import org.apache.catalina.manager.DummyProxySession;
import org.apache.catalina.manager.JspHelper;
import org.apache.catalina.manager.ManagerServlet;
import org.apache.catalina.manager.util.BaseSessionComparator;
import org.apache.catalina.manager.util.SessionUtils;
import org.apache.catalina.util.ContextName;
import org.apache.catalina.util.ServerInfo;
import org.apache.catalina.util.URLEncoder;
import org.apache.tomcat.util.res.StringManager;
import org.apache.tomcat.util.security.Escape;

public final class HTMLManagerServlet
extends ManagerServlet {
    private static final long serialVersionUID = 1L;
    static final String APPLICATION_MESSAGE = "message";
    static final String APPLICATION_ERROR = "error";
    static final String sessionsListJspPath = "/WEB-INF/jsp/sessionsList.jsp";
    static final String sessionDetailJspPath = "/WEB-INF/jsp/sessionDetail.jsp";
    static final String connectorCiphersJspPath = "/WEB-INF/jsp/connectorCiphers.jsp";
    static final String connectorCertsJspPath = "/WEB-INF/jsp/connectorCerts.jsp";
    static final String connectorTrustedCertsJspPath = "/WEB-INF/jsp/connectorTrustedCerts.jsp";
    private boolean showProxySessions = false;
    private static final String APPS_HEADER_SECTION = "<table border=\"1\" cellspacing=\"0\" cellpadding=\"3\">\n<tr>\n <td colspan=\"6\" class=\"title\">{0}</td>\n</tr>\n<tr>\n <td class=\"header-left\"><small>{1}</small></td>\n <td class=\"header-left\"><small>{2}</small></td>\n <td class=\"header-center\"><small>{3}</small></td>\n <td class=\"header-center\"><small>{4}</small></td>\n <td class=\"header-left\"><small>{5}</small></td>\n <td class=\"header-left\"><small>{6}</small></td>\n</tr>\n";
    private static final String APPS_ROW_DETAILS_SECTION = "<tr>\n <td class=\"row-left\" bgcolor=\"{6}\" rowspan=\"2\"><small>{0}</small></td>\n <td class=\"row-left\" bgcolor=\"{6}\" rowspan=\"2\"><small>{1}</small></td>\n <td class=\"row-left\" bgcolor=\"{6}\" rowspan=\"2\"><small>{2}</small></td>\n <td class=\"row-center\" bgcolor=\"{6}\" rowspan=\"2\"><small>{3}</small></td>\n <td class=\"row-center\" bgcolor=\"{6}\" rowspan=\"2\"><small><a href=\"{4}\">{5}</a></small></td>\n";
    private static final String MANAGER_APP_ROW_BUTTON_SECTION = " <td class=\"row-left\" bgcolor=\"{13}\">\n  <small>\n  &nbsp;{1}&nbsp;\n  &nbsp;{3}&nbsp;\n  &nbsp;{5}&nbsp;\n  &nbsp;{7}&nbsp;\n  </small>\n </td>\n</tr><tr>\n <td class=\"row-left\" bgcolor=\"{13}\">\n  <form method=\"POST\" action=\"{8}\">\n  <small>\n  &nbsp;<input type=\"submit\" value=\"{9}\">&nbsp;{10}&nbsp;<input type=\"text\" name=\"idle\" size=\"5\" value=\"{11}\">&nbsp;{12}&nbsp;\n  </small>\n  </form>\n </td>\n</tr>\n";
    private static final String STARTED_DEPLOYED_APPS_ROW_BUTTON_SECTION = " <td class=\"row-left\" bgcolor=\"{13}\">\n  &nbsp;<small>{1}</small>&nbsp;\n  <form class=\"inline\" method=\"POST\" action=\"{2}\">  <small><input type=\"submit\" value=\"{3}\"></small>  </form>\n  <form class=\"inline\" method=\"POST\" action=\"{4}\">  <small><input type=\"submit\" value=\"{5}\"></small>  </form>\n  <form class=\"inline\" method=\"POST\" action=\"{6}\">  <small><input type=\"submit\" value=\"{7}\"></small>  </form>\n </td>\n </tr><tr>\n <td class=\"row-left\" bgcolor=\"{13}\">\n  <form method=\"POST\" action=\"{8}\">\n  <small>\n  &nbsp;<input type=\"submit\" value=\"{9}\">&nbsp;{10}&nbsp;<input type=\"text\" name=\"idle\" size=\"5\" value=\"{11}\">&nbsp;{12}&nbsp;\n  </small>\n  </form>\n </td>\n</tr>\n";
    private static final String STOPPED_DEPLOYED_APPS_ROW_BUTTON_SECTION = " <td class=\"row-left\" bgcolor=\"{13}\" rowspan=\"2\">\n  <form class=\"inline\" method=\"POST\" action=\"{0}\">  <small><input type=\"submit\" value=\"{1}\"></small>  </form>\n  &nbsp;<small>{3}</small>&nbsp;\n  &nbsp;<small>{5}</small>&nbsp;\n  <form class=\"inline\" method=\"POST\" action=\"{6}\">  <small><input type=\"submit\" value=\"{7}\"></small>  </form>\n </td>\n</tr>\n<tr></tr>\n";
    private static final String STARTED_NONDEPLOYED_APPS_ROW_BUTTON_SECTION = " <td class=\"row-left\" bgcolor=\"{13}\">\n  &nbsp;<small>{1}</small>&nbsp;\n  <form class=\"inline\" method=\"POST\" action=\"{2}\">  <small><input type=\"submit\" value=\"{3}\"></small>  </form>\n  <form class=\"inline\" method=\"POST\" action=\"{4}\">  <small><input type=\"submit\" value=\"{5}\"></small>  </form>\n  &nbsp;<small>{7}</small>&nbsp;\n </td>\n </tr><tr>\n <td class=\"row-left\" bgcolor=\"{13}\">\n  <form method=\"POST\" action=\"{8}\">\n  <small>\n  &nbsp;<input type=\"submit\" value=\"{9}\">&nbsp;{10}&nbsp;<input type=\"text\" name=\"idle\" size=\"5\" value=\"{11}\">&nbsp;{12}&nbsp;\n  </small>\n  </form>\n </td>\n</tr>\n";
    private static final String STOPPED_NONDEPLOYED_APPS_ROW_BUTTON_SECTION = " <td class=\"row-left\" bgcolor=\"{13}\" rowspan=\"2\">\n  <form class=\"inline\" method=\"POST\" action=\"{0}\">  <small><input type=\"submit\" value=\"{1}\"></small>  </form>\n  &nbsp;<small>{3}</small>&nbsp;\n  &nbsp;<small>{5}</small>&nbsp;\n  &nbsp;<small>{7}</small>&nbsp;\n </td>\n</tr>\n<tr></tr>\n";
    private static final String DEPLOY_SECTION = "</table>\n<br>\n<table border=\"1\" cellspacing=\"0\" cellpadding=\"3\">\n<tr>\n <td colspan=\"2\" class=\"title\">{0}</td>\n</tr>\n<tr>\n <td colspan=\"2\" class=\"header-left\"><small>{1}</small></td>\n</tr>\n<tr>\n <td colspan=\"2\">\n<form method=\"post\" action=\"{2}\">\n<table cellspacing=\"0\" cellpadding=\"3\">\n<tr>\n <td class=\"row-right\">\n  <small>{3}</small>\n </td>\n <td class=\"row-left\">\n  <input type=\"text\" name=\"deployPath\" size=\"20\">\n </td>\n</tr>\n<tr>\n <td class=\"row-right\">\n  <small>{4}</small>\n </td>\n <td class=\"row-left\">\n  <input type=\"text\" name=\"deployConfig\" size=\"20\">\n </td>\n</tr>\n<tr>\n <td class=\"row-right\">\n  <small>{5}</small>\n </td>\n <td class=\"row-left\">\n  <input type=\"text\" name=\"deployWar\" size=\"40\">\n </td>\n</tr>\n<tr>\n <td class=\"row-right\">\n  &nbsp;\n </td>\n <td class=\"row-left\">\n  <input type=\"submit\" value=\"{6}\">\n </td>\n</tr>\n</table>\n</form>\n</td>\n</tr>\n";
    private static final String UPLOAD_SECTION = "<tr>\n <td colspan=\"2\" class=\"header-left\"><small>{0}</small></td>\n</tr>\n<tr>\n <td colspan=\"2\">\n<form method=\"post\" action=\"{1}\" enctype=\"multipart/form-data\">\n<table cellspacing=\"0\" cellpadding=\"3\">\n<tr>\n <td class=\"row-right\">\n  <small>{2}</small>\n </td>\n <td class=\"row-left\">\n  <input type=\"file\" name=\"deployWar\" size=\"40\">\n </td>\n</tr>\n<tr>\n <td class=\"row-right\">\n  &nbsp;\n </td>\n <td class=\"row-left\">\n  <input type=\"submit\" value=\"{3}\">\n </td>\n</tr>\n</table>\n</form>\n</td>\n</tr>\n</table>\n<br>\n\n";
    private static final String CONFIG_SECTION = "<table border=\"1\" cellspacing=\"0\" cellpadding=\"3\">\n<tr>\n <td colspan=\"2\" class=\"title\">{0}</td>\n</tr>\n<tr>\n <td colspan=\"2\" class=\"header-left\"><small>{1}</small></td>\n</tr>\n<tr>\n <td colspan=\"2\">\n<form method=\"post\" action=\"{2}\">\n<table cellspacing=\"0\" cellpadding=\"3\">\n<tr>\n <td class=\"row-right\">\n  <small>{3}</small>\n </td>\n <td class=\"row-left\">\n  <input type=\"text\" name=\"tlsHostName\" size=\"20\">\n </td>\n</tr>\n<tr>\n <td class=\"row-right\">\n  &nbsp;\n </td>\n <td class=\"row-left\">\n  <input type=\"submit\" value=\"{4}\">\n </td>\n</tr>\n</table>\n</form>\n</td>\n</tr>\n</table>\n<br>";
    private static final String DIAGNOSTICS_SECTION = "<table border=\"1\" cellspacing=\"0\" cellpadding=\"3\">\n<tr>\n <td colspan=\"2\" class=\"title\">{0}</td>\n</tr>\n<tr>\n <td colspan=\"2\" class=\"header-left\"><small>{1}</small></td>\n</tr>\n<tr>\n <td class=\"row-left\">\n  <form method=\"post\" action=\"{2}\">\n   <input type=\"submit\" value=\"{4}\">\n  </form>\n </td>\n <td class=\"row-left\">\n  <small>{3}</small>\n </td>\n</tr>\n<tr>\n <td colspan=\"2\" class=\"header-left\"><small>{5}</small></td>\n</tr>\n<tr>\n <td class=\"row-left\">\n  <form method=\"post\" action=\"{6}\">\n   <input type=\"submit\" value=\"{7}\">\n  </form>\n </td>\n <td class=\"row-left\">\n  <small>{8}</small>\n </td>\n</tr>\n<tr>\n <td class=\"row-left\">\n  <form method=\"post\" action=\"{9}\">\n   <input type=\"submit\" value=\"{10}\">\n  </form>\n </td>\n <td class=\"row-left\">\n  <small>{11}</small>\n </td>\n</tr>\n<tr>\n <td class=\"row-left\">\n  <form method=\"post\" action=\"{12}\">\n   <input type=\"submit\" value=\"{13}\">\n  </form>\n </td>\n <td class=\"row-left\">\n  <small>{14}</small>\n </td>\n</tr>\n</table>\n<br>";

    @Override
    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        StringManager smClient = StringManager.getManager("org.apache.catalina.manager", request.getLocales());
        String command = request.getPathInfo();
        String path = request.getParameter("path");
        ContextName cn = null;
        if (path != null) {
            cn = new ContextName(path, request.getParameter("version"));
        }
        response.setContentType("text/html; charset=utf-8");
        String message = "";
        if (command != null && !command.equals("/") && !command.equals("/list")) {
            if (command.equals("/sessions")) {
                try {
                    this.doSessions(cn, request, response, smClient);
                    return;
                }
                catch (Exception e) {
                    this.log("HTMLManagerServlet.sessions[" + cn + "]", e);
                    message = smClient.getString("managerServlet.exception", e.toString());
                }
            } else if (command.equals("/sslConnectorCiphers")) {
                this.sslConnectorCiphers(request, response);
            } else if (command.equals("/sslConnectorCerts")) {
                this.sslConnectorCerts(request, response);
            } else if (command.equals("/sslConnectorTrustedCerts")) {
                this.sslConnectorTrustedCerts(request, response);
            } else {
                message = command.equals("/upload") || command.equals("/deploy") || command.equals("/reload") || command.equals("/undeploy") || command.equals("/expire") || command.equals("/start") || command.equals("/stop") ? smClient.getString("managerServlet.postCommand", command) : smClient.getString("managerServlet.unknownCommand", command);
            }
        }
        this.list(request, response, message, smClient);
    }

    @Override
    public void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        StringManager smClient = StringManager.getManager("org.apache.catalina.manager", request.getLocales());
        String command = request.getPathInfo();
        String path = request.getParameter("path");
        ContextName cn = null;
        if (path != null) {
            cn = new ContextName(path, request.getParameter("version"));
        }
        String deployPath = request.getParameter("deployPath");
        ContextName deployCn = null;
        if (deployPath != null) {
            deployCn = new ContextName(deployPath, request.getParameter("deployVersion"));
        }
        String deployConfig = request.getParameter("deployConfig");
        String deployWar = request.getParameter("deployWar");
        String tlsHostName = request.getParameter("tlsHostName");
        response.setContentType("text/html; charset=utf-8");
        String message = "";
        if (command != null && command.length() != 0) {
            if (command.equals("/upload")) {
                message = this.upload(request, smClient);
            } else if (command.equals("/deploy")) {
                message = this.deployInternal(deployConfig, deployCn, deployWar, smClient);
            } else if (command.equals("/reload")) {
                message = this.reload(cn, smClient);
            } else if (command.equals("/undeploy")) {
                message = this.undeploy(cn, smClient);
            } else if (command.equals("/expire")) {
                message = this.expireSessions(cn, request, smClient);
            } else if (command.equals("/start")) {
                message = this.start(cn, smClient);
            } else if (command.equals("/stop")) {
                message = this.stop(cn, smClient);
            } else if (command.equals("/findleaks")) {
                message = this.findleaks(smClient);
            } else if (command.equals("/sslReload")) {
                message = this.sslReload(tlsHostName, smClient);
            } else {
                this.doGet(request, response);
                return;
            }
        }
        this.list(request, response, message, smClient);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String upload(HttpServletRequest request, StringManager smClient) {
        String message;
        block12: {
            message = "";
            try {
                File file;
                Part warPart = request.getPart("deployWar");
                if (warPart == null) {
                    message = smClient.getString("htmlManagerServlet.deployUploadNoFile");
                    break block12;
                }
                String filename = warPart.getSubmittedFileName();
                if (!filename.toLowerCase(Locale.ENGLISH).endsWith(".war")) {
                    message = smClient.getString("htmlManagerServlet.deployUploadNotWar", filename);
                    break block12;
                }
                if (filename.lastIndexOf(92) >= 0) {
                    filename = filename.substring(filename.lastIndexOf(92) + 1);
                }
                if (filename.lastIndexOf(47) >= 0) {
                    filename = filename.substring(filename.lastIndexOf(47) + 1);
                }
                if ((file = new File(this.host.getAppBaseFile(), filename)).exists()) {
                    message = smClient.getString("htmlManagerServlet.deployUploadWarExists", filename);
                    break block12;
                }
                ContextName cn = new ContextName(filename, true);
                String name = cn.getName();
                if (this.host.findChild(name) != null && !this.isDeployed(name)) {
                    message = smClient.getString("htmlManagerServlet.deployUploadInServerXml", filename);
                    break block12;
                }
                if (this.isServiced(name)) {
                    message = smClient.getString("managerServlet.inService", name);
                    break block12;
                }
                this.addServiced(name);
                try {
                    warPart.write(file.getAbsolutePath());
                    this.check(name);
                }
                finally {
                    this.removeServiced(name);
                }
            }
            catch (Exception e) {
                message = smClient.getString("htmlManagerServlet.deployUploadFail", e.getMessage());
                this.log(message, e);
            }
        }
        return message;
    }

    protected String deployInternal(String config, ContextName cn, String war, StringManager smClient) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        super.deploy(printWriter, config, cn, war, false, smClient);
        return stringWriter.toString();
    }

    protected void list(HttpServletRequest request, HttpServletResponse response, String message, StringManager smClient) throws IOException {
        if (this.debug >= 1) {
            this.log("list: Listing contexts for virtual host '" + this.host.getName() + "'");
        }
        PrintWriter writer = response.getWriter();
        writer.print(Constants.HTML_HEADER_SECTION);
        Object[] args = new Object[]{request.getContextPath(), smClient.getString("htmlManagerServlet.title")};
        writer.print(MessageFormat.format(Constants.BODY_HEADER_SECTION, args));
        args = new Object[3];
        args[0] = smClient.getString("htmlManagerServlet.messageLabel");
        args[1] = message == null || message.length() == 0 ? "OK" : Escape.htmlElementContent(message);
        writer.print(MessageFormat.format(Constants.MESSAGE_SECTION, args));
        args = new Object[]{smClient.getString("htmlManagerServlet.manager"), response.encodeURL(request.getContextPath() + "/html/list"), smClient.getString("htmlManagerServlet.list"), response.encodeURL(request.getContextPath() + "/" + smClient.getString("htmlManagerServlet.helpHtmlManagerFile")), smClient.getString("htmlManagerServlet.helpHtmlManager"), response.encodeURL(request.getContextPath() + "/" + smClient.getString("htmlManagerServlet.helpManagerFile")), smClient.getString("htmlManagerServlet.helpManager"), response.encodeURL(request.getContextPath() + "/status"), smClient.getString("statusServlet.title")};
        writer.print(MessageFormat.format(Constants.MANAGER_SECTION, args));
        args = new Object[]{smClient.getString("htmlManagerServlet.appsTitle"), smClient.getString("htmlManagerServlet.appsPath"), smClient.getString("htmlManagerServlet.appsVersion"), smClient.getString("htmlManagerServlet.appsName"), smClient.getString("htmlManagerServlet.appsAvailable"), smClient.getString("htmlManagerServlet.appsSessions"), smClient.getString("htmlManagerServlet.appsTasks")};
        writer.print(MessageFormat.format(APPS_HEADER_SECTION, args));
        Container[] children = this.host.findChildren();
        Object[] contextNames = new String[children.length];
        for (int i = 0; i < children.length; ++i) {
            contextNames[i] = children[i].getName();
        }
        Arrays.sort(contextNames);
        String appsStart = smClient.getString("htmlManagerServlet.appsStart");
        String appsStop = smClient.getString("htmlManagerServlet.appsStop");
        String appsReload = smClient.getString("htmlManagerServlet.appsReload");
        String appsUndeploy = smClient.getString("htmlManagerServlet.appsUndeploy");
        String appsExpire = smClient.getString("htmlManagerServlet.appsExpire");
        String noVersion = "<i>" + smClient.getString("htmlManagerServlet.noVersion") + "</i>";
        boolean isHighlighted = true;
        boolean isDeployed = true;
        String highlightColor = null;
        for (Object contextName : contextNames) {
            Context ctxt = (Context)this.host.findChild((String)contextName);
            if (ctxt == null) continue;
            isHighlighted = !isHighlighted;
            highlightColor = isHighlighted ? "#C3F3C3" : "#FFFFFF";
            String contextPath = ctxt.getPath();
            String displayPath = contextPath;
            if (displayPath.equals("")) {
                displayPath = "/";
            }
            StringBuilder tmp = new StringBuilder();
            tmp.append("path=");
            tmp.append(URLEncoder.DEFAULT.encode(displayPath, StandardCharsets.UTF_8));
            if (ctxt.getWebappVersion().length() > 0) {
                tmp.append("&version=");
                tmp.append(URLEncoder.DEFAULT.encode(ctxt.getWebappVersion(), StandardCharsets.UTF_8));
            }
            String pathVersion = tmp.toString();
            try {
                isDeployed = this.isDeployed((String)contextName);
            }
            catch (Exception e) {
                isDeployed = false;
            }
            args = new Object[7];
            args[0] = "<a href=\"" + URLEncoder.DEFAULT.encode(contextPath + "/", StandardCharsets.UTF_8) + "\">" + Escape.htmlElementContent(displayPath) + "</a>";
            args[1] = "".equals(ctxt.getWebappVersion()) ? noVersion : Escape.htmlElementContent(ctxt.getWebappVersion());
            args[2] = ctxt.getDisplayName() == null ? "&nbsp;" : Escape.htmlElementContent(ctxt.getDisplayName());
            args[3] = ctxt.getState().isAvailable();
            args[4] = Escape.htmlElementContent(response.encodeURL(request.getContextPath() + "/html/sessions?" + pathVersion));
            Manager manager = ctxt.getManager();
            args[5] = manager instanceof DistributedManager && this.showProxySessions ? Integer.valueOf(((DistributedManager)((Object)manager)).getActiveSessionsFull()) : (manager != null ? Integer.valueOf(manager.getActiveSessions()) : Integer.valueOf(0));
            args[6] = highlightColor;
            writer.print(MessageFormat.format(APPS_ROW_DETAILS_SECTION, args));
            args = new Object[]{Escape.htmlElementContent(response.encodeURL(request.getContextPath() + "/html/start?" + pathVersion)), appsStart, Escape.htmlElementContent(response.encodeURL(request.getContextPath() + "/html/stop?" + pathVersion)), appsStop, Escape.htmlElementContent(response.encodeURL(request.getContextPath() + "/html/reload?" + pathVersion)), appsReload, Escape.htmlElementContent(response.encodeURL(request.getContextPath() + "/html/undeploy?" + pathVersion)), appsUndeploy, Escape.htmlElementContent(response.encodeURL(request.getContextPath() + "/html/expire?" + pathVersion)), appsExpire, smClient.getString("htmlManagerServlet.expire.explain"), manager == null ? smClient.getString("htmlManagerServlet.noManager") : Integer.valueOf(ctxt.getSessionTimeout()), smClient.getString("htmlManagerServlet.expire.unit"), highlightColor};
            if (ctxt.getName().equals(this.context.getName())) {
                writer.print(MessageFormat.format(MANAGER_APP_ROW_BUTTON_SECTION, args));
                continue;
            }
            if (ctxt.getState().isAvailable() && isDeployed) {
                writer.print(MessageFormat.format(STARTED_DEPLOYED_APPS_ROW_BUTTON_SECTION, args));
                continue;
            }
            if (ctxt.getState().isAvailable() && !isDeployed) {
                writer.print(MessageFormat.format(STARTED_NONDEPLOYED_APPS_ROW_BUTTON_SECTION, args));
                continue;
            }
            if (!ctxt.getState().isAvailable() && isDeployed) {
                writer.print(MessageFormat.format(STOPPED_DEPLOYED_APPS_ROW_BUTTON_SECTION, args));
                continue;
            }
            writer.print(MessageFormat.format(STOPPED_NONDEPLOYED_APPS_ROW_BUTTON_SECTION, args));
        }
        args = new Object[]{smClient.getString("htmlManagerServlet.deployTitle"), smClient.getString("htmlManagerServlet.deployServer"), response.encodeURL(request.getContextPath() + "/html/deploy"), smClient.getString("htmlManagerServlet.deployPath"), smClient.getString("htmlManagerServlet.deployConfig"), smClient.getString("htmlManagerServlet.deployWar"), smClient.getString("htmlManagerServlet.deployButton")};
        writer.print(MessageFormat.format(DEPLOY_SECTION, args));
        args = new Object[]{smClient.getString("htmlManagerServlet.deployUpload"), response.encodeURL(request.getContextPath() + "/html/upload"), smClient.getString("htmlManagerServlet.deployUploadFile"), smClient.getString("htmlManagerServlet.deployButton")};
        writer.print(MessageFormat.format(UPLOAD_SECTION, args));
        args = new Object[]{smClient.getString("htmlManagerServlet.configTitle"), smClient.getString("htmlManagerServlet.configSslReloadTitle"), response.encodeURL(request.getContextPath() + "/html/sslReload"), smClient.getString("htmlManagerServlet.configSslHostName"), smClient.getString("htmlManagerServlet.configReloadButton")};
        writer.print(MessageFormat.format(CONFIG_SECTION, args));
        args = new Object[]{smClient.getString("htmlManagerServlet.diagnosticsTitle"), smClient.getString("htmlManagerServlet.diagnosticsLeak"), response.encodeURL(request.getContextPath() + "/html/findleaks"), smClient.getString("htmlManagerServlet.diagnosticsLeakWarning"), smClient.getString("htmlManagerServlet.diagnosticsLeakButton"), smClient.getString("htmlManagerServlet.diagnosticsSsl"), response.encodeURL(request.getContextPath() + "/html/sslConnectorCiphers"), smClient.getString("htmlManagerServlet.diagnosticsSslConnectorCipherButton"), smClient.getString("htmlManagerServlet.diagnosticsSslConnectorCipherText"), response.encodeURL(request.getContextPath() + "/html/sslConnectorCerts"), smClient.getString("htmlManagerServlet.diagnosticsSslConnectorCertsButton"), smClient.getString("htmlManagerServlet.diagnosticsSslConnectorCertsText"), response.encodeURL(request.getContextPath() + "/html/sslConnectorTrustedCerts"), smClient.getString("htmlManagerServlet.diagnosticsSslConnectorTrustedCertsButton"), smClient.getString("htmlManagerServlet.diagnosticsSslConnectorTrustedCertsText")};
        writer.print(MessageFormat.format(DIAGNOSTICS_SECTION, args));
        args = new Object[]{smClient.getString("htmlManagerServlet.serverTitle"), smClient.getString("htmlManagerServlet.serverVersion"), smClient.getString("htmlManagerServlet.serverJVMVersion"), smClient.getString("htmlManagerServlet.serverJVMVendor"), smClient.getString("htmlManagerServlet.serverOSName"), smClient.getString("htmlManagerServlet.serverOSVersion"), smClient.getString("htmlManagerServlet.serverOSArch"), smClient.getString("htmlManagerServlet.serverHostname"), smClient.getString("htmlManagerServlet.serverIPAddress")};
        writer.print(MessageFormat.format(Constants.SERVER_HEADER_SECTION, args));
        args = new Object[8];
        args[0] = ServerInfo.getServerInfo();
        args[1] = System.getProperty("java.runtime.version");
        args[2] = System.getProperty("java.vm.vendor");
        args[3] = System.getProperty("os.name");
        args[4] = System.getProperty("os.version");
        args[5] = System.getProperty("os.arch");
        try {
            InetAddress address = InetAddress.getLocalHost();
            args[6] = address.getHostName();
            args[7] = address.getHostAddress();
        }
        catch (UnknownHostException e) {
            args[6] = "-";
            args[7] = "-";
        }
        writer.print(MessageFormat.format(Constants.SERVER_ROW_SECTION, args));
        writer.print(Constants.HTML_TAIL_SECTION);
        writer.flush();
        writer.close();
    }

    protected String reload(ContextName cn, StringManager smClient) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        super.reload(printWriter, cn, smClient);
        return stringWriter.toString();
    }

    protected String undeploy(ContextName cn, StringManager smClient) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        super.undeploy(printWriter, cn, smClient);
        return stringWriter.toString();
    }

    protected String sessions(ContextName cn, int idle, StringManager smClient) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        super.sessions(printWriter, cn, idle, smClient);
        return stringWriter.toString();
    }

    protected String start(ContextName cn, StringManager smClient) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        super.start(printWriter, cn, smClient);
        return stringWriter.toString();
    }

    protected String stop(ContextName cn, StringManager smClient) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        super.stop(printWriter, cn, smClient);
        return stringWriter.toString();
    }

    protected String findleaks(StringManager smClient) {
        StringBuilder msg = new StringBuilder();
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        super.findleaks(false, printWriter, smClient);
        String writerText = stringWriter.toString();
        if (writerText.length() > 0) {
            if (!writerText.startsWith("FAIL -")) {
                msg.append(smClient.getString("htmlManagerServlet.findleaksList"));
            }
            msg.append(writerText);
        } else {
            msg.append(smClient.getString("htmlManagerServlet.findleaksNone"));
        }
        return msg.toString();
    }

    protected String sslReload(String tlsHostName, StringManager smClient) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        super.sslReload(printWriter, tlsHostName, smClient);
        return stringWriter.toString();
    }

    protected void sslConnectorCiphers(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        request.setAttribute("cipherList", this.getConnectorCiphers());
        this.getServletContext().getRequestDispatcher(connectorCiphersJspPath).forward(request, response);
    }

    protected void sslConnectorCerts(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        request.setAttribute("certList", this.getConnectorCerts());
        this.getServletContext().getRequestDispatcher(connectorCertsJspPath).forward(request, response);
    }

    protected void sslConnectorTrustedCerts(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        request.setAttribute("trustedCertList", this.getConnectorTrustedCerts());
        this.getServletContext().getRequestDispatcher(connectorTrustedCertsJspPath).forward(request, response);
    }

    @Override
    public String getServletInfo() {
        return "HTMLManagerServlet, Copyright (c) 1999-2018, The Apache Software Foundation";
    }

    @Override
    public void init() throws ServletException {
        super.init();
        String value = null;
        value = this.getServletConfig().getInitParameter("showProxySessions");
        this.showProxySessions = Boolean.parseBoolean(value);
    }

    protected String expireSessions(ContextName cn, HttpServletRequest req, StringManager smClient) {
        int idle = -1;
        String idleParam = req.getParameter("idle");
        if (idleParam != null) {
            try {
                idle = Integer.parseInt(idleParam);
            }
            catch (NumberFormatException e) {
                this.log("Could not parse idle parameter to an int: " + idleParam);
            }
        }
        return this.sessions(cn, idle, smClient);
    }

    protected void doSessions(ContextName cn, HttpServletRequest req, HttpServletResponse resp, StringManager smClient) throws ServletException, IOException {
        req.setAttribute("path", cn.getPath());
        req.setAttribute("version", cn.getVersion());
        String action = req.getParameter("action");
        if (this.debug >= 1) {
            this.log("sessions: Session action '" + action + "' for web application '" + cn.getDisplayName() + "'");
        }
        if ("sessionDetail".equals(action)) {
            String sessionId = req.getParameter("sessionId");
            this.displaySessionDetailPage(req, resp, cn, sessionId, smClient);
            return;
        }
        if ("invalidateSessions".equals(action)) {
            String[] sessionIds = req.getParameterValues("sessionIds");
            int i = this.invalidateSessions(cn, sessionIds, smClient);
            req.setAttribute(APPLICATION_MESSAGE, "" + i + " sessions invalidated.");
        } else if ("removeSessionAttribute".equals(action)) {
            String name;
            String sessionId = req.getParameter("sessionId");
            boolean removed = this.removeSessionAttribute(cn, sessionId, name = req.getParameter("attributeName"), smClient);
            String outMessage = removed ? "Session attribute '" + name + "' removed." : "Session did not contain any attribute named '" + name + "'";
            req.setAttribute(APPLICATION_MESSAGE, outMessage);
            this.displaySessionDetailPage(req, resp, cn, sessionId, smClient);
            return;
        }
        this.displaySessionsListPage(cn, req, resp, smClient);
    }

    protected List<Session> getSessionsForName(ContextName cn, StringManager smClient) {
        if (cn == null || !cn.getPath().startsWith("/") && !cn.getPath().equals("")) {
            String path = null;
            if (cn != null) {
                path = cn.getPath();
            }
            throw new IllegalArgumentException(smClient.getString("managerServlet.invalidPath", Escape.htmlElementContent(path)));
        }
        Context ctxt = (Context)this.host.findChild(cn.getName());
        if (null == ctxt) {
            throw new IllegalArgumentException(smClient.getString("managerServlet.noContext", Escape.htmlElementContent(cn.getDisplayName())));
        }
        Manager manager = ctxt.getManager();
        ArrayList<Session> sessions = new ArrayList<Session>();
        sessions.addAll(Arrays.asList(manager.findSessions()));
        if (manager instanceof DistributedManager && this.showProxySessions) {
            Set<String> sessionIds = ((DistributedManager)((Object)manager)).getSessionIdsFull();
            for (Session session : sessions) {
                sessionIds.remove(session.getId());
            }
            for (String sessionId : sessionIds) {
                sessions.add(new DummyProxySession(sessionId));
            }
        }
        return sessions;
    }

    protected Session getSessionForNameAndId(ContextName cn, String id, StringManager smClient) {
        List<Session> sessions = this.getSessionsForName(cn, smClient);
        if (sessions.isEmpty()) {
            return null;
        }
        for (Session session : sessions) {
            if (!session.getId().equals(id)) continue;
            return session;
        }
        return null;
    }

    protected void displaySessionsListPage(ContextName cn, HttpServletRequest req, HttpServletResponse resp, StringManager smClient) throws ServletException, IOException {
        List<Session> sessions = this.getSessionsForName(cn, smClient);
        String sortBy = req.getParameter("sort");
        String orderBy = null;
        if (null != sortBy && !"".equals(sortBy.trim())) {
            Comparator<Session> comparator = this.getComparator(sortBy);
            if (comparator != null) {
                orderBy = req.getParameter("order");
                if ("DESC".equalsIgnoreCase(orderBy)) {
                    comparator = Collections.reverseOrder(comparator);
                    orderBy = "ASC";
                } else {
                    orderBy = "DESC";
                }
                try {
                    Collections.sort(sessions, comparator);
                }
                catch (IllegalStateException ise) {
                    req.setAttribute(APPLICATION_ERROR, "Can't sort session list: one session is invalidated");
                }
            } else {
                this.log("WARNING: unknown sort order: " + sortBy);
            }
        }
        req.setAttribute("sort", sortBy);
        req.setAttribute("order", orderBy);
        req.setAttribute("activeSessions", sessions);
        resp.setHeader("Pragma", "No-cache");
        resp.setHeader("Cache-Control", "no-cache,no-store,max-age=0");
        resp.setDateHeader("Expires", 0L);
        this.getServletContext().getRequestDispatcher(sessionsListJspPath).include(req, resp);
    }

    protected void displaySessionDetailPage(HttpServletRequest req, HttpServletResponse resp, ContextName cn, String sessionId, StringManager smClient) throws ServletException, IOException {
        Session session = this.getSessionForNameAndId(cn, sessionId, smClient);
        resp.setHeader("Pragma", "No-cache");
        resp.setHeader("Cache-Control", "no-cache,no-store,max-age=0");
        resp.setDateHeader("Expires", 0L);
        req.setAttribute("currentSession", session);
        this.getServletContext().getRequestDispatcher(resp.encodeURL(sessionDetailJspPath)).include(req, resp);
    }

    protected int invalidateSessions(ContextName cn, String[] sessionIds, StringManager smClient) {
        if (null == sessionIds) {
            return 0;
        }
        int nbAffectedSessions = 0;
        for (int i = 0; i < sessionIds.length; ++i) {
            String sessionId = sessionIds[i];
            HttpSession session = this.getSessionForNameAndId(cn, sessionId, smClient).getSession();
            if (null == session) {
                if (this.debug < 1) continue;
                this.log("WARNING: can't invalidate null session " + sessionId);
                continue;
            }
            try {
                session.invalidate();
                ++nbAffectedSessions;
                if (this.debug < 1) continue;
                this.log("Invalidating session id " + sessionId);
                continue;
            }
            catch (IllegalStateException ise) {
                if (this.debug < 1) continue;
                this.log("Can't invalidate already invalidated session id " + sessionId);
            }
        }
        return nbAffectedSessions;
    }

    protected boolean removeSessionAttribute(ContextName cn, String sessionId, String attributeName, StringManager smClient) {
        boolean wasPresent;
        block4: {
            HttpSession session = this.getSessionForNameAndId(cn, sessionId, smClient).getSession();
            if (null == session) {
                if (this.debug >= 1) {
                    this.log("WARNING: can't remove attribute '" + attributeName + "' for null session " + sessionId);
                }
                return false;
            }
            wasPresent = null != session.getAttribute(attributeName);
            try {
                session.removeAttribute(attributeName);
            }
            catch (IllegalStateException ise) {
                if (this.debug < 1) break block4;
                this.log("Can't remote attribute '" + attributeName + "' for invalidated session id " + sessionId);
            }
        }
        return wasPresent;
    }

    protected Comparator<Session> getComparator(String sortBy) {
        BaseSessionComparator<Object> comparator = null;
        if ("CreationTime".equalsIgnoreCase(sortBy)) {
            comparator = new BaseSessionComparator<Date>(){

                @Override
                public Comparable<Date> getComparableObject(Session session) {
                    return new Date(session.getCreationTime());
                }
            };
        } else if ("id".equalsIgnoreCase(sortBy)) {
            comparator = new BaseSessionComparator<String>(){

                @Override
                public Comparable<String> getComparableObject(Session session) {
                    return session.getId();
                }
            };
        } else if ("LastAccessedTime".equalsIgnoreCase(sortBy)) {
            comparator = new BaseSessionComparator<Date>(){

                @Override
                public Comparable<Date> getComparableObject(Session session) {
                    return new Date(session.getLastAccessedTime());
                }
            };
        } else if ("MaxInactiveInterval".equalsIgnoreCase(sortBy)) {
            comparator = new BaseSessionComparator<Integer>(){

                @Override
                public Comparable<Integer> getComparableObject(Session session) {
                    return session.getMaxInactiveInterval();
                }
            };
        } else if ("new".equalsIgnoreCase(sortBy)) {
            comparator = new BaseSessionComparator<Boolean>(){

                @Override
                public Comparable<Boolean> getComparableObject(Session session) {
                    return session.getSession().isNew();
                }
            };
        } else if ("locale".equalsIgnoreCase(sortBy)) {
            comparator = new BaseSessionComparator<String>(){

                @Override
                public Comparable<String> getComparableObject(Session session) {
                    return JspHelper.guessDisplayLocaleFromSession(session);
                }
            };
        } else if ("user".equalsIgnoreCase(sortBy)) {
            comparator = new BaseSessionComparator<String>(){

                @Override
                public Comparable<String> getComparableObject(Session session) {
                    return JspHelper.guessDisplayUserFromSession(session);
                }
            };
        } else if ("UsedTime".equalsIgnoreCase(sortBy)) {
            comparator = new BaseSessionComparator<Date>(){

                @Override
                public Comparable<Date> getComparableObject(Session session) {
                    return new Date(SessionUtils.getUsedTimeForSession(session));
                }
            };
        } else if ("InactiveTime".equalsIgnoreCase(sortBy)) {
            comparator = new BaseSessionComparator<Date>(){

                @Override
                public Comparable<Date> getComparableObject(Session session) {
                    return new Date(SessionUtils.getInactiveTimeForSession(session));
                }
            };
        } else if ("TTL".equalsIgnoreCase(sortBy)) {
            comparator = new BaseSessionComparator<Date>(){

                @Override
                public Comparable<Date> getComparableObject(Session session) {
                    return new Date(SessionUtils.getTTLForSession(session));
                }
            };
        }
        return comparator;
    }
}

