"use strict";

var WorldBreditorScreen = function(_parent)
{
	this.mSQHandle = null;
	this.mRoster = null;
	this.mTraits = null;
	this.mBackgrounds = null;
	this.mNItems = null;
	this.mData = null; //data on current bro, not everyone
	this.mMode = null;
	
	// generic containers
	this.mContainer = null;
    this.mDialogContainer = null;
    this.mListContainer = null;
    this.mListScrollContainer = null;
    this.mDetailsPanel = {
        Container: null,
        CharacterName: null,
    };
    this.mNamedItemsPanel = {
        Container: null,
		Image: null,
        Rows: 	[
		[{Row: null},{TypeButton: null, TBValue: 0},{NINameInput: null, NIName: 0, NIVariant: 0},{NIFinButton: null},{BroExpImpInput: null, MainS: true, LifeStats: false, Gear: false},],
		[{Row: null},{TypeButton: null, TBValue: 0},{SWButton: null, SWBValue: 0},{SInput: null, SIValue: 0, SIName: 0},{FreeSpaceText: null},],
		],
		BioInput: null,
    };

	// controls
	this.mStatsOptions =
	{
		Hitpoints:
		{
			SVal: null,
			DownButton: null,
			UpButton: null,
			TalentButton: null,
			IconPath: Path.GFX + Asset.ICON_HEALTH,
			TooltipId: TooltipIdentifier.CharacterStats.Hitpoints,
			//R: null,
		},
		Stamina:
		{
			SVal: null,
			DownButton: null,
			UpButton: null,
			TalentButton: null,
			IconPath: Path.GFX + Asset.ICON_FATIGUE,
			TooltipId: TooltipIdentifier.CharacterStats.Fatigue,
			//R: null,
		},
		Initiative:
		{
			SVal: null,
			DownButton: null,
			UpButton: null,
			TalentButton: null,
			IconPath: Path.GFX + Asset.ICON_INITIATIVE,
			TooltipId: TooltipIdentifier.CharacterStats.Initiative,
			//R: null,
		},
		Bravery:
		{
			SVal: null,
			DownButton: null,
			UpButton: null,
			TalentButton: null,
			IconPath: Path.GFX + Asset.ICON_BRAVERY,
			TooltipId: TooltipIdentifier.CharacterStats.Bravery,
			//R: null,
		},
		MeleeSkill:
		{
			SVal: null,
			DownButton: null,
			UpButton: null,
			TalentButton: null,
			IconPath: Path.GFX + Asset.ICON_MELEE_SKILL,
			TooltipId: TooltipIdentifier.CharacterStats.MeleeSkill,
			//R: null,
		},
		RangedSkill:
		{
			SVal: null,
			DownButton: null,
			UpButton: null,
			TalentButton: null,
			IconPath: Path.GFX + Asset.ICON_RANGE_SKILL,
			TooltipId: TooltipIdentifier.CharacterStats.RangeSkill,
			//R: null,
		},
		MeleeDefense:
		{
			SVal: null,
			DownButton: null,
			UpButton: null,
			TalentButton: null,
			IconPath: Path.GFX + Asset.ICON_MELEE_DEFENCE,
			TooltipId: TooltipIdentifier.CharacterStats.MeleeDefense,
			//R: null,
		},
		RangedDefense:
		{
			SVal: null,
			DownButton: null,
			UpButton: null,
			TalentButton: null,
			IconPath: Path.GFX + Asset.ICON_RANGE_DEFENCE,
			TooltipId: TooltipIdentifier.CharacterStats.RangeDefense,
			//R: null,
		},
		ActionPoints:
		{
			SVal: null,
			DownButton: null,
			UpButton: null,
			IconPath: Path.GFX + Asset.ICON_ACTION_POINTS,
			TooltipId: TooltipIdentifier.CharacterStats.ActionPoints,
			//R: null,
		},
		DailyWage:
		{
			SVal: null,
			DownButton: null,
			UpButton: null,
			IconPath: Path.GFX +  'ui/icons/breditor_dm.png',
			TooltipId: TooltipIdentifier.Assets.DailyMoney,
			//R: null,
		},
		DailyFood:
		{
			SVal: null,
			DownButton: null,
			UpButton: null,
			IconPath: Path.GFX + 'ui/icons/breditor_df.png',
			TooltipId: TooltipIdentifier.Assets.DailyFood,
			//R: null,
		},
		PerkPoints:
		{
			SVal: null,
			DownButton: null,
			UpButton: null,
			IconPath: Path.GFX + 'ui/icons/special.png',
			TooltipId: 'breditor-pp-tooltip',
			//R: null,
		},
	};
	
	this.mTraitOptions =
	[
		[{Row: null},{Container: null,Image: null},{Container: null,Image: null},{Container: null,Image: null},{Container: null,Image: null},{Container: null,Image: null},{Container: null,Image: null},{Container: null,Image: null}],
		[{Row: null},{Container: null,Image: null},{Container: null,Image: null},{Container: null,Image: null},{Container: null,Image: null},{Container: null,Image: null},{Container: null,Image: null},{Container: null,Image: null}],
		[{Row: null},{Container: null,Image: null},{Container: null,Image: null},{Container: null,Image: null},{Container: null,Image: null},{Container: null,Image: null},{Container: null,Image: null},{Container: null,Image: null}],
		[{Row: null},{Container: null,Image: null},{Container: null,Image: null},{Container: null,Image: null},{Container: null,Image: null},{Container: null,Image: null},{Container: null,Image: null},{Container: null,Image: null}],
		[{Row: null},{Container: null,Image: null},{Container: null,Image: null},{Container: null,Image: null},{Container: null,Image: null},{Container: null,Image: null},{Container: null,Image: null},{Container: null,Image: null}],
		[{Row: null},{Container: null,Image: null},{Container: null,Image: null},{Container: null,Image: null},{Container: null,Image: null},{Container: null,Image: null},{Container: null,Image: null},{Container: null,Image: null}],
		[{Row: null},{Container: null,Image: null},{Container: null,Image: null},{Container: null,Image: null},{Container: null,Image: null},{Container: null,Image: null},{Container: null,Image: null},{Container: null,Image: null}],
		[{Row: null},{Container: null,Image: null},{Container: null,Image: null},{Container: null,Image: null},{Container: null,Image: null},{Container: null,Image: null},{Container: null,Image: null},{Container: null,Image: null}],
		[{Row: null},{Container: null,Image: null},{Container: null,Image: null},{Container: null,Image: null},{Container: null,Image: null},{Container: null,Image: null},{Container: null,Image: null},{Container: null,Image: null}],
		[{Row: null},{Container: null,Image: null},{Container: null,Image: null},{Container: null,Image: null},{Container: null,Image: null},{Container: null,Image: null},{Container: null,Image: null},{Container: null,Image: null}],
		[{Row: null},{Container: null,Image: null},{Container: null,Image: null},{Container: null,Image: null},{Container: null,Image: null},{Container: null,Image: null},{Container: null,Image: null},{Container: null,Image: null}],
		[{Row: null},{Container: null,Image: null},{Container: null,Image: null},{Container: null,Image: null},{Container: null,Image: null},{Container: null,Image: null},{Container: null,Image: null},{Container: null,Image: null}],
		[{Row: null},{Container: null,Image: null},{Container: null,Image: null},{Container: null,Image: null},{Container: null,Image: null},{Container: null,Image: null},{Container: null,Image: null},{Container: null,Image: null}],
		[{Row: null},{Container: null,Image: null},{Container: null,Image: null},{Container: null,Image: null},{Container: null,Image: null},{Container: null,Image: null},{Container: null,Image: null},{Container: null,Image: null}],
		[{Row: null},{Container: null,Image: null},{Container: null,Image: null},{Container: null,Image: null},{Container: null,Image: null},{Container: null,Image: null},{Container: null,Image: null},{Container: null,Image: null}]
	];
	
    // buttons
    this.mLeaveButton = null;

    // generics
    this.mIsVisible = false;

    // selected entry
    this.mSelectedEntry = null;
};

WorldBreditorScreen.prototype.isConnected = function ()
{
    return this.mSQHandle !== null;
};

WorldBreditorScreen.prototype.onConnection = function (_handle)
{
	this.mSQHandle = _handle;
	this.register($('.root-screen'));
};

WorldBreditorScreen.prototype.onDisconnection = function ()
{
	this.mSQHandle = null;
	this.unregister();
};

WorldBreditorScreen.prototype.getModule = function (_name)
{
	switch(_name)
	{
        default: return null;
	}
};

WorldBreditorScreen.prototype.getModules = function ()
{
	return [];
};

WorldBreditorScreen.prototype.createDIV = function (_parentDiv)
{
    var self = this;
	this.mMode = 1;
	
	// create: containers (init hidden!)
     this.mContainer = $('<div class="world-breditor-screen display-none opacity-none"/>');
     _parentDiv.append(this.mContainer);
	 
    // create: containers (init hidden!)
    var dialogLayout = $('<div class="l-breditor-dialog-container"/>');
    this.mContainer.append(dialogLayout);
    this.mDialogContainer = dialogLayout.createDialog('Breditor', '', '', true, 'dialog-1024-768');
	this.mDialogContainer.css('background-image', 'url("coui://gfx/ui/skin/dialog_breditor.png")');
	
	this.mNamedItemsPanel.Container = $('<div class="l-named-container"/>');
	this.mDialogContainer.append(this.mNamedItemsPanel.Container);
	this.mNamedItemsPanel.Rows[0][0].Row = $('<div class="named-row"/>');
	this.mNamedItemsPanel.Container.append(this.mNamedItemsPanel.Rows[0][0].Row);
	this.mNamedItemsPanel.Rows[1][0].Row = $('<div class="named-row"/>');
	this.mNamedItemsPanel.Container.append(this.mNamedItemsPanel.Rows[1][0].Row);
	
	var NIType = $('<div class="ni-type-button"/>');
    this.mNamedItemsPanel.Rows[0][0].Row.append(NIType);
    this.mNamedItemsPanel.Rows[0][1].TypeButton = NIType.createTextButton("NI Category", function()
	{
         if(self.mSelectedEntry !== null)
        {
            self.FirstNIButton();
        } 
    }, '', 1);
	this.mNamedItemsPanel.Rows[0][1].TypeButton.bindTooltip({ contentType: 'ui-element', elementId: 'breditor-nicategory-tooltip' });
	this.mNamedItemsPanel.Rows[0][1].TypeButton.mousedown(function (event)
	{
		if (event.which === 3)
		{self.FirstNIButton(false);} //return false;
	});
	
	var NITypeTwo = $('<div class="ni-type-button"/>');
	NITypeTwo.css('top', '-1px');
    this.mNamedItemsPanel.Rows[1][0].Row.append(NITypeTwo);
    this.mNamedItemsPanel.Rows[1][1].TypeButton = NITypeTwo.createTextButton("NI Type", function()
	{
         if(self.mSelectedEntry !== null)
        {
            self.SecondNIButton(true);
        } 
    }, '', 1);
	this.mNamedItemsPanel.Rows[1][1].TypeButton.mousedown(function (event)
	{
		if (event.which === 3)
		{self.SecondNIButton(false);} //return false;
	});
	//this.mNamedItemsPanel.Rows[1][1].TypeButton.bindTooltip({ contentType: 'ui-element', elementId: 'breditor-nitype-tooltip' }); //covers the image, annoying
	
	var NIImageContainer = $('<div class="ni-image"/>');
	this.mNamedItemsPanel.Container.append(NIImageContainer);
	this.mNamedItemsPanel.Image = $('<img/>');
	this.mNamedItemsPanel.Image.css('width', '5.6rem');
	this.mNamedItemsPanel.Image.css('height', '5.6rem');
	this.mNamedItemsPanel.Image.css('margin', '5px 5px 5px 5px');
	NIImageContainer.append(this.mNamedItemsPanel.Image);
	//don't bother with tooltips for item icon
	
	var NIUPDButtonCont = $('<div class="ni-upd-button"/>');
    this.mNamedItemsPanel.Rows[0][0].Row.append(NIUPDButtonCont);
    var NIUPDButton = NIUPDButtonCont.createTextButton("重掷", function()
	{
         if(self.mSelectedEntry !== null)
        {
            self.RerollNIData();
        } 
    }, '', 2);
	NIUPDButton.bindTooltip({ contentType: 'ui-element', elementId: 'breditor-niupdateimage-tooltip' }); 
	
	var NIStatSwitchCont = $('<div class="ni-statswitch-button"/>');
    this.mNamedItemsPanel.Rows[1][0].Row.append(NIStatSwitchCont);
    this.mNamedItemsPanel.Rows[1][2].SWButton = NIStatSwitchCont.createTextButton("", function()
	{
         if(self.mSelectedEntry !== null)
        {
            self.NISwitchStats(true, null);
        } 
    }, '', 4);
	this.mNamedItemsPanel.Rows[1][2].SWButton.mousedown(function (event)
	{
		if (event.which === 3)
		{self.NISwitchStats(false, null);} //return false;
	});
	
	var SICont = $('<div class="ni-stats-input"/>');
	this.mNamedItemsPanel.Rows[1][0].Row.append(SICont);
	this.mNamedItemsPanel.Rows[1][3].SInput = SICont.createInput('', 0, 4, null, null, 'title-font-normal font-bold font-color-brother-name', function (_input)
	{
		self.ProcessNIStatEdited(_input);
	}, 3);
	
	var SINameCont = $('<div class="ni-name-input"/>');
	this.mNamedItemsPanel.Rows[0][0].Row.append(SINameCont);
	this.mNamedItemsPanel.Rows[0][2].NINameInput = SINameCont.createInput('', 0, 50, null, null, 'title-font-normal font-bold font-color-brother-name', function (_input)
	{
		self.ProcessNINameEdited(_input);
	}, 4);
	
	var NIFinCont = $('<div class="ni-finalize-button"/>');
    this.mNamedItemsPanel.Rows[0][0].Row.append(NIFinCont);
    this.mNamedItemsPanel.Rows[0][3].NIFinButton = NIFinCont.createTextButton("加入仓库", function()
	{
         if(self.mSelectedEntry !== null)
        {
            self.NIAddItem();
        } 
    }, '', 2);
	this.mNamedItemsPanel.Rows[0][3].NIFinButton.findButtonText().css('margin-left', '0.1rem');
	this.mNamedItemsPanel.Rows[0][3].NIFinButton.bindTooltip({ contentType: 'ui-element', elementId: 'breditor-nifinalize-tooltip' }); 
	
	this.mNamedItemsPanel.Rows[1][4].FreeSpaceText = $('<div class="ni-invspacetext text-font-medium font-color-brother-name"/>');
	this.mNamedItemsPanel.Rows[1][0].Row.append(this.mNamedItemsPanel.Rows[1][4].FreeSpaceText);
	
	
	
	var StrButtonContainer = $('<div class="party-strength-button"/>');
	this.mNamedItemsPanel.Rows[0][0].Row.append(StrButtonContainer);
    var StrButton = StrButtonContainer.createTextButton("团队战力", function(_button)
	{
		if(self.mSQHandle !== null)
        {
			SQ.call(self.mSQHandle, 'BreditorCalculateSTR', true, function(_result)
			{
				_button.changeButtonText(_result);
			}); 
        }
    }, '', 4);
	StrButton.bindTooltip({ contentType: 'ui-element', elementId: 'breditor-partystrength-tooltip' });
	
	var MirrorButtonContainer = $('<div class="party-strength-button"/>');
	this.mNamedItemsPanel.Rows[1][0].Row.append(MirrorButtonContainer);
    var MirrorButton = MirrorButtonContainer.createTextButton("镜像战斗", function(_button)
	{
		if(self.mSQHandle !== null)
        {
			SQ.call(self.mSQHandle, 'MirrorBattle', true); 
        }
    }, '', 4);
	MirrorButton.bindTooltip({ contentType: 'ui-element', elementId: 'breditor-mirrorbattle-tooltip' });
	
	
	var BroExpInpCont = $('<div class="expimp-input"/>');
	this.mNamedItemsPanel.Rows[0][0].Row.append(BroExpInpCont);
	this.mNamedItemsPanel.Rows[0][4].BroExpImpInput = BroExpInpCont.createInput('', 0, 1000000, null, null, 'title-font-normal font-bold font-color-brother-name', null, 2, function (_input)
	{
		_input.css('font-size', '4px');
	});
	this.mNamedItemsPanel.Rows[0][4].BroExpImpInput.css('font-size', '4px');
	
	var IEMainStatsCont = $('<div class="impexpsettingbutton"/>');
    this.mNamedItemsPanel.Rows[0][0].Row.append(IEMainStatsCont);
    var IEMainStatsButton = IEMainStatsCont.createTextButton("主|是", function(_button)
	{
        if (self.mNamedItemsPanel.Rows[0][4].MainS == true){self.mNamedItemsPanel.Rows[0][4].MainS = false; _button.changeButtonText("主|否")}
		else {self.mNamedItemsPanel.Rows[0][4].MainS = true; _button.changeButtonText("主|是")}
		
    }, '', 8);
	IEMainStatsButton.bindTooltip({ contentType: 'ui-element', elementId: 'breditor-impexpstats-tooltip' });
	
	var IELifeStatsCont = $('<div class="impexpsettingbutton"/>');
    this.mNamedItemsPanel.Rows[0][0].Row.append(IELifeStatsCont);
    var IELifeStatsButton = IELifeStatsCont.createTextButton("涯|否", function(_button)
	{
        if (self.mNamedItemsPanel.Rows[0][4].LifeStats == true){self.mNamedItemsPanel.Rows[0][4].LifeStats = false; _button.changeButtonText("涯|否")}
		else {self.mNamedItemsPanel.Rows[0][4].LifeStats = true; _button.changeButtonText("涯|是")}
		
    }, '', 8);
	IELifeStatsButton.bindTooltip({ contentType: 'ui-element', elementId: 'breditor-impexplifestats-tooltip' });
	
	var IEGearCont = $('<div class="impexpsettingbutton"/>');
    this.mNamedItemsPanel.Rows[0][0].Row.append(IEGearCont);
    var IEGearButton = IEGearCont.createTextButton("装|否", function(_button)
	{
        if (self.mNamedItemsPanel.Rows[0][4].Gear == true){self.mNamedItemsPanel.Rows[0][4].Gear = false; _button.changeButtonText("装|否")}
		else {self.mNamedItemsPanel.Rows[0][4].Gear = true; _button.changeButtonText("装|是")}
		
    }, '', 8);
	IEGearButton.bindTooltip({ contentType: 'ui-element', elementId: 'breditor-impexpgear-tooltip' });
	
	var ExpButtonCont = $('<div class="impexpbutton"/>');
    this.mNamedItemsPanel.Rows[0][0].Row.append(ExpButtonCont);
    var ExpButton = ExpButtonCont.createTextButton("导出", function()
	{
         if(self.mSelectedEntry !== null)
        {
            self.ExportBroData();
        } 
    }, '', 2);
	ExpButton.bindTooltip({ contentType: 'ui-element', elementId: 'breditor-broexport-tooltip' }); 
	
	var ImpButtonCont = $('<div class="impexpbutton"/>');
    this.mNamedItemsPanel.Rows[1][0].Row.append(ImpButtonCont);
    var ImpButton = ImpButtonCont.createTextButton("导入", function()
	{
         if(self.mSelectedEntry !== null)
        {
            self.ImportBroData();
        } 
    }, '', 2);
	ImpButton.bindTooltip({ contentType: 'ui-element', elementId: 'breditor-broimport-tooltip' }); 
	
	var HairColorCont = $('<div class="hairbeardcolor"/>');
    this.mNamedItemsPanel.Rows[0][0].Row.append(HairColorCont);
    var HairColorButton = HairColorCont.createTextButton("发色", function(_button)
	{
		if(self.mSelectedEntry !== null && self.mSQHandle !== null && self.mNamedItemsPanel.Rows[0][4].BroExpImpInput.getInputText().length == 6)
        {
			SQ.call(self.mSQHandle, 'DyeMyHair', {BroId: self.mData.ID, Color: self.mNamedItemsPanel.Rows[0][4].BroExpImpInput.getInputText(), Type: 'Hair'}, function(_result)
			{if (typeof(_result) == "string")
			{	self.mNamedItemsPanel.Rows[0][4].BroExpImpInput.css('font-size', '15px');
				self.mNamedItemsPanel.Rows[0][4].BroExpImpInput.setInputTextBP(_result);}
			else
			{self.mData.ImagePath = _result.ImagePath;
			self.mData.BroImage.attr('src', Path.PROCEDURAL + _result['ImagePath']);}	
			}); 
        }
    }, '', 8);
	HairColorButton.bindTooltip({ contentType: 'ui-element', elementId: 'breditor-haircolor-tooltip' });
	
	var BeardColorCont = $('<div class="hairbeardcolor"/>');
    this.mNamedItemsPanel.Rows[1][0].Row.append(BeardColorCont);
    var BeardColorButton = BeardColorCont.createTextButton("须色", function(_button)
	{
		if(self.mSelectedEntry !== null && self.mSQHandle !== null && self.mNamedItemsPanel.Rows[0][4].BroExpImpInput.getInputText().length == 6)
        {
			SQ.call(self.mSQHandle, 'DyeMyHair', {BroId: self.mData.ID, Color: self.mNamedItemsPanel.Rows[0][4].BroExpImpInput.getInputText(), Type: 'Beard'}, function(_result)
			{if (typeof(_result) == "string")
			{	self.mNamedItemsPanel.Rows[0][4].BroExpImpInput.css('font-size', '15px');
				self.mNamedItemsPanel.Rows[0][4].BroExpImpInput.setInputTextBP(_result);}
			else
			{self.mData.ImagePath = _result.ImagePath;
			self.mData.BroImage.attr('src', Path.PROCEDURAL + _result['ImagePath']);}	
			}); 
        }
    }, '', 8);
	BeardColorButton.bindTooltip({ contentType: 'ui-element', elementId: 'breditor-beardcolor-tooltip' });
	
    // create tabs
    var tabButtonsContainer = $('<div class="l-tab-container"/>');
    this.mDialogContainer.findDialogTabContainer().append(tabButtonsContainer);

    // create content
    var content = this.mDialogContainer.findDialogContentContainer();

    // left column
    var column = $('<div class="column is-left"/>');
    content.append(column);
    var listContainerLayout = $('<div class="l-list-container"/>');
    column.append(listContainerLayout);
    this.mListContainer = listContainerLayout.createList(1.77/*8.85*/);
    this.mListScrollContainer = this.mListContainer.findListScrollContainer();

    // right column
    column = $('<div class="column is-right"/>');
    content.append(column);

    // details container
    var detailsFrame = $('<div class="l-details-frame"/>');
    column.append(detailsFrame);
    this.mDetailsPanel.Container = $('<div class="details-container display-none"/>');
    detailsFrame.append(this.mDetailsPanel.Container);

    // details: character container
    var detailsRow = $('<div class="row is-character-container"/>');
    this.mDetailsPanel.Container.append(detailsRow);
    var detailsColumn = $('<div class="column is-character-background-container"/>');
    detailsRow.append(detailsColumn);

    // details: background
    var backgroundRow = $('<div class="row is-top"/>');
    detailsColumn.append(backgroundRow);

    this.mDetailsPanel.CharacterName = $('<div class="name title-font-normal font-bold font-color-brother-name"/>');
    backgroundRow.append(this.mDetailsPanel.CharacterName);

	// details: controls
	for (var r = 0; r < this.mTraitOptions.length; r++) 
	{
	  var rrow = this.mTraitOptions[r][0];
	  rrow.Row = $('<div class="stats-row"/>');
	  detailsColumn.append(rrow.Row);
	}
	this.createAttributesControlDIV(this.mStatsOptions, detailsColumn);
	
	for (var r = 0; r < this.mTraitOptions.length; r++) 
	{
		var rrow = this.mTraitOptions[r][0];
		for (var trid = 1; trid < this.mTraitOptions[r].length; trid++) 
		{
			var trait = this.mTraitOptions[r][trid];
			trait.Container = $('<div class="l-trait-container"/>');
			rrow.Row.append(trait.Container);
			
 			trait.Image = $('<img class="trait-image"/>');
			//trait.Image.attr('src', Path.GFX + Asset.ICON_HEALTH);
			trait.Container.append(trait.Image); 
		}
	}
	var xprow = this.mTraitOptions[8][0];
	var XPButtonLayout = $('<div class="l-talent-button-container"/>');
    xprow.Row.append(XPButtonLayout);
    var XPButton = XPButtonLayout.createTextButton("经验", function()
	{
        if(self.mSelectedEntry !== null)
        {
            self.giveXP();
        }
    }, '', 8);
	XPButton.bindTooltip({ contentType: 'ui-element', elementId: 'breditor-xp-tooltip' });
	
	var oprow = this.mTraitOptions[9][0];
	var OPButtonLayout = $('<div class="l-talent-button-container"/>');
    oprow.Row.append(OPButtonLayout);
    var OPButton = OPButtonLayout.createTextButton("洗点", function()
	{
        if(self.mSelectedEntry !== null)
        {
            self.giveOP();
        }
    }, '', 8);
	OPButton.bindTooltip({ contentType: 'ui-element', elementId: 'breditor-op-tooltip' });
	
	var yfrow = this.mTraitOptions[10][0];
	var YFButtonLayout = $('<div class="l-talent-button-container"/>');
    yfrow.Row.append(YFButtonLayout);
    var YFButton = YFButtonLayout.createTextButton("圣水", function()
	{
        if(self.mSelectedEntry !== null)
        {
            self.giveYF();
        }
    }, '', 8);
	YFButton.bindTooltip({ contentType: 'ui-element', elementId: 'breditor-yf-tooltip' });
	
	var bgrow = this.mTraitOptions[11][0];
	var BGButtonLayout = $('<div class="l-talent-button-container"/>');
    bgrow.Row.append(BGButtonLayout);
    var BGButton = BGButtonLayout.createTextButton("背景", function()
	{
        if(self.mSelectedEntry !== null)
        {
            self.SwitchMode();
        }
    }, '', 8);
	BGButton.bindTooltip({ contentType: 'ui-element', elementId: 'breditor-bg-tooltip' });

    // create footer button bar
    var footerButtonBar = $('<div class="l-button-bar"/>');
    this.mDialogContainer.findDialogFooterContainer().append(footerButtonBar);

    // create: buttons
    var layout = $('<div class="l-leave-button"/>');
    footerButtonBar.append(layout);
    this.mLeaveButton = layout.createTextButton("关闭", function()
	{
        self.notifyBackendCloseButtonPressed();
    }, '', 1);

	var BioInputCont = $('<div class="bro-bio-input"/>');
    footerButtonBar.append(BioInputCont);
    this.mNamedItemsPanel.BioInput = BioInputCont.createInput('', 0, 2000, null, null, 'title-font-normal font-bold font-color-brother-name', function (_input)
	{
		var inputtext = _input.getInputText();
		if(self.mSQHandle !== null && inputtext != "传记" && inputtext != self.mData.BackgroundText)
		{
			SQ.call(self.mSQHandle, 'SaveBio', {BroId: self.mData.ID, Bio: inputtext});
			self.mData.BackgroundText = inputtext;
		}
		_input.setInputText("传记");
	}, 5, function (_input)
	{
		if(_input.getInputText() == "传记")
		{
			_input.setInputText(self.mData.BackgroundText);
		}
	});
	this.mNamedItemsPanel.BioInput.setInputText("传记");
	
    this.mIsVisible = false;
};

WorldBreditorScreen.prototype.destroyDIV = function ()
{
	this.mSelectedEntry = null;
	
    this.mDetailsPanel.CharacterName.empty();
    this.mDetailsPanel.CharacterName.remove();
    this.mDetailsPanel.CharacterName = null;

    this.mDetailsPanel.Container.empty();
    this.mDetailsPanel.Container.remove();
    this.mDetailsPanel.Container = null;

    this.mListScrollContainer.empty();
    this.mListScrollContainer = null;
    this.mListContainer.destroyList();
    this.mListContainer.remove();
    this.mListContainer = null;

	this.mLeaveButton.remove();
    this.mLeaveButton = null;

    this.mDialogContainer.empty();
    this.mDialogContainer.remove();
    this.mDialogContainer = null;

    this.mContainer.empty();
    this.mContainer.remove();
    this.mContainer = null;
};

WorldBreditorScreen.prototype.createAttributesControlDIV = function (_definitions, _parentDiv)
{
	var self = this;
	var rowcounter = 0;
	$.each(_definitions, function (_key, _value)
	{
		var row = self.mTraitOptions[rowcounter][0].Row;
/* 		_value.SVal = $('<div class="statsvalues text-font-medium font-color-description"/>');
		row.append(_value.SVal);
 */
		
 		var leftStatsRowLayout = $('<div class="l-stats-row"/>');
		row.append(leftStatsRowLayout);

		var statsRowIconLayout = $('<div class="l-stats-row-icon"/>');
		leftStatsRowLayout.append(statsRowIconLayout);
		var statsRowIcon = $('<img/>');
		statsRowIcon.attr('src', _value.IconPath);
		statsRowIconLayout.append(statsRowIcon);
		statsRowIcon.bindTooltip({ contentType: 'ui-element', elementId: _value.TooltipId });
		
		var inputLayout = $('<div class="l-input"/>');
		row.append(inputLayout);
		_value.SVal = inputLayout.createInput('', 0, 4, null, null, 'title-font-normal font-bold font-color-brother-name', function (_input)
		{
			self.ConfirmAttributeChange(_key, _input);
		}, 2, function (_input)
		{
			var iText = _input.getInputText();
			var iTextInd = iText.indexOf(' ');
			if (iTextInd > 0)
			{
				iText = iText.slice(0, iTextInd);
				_input.setInputText(iText);
			}
		});
/* 		if (_key !== 'ActionPoints' && _key !== 'DailyWage' && _key !== 'DailyFood' && _key !== 'PerkPoints')
		{
			_value.SVal.bindTooltip({ contentType: 'ui-element', elementId: 'breditor-stats-tooltip' }); 
		} */
		
/* 		var buttonLayout = $('<div class="l-decrease-button-container"/>');
        row.append(buttonLayout);
		_value.DownButton = buttonLayout.createTextButton("-1", function()
		{
            self.increaseLevelUpStatValue(_key, -1);
        }, 'font-bold', 8);
		var buttonLayoutTwo = $('<div class="l-increase-button-container"/>');
        row.append(buttonLayoutTwo);
		_value.UpButton = buttonLayoutTwo.createTextButton("+3", function()
		{
            self.increaseLevelUpStatValue(_key, 3);
        }, 'font-bold', 8);  */
		
		if (_key !== 'ActionPoints' && _key !== 'DailyWage' && _key !== 'DailyFood' && _key !== 'PerkPoints')
		{
			var buttonLayoutThree = $('<div class="l-talent-button-container"/>');
			row.append(buttonLayoutThree);
			_value.TalentButton = buttonLayoutThree.createTextButton('', function()
			{
				self.changeTalents(_key);
			}, 'font-bold', 8);
			_value.TalentButton.bindTooltip({ contentType: 'ui-element', elementId: 'breditor-talent-tooltip' }); 
		}
		rowcounter +=1;
	});
};

 WorldBreditorScreen.prototype.ConfirmAttributeChange = function (_statName, _input)
{
	var stat = null;
	var statvalue = null;
    if (_statName in this.mStatsOptions) // _statName = Hitpoints etc.
    {
        stat = this.mStatsOptions[_statName];
    }
    if (_statName in this.mData)
    {
        statvalue = this.mData[_statName];
    }
	var inputtext = parseInt(_input.getInputText(), 10);
    if (!isNaN(inputtext))
    {
		if (_statName == 'ActionPoints' || _statName == 'DailyWage' || _statName == 'DailyFood' || _statName == 'PerkPoints')
		{
			if (inputtext != statvalue)
			{
				var result = {
					BroId: this.mData.ID,
					StatName: _statName,
					Value: inputtext,
				}
				this.notifyBackendOnChangingAttributes(result);
				this.UpdateAttributes(this.mData.ID);
			}
			else
			{
				stat.SVal.setInputTextBP(this.mData[_statName]+'');
			}
		}
		else 
		{
			if (inputtext != statvalue.Max)
			{
				var result = {
					BroId: this.mData.ID,
					StatName: _statName,
					Value: inputtext,
				}
				this.notifyBackendOnChangingAttributes(result);
				this.UpdateAttributes(this.mData.ID);
			}
			else
			{
				stat.SVal.setInputTextBP(statvalue.Max+' ('+statvalue.MaxPlus+') / '+statvalue.BLimit);
			}
		}
    }
	else
	{
		if (_statName == 'ActionPoints' || _statName == 'DailyWage' || _statName == 'DailyFood' || _statName == 'PerkPoints') 
		{
			stat.SVal.setInputTextBP(this.mData[_statName]+'');
		}
		else
		{
			stat.SVal.setInputTextBP(statvalue.Max+' ('+statvalue.MaxPlus+') / '+statvalue.BLimit);
		}
	}
}; 

 WorldBreditorScreen.prototype.UpdateAttributes = function (_bro)
{
	var result = {
		BroId: _bro,
	}
	var data = this.mData;
	var self = this;
	this.notifyBackendOnUpdateAttributes(result, function(_result)
	{           
		$.each(self.mStatsOptions, function (_key, _value)
		{
			if (_key !== 'ActionPoints' && _key !== 'DailyWage' && _key !== 'DailyFood' && _key !== 'PerkPoints' && _key in data) //don't this it Leo because it's inside the function
			{
				data[_key].Max = _result[_key].Max;
				data[_key].MaxPlus = _result[_key].MaxPlus;
				data[_key].BLimit = _result[_key].BLimit;
				//data[_key].Talent = _result[_key].Talent;
				self.mStatsOptions[_key].SVal.setInputTextBP(data[_key].Max+' ('+data[_key].MaxPlus+') / '+data[_key].BLimit);
			}
			else
			{
				data[_key] = _result[_key];
				self.mStatsOptions[_key].SVal.setInputTextBP(data[_key]+'');
			}
		});
	}); 
}; 

WorldBreditorScreen.prototype.changeTalents = function (_statName)
{
    var difference = this.mData.Level - this.mData.LevelUps;
	if (difference < 11)
	{
		var stat = null;
		var statvalue = null;
		if (_statName in this.mStatsOptions)
		{
			stat = this.mStatsOptions[_statName];
		}
		if (_statName in this.mData)
		{
			statvalue = this.mData[_statName];
		}
		
		if (statvalue.Talent == 3) 
		{
			statvalue.Talent = 0;
		}
		else
		{
			statvalue.Talent += 1;
		}
		var NStars = '';
		for (var stars = 0; stars < statvalue.Talent; stars++) {
		  NStars += '*';
		}
		this.mStatsOptions[_statName].TalentButton.changeButtonText(NStars);
		var result = {
			BroId: this.mData.ID,
			StatName: _statName,
			TalentValue: statvalue.Talent,
		}
		this.notifyBackendOnChangingTalents(result);
	}
};

WorldBreditorScreen.prototype.ToggleSkill = function (_row, _column, _counter)
{
	//this.mDetailsPanel.CharacterName.html(""+this.mTraits[_counter][0]);
	var self = this;
	var trait = this.mTraitOptions[_row][_column];
	var data = this.mData;
	var yesorno = 1;
	for (var i = 0; i < data.Traits.length; i++) 
	{
		if (data.Traits[i][0] == this.mTraits[_counter][0])
		{
			yesorno = 0;
			trait.Container.css({ opacity: 0.33 });
			data.Traits.splice(i, 1);
			break;
		}
	}
 	if (yesorno == 1)
	{
		trait.Container.css({ opacity: 1 });
		data.Traits.push(this.mTraits[_counter]);
	} 
		
	var result = {
		BroId: this.mData.ID,
		TraitId: this.mTraits[_counter][0],
		TraitLink: this.mTraits[_counter][1],
		YesOrNo: yesorno,
	}
	this.notifyBackendOnChangingTraits(result);
	this.UpdateAttributes(this.mData.ID);
};

WorldBreditorScreen.prototype.ChooseBG = function (_row, _column, _counter)
{
	//this.mDetailsPanel.CharacterName.html(""+this.mTraits[_counter][0]);
	
	var trait = this.mTraitOptions[_row][_column];
	var data = this.mData;
	var self = this;
	var traitcounter = 0;
	if (data.Background == this.mBackgrounds[_counter][0])
	{
	}
 	else
	{
		data.Background = this.mBackgrounds[_counter][0];
		var bgslength = this.mBackgrounds.length;
		for (var r = 0; r < this.mTraitOptions.length; r++) 
		{
			for (var trid = 1; trid < this.mTraitOptions[r].length; trid++) 
			{
				var trait = this.mTraitOptions[r][trid];
				if (traitcounter < bgslength)
				{
					trait.Container.css({ opacity: 0.33 });
					if (data.Background == this.mBackgrounds[traitcounter][0])
					{
						trait.Container.css({ opacity: 1 });
					}
				}
				traitcounter +=1;
			}
		}
	var result = {
		BroId: this.mData.ID,
		TraitLink: this.mBackgrounds[_counter][1],
	}
	this.notifyBackendOnChoosingBG(result, function(_result)
        {           
			self.mData.BackgroundImageObj.attr('src', Path.GFX + _result['BackgroundImagePath']);
			self.UpdateAttributes(self.mData.ID);
        }); 
	}
};

WorldBreditorScreen.prototype.giveXP = function ()
{
	var data = this.mData;
	var self = this;
	var result = {
		BroId: this.mData.ID,
	}
	this.notifyBackendOnGiveXP(result, function(_result)
        {           
            data.XpValue += 1000;
			data.Level = _result.Level;
            data.LevelUps = _result.LevelUps;
            data.PerkPoints = _result.PerkPoints;
			data.DailyWage = _result.DailyWage;
			var parsedText = XBBCODE.process({
				text: data['Name']+" (等级: "+data['Level']+" ("+data.LevelUps+"[img]gfx/ui/icons/leveled_up_bred.png[/img]), 经验: "+data['XpValue']+")",
				removeMisalignedTags: false,
				addInLineBreaks: false
			});
			self.mDetailsPanel.CharacterName.html(parsedText.html);
			self.mStatsOptions.PerkPoints.SVal.setInputTextBP(data.PerkPoints+'');
			self.mStatsOptions.DailyWage.SVal.setInputTextBP(data.DailyWage+'');
        }); 
};

WorldBreditorScreen.prototype.giveOP = function ()
{
	var data = this.mData;
	var self = this;
	var result = {
		BroId: this.mData.ID,
	}
	this.notifyBackendOnGiveOP(result, function(_result)
        {           
            data.PerkPoints = _result.PerkPoints;
			self.mStatsOptions.PerkPoints.SVal.setInputTextBP(data.PerkPoints+'');
        }); 
};
WorldBreditorScreen.prototype.giveYF = function ()
{
	var data = this.mData;
	var self = this;
	var result = {
		BroId: this.mData.ID,
	}
	this.notifyBackendOnGiveYF(result, function(_result)
        {           
			self.FullyUpdateTheBloodyEntry();
        }); 
};

WorldBreditorScreen.prototype.FirstNIButton = function (_moveforward)
{
	var pt_nitypenames = ['Weapons', 'Shields', 'Armor', 'Helmets', 'Legendary', 'Misc'];
	if (_moveforward)
	{
		this.mNamedItemsPanel.Rows[0][1].TBValue +=1;
		
		if (this.mNamedItemsPanel.Rows[0][1].TBValue == pt_nitypenames.length)
		{
			this.mNamedItemsPanel.Rows[0][1].TBValue = 0;
		}
	}
	else
	{
		this.mNamedItemsPanel.Rows[0][1].TBValue -=1;
		
		if (this.mNamedItemsPanel.Rows[0][1].TBValue == -1)
		{
			this.mNamedItemsPanel.Rows[0][1].TBValue = pt_nitypenames.length - 1;
		}
	}
	this.mNamedItemsPanel.Rows[0][1].TypeButton.changeButtonText(BEFanYi(pt_nitypenames[this.mNamedItemsPanel.Rows[0][1].TBValue]));
	this.mNamedItemsPanel.Rows[1][1].TBValue = 0;
	
	this.RerollNIData();
};

WorldBreditorScreen.prototype.SecondNIButton = function (_moveforward)
{
	var pt_nitypenames = ['Weapons', 'Shields', 'Armor', 'Helmets', 'Legendary', 'Misc'];
	if (_moveforward)
	{
		this.mNamedItemsPanel.Rows[1][1].TBValue +=1;
		
		if (this.mNamedItemsPanel.Rows[1][1].TBValue == this.mNItems.Items[pt_nitypenames[this.mNamedItemsPanel.Rows[0][1].TBValue]].List.length)
		{
			this.mNamedItemsPanel.Rows[1][1].TBValue = 0;
		}
	}
	else
	{
		this.mNamedItemsPanel.Rows[1][1].TBValue -=1;
		
		if (this.mNamedItemsPanel.Rows[1][1].TBValue == -1)
		{
			this.mNamedItemsPanel.Rows[1][1].TBValue = this.mNItems.Items[pt_nitypenames[this.mNamedItemsPanel.Rows[0][1].TBValue]].List.length - 1;
		}
	}
	this.RerollNIData();
};

WorldBreditorScreen.prototype.RerollNIData = function ()
{
	var self = this;
	var text = "";
	var pt_nitypenames = ['Weapons', 'Shields', 'Armor', 'Helmets', 'Legendary', 'Misc'];
	
	var result = {
		Item: this.mNItems.Items[pt_nitypenames[this.mNamedItemsPanel.Rows[0][1].TBValue]].List[this.mNamedItemsPanel.Rows[1][1].TBValue],
		ItemType: pt_nitypenames[this.mNamedItemsPanel.Rows[0][1].TBValue],
	}
	//this.mDetailsPanel.CharacterName.html(""+this.mNItems.Items[pt_nitypenames[this.mNamedItemsPanel.Rows[0][1].TBValue]].List[this.mNamedItemsPanel.Rows[1][1].TBValue]);
	this.notifyBackendNIReroll(result, function(_result)
        {           
			var NIname = _result.ID.split('.');
			NIname = NIname[NIname.length-1].replace('_', ' ').replace('_', ' ').replace('_', ' ').replace('named ', '');
			self.mNamedItemsPanel.Rows[1][1].TypeButton.changeButtonText(BEFanYi(NIname.charAt(0).toUpperCase() + NIname.slice(1)));
//			self.mNamedItemsPanel.Rows[1][1].TypeButton.changeButtonText(TranslateToolTip0(NIname));

			self.mNamedItemsPanel.Image.attr('src', Path.GFX + "ui/items/" +  _result.IconLarge);
			self.mNamedItemsPanel.Rows[0][2].NIName = _result.Name;
			self.mNamedItemsPanel.Rows[0][2].NIVariant = _result.Variant;
			self.mNamedItemsPanel.Rows[0][2].NINameInput.setInputTextBP(""+TranslateToolTip0(_result.Name));
			self.mNamedItemsPanel.Rows[1][4].FreeSpaceText.html(_result.Room+"仓库空位");
			//self.mNamedItemsPanel.Rows[0][3].NIFinButton.changeButtonText("Add (Empty: "+_result.Room+")");
			
			self.mNItems.CurrentItem.ConditionMax = null;
			self.mNItems.CurrentItem.StaminaModifier = null;
			self.mNItems.CurrentItem.MeleeDefense = null;
			self.mNItems.CurrentItem.RangedDefense = null;
			self.mNItems.CurrentItem.FatigueOnSkillUse = null;
			self.mNItems.CurrentItem.RegularDamage = null;
			self.mNItems.CurrentItem.RegularDamageMax = null;
			self.mNItems.CurrentItem.ArmorDamageMult = null;
			self.mNItems.CurrentItem.DirectDamageAdd = null;
			self.mNItems.CurrentItem.ChanceToHitHead = null;
			self.mNItems.CurrentItem.ShieldDamage = null;
			self.mNItems.CurrentItem.AdditionalAccuracy = null;
			self.mNItems.CurrentItem.AmmoMax = null;
			
			$.each(_result.Current, function (_key, _value)
			{
				self.mNItems.CurrentItem[_key] = _value;
			});
			self.NISwitchStats(false, 0);
        }); 
};

WorldBreditorScreen.prototype.NISwitchStats = function (_moveforward, _switchto)
{
	var self = this;
	var safearray = [];
	var pt_nitypenames = ['Weapons', 'Shields', 'Armor', 'Helmets', 'Legendary', 'Misc'];
	
	if (pt_nitypenames[this.mNamedItemsPanel.Rows[0][1].TBValue] == 'Legendary' || pt_nitypenames[this.mNamedItemsPanel.Rows[0][1].TBValue] == 'Misc')
	{
		this.mNamedItemsPanel.Rows[1][2].SWButton.changeButtonText("无属性可更改");
		this.mNamedItemsPanel.Rows[1][3].SInput.setInputTextBP("");
	}
	else
	{
		var statarray = this.mNItems.Items[pt_nitypenames[this.mNamedItemsPanel.Rows[0][1].TBValue]].Stats;
		for (var r = 0; r < statarray.length; r++) 
		{
			if (self.mNItems.CurrentItem[statarray[r]] !== null)
			{
				safearray.push(statarray[r]);
			}
		}
		if (_switchto !== null)
		{
			this.mNamedItemsPanel.Rows[1][2].SWBValue = _switchto;
		}
		else
		{
			if (_moveforward)
			{
				this.mNamedItemsPanel.Rows[1][2].SWBValue +=1;
				if (this.mNamedItemsPanel.Rows[1][2].SWBValue == safearray.length)
				{
					this.mNamedItemsPanel.Rows[1][2].SWBValue = 0;
				}
			}
			else
			{
				this.mNamedItemsPanel.Rows[1][2].SWBValue -=1;
				if (this.mNamedItemsPanel.Rows[1][2].SWBValue == -1)
				{
					this.mNamedItemsPanel.Rows[1][2].SWBValue = safearray.length - 1;
				}
			}
		}
		
		this.mNamedItemsPanel.Rows[1][3].SIName = safearray[this.mNamedItemsPanel.Rows[1][2].SWBValue];
		if (this.mNamedItemsPanel.Rows[1][3].SIName != "DirectDamageAdd")
		{
			this.mNamedItemsPanel.Rows[1][2].SWButton.changeButtonText(BEFanYi(this.mNamedItemsPanel.Rows[1][3].SIName));
		}
		else
		{
			this.mNamedItemsPanel.Rows[1][2].SWButton.changeButtonText("穿甲伤害");
		}
		
		this.mNamedItemsPanel.Rows[1][3].SInput.setInputTextBP(""+self.mNItems.CurrentItem[safearray[this.mNamedItemsPanel.Rows[1][2].SWBValue]]);
	}
};

WorldBreditorScreen.prototype.ProcessNIStatEdited = function (_input)
{
	var inputtext = parseInt(_input.getInputText(), 10);
	var pt_nitypenames = ['Weapons', 'Shields', 'Armor', 'Helmets', 'Legendary', 'Misc'];
	if (pt_nitypenames[this.mNamedItemsPanel.Rows[0][1].TBValue] == 'Legendary' || pt_nitypenames[this.mNamedItemsPanel.Rows[0][1].TBValue] == 'Misc')
	{
		this.mNamedItemsPanel.Rows[1][3].SInput.setInputTextBP("");
	}
    else if (!isNaN(inputtext))
    {
		this.mNItems.CurrentItem[this.mNamedItemsPanel.Rows[1][3].SIName] = inputtext;
		this.mNamedItemsPanel.Rows[1][3].SInput.setInputTextBP(""+inputtext);
    }
	else if (isNaN(inputtext))
	{
		this.mNamedItemsPanel.Rows[1][3].SInput.setInputTextBP(""+this.mNItems.CurrentItem[this.mNamedItemsPanel.Rows[1][3].SIName]);
	}
};

WorldBreditorScreen.prototype.ProcessNINameEdited = function (_input)
{
	var pt_nitypenames = ['Weapons', 'Shields', 'Armor', 'Helmets', 'Legendary', 'Misc'];
	if (pt_nitypenames[this.mNamedItemsPanel.Rows[0][1].TBValue] == 'Legendary' || pt_nitypenames[this.mNamedItemsPanel.Rows[0][1].TBValue] == 'Misc')
	{
		this.mNamedItemsPanel.Rows[0][2].NINameInput.setInputTextBP(""+this.mNamedItemsPanel.Rows[0][2].NIName);
	}
    else
    {
		this.mNamedItemsPanel.Rows[0][2].NIName = _input.getInputText();
    }
};

WorldBreditorScreen.prototype.NIAddItem = function (_input)
{
	var self = this;
	var pt_nitypenames = ['Weapons', 'Shields', 'Armor', 'Helmets', 'Legendary', 'Misc'];
	
	var result = {
		Item: this.mNItems.Items[pt_nitypenames[this.mNamedItemsPanel.Rows[0][1].TBValue]].List[this.mNamedItemsPanel.Rows[1][1].TBValue],
		ItemType: pt_nitypenames[this.mNamedItemsPanel.Rows[0][1].TBValue],
		Stats: {},
	}
	result.Stats["Name"] = self.mNamedItemsPanel.Rows[0][2].NIName;
	result.Stats["Variant"] = self.mNamedItemsPanel.Rows[0][2].NIVariant;
	$.each(self.mNItems.CurrentItem, function (_key, _value)
	{
		if(self.mNItems.CurrentItem[_key] !== null)
		{
			result.Stats[_key] = _value;
		}
	});
	
	this.notifyBackendOnAddNI(result, function(_result)
        {           
			//self.mNamedItemsPanel.Rows[0][3].NIFinButton.changeButtonText("Add (Empty: "+_result.Room+")");
			self.mNamedItemsPanel.Rows[1][4].FreeSpaceText.html(_result.Room+"仓库空位");
        }); 	
	
};

WorldBreditorScreen.prototype.ExportBroData = function ()
{
	var self = this;
	if (!self.mNamedItemsPanel.Rows[0][4].MainS && !self.mNamedItemsPanel.Rows[0][4].LifeStats && !self.mNamedItemsPanel.Rows[0][4].Gear)
	{
		self.mNamedItemsPanel.Rows[0][4].BroExpImpInput.css('font-size', '15px');
		self.mNamedItemsPanel.Rows[0][4].BroExpImpInput.setInputTextBP("Oh, come on!");
		return;
	}
	var result = {
			BroId: this.mData.ID,
			MainS: self.mNamedItemsPanel.Rows[0][4].MainS,
			LifeStats: self.mNamedItemsPanel.Rows[0][4].LifeStats,
			Gear: self.mNamedItemsPanel.Rows[0][4].Gear,
	}
	
	this.notifyBackendOnExportBroData(result, function(_result)
        {           
			self.mNamedItemsPanel.Rows[0][4].BroExpImpInput.css('font-size', '4px');
			self.mNamedItemsPanel.Rows[0][4].BroExpImpInput.setInputTextBP(_result);
        }); 	
	//this.mNamedItemsPanel.Rows[0][2].NINameInput = SINameCont
};

WorldBreditorScreen.prototype.ImportBroData = function ()
{
	var self = this;
	var data = this.mData;
	if (this.mNamedItemsPanel.Rows[0][4].BroExpImpInput.getInputText() == "")
	{
		return;
	}
	var result = {
			BroId: this.mData.ID,
			IString: this.mNamedItemsPanel.Rows[0][4].BroExpImpInput.getInputText().split("%!"), //java does it better, it doesn't skip empty sections
			MainS: self.mNamedItemsPanel.Rows[0][4].MainS,
			LifeStats: self.mNamedItemsPanel.Rows[0][4].LifeStats,
			Gear: self.mNamedItemsPanel.Rows[0][4].Gear,
	}
	this.notifyBackendOnImportBroData(result, function(_result)
	{           
		if (typeof(_result) == "string")
		{
			self.mNamedItemsPanel.Rows[0][4].BroExpImpInput.css('font-size', '15px');
			self.mNamedItemsPanel.Rows[0][4].BroExpImpInput.setInputTextBP(_result);
		}
		else 
		{
			if (_result.hasMS)
			{
				self.FullyUpdateTheBloodyEntry();
			}
			else if (_result.hasGS)
			{
				data.ImagePath = _result.ImagePath;
				self.mData.BroImage.attr('src', Path.PROCEDURAL + _result['ImagePath']);
			}
		}
	}); 
};

WorldBreditorScreen.prototype.FullyUpdateTheBloodyEntry = function ()
{
	var self = this;
	var data = this.mData;
	if(this.mSQHandle !== null)
    {
        SQ.call(this.mSQHandle, 'queryRosterInformation', self.mData.ID, function(_result)
		{           
			$.each(_result, function (_key, _value)
			{
				if ((_key == 'ActionPoints' || _key == 'DailyWage' || _key == 'DailyFood' || _key == 'PerkPoints') && _key in data)
				{
					data[_key] = _value;
					self.mStatsOptions[_key].SVal.setInputTextBP(_value+'');
				}
				else if ((_key == 'Hitpoints' || _key == 'Stamina' || _key == 'Initiative' || _key == 'Bravery' || _key == 'MeleeSkill' || _key == 'RangedSkill' || _key == 'MeleeDefense' || _key == 'RangedDefense') && _key in data)
				{
					data[_key].Max = _value.Max;
					data[_key].MaxPlus = _value.MaxPlus;
					data[_key].BLimit = _value.BLimit;
					data[_key].Talent = _value.Talent;
					self.mStatsOptions[_key].SVal.setInputTextBP(data[_key].Max+' ('+data[_key].MaxPlus+') / '+data[_key].BLimit);
					var NStars = '';
					for (var stars = 0; stars < data[_key].Talent; stars++) {
					  NStars += '*';
					}
					self.mStatsOptions[_key].TalentButton.changeButtonText(NStars);
				}
				else if (_key in data)
				{
					data[_key] = _value;
				}
				var traitcounter = 0; // copied from updatedetailspanel
				var traitslength = self.mTraits.length;
				var bgslength = self.mBackgrounds.length;
				if (self.mMode == 1)
				{
					for (var r = 0; r < self.mTraitOptions.length; r++) 
					{
						for (var trid = 1; trid < self.mTraitOptions[r].length; trid++) 
						{
							var trait = self.mTraitOptions[r][trid];
							if (traitcounter < traitslength)
							{
								trait.Container.css({ opacity: 0.33 });
								for (var i = 0; i < data.Traits.length; i++) 
								{
									if (data.Traits[i][0] == self.mTraits[traitcounter][0])
									{
										trait.Container.css({ opacity: 1 });
									}
								}
								traitcounter +=1;
							}
						} 
					}
				}
				else if (self.mMode == 2)
				{
					for (var r = 0; r < self.mTraitOptions.length; r++) 
					{
						for (var trid = 1; trid < self.mTraitOptions[r].length; trid++) 
						{
							var trait = self.mTraitOptions[r][trid];
							if (traitcounter < bgslength)
							{
								trait.Container.css({ opacity: 0.33 });
								trait.Image.attr('src', Path.GFX+self.mBackgrounds[traitcounter][2]);
								if (data.Background == self.mBackgrounds[traitcounter][0])
								{
									trait.Container.css({ opacity: 1 });
								}
							}
							traitcounter +=1;
						}
					}
				}
				self.mData.BackgroundImageObj.attr('src', Path.GFX + _result['BackgroundImagePath']);
				self.mData.BroImage.attr('src', Path.PROCEDURAL + _result['ImagePath']);
				var parsedText = XBBCODE.process({
					text: data['Name']+" (等级: "+data['Level']+" ("+data.LevelUps+"[img]gfx/ui/icons/leveled_up_bred.png[/img]), 经验: "+data['XpValue']+")",
					removeMisalignedTags: false,
					addInLineBreaks: false
				});
				self.mDetailsPanel.CharacterName.html(parsedText.html);
				self.mData.BroName.html(data['Name']);
			});
		}); 
    }
};

WorldBreditorScreen.prototype.createAssetDIV = function (_parentDiv, _imagePath, _classExtra)
{

};


WorldBreditorScreen.prototype.addListEntry = function (_data)
{
    var result = $('<div class="l-row"/>');
    this.mListScrollContainer.append(result);

    var entry = $('<div class="ui-control list-entry"/>');
    result.append(entry);
    entry.data('entry', _data);
    entry.click(this, function(_event)
	{
        var self = _event.data;
        self.selectListEntry($(this));
    });

    // left column
    var column = $('<div class="column is-left"/>');
    entry.append(column);

    var imageOffsetX = ('ImageOffsetX' in _data ? _data['ImageOffsetX'] : 0);
    var imageOffsetY = ('ImageOffsetY' in _data ? _data['ImageOffsetY'] : 0);
   _data.BroImage = column.createImage(Path.PROCEDURAL + _data['ImagePath'], function (_image)
	{
        _image.centerImageWithinParent(imageOffsetX, imageOffsetY, 0.64);
        _image.removeClass('opacity-none');
    }, null, 'opacity-none');

    // right column
    column = $('<div class="column is-right"/>');
    entry.append(column);

    // top row
    var row = $('<div class="row is-top"/>');
    column.append(row);

    var image = $('<img/>');
    image.attr('src', Path.GFX + _data['BackgroundImagePath']);
    row.append(image);
	_data.BackgroundImageObj = image;

    // bind tooltip
    image.bindTooltip({ contentType: 'ui-element', elementId: TooltipIdentifier.CharacterBackgrounds.Generic, elementOwner: TooltipIdentifier.ElementOwner.HireScreen, entityId: _data.ID });

    _data.BroName = $('<div class="name title-font-normal font-bold font-color-brother-name">' + _data[WorldTownScreenIdentifier.HireRosterEntry.Name] + '</div>');
    row.append(_data.BroName);

    // bottom row
    row = $('<div class="row is-bottom"/>');
    column.append(row);

};

WorldBreditorScreen.prototype.selectListEntry = function(_element, _scrollToEntry)
{
    if (_element !== null && _element.length > 0)
    {
        {
            this.mListContainer.deselectListEntries();
            _element.addClass('is-selected');

            // give the renderer some time to layout his shit...
            if (_scrollToEntry !== undefined && _scrollToEntry === true)
            {
                this.mListContainer.scrollListToElement(_element);
            }

            this.mSelectedEntry = _element;
            this.updateDetailsPanel(this.mSelectedEntry);
        }
    }
    else
    {
        this.mSelectedEntry = null;
        this.updateDetailsPanel(this.mSelectedEntry);
    }
};

WorldBreditorScreen.prototype.SwitchMode = function ()
{
	var traitcounter = 0;
	var traitslength = this.mTraits.length;
	var bgslength = this.mBackgrounds.length;
	var data = this.mData;
	if (this.mMode == 1)
	{
		//this.removeSkillEventHandlers();
		for (var r = 0; r < this.mTraitOptions.length; r++) 
		{
			for (var trid = 1; trid < this.mTraitOptions[r].length; trid++) 
			{
				var trait = this.mTraitOptions[r][trid];
				if (traitcounter < traitslength)
				{
					trait.Image.attr('src', Path.GFX+'ui/icons/talent_0.png');
					trait.Image.unbindTooltip();
				}
				traitcounter +=1;
			}
		}
		traitcounter = 0;
		for (var r = 0; r < this.mTraitOptions.length; r++) 
		{
			for (var trid = 1; trid < this.mTraitOptions[r].length; trid++) 
			{
				var trait = this.mTraitOptions[r][trid];
				if (traitcounter < bgslength)
				{
					trait.Container.css({ opacity: 0.33 });
					trait.Image.attr('src', Path.GFX+this.mBackgrounds[traitcounter][2]);
					trait.Image.bindTooltip({ contentType: 'ui-element', elementId: 'breditor-background-tooltip', elementOwner: this.mBackgrounds[traitcounter][1] });
					if (data.Background == this.mBackgrounds[traitcounter][0])
					{
						trait.Container.css({ opacity: 1 });
					}
					//this.attachSkillEventHandler(bg);
				}
				traitcounter +=1;
			}
		}
	}//-------------------------------------------------------------------------------------------------------------------
	else if (this.mMode == 2)
	{
		for (var r = 0; r < this.mTraitOptions.length; r++) 
		{
			for (var trid = 1; trid < this.mTraitOptions[r].length; trid++) 
			{
				var trait = this.mTraitOptions[r][trid];
				if (traitcounter < bgslength)
				{
					trait.Image.unbindTooltip();
					trait.Image.attr('src', Path.GFX+'ui/icons/talent_0.png');
				}
				traitcounter +=1;
			}
		}
		traitcounter = 0;
		for (var r = 0; r < this.mTraitOptions.length; r++) 
		{
			for (var trid = 1; trid < this.mTraitOptions[r].length; trid++) 
			{
				var trait = this.mTraitOptions[r][trid];
				if (traitcounter < traitslength)
				{
					trait.Image.attr('src', Path.GFX+this.mTraits[traitcounter][2]);
					trait.Image.bindTooltip({ contentType: 'status-effect', entityId: this.mRoster[this.mRoster.length-1].ID, statusEffectId: this.mTraits[traitcounter][0] });
					trait.Container.css({ opacity: 0.33 });
					for (var i = 0; i < data.Traits.length; i++) 
					{
						if (data.Traits[i][0] == this.mTraits[traitcounter][0])
						{
							trait.Container.css({ opacity: 1 });
						}
					}
				}
				traitcounter +=1;
			}
		}
	}
	
	this.mMode = 3 - this.mMode;
};

WorldBreditorScreen.prototype.updateDetailsPanel = function(_element)
{
    if(_element !== null && _element.length > 0)
    {
		this.mData = _element.data('entry');
        var data = this.mData;
		
        var self = this;
		var parsedText = XBBCODE.process({
			text: data['Name']+" (等级: "+data['Level']+" ("+data.LevelUps+"[img]gfx/ui/icons/leveled_up_bred.png[/img]), 经验: "+data['XpValue']+")",
			removeMisalignedTags: false,
			addInLineBreaks: false
		});
		self.mDetailsPanel.CharacterName.html(parsedText.html);
		self.mStatsOptions.Hitpoints.SVal.setInputTextBP(data.Hitpoints.Max+' ('+data.Hitpoints.MaxPlus+') / '+data.Hitpoints.BLimit);
		self.mStatsOptions.Stamina.SVal.setInputTextBP(data.Stamina.Max+' ('+data.Stamina.MaxPlus+') / '+data.Stamina.BLimit);
		self.mStatsOptions.Initiative.SVal.setInputTextBP(data.Initiative.Max+' ('+data.Initiative.MaxPlus+') / '+data.Initiative.BLimit);
		self.mStatsOptions.Bravery.SVal.setInputTextBP(data.Bravery.Max+' ('+data.Bravery.MaxPlus+') / '+data.Bravery.BLimit);
		self.mStatsOptions.MeleeSkill.SVal.setInputTextBP(data.MeleeSkill.Max+' ('+data.MeleeSkill.MaxPlus+') / '+data.MeleeSkill.BLimit);
		self.mStatsOptions.RangedSkill.SVal.setInputTextBP(data.RangedSkill.Max+' ('+data.RangedSkill.MaxPlus+') / '+data.RangedSkill.BLimit);
		self.mStatsOptions.MeleeDefense.SVal.setInputTextBP(data.MeleeDefense.Max+' ('+data.MeleeDefense.MaxPlus+') / '+data.MeleeDefense.BLimit);
		self.mStatsOptions.RangedDefense.SVal.setInputTextBP(data.RangedDefense.Max+' ('+data.RangedDefense.MaxPlus+') / '+data.RangedDefense.BLimit);
		self.mStatsOptions.ActionPoints.SVal.setInputTextBP(data.ActionPoints+'');
		self.mStatsOptions.DailyWage.SVal.setInputTextBP(data.DailyWage+'');
		self.mStatsOptions.DailyFood.SVal.setInputTextBP(data.DailyFood+'');
		self.mStatsOptions.PerkPoints.SVal.setInputTextBP(data.PerkPoints+'');
		
		$.each(this.mStatsOptions, function (_key, _value)
		{
			if (_key !== 'ActionPoints' && _key !== 'DailyWage' && _key !== 'DailyFood' && _key !== 'PerkPoints' && _key in data) //don't this it Leo because it's inside the function
			{
				var NStars = '';
				for (var stars = 0; stars < data[_key].Talent; stars++) {
				  NStars += '*';
				}
				self.mStatsOptions[_key].TalentButton.changeButtonText(NStars);

			}
		});
		var traitcounter = 0;
		var traitslength = this.mTraits.length;
		var bgslength = this.mBackgrounds.length;
		if (this.mMode == 1)
		{
			for (var r = 0; r < this.mTraitOptions.length; r++) 
			{
				for (var trid = 1; trid < this.mTraitOptions[r].length; trid++) 
				{
					var trait = this.mTraitOptions[r][trid];
					if (traitcounter < traitslength)
					{
						trait.Container.css({ opacity: 0.33 });
						for (var i = 0; i < data.Traits.length; i++) 
						{
							if (data.Traits[i][0] == self.mTraits[traitcounter][0])
							{
								trait.Container.css({ opacity: 1 });
							}
						}
						traitcounter +=1;
					}
				} 
			}
		}
		else if (this.mMode == 2)
		{
			for (var r = 0; r < this.mTraitOptions.length; r++) 
			{
				for (var trid = 1; trid < this.mTraitOptions[r].length; trid++) 
				{
					var trait = this.mTraitOptions[r][trid];
					if (traitcounter < bgslength)
					{
						trait.Container.css({ opacity: 0.33 });
						trait.Image.attr('src', Path.GFX+this.mBackgrounds[traitcounter][2]);
						if (data.Background == this.mBackgrounds[traitcounter][0])
						{
							trait.Container.css({ opacity: 1 });
						}
					}
					traitcounter +=1;
				}
			}
		}
		this.notifyBackendEntrySelected(data['ID'], function(imagePath)
        {           
            self.mDetailsPanel.Container.removeClass('display-none').addClass('display-block');
        });
    }
    else
    {
        this.mDetailsPanel.Container.removeClass('display-block').addClass('display-none');
    }
};

WorldBreditorScreen.prototype.bindTooltips = function ()
{

};

WorldBreditorScreen.prototype.unbindTooltips = function ()
{

};


WorldBreditorScreen.prototype.create = function(_parentDiv)
{
    this.createDIV(_parentDiv);
    this.bindTooltips();
};

WorldBreditorScreen.prototype.destroy = function()
{
    this.unbindTooltips();
    this.destroyDIV();
};


WorldBreditorScreen.prototype.register = function (_parentDiv)
{
    console.log('WorldBreditorScreen::REGISTER');

    if (this.mContainer !== null)
    {
        console.error('ERROR: Failed to register Breditor Screen. Reason: Already initialized.');
        return;
    }

    if (_parentDiv !== null && typeof(_parentDiv) == 'object')
    {
        this.create(_parentDiv);
    }
};

WorldBreditorScreen.prototype.unregister = function ()
{
    console.log('WorldBreditorScreen::UNREGISTER');

    if (this.mContainer === null)
    {
        console.error('ERROR: Failed to unregister Breditor Screen. Reason: Not initialized.');
        return;
    }

    this.destroy();
};

WorldBreditorScreen.prototype.isRegistered = function ()
{
    if (this.mContainer !== null)
    {
        return this.mContainer.parent().length !== 0;
    }

    return false;
};


WorldBreditorScreen.prototype.show = function (_data)
{
    this.loadFromData(_data);

	if(!this.mIsVisible)
	{
		var self = this;

		var withAnimation = true;//(_data !== undefined && _data['withSlideAnimation'] !== null) ? _data['withSlideAnimation'] : true;
		if (withAnimation === true)
		{
			var offset = -(this.mContainer.parent().width() + this.mContainer.width());
			this.mContainer.css({ 'left': offset });
			this.mContainer.velocity("finish", true).velocity({ opacity: 1, left: '0', right: '0' }, {
				duration: Constants.SCREEN_SLIDE_IN_OUT_DELAY,
				easing: 'swing',
				begin: function () {
					$(this).removeClass('display-none').addClass('display-block');
					self.notifyBackendOnAnimating();
				},
				complete: function () {
					self.mIsVisible = true;
					self.notifyBackendOnShown();
				}
			});
		}
		else
		{
			this.mContainer.css({ opacity: 0 });
			this.mContainer.velocity("finish", true).velocity({ opacity: 1 }, {
				duration: Constants.SCREEN_FADE_IN_OUT_DELAY,
				easing: 'swing',
				begin: function() {
					$(this).removeClass('display-none').addClass('display-block');
					self.notifyBackendOnAnimating();
				},
				complete: function() {
					self.mIsVisible = true;
					self.notifyBackendOnShown();
				}
			});
		}
	}
};

WorldBreditorScreen.prototype.hide = function (_withSlideAnimation)
{
    var self = this;
	this.mNamedItemsPanel.Rows[0][4].BroExpImpInput.setInputTextBP("");

    var withAnimation = true;//(_withSlideAnimation !== undefined && _withSlideAnimation !== null) ? _withSlideAnimation : true;
    if (withAnimation === true)
    {
        var offset = -(this.mContainer.parent().width() + this.mContainer.width());
        this.mContainer.velocity("finish", true).velocity({ opacity: 0, left: offset },
		{
            duration: Constants.SCREEN_SLIDE_IN_OUT_DELAY,
            easing: 'swing',
            begin: function ()
            {
                $(this).removeClass('is-center');
                self.notifyBackendOnAnimating();
            },
            complete: function ()
            {
            	self.mIsVisible = false;
            	self.mListScrollContainer.empty();
                $(this).removeClass('display-block').addClass('display-none');
                self.notifyBackendOnHidden();
            }
        });
    }
    else
    {
    	this.mContainer.velocity("finish", true).velocity({ opacity: 0 },
		{
            duration: Constants.SCREEN_SLIDE_IN_OUT_DELAY,
            easing: 'swing',
            begin: function ()
            {
                $(this).removeClass('is-center');
                self.notifyBackendOnAnimating();
            },
            complete: function ()
            {
                self.mIsVisible = false;
                self.mListScrollContainer.empty();
                $(this).removeClass('display-block').addClass('display-none');
                self.notifyBackendOnHidden();
            }
        });
    }
};

WorldBreditorScreen.prototype.isVisible = function ()
{
    return this.mIsVisible;
};

WorldBreditorScreen.prototype.loadFromData = function (_data)
{
	if(_data === undefined || _data === null)
    {
        return;
    }

	if('Title' in _data && _data.Title !== null)
	{
		 this.mDialogContainer.findDialogTitle().html(_data.Title);
	}

/* 	if('SubTitle' in _data && _data.SubTitle !== null)
	{
		 this.mDialogContainer.findDialogSubTitle().html(_data.SubTitle);
	} */
	this.mMode = 1;
	this.mRoster = _data.Roster;
	this.mTraits = _data.Traits;
	this.mBackgrounds = _data.Backgrounds;
	this.mNItems = _data.NamedItems;
	
	var traitcounter = 0;
	var traitslength = this.mTraits.length;
	for (var r = 0; r < this.mTraitOptions.length; r++) 
	{
		for (var trid = 1; trid < this.mTraitOptions[r].length; trid++) 
		{
 			var trait = this.mTraitOptions[r][trid];
			if (traitcounter < traitslength)
			{
				trait.Image.attr('src', Path.GFX+this.mTraits[traitcounter][2]);
				trait.Image.bindTooltip({ contentType: 'status-effect', entityId: _data.Roster[_data.Roster.length-1].ID, statusEffectId: this.mTraits[traitcounter][0] });
				trait.Container.css({ opacity: 0.33 });
				traitcounter +=1;
			}
		}
	}
	this.setupSkillEventHandlers();
	
	this.mNamedItemsPanel.Rows[0][1].TBValue = 0;
	this.mNamedItemsPanel.Rows[0][1].TypeButton.changeButtonText("武器");
	this.mNamedItemsPanel.Rows[1][1].TBValue = 0;
	this.RerollNIData();
	this.mNamedItemsPanel.Rows[0][4].BroExpImpInput.setInputTextBP("");
	//this.mNamedItemsPanel.Rows[1][1].TypeButton.changeButtonText(this.mNItems.Items["Weapons"].List[0]);
	
	//this.mStatsOptions.Hitpoints.TraitContainer[2].Image.attr('src', Path.GFX + Asset.ICON_FATIGUE); //self.mTraits[1][2]
	
	
    this.mListScrollContainer.empty();

    for(var i = 0; i < _data.Roster.length - 1; ++i)
    {
		var entry = _data.Roster[i];
        this.addListEntry(entry);
    }

    this.selectListEntry(this.mListContainer.findListEntryByIndex(0), true);
};

WorldBreditorScreen.prototype.setupSkillEventHandlers = function()
{
	this.removeSkillEventHandlers();
	var traitcounter = 0;
	if (this.mMode == 1)
	{
		var traitslength = this.mTraits.length;
		for (var r = 0; r < this.mTraitOptions.length; r++) 
		{
			for (var trid = 1; trid < this.mTraitOptions[r].length; trid++) 
			{
				var trait = this.mTraitOptions[r][trid];
				if (traitcounter < traitslength)
				{
					this.attachSkillEventHandler(trait);
				}
				traitcounter +=1;
			}
		}
	}
};

WorldBreditorScreen.prototype.attachSkillEventHandler = function(_trait)
{
	var self = this;
	_trait.Container.click(this, function (_event)
	{
		var traitcounter = 0;
		if (self.mMode == 1)
		{
			var traitslength = self.mTraits.length;
			for (var r = 0; r < self.mTraitOptions.length; r++) 
			{
				for (var trid = 1; trid < self.mTraitOptions[r].length; trid++) 
				{
					var trait = self.mTraitOptions[r][trid];
					if (traitcounter < traitslength && trait == _trait)
					{
						self.ToggleSkill(r, trid, traitcounter);
					}
					traitcounter +=1;
				}
			}
		}
		else if (self.mMode == 2)
		{
			var bgslength = self.mBackgrounds.length;
			for (var r = 0; r < self.mTraitOptions.length; r++) 
			{
				for (var trid = 1; trid < self.mTraitOptions[r].length; trid++) 
				{
					var trait = self.mTraitOptions[r][trid];
					if (traitcounter < bgslength && trait == _trait)
					{
						self.ChooseBG(r, trid, traitcounter);
					}
					traitcounter +=1;
				}
			}
		}
	});
};

WorldBreditorScreen.prototype.removeSkillEventHandlers = function()
{
	var traitcounter = 0;
	if (this.mMode == 1)
	{
		var traitslength = this.mTraits.length;
		for (var r = 0; r < this.mTraitOptions.length; r++) 
		{
			for (var trid = 1; trid < this.mTraitOptions[r].length; trid++) 
			{
				var trait = this.mTraitOptions[r][trid];
				if (traitcounter < traitslength)
				{
					trait.Container.unbind('click');
				}
				traitcounter +=1;
			}
		}
	}
};

WorldBreditorScreen.prototype.notifyBackendOnConnected = function ()
{
	if(this.mSQHandle !== null)
	{
		SQ.call(this.mSQHandle, 'onScreenConnected');
	}
};

WorldBreditorScreen.prototype.notifyBackendOnDisconnected = function ()
{
	if(this.mSQHandle !== null)
	{
		SQ.call(this.mSQHandle, 'onScreenDisconnected');
	}
};

WorldBreditorScreen.prototype.notifyBackendOnShown = function ()
{
    if(this.mSQHandle !== null)
    {
        SQ.call(this.mSQHandle, 'onScreenShown');
    }
};

WorldBreditorScreen.prototype.notifyBackendOnHidden = function ()
{
    if(this.mSQHandle !== null)
    {
        SQ.call(this.mSQHandle, 'onScreenHidden');
    }
};

WorldBreditorScreen.prototype.notifyBackendOnAnimating = function ()
{
    if(this.mSQHandle !== null)
    {
        SQ.call(this.mSQHandle, 'onScreenAnimating');
    }
};

WorldBreditorScreen.prototype.notifyBackendCloseButtonPressed = function (_buttonID)
{
    this.mNamedItemsPanel.Rows[0][4].BroExpImpInput.setInputTextBP("");
	if(this.mSQHandle !== null)
    {
        SQ.call(this.mSQHandle, 'onClose', _buttonID);
    }
};

WorldBreditorScreen.prototype.notifyBackendOnChangingAttributes = function (_result)
{
    if(this.mSQHandle !== null)
    {
        SQ.call(this.mSQHandle, 'onChangeAttributes', _result);
    }
};

WorldBreditorScreen.prototype.notifyBackendOnUpdateAttributes = function (_result, _callback)
{
    if(this.mSQHandle !== null)
    {
        SQ.call(this.mSQHandle, 'BDUpdateAttributes', _result, _callback);
    }
};

WorldBreditorScreen.prototype.notifyBackendOnChangingTalents = function (_result)
{
    if(this.mSQHandle !== null)
    {
        SQ.call(this.mSQHandle, 'onChangeTalents', _result);
    }
};

WorldBreditorScreen.prototype.notifyBackendOnChangingTraits = function (_result)
{
    if(this.mSQHandle !== null)
    {
        SQ.call(this.mSQHandle, 'onChangeTraits', _result);
    }
};
WorldBreditorScreen.prototype.notifyBackendOnChoosingBG = function (_result, _callback)
{
    if(this.mSQHandle !== null)
    {
        SQ.call(this.mSQHandle, 'onChooseBG', _result, _callback);
    }
};

WorldBreditorScreen.prototype.notifyBackendOnGiveXP = function (_result, _callback)
{
    if(this.mSQHandle !== null)
    {
        SQ.call(this.mSQHandle, 'OnGiveXP', _result, _callback);
    }
};

WorldBreditorScreen.prototype.notifyBackendOnGiveOP = function (_result, _callback)
{
    if(this.mSQHandle !== null)
    {
        SQ.call(this.mSQHandle, 'OnGiveOP', _result, _callback);
    }
};

WorldBreditorScreen.prototype.notifyBackendOnGiveYF = function (_result, _callback)
{
    if(this.mSQHandle !== null)
    {
        SQ.call(this.mSQHandle, 'OnGiveYF', _result, _callback);
    }
};

WorldBreditorScreen.prototype.notifyBackendNIReroll = function (_result, _callback)
{
    if(this.mSQHandle !== null)
    {
        SQ.call(this.mSQHandle, 'NIReroll', _result, _callback);
    }
};

WorldBreditorScreen.prototype.notifyBackendOnAddNI = function (_result, _callback)
{
    if(this.mSQHandle !== null)
    {
        SQ.call(this.mSQHandle, 'AddNI', _result, _callback);
    }
};

WorldBreditorScreen.prototype.notifyBackendOnExportBroData = function (_result, _callback)
{
    if(this.mSQHandle !== null)
    {
        SQ.call(this.mSQHandle, 'ExportBro', _result, _callback);
    }
};

WorldBreditorScreen.prototype.notifyBackendOnImportBroData = function (_result, _callback)
{
    if(this.mSQHandle !== null)
    {
        SQ.call(this.mSQHandle, 'ImportBro', _result, _callback);
    }
};

WorldBreditorScreen.prototype.notifyBackendEntrySelected = function (_entryID, _callback)
{
	SQ.call(this.mSQHandle, 'onEntrySelected', _entryID, _callback);
};

var BEFanYi = function(text)
{

	text = text.replace("Axe", "斧");
	text = text.replace("Bardiche", "月牙砍刀");
	text = text.replace("Battle whip", "战鞭");
	text = text.replace("Billhook", "钩镰枪");
	text = text.replace("Warscythe", "军用镰刀");
	text = text.replace("Cleaver", "砍刀");
	text = text.replace("Crossbow", "弩");
	text = text.replace("Crypt cleaver", "墓穴砍刀");
	text = text.replace("Dagger", "匕首");
	text = text.replace("Fencing sword", "刺剑");
	text = text.replace("Flail", "链枷");
	text = text.replace("Goblin falchion", "哥布林弯形剑");
	text = text.replace("Goblin heavy bow", "哥布林重弓");
	text = text.replace("Goblin pike", "哥布林梭矛");
	text = text.replace("Goblin spear", "哥布林长矛");
	text = text.replace("Greataxe", "双手巨斧");
	text = text.replace("Greatsword", "双手大剑");
	text = text.replace("Handgonne", "手炮");
	text = text.replace("Heavy rusty axe", "生锈重型斧");
	text = text.replace("Javelin", "标枪");
	text = text.replace("Khopesh", "弯刀");
	text = text.replace("Longaxe", "长斧");
	text = text.replace("Mace", "棍棒");
	text = text.replace("Orc axe", "兽人斧");
	text = text.replace("Orc cleaver", "兽人砍刀");
	text = text.replace("Pike", "梭矛");
	text = text.replace("Polehammer", "长锤");
	text = text.replace("Polemace", "长棍");
	text = text.replace("Qatal dagger", "卡塔尔匕首");
	text = text.replace("Rusty warblade", "生锈战刀");
	text = text.replace("Shamshir", "塞施尔弯刀");
	text = text.replace("Skullhammer", "头骨锤");
	text = text.replace("Spear", "长矛");
	text = text.replace("Spetum", "长戟");
	text = text.replace("Sword", "剑");
	text = text.replace("Swordlance", "刃矛");
	text = text.replace("Three headed flail", "三头链枷");
	text = text.replace("Throwing axe", "投斧");
	text = text.replace("Two handed flail", "双手链枷");
	text = text.replace("Two handed hammer", "双手锤");
	text = text.replace("Two handed mace", "双手棍");
	text = text.replace("Two handed mace", "test");
	text = text.replace("Two handed mace", "test");
	text = text.replace("Warbow", "战弓");
	text = text.replace("Warbrand", "战剑");
	text = text.replace("Warhammer", "战锤");
	text = text.replace("additional padding", "额外的填充物");
	text = text.replace("Barbarian horn", "野蛮人之角");
	text = text.replace("Bone platings", "骨头板");
	text = text.replace("Direwolf pelt", "冰原野狼皮");
	text = text.replace("test", "test");
	text = text.replace("test", "test");
	
	text = text.replace("ConditionMax", "最大耐久");
	text = text.replace("StaminaModifier", "疲劳修正");
	text = text.replace("MeleeDefense", "近战防御");
	text = text.replace("RangedDefense", "远程防御");
	text = text.replace("FatigueOnSkillUse", "武器技能疲劳");
	text = text.replace("RegularDamageMax", "最大伤害");
	text = text.replace("RegularDamage", "最小伤害");
	text = text.replace("ArmorDamageMult", "护甲伤害系数");
	text = text.replace("DirectDamageAdd", "穿甲伤害");
	text = text.replace("ChanceToHitHead", "击中头部几率");
	text = text.replace("ShieldDamage", "盾牌伤害");
	text = text.replace("AdditionalAccuracy", "额外命中几率");
	text = text.replace("AmmoMax", "填装量");
	
	text = text.replace("Weapons", "武器");
	text = text.replace("Shields", "盾牌");
	text = text.replace("Armor", "盔甲");
	text = text.replace("Helmets", "头盔");
	text = text.replace("Legendary", "传奇");
	text = text.replace("Misc", "杂项");
	
	return text;
}