local assets=
{
    Asset("ANIM", "anim/fs.zip"),
    Asset("ANIM", "anim/swap_fs.zip"),
  
    Asset("ATLAS", "images/inventoryimages/fs.xml"), 
    Asset("IMAGE", "images/inventoryimages/fs.tex"),
}

    local function onequip(inst, owner)
        owner.AnimState:OverrideSymbol("swap_object", "swap_fs", "swap_batbat")
        owner.AnimState:Show("ARM_carry") 
        owner.AnimState:Hide("ARM_normal") 
    end

    local function onunequip(inst, owner) 
        owner.AnimState:Hide("ARM_carry") 
        owner.AnimState:Show("ARM_normal") 
    end

local function fn()
    local inst = CreateEntity()
    local trans = inst.entity:AddTransform()
    local anim = inst.entity:AddAnimState()

    MakeInventoryPhysics(inst)

    inst.AnimState:SetBank("batbat")
    inst.AnimState:SetBuild("fs")
    inst.AnimState:PlayAnimation("idle")

    inst:AddComponent("inspectable")
    
    inst:AddComponent("inventoryitem")
    inst.components.inventoryitem.atlasname = "images/inventoryimages/fs.xml"

	inst:AddComponent("equippable")
    inst.components.equippable:SetOnEquip( onequip )
    inst.components.equippable:SetOnUnequip( onunequip )

    inst:AddTag("sharp")


local function onhit(inst, attacker, target)
    SpawnPrefab("collapse_small").Transform:SetPosition(target.Transform:GetWorldPosition())
    SpawnPrefab("explode_small").Transform:SetPosition(target.Transform:GetWorldPosition())
    local pos = Vector3(target.Transform:GetWorldPosition())
    GetClock():DoLightningLighting()
    GetPlayer().components.playercontroller:ShakeCamera(target, "FULL", 0.7, 0.02, .5, 40)
    inst.components.combat:DoAreaAttack(target, 8)
    inst:Remove()

  
end
local function onthrown(inst, data)
    inst.AnimState:SetOrientation( ANIM_ORIENTATION.OnGround )
end

    inst:AddComponent("weapon")
    inst.components.weapon:SetDamage(120)
inst.components.weapon:SetRange(7, 8)
  


   inst:AddComponent("combat")
  inst.components.combat:SetDefaultDamage(120)
    inst.components.combat.playerdamagepercent = 0

 inst:AddComponent("stackable")
   inst.components.equippable.equipstack = true
   
inst:AddComponent("projectile")
    inst.components.projectile:SetSpeed(60)
    inst.components.projectile:SetOnHitFn(onhit)
    inst:ListenForEvent("onthrown", onthrown)

	return inst
end
	

return Prefab( "common/inventory/fs", fn, assets) 
