local assets=
{
    Asset("ANIM", "anim/isword.zip"),
    Asset("ANIM", "anim/swap_isword.zip"),
  
    Asset("ATLAS", "images/inventoryimages/isword.xml"), 
    Asset("IMAGE", "images/inventoryimages/isword.tex"),
}

    local function onequip(inst, owner)
        owner.AnimState:OverrideSymbol("swap_object", "swap_isword", "swap_cutlass")
        owner.AnimState:Show("ARM_carry") 
        owner.AnimState:Hide("ARM_normal") 
    end

    local function onunequip(inst, owner) 
        owner.AnimState:Hide("ARM_carry") 
        owner.AnimState:Show("ARM_normal") 
    end


local function fn()
    local inst = CreateEntity()
    local trans = inst.entity:AddTransform()
    local anim = inst.entity:AddAnimState()

    MakeInventoryPhysics(inst)


    inst.AnimState:SetBank("cutlass")
    inst.AnimState:SetBuild("isword")
    inst.AnimState:PlayAnimation("idle")

    inst:AddComponent("inspectable")
  
    inst:AddComponent("inventoryitem")
    inst.components.inventoryitem.atlasname = "images/inventoryimages/isword.xml"


    inst:AddComponent("equippable")
    inst.components.equippable:SetOnEquip( onequip )
    inst.components.equippable:SetOnUnequip( onunequip )

    inst.bg = 0
    local function onattack(inst, attacker, target)
        inst.bg=inst.bg +1  

    
      
        if inst.bg % 3 == 0 and target.components.freezable and not target:HasTag("player") then
        target.components.freezable:AddColdness(3)
        target.components.freezable:SpawnShatterFX()

   
end
    

local pos = Vector3(target.Transform:GetWorldPosition())
    local ents = TheSim:FindEntities(pos.x,pos.y,pos.z, 4)
    for k,v in pairs(ents) do      
        if  math.random()<0.08 and v.components.freezable and not v:HasTag("player") then
        v.components.freezable:AddColdness(3)
        v.components.freezable:SpawnShatterFX()
v.components.health:DoDelta(-40)
   
end
        end


    end

    inst:AddComponent("weapon")
    inst.components.weapon:SetDamage(40)
    inst:ListenForEvent("onattacker",onattack)
    inst.components.weapon.onattack = onattack
     inst:AddTag("sharp")

 
	
	
    inst:AddComponent("finiteuses")
    inst.components.finiteuses:SetMaxUses(150)
    inst.components.finiteuses:SetUses(150)
    inst.components.finiteuses:SetOnFinished(inst.Remove)


	return inst
end
	

return Prefab( "common/inventory/isword", fn, assets) 
