require("recipe")
local MakePlayerCharacter = require "prefabs/player_common"


local assets = {

        Asset( "ANIM", "anim/player_basic.zip" ),
        Asset( "ANIM", "anim/player_idles_shiver.zip" ),
        Asset( "ANIM", "anim/player_actions.zip" ),
        Asset( "ANIM", "anim/player_actions_axe.zip" ),
        Asset( "ANIM", "anim/player_actions_pickaxe.zip" ),
        Asset( "ANIM", "anim/player_actions_shovel.zip" ),
        Asset( "ANIM", "anim/player_actions_blowdart.zip" ),
        Asset( "ANIM", "anim/player_actions_eat.zip" ),
        Asset( "ANIM", "anim/player_actions_item.zip" ),
        Asset( "ANIM", "anim/player_actions_uniqueitem.zip" ),
        Asset( "ANIM", "anim/player_actions_bugnet.zip" ),
        Asset( "ANIM", "anim/player_actions_fishing.zip" ),
        Asset( "ANIM", "anim/player_actions_boomerang.zip" ),
        Asset( "ANIM", "anim/player_bush_hat.zip" ),
        Asset( "ANIM", "anim/player_attacks.zip" ),
        Asset( "ANIM", "anim/player_idles.zip" ),
        Asset( "ANIM", "anim/player_rebirth.zip" ),
        Asset( "ANIM", "anim/player_jump.zip" ),
        Asset( "ANIM", "anim/player_amulet_resurrect.zip" ),
        Asset( "ANIM", "anim/player_teleport.zip" ),
        Asset( "ANIM", "anim/wilson_fx.zip" ),
        Asset( "ANIM", "anim/player_one_man_band.zip" ),
        Asset( "ANIM", "anim/shadow_hands.zip" ),
        Asset( "SOUND", "sound/sfx.fsb" ),
        Asset( "SOUND", "sound/wilson.fsb" ),
        Asset( "ANIM", "anim/beard.zip" ),

        Asset( "ANIM", "anim/ks.zip" ),
}
local prefabs = {}
local start_inv = {  
    "goldnugget", "fs", "lj",
}

local max_upgrades = 20
local function applyupgrades(inst)

        
        local upgrades = math.min(inst.level, max_upgrades)

        local hunger_percent = inst.components.hunger:GetPercent()
        local health_percent = inst.components.health:GetPercent()
        local sanity_percent = inst.components.sanity:GetPercent()

        inst.components.hunger.max = math.ceil (120 + upgrades * 3)
        inst.components.health.maxhealth = math.ceil (70 + upgrades * 3)
        inst.components.sanity.max = math.ceil (120 + upgrades * 3)

   

        inst.components.talker:Say("kill wish : ".. (inst.level))
        
        if inst.level >19 then
                inst.components.talker:Say("kill wish : Max!")
inst.components.combat.damagemultiplier = 1.5
inst.components.combat:AddDamageModifier("wigfrid", TUNING.WATHGRITHR_DAMAGE_MULT)
inst.components.sanity.neg_aura_mult = 0
inst.components.combat.min_attack_period = 0.3
        end

        inst.components.hunger:SetPercent(hunger_percent)
        inst.components.health:SetPercent(health_percent)
        inst.components.sanity:SetPercent(sanity_percent)
end

local function onkill(inst, data)
inst.components.sanity:DoDelta(1)
if data.cause == inst.prefab 
		
		and not data.inst:HasTag("veggie") 
		and not data.inst:HasTag("structure")
and TUNING.R_D < 150  then
             
        			TUNING.R_D = TUNING.R_D + 2.5
    		
	end

    local chance1 = 0.13
    local chance2 = 0.09
    local iflevelup = false
    if data.cause == inst.prefab and not data.inst:HasTag("companion") then
        if math.random() < chance1 and data.inst:HasTag("monster") then
            iflevelup = true
        elseif math.random() < chance2 and not data.inst:HasTag("monster") and not data.inst:HasTag("insect") then
            iflevelup = true
        end
    end

    if iflevelup and inst.level < max_upgrades then
        inst.level = inst.level + 1
        applyupgrades(inst) 
        inst.SoundEmitter:PlaySound("dontstarve/characters/wx78/levelup")

        --icon pulse while upgrading
        inst.HUD.controls.status.heart:PulseGreen()
        inst.HUD.controls.status.stomach:PulseGreen()
        inst.HUD.controls.status.brain:PulseGreen()
            
        inst.HUD.controls.status.brain:ScaleTo(1.3,1,.7)
        inst.HUD.controls.status.heart:ScaleTo(1.3,1,.7)
        inst.HUD.controls.status.stomach:ScaleTo(1.3,1,.7)
    end
end


local function onpreload(inst, data)
        if data then
                if data.level then
                        inst.level = data.level
TUNING.R_D = data.R_D
                        applyupgrades(inst)
                        --re-set these from the save data, because of load-order clipping issues
                        if data.health and data.health.health then inst.components.health.currenthealth = data.health.health end
                        if data.hunger and data.hunger.hunger then inst.components.hunger.current = data.hunger.hunger end
                        if data.sanity and data.sanity.current then inst.components.sanity.current = data.sanity.current end
                        inst.components.health:DoDelta(10)
                        inst.components.hunger:DoDelta(10)
                        inst.components.sanity:DoDelta(10)
                end
        end

end

local function onsave(inst, data)
        data.level = inst.level
data.R_D = TUNING.R_D
end


local function oneat(inst, food)
if food and food.components.edible and food.components.edible.sanityvalue > 0 and TUNING.R_D < 150 then
	local f_mana = food.components.edible.hungervalue
	TUNING.R_D = TUNING.R_D + f_mana*0.5
	end
end

local fn = function(inst)
TUNING.R_D = 100
inst:ListenForEvent("entity_death", function(wrld, data) onkill(inst, data) end, GetWorld())

TheInput:AddKeyUpHandler(KEY_R, function()--check mana
        if TheInput:IsKeyDown(KEY_CTRL) then	
        inst.components.talker:Say("mana= " .. (TUNING.R_D))
        end
    end)


    inst.soundsname = "willow"
    inst.MiniMapEntity:SetIcon( "ks.tex" )
        inst.components.health.absorb = 0
        inst.level = 0
        applyupgrades(inst)

    -- Damage multiplier (optional)
    inst.components.combat.damagemultiplier = 0.9
    
    -- Movement speed (optional)
    inst.components.locomotor.walkspeed = 5
    inst.components.locomotor.runspeed = 7

    inst.OnSave = onsave
    inst.OnPreLoad = onpreload

local function OnAttacked(inst, data)
inst.components.sanity:DoDelta(-3)


       
  
end
inst:ListenForEvent("attacked", OnAttacked)
TheInput:AddKeyUpHandler(KEY_G, function()


    if not inst:HasTag("chameleon") and TUNING.R_D > 19 then
       inst.components.locomotor:Stop()
       inst.components.talker:ShutUp()
       inst.components.playercontroller:Enable(false)
TUNING.R_D = TUNING.R_D - 20
       local head = GetPlayer().components.inventory:GetEquippedItem(EQUIPSLOTS.HEAD)
       GetPlayer().components.inventory:DropItem(head)
       local hands = GetPlayer().components.inventory:GetEquippedItem(EQUIPSLOTS.HANDS)
       GetPlayer().components.inventory:DropItem(hands)
     
     
       inst.components.sanity.ignore = true
      
       SpawnPrefab("collapse_small").Transform:SetPosition(inst.Transform:GetWorldPosition())
       inst:DoTaskInTime(0.3, function() 
           inst:AddTag("chameleon")
           inst.chameleon = inst:DoPeriodicTask(.5, function()
               local pos = Vector3(inst.Transform:GetWorldPosition())
               local ents = TheSim:FindEntities(pos.x,pos.y,pos.z, 25)
               for k,v in pairs(ents) do
                   if v.components.combat and v.components.combat.target and v.components.combat.target == inst then
                      v.components.combat:SetTarget(nil)
                   end
               end
           end )
           if inst.level < 10 then
              inst.AnimState:SetBank("rabbit")
              inst.AnimState:SetBuild("rabbit_build")
              inst.AnimState:PlayAnimation("idle")
              local rabbitsounds = { scream = "dontstarve/rabbit/scream", hurt = "dontstarve/rabbit/scream_short", }
              inst.sounds = rabbitsounds
              inst.data = {}
              inst:SetStateGraph("SGra")
 inst.components.locomotor.walkspeed = 7
    inst.components.locomotor.runspeed = 9
           elseif inst.level > 9 then
              inst.AnimState:SetBank("perd")
              inst.AnimState:SetBuild("perd")
              inst.AnimState:PlayAnimation("idle_loop")
              inst:SetStateGraph("SGpe")
                inst.components.locomotor.walkspeed = 9
    inst.components.locomotor.runspeed = 11
         
    local light = inst.entity:AddLight()
    light:SetFalloff(1)
    light:SetIntensity(.8)
    light:SetRadius(10)
    light:Enable(true)
    light:SetColour(0/255, 255/255, 0/255)


          
        
     
           end
           inst.components.playercontroller:Enable(true)
       end )
    else
        inst.components.locomotor:Stop()
        inst.components.talker:ShutUp()
        inst.components.playercontroller:Enable(false)
        SpawnPrefab("collapse_small").Transform:SetPosition(inst.Transform:GetWorldPosition())
        inst:DoTaskInTime(0.3, function()
            inst:RemoveTag("chameleon")
            if inst.chameleon then inst.chameleon:Cancel() inst.chameleon = nil end
            inst.AnimState:SetBank("wilson")
            inst.AnimState:SetBuild("ks")
            inst.AnimState:PlayAnimation("idle")
            inst:SetStateGraph("SGwilson")
         inst.components.combat:SetDefaultDamage(5)
            inst.components.health:SetInvincible(false)
            inst.components.hunger:Resume()
            inst.components.sanity.ignore = false

   inst.components.locomotor.walkspeed = 5
    inst.components.locomotor.runspeed = 7
   inst.Light:Enable(false)
            inst.components.temperature:SetTemp(nil)
            inst.components.playercontroller:Enable(true)
        end )
    end
end )
    -- lower profit from non-meat food

    inst:ListenForEvent("entity_death", function(wrld, data) onkill(inst, data) end, GetWorld())

   local fs = Recipe("fs", {Ingredient("nightmarefuel", 1), Ingredient("nitre", 1)}, RECIPETABS.WAR, {SCIENCE = 0})
    fs.atlas = "images/inventoryimages/fs.xml"

    local fs = Ingredient( "fs", 1)
    fs.atlas = "images/inventoryimages/fs.xml"

  local xsword = Ingredient( "xsword", 1)
    xsword.atlas = "images/inventoryimages/xsword.xml"

    local isword = Recipe("isword", {xsword, Ingredient("ice", 10), Ingredient("bluegem", 2)}, RECIPETABS.WAR, {SCIENCE = 1})
    isword.atlas = "images/inventoryimages/isword.xml"

    local isword = Ingredient( "isword", 1)
    isword.atlas = "images/inventoryimages/isword.xml"

    local lsword = Recipe("lsword", {xsword, Ingredient("goldnugget", 3), Ingredient("transistor", 2)}, RECIPETABS.WAR, {SCIENCE = 1})
    lsword.atlas = "images/inventoryimages/lsword.xml"

 local xsword = Recipe("xsword", {Ingredient("flint", 10), Ingredient("twigs", 10), Ingredient("goldnugget", 1)}, RECIPETABS.WAR, {SCIENCE = 0})
   xsword.atlas = "images/inventoryimages/xsword.xml"

 local lj = Recipe("lj", {Ingredient("butterflywings", 1), Ingredient("berries", 2), Ingredient("honey", 2)}, RECIPETABS.SURVIVAL, {SCIENCE = 0})
   lj.atlas = "images/inventoryimages/lj.xml"


end


return MakePlayerCharacter("ks", prefabs, assets, fn, start_inv)
