local assets=
{
	Asset("ANIM", "anim/lj.zip"),
Asset("ATLAS", "images/inventoryimages/lj.xml"),
    Asset("IMAGE", "images/inventoryimages/lj.tex"),
}



local function fn(Sim)
		local inst = CreateEntity()
	inst.entity:AddTransform()
	inst.entity:AddAnimState()
    
    MakeInventoryPhysics(inst)
    MakeBlowInHurricane(inst, TUNING.WINDBLOWN_SCALE_MIN.MEDIUM, TUNING.WINDBLOWN_SCALE_MAX.MEDIUM)
    
    inst:AddTag("meat")

	
    inst:AddComponent("edible")
    inst.components.edible.ismeat = true    
    inst.components.edible.foodtype = "MEAT"
    inst.components.edible.foodstate = "RAW"
    
    inst:AddComponent("stackable")
    
    inst:AddComponent("inspectable")
    
     inst:AddComponent("inventoryitem")
    inst.components.inventoryitem.imagename = "lj"
    inst.components.inventoryitem.atlasname = "images/inventoryimages/lj.xml"

    inst.AnimState:SetBank("monstermeat")
    inst.AnimState:SetBuild("lj")
    inst.AnimState:PlayAnimation("idle")
    MakeInventoryFloatable(inst, "idle_water", "idle")
    
    inst.components.edible.ismeat = true    
    inst.components.edible.foodtype = "MEAT"
    inst.components.edible.healthvalue = TUNING.HEALING_SMALL
    inst.components.edible.hungervalue = TUNING.CALORIES_MEDSMALL
    inst.components.edible.sanityvalue = TUNING.SANITY_SMALL
 local function proc(inst, eater)
        eater.components.health:SetInvincible(true)
        inst:AddTag("forcefield")
        local fx = SpawnPrefab("forcefieldfx")
        fx.entity:SetParent(eater.entity)
        fx.Transform:SetPosition(0, 0.2, 0)
        local fx_hitanim = function()
            fx.AnimState:PlayAnimation("hit")
            fx.AnimState:PushAnimation("idle_loop")
        end
        fx:ListenForEvent("blocked", fx_hitanim, eater)
        inst.active = true
        eater:DoTaskInTime(15, function()
            fx:RemoveEventCallback("blocked", fx_hitanim, eater)
            fx.kill_fx(fx)
            if inst:IsValid() then
                eater.components.health:SetInvincible(false)
                inst:RemoveTag("forcefield")
                eater:DoTaskInTime(5, function() inst.active = false end)
            end
        end)
    end
local function oneaten(inst, eater)
	proc(inst, eater)
end
       	inst.components.edible:SetOnEatenFn(oneaten)

  
    
    return inst
end

return Prefab( "common/inventory/lj", fn, assets) 
