local assets=
{
    Asset("ANIM", "anim/lsword.zip"),
    Asset("ANIM", "anim/swap_lsword.zip"),
  
    Asset("ATLAS", "images/inventoryimages/lsword.xml"), 
    Asset("IMAGE", "images/inventoryimages/lsword.tex"),
}

    local function onequip(inst, owner)
        owner.AnimState:OverrideSymbol("swap_object", "swap_lsword", "swap_cutlass")
        owner.AnimState:Show("ARM_carry") 
        owner.AnimState:Hide("ARM_normal") 

if owner.components.playerlightningtarget then
       owner:AddTag("nolightning")
       owner:RemoveComponent("playerlightningtarget")
    end
    end

    local function onunequip(inst, owner) 
        owner.AnimState:Hide("ARM_carry") 
        owner.AnimState:Show("ARM_normal")

if owner:HasTag("nolightning") then
       owner:RemoveTag("nolightning")
       owner:AddComponent("playerlightningtarget")
    end
 
    end








local function fn()
    local inst = CreateEntity()
    local trans = inst.entity:AddTransform()
    local anim = inst.entity:AddAnimState()

    MakeInventoryPhysics(inst)


    inst.AnimState:SetBank("cutlass")
    inst.AnimState:SetBuild("lsword")
    inst.AnimState:PlayAnimation("idle")
   

    inst:AddComponent("inspectable")

    
    inst:AddComponent("inventoryitem")
    inst.components.inventoryitem.imagename = "lsword"
    inst.components.inventoryitem.atlasname = "images/inventoryimages/lsword.xml"


	inst:AddComponent("equippable")
    inst.components.equippable:SetOnEquip( onequip )
    inst.components.equippable:SetOnUnequip( onunequip )
	

    inst.bg = 0
    local function onattack(inst, owner, target)
inst.bg=inst.bg +1 
 if inst.bg % 3 == 0 then
inst:StartThread(function()
               
       
           
        for k = 1, 1 do
            local pos = target:GetPosition()
            GetSeasonManager():DoLightningStrike(pos)
            target.components.health:DoDelta(-50)
            Sleep(0.3)
        end
  end)
 end 
    end


    inst:AddComponent("weapon")
    inst.components.weapon:SetRange(1, 2)
    inst.components.weapon:SetOnAttack(onattack)

    inst.components.weapon:SetDamage(40)
    inst:ListenForEvent("onattacker",onattack)
    inst.components.weapon:SetOnAttack(onattack)

	inst:AddTag("sharp")

 inst:AddComponent("finiteuses")
    inst.components.finiteuses:SetMaxUses(200)
    inst.components.finiteuses:SetUses(200)
    inst.components.finiteuses:SetOnFinished(inst.Remove)

	return inst
end
	

return Prefab( "common/inventory/lsword", fn, assets) 
