local assets=
{
    Asset("ANIM", "anim/xsword.zip"),
    Asset("ANIM", "anim/swap_xsword.zip"),
  
    Asset("ATLAS", "images/inventoryimages/xsword.xml"), 
    Asset("IMAGE", "images/inventoryimages/xsword.tex"),
}

    local function onequip(inst, owner)
        owner.AnimState:OverrideSymbol("swap_object", "swap_xsword", "swap_cutlass")
        owner.AnimState:Show("ARM_carry") 
        owner.AnimState:Hide("ARM_normal") 
    end

    local function onunequip(inst, owner) 
        owner.AnimState:Hide("ARM_carry") 
        owner.AnimState:Show("ARM_normal") 
    end


local function fn()
    local inst = CreateEntity()
    local trans = inst.entity:AddTransform()
    local anim = inst.entity:AddAnimState()

    MakeInventoryPhysics(inst)


    inst.AnimState:SetBank("cutlass")
    inst.AnimState:SetBuild("xsword")
    inst.AnimState:PlayAnimation("idle")

    inst:AddComponent("inspectable")
  
    inst:AddComponent("inventoryitem")
    inst.components.inventoryitem.atlasname = "images/inventoryimages/xsword.xml"


    inst:AddComponent("equippable")
    inst.components.equippable:SetOnEquip( onequip )
    inst.components.equippable:SetOnUnequip( onunequip )


    local function onattack(inst, attacker, target)
        
        if math.random() < 0.3 then
      target.components.health:DoDelta(-35)
 
  

        end
    end

 inst:AddComponent("tool")
    inst.components.tool:SetAction(ACTIONS.CHOP, 5)
    inst.components.tool:SetAction(ACTIONS.MINE, 5)
    inst.components.tool:SetAction(ACTIONS.HAMMER,5)
inst.components.tool:SetAction(ACTIONS.HACK,5)
    inst:AddComponent("weapon")
    inst.components.weapon:SetDamage(20)
    inst:ListenForEvent("onattacker",onattack)
    inst.components.weapon.onattack = onattack
     inst:AddTag("sharp")

 
	
	
    inst:AddComponent("finiteuses")
    inst.components.finiteuses:SetMaxUses(180)
    inst.components.finiteuses:SetUses(180)
    inst.components.finiteuses:SetOnFinished(inst.Remove)
inst.components.finiteuses:SetConsumption(ACTIONS.HACK, 1)
inst.components.finiteuses:SetConsumption(ACTIONS.CHOP, 1)
inst.components.finiteuses:SetConsumption(ACTIONS.MINE, 1)
inst.components.finiteuses:SetConsumption(ACTIONS.HAMMER, 1)
	return inst
end
	

return Prefab( "common/inventory/xsword", fn, assets) 
