ScriptName BattleRifle:FireModeController extends Quest

Group AutoFill
	Actor		Property PlayerRef				Auto Const Mandatory
EndGroup

Group Messages
	Message Property BattleRifle_MESG_FireModeSemi	Auto Const Mandatory
	Message Property BattleRifle_MESG_FireModeAuto	Auto Const Mandatory
EndGroup

Group Misc
	WeaponOverride[] Property WeaponOverrides	Auto Const
	Form[]		Property StuffToAddOnStartup Auto Const
	
	ObjectMod	Property BattleRifle_ModBaseTemp	Auto Const Mandatory
	ObjectMod	Property BattleRifle_ModBase1		Auto Const Mandatory
	ObjectMod	Property BattleRifle_ModBase2		Auto Const Mandatory
	
	ObjectMod	Property BattleRifle_FireModeSemi	Auto Const Mandatory
	ObjectMod	Property BattleRifle_FireModeAuto	Auto Const Mandatory
	
	Keyword		Property BattleRifle_CurrentlyAuto	Auto Const Mandatory
	
	Container 	Property BattleRifle_EmptyContainer	Auto Const Mandatory
	
	Location[]	Property StartGameLocations	Auto Const Mandatory
EndGroup

Group StateData
	Weapon			Property CurrentWeaponBase	Auto
	; ObjectReference	Property CurrentWeapon		Auto
EndGroup

Struct WeaponOverride
	Weapon BaseWeapon
	ObjectMod SemiAuto
	ObjectMod FullAuto
EndStruct

Event OnQuestInit()
	if (StartGameLocations.Find(PlayerRef.GetCurrentLocation()) < 0)
		GiveStuff()
	else
		RegisterForRemoteEvent(PlayerRef, "OnLocationChange")
	endif
EndEvent

Event Actor.OnLocationChange(Actor akSender, Location akOldLoc, Location akNewLoc)
	if (akSender == PlayerRef && StartGameLocations.Find(akNewLoc) < 0)
		GiveStuff()
		UnregisterForRemoteEvent(PlayerRef, "OnLocationChange")
	endif
EndEvent

Function GiveStuff()
	int i = 0
	while (i < StuffToAddOnStartup.Length)
		PlayerRef.AddItem(StuffToAddOnStartup[i])
		i += 1
	endwhile
EndFunction

Function ToggleAuto()
	ObjectMod[] toAdd
	Weapon base = PlayerRef.GetEquippedWeapon(0)
	
	int index = WeaponOverrides.FindStruct("BaseWeapon", base)
	bool isAuto = PlayerRef.WornHasKeyword(BattleRifle_CurrentlyAuto)
	
	if (index >= 0)
		toAdd = new ObjectMod[2]
		if (isAuto)
			toAdd[0] = BattleRifle_FireModeSemi
			toAdd[1] = WeaponOverrides[index].SemiAuto
		else
			toAdd[0] = BattleRifle_FireModeAuto
			toAdd[1] = WeaponOverrides[index].FullAuto
			BattleRifle_MESG_FireModeSemi.Show()
		endif
	;else
	;	toAdd = new ObjectMod[1]
	;	if (isAuto)
	;		toAdd[0] = BattleRifle_FireModeSemi
	;	else
	;		toAdd[0] = BattleRifle_FireModeAuto
	;	endif
	else
		return
	endif
	
	
	ChangeMods(toAdd, None, base)
	
	if (isAuto)
		BattleRifle_MESG_FireModeSemi.Show()
	else
		BattleRifle_MESG_FireModeAuto.Show()
	endif
EndFunction

Function AddSingleMod(ObjectMod OMOD, Weapon weaponBase = None)
	ObjectMod[] modsToAdd = new ObjectMod[1]
	modsToAdd[0] = OMOD
	
	AddMods(modsToAdd, weaponBase)
EndFunction

function RemoveSingleMod(ObjectMod OMOD, Weapon weaponBase = None)
	ObjectMod[] modsToRemove = new ObjectMod[1]
	modsToRemove[0] = OMOD
	
	RemoveMods(modsToRemove, weaponBase)
EndFunction

Function AddMods(ObjectMod[] modsToAdd, Weapon weaponBase = None)
	ChangeMods(modsToAdd, None, weaponBase)
EndFunction

Function RemoveMods(ObjectMod[] modsToRemove, Weapon weaponBase = None)
	ChangeMods(None, modsToRemove, weaponBase)
EndFunction

Function ChangeMods(ObjectMod[] modsToAdd, ObjectMod[] modsToRemove, Weapon weaponBase = None)
	ObjectReference cont = PlayerRef
	ObjectReference shellGame = None

	bool indirectMethod = false
	
	if (weaponBase == None)
		weaponBase = PlayerRef.GetEquippedWeapon(0)
	endif
	
	int weaponCt = cont.GetItemCount(weaponBase) 
	if (weaponCt > 1)
		Debug.Trace("Player has " + weaponCt + " of " + weaponBase + ", so using 'shell game' method...")
		; Rather than give up if there are too many items in the player's inventory,
		; use spacefiddle's slower, but more reliable "shell game" method instead
		indirectMethod = true
		
		cont = PlayerRef.PlaceAtMe(BattleRifle_EmptyContainer)
		shellGame = cont.PlaceAtMe(BattleRifle_EmptyContainer)
		
		while (indirectMethod) ; just reusing a bool because it's already here lol
			PlayerRef.RemoveItem(weaponBase, -1, true, cont)
			if (PlayerRef.GetEquippedWeapon(0) == weaponBase)
				cont.RemoveItem(weaponBase, -1, true, shellGame)
			else
				; found the specific item
				while (indirectMethod)
					PlayerRef.RemoveItem(weaponBase, -1, true, shellGame)
					indirectMethod = PlayerRef.GetItemCount(weaponBase) > 0
				endwhile
			endif
		endwhile
		int ct = cont.GetItemCount(weaponBase)
		if (ct > 1)
			cont.RemoveItem(weaponBase, ct-1, true, shellGame)
		endif
		
		; cont now has exactly one item in its inventory, which should be the same item that the player
		; had equipped when we started—now we can just use the standard item modification code, and
		; after we're done just drop the item from cont and force equip it to the player
		
		indirectMethod = true
	endif
	
	int i = 0
	while (modsToAdd && i < modsToAdd.Length)
		Debug.Trace("Attaching " + modsToAdd[i] + " to weapon " + weaponBase + "...")
		if (!cont.AttachModToInventoryItem(weaponBase, modsToAdd[i]))
			; attachment failed because of a lack of the attachment point mod - attach it and try again
			Debug.Trace("Attachment failed, attaching dummy mods to " + weaponBase + " and retrying...")
			
			;/ Fallout 4 troll physics:
			; >_GAC_ModDummyTemp attaches to NONE attach point
			; >_GAC_ModDummy attaches to _GAC_ap_DummyMod, provided by _GAC_ModDummyTemp
			; >_GAC_ModDummy2 attaches to _GAC_ap_DummyMod2, provided by _GAC_ModDummy
			; >_GAC_ModDummyTemp gets removed, and along with it the original _GAC_ap_DummyMod attach point it used to provide
			; >_GAC_ModDummy is now attached to _GAC_ModDummy2, which is turn attached to _GAC_ModDummy, ad infinitum
			; >Neither _GAC_ModDummy or _GAC_ModDummy2 is actually directly attached to the original weapon anymore
			; You have no idea how proud of this feature I am /;
			
			cont.AttachModToInventoryItem(weaponBase, BattleRifle_ModBaseTemp)
			cont.AttachModToInventoryItem(weaponBase, BattleRifle_ModBase1)
			cont.AttachModToInventoryItem(weaponBase, BattleRifle_ModBase2)
			cont.RemoveModFromInventoryItem(weaponBase, BattleRifle_ModBaseTemp)
			
			cont.AttachModToInventoryItem(weaponBase, modsToAdd[i])
		endif
		i += 1
	endWhile
	
	i = 0
	while (modsToRemove && i < modsToRemove.Length)
		Debug.Trace("Removed " + modsToRemove[i] + " from weapon " + weaponBase)
		cont.RemoveModFromInventoryItem(weaponBase, modsToRemove[i])
		i += 1
	endWhile
	
	if (indirectMethod)
		cont.RemoveItem(weaponBase, 1, true, PlayerRef)
		PlayerRef.EquipItem(weaponBase, false, true)
		
		; there SHOULD only be one item in this container, but verify
		if (cont.GetItemCount(weaponBase) > 0)
			; silently move the items over
			do
				cont.RemoveItem(weaponBase, 1, true, PlayerRef)
			loopWhile (cont.GetItemCount(weaponBase) > 0)
		endif
		; and just to be 100% certain nothing's left over
		cont.RemoveAllItems(PlayerRef)
		
		; now do the same for the second container
		if (shellGame.GetItemCount(weaponBase) > 0)
			do
				shellGame.RemoveItem(weaponBase, 1, true, PlayerRef)
			loopWhile (shellGame.GetItemCount(weaponBase) > 0)
		endif
		shellGame.RemoveAllItems(PlayerRef)
		
		; these should clean themselves up, but speed it up a little anyway
		cont.Delete()
		shellGame.Delete()
	endif
EndFunction


;Function ToggleAuto()
;	if (CurrentWeapon == None)
;		CurrentWeaponBase = PlayerRef.GetEquippedWeapon(0)
;		
;		if (PlayerRef.GetItemCount(CurrentWeaponBase) > 1)
;			BattleRifle_TooManyWeapons.Show()
;			return
;		endif
;		
;		CurrentWeapon = PlayerRef.DropObject(CurrentWeaponBase, 1)
;		PlayerRef.AddItem(CurrentWeapon, 1, true)
;		PlayerRef.EquipItem(CurrentWeaponBase, false, true)
;	endif
;	
;	if (CurrentWeapon.HasKeyword(BattleRifle_CurrentlyAuto))
;		AttachOMOD(BattleRifle_FireModeSemi)
;	else
;		AttachOMOD(BattleRifle_FireModeAuto)
;	endif
;EndFunction;
	
;Event Actor.OnItemUnequipped(Actor akSender, Form akBaseObject, ObjectReference akReference)
;	if (akBaseObject == CurrentWeaponBase)
;		; The weapon we got a direct reference to to has been unequipped, so forget about it
;		UnregisterForRemoteEvent(PlayerRef, "OnItemUnequipped")
;		CurrentWeaponBase = None
;		CurrentWeapon = None
;	endif
;EndEvent
;
;Function AttachOMOD(ObjectMod toAttach)
;	UnregisterForRemoteEvent(PlayerRef, "OnItemUnequipped")
;	
;	; bool attempt = CurrentWeapon.AttachMod(toAttach)
;	bool attempt = PlayerRef.AttachModToInventoryItem(CurrentWeaponBase, toAttach)
;	if (attempt == false)
;		; failed, so set up base and retry
;		SetupAttachBase()
;		;attempt = CurrentWeapon.AttachMod(toAttach)
;		attempt = PlayerRef.AttachModToInventoryItem(CurrentWeaponBase, toAttach)
;		if (attempt == false)
;			Debug.Notification("Failed to attach mod to weapon")
;		endif
;	endif
;	
;	RegisterForRemoteEvent(PlayerRef, "OnItemUnequipped")
;EndFunction

;Function SetupAttachBase()
;	CurrentWeapon.AttachMod(BattleRifle_ModBaseTemp)
;	
;	CurrentWeapon.AttachMod(BattleRifle_ModBase1)
;	CurrentWeapon.AttachMod(BattleRifle_ModBase2)
;	
;	CurrentWeapon.RemoveMod(BattleRifle_ModBaseTemp)
;EndFunction

;Function ClearAttachBase()
;	UnregisterForRemoteEvent(PlayerRef, "OnItemUnequipped")
;		
;	CurrentWeapon.RemoveMod(BattleRifle_ModBase1)
;	CurrentWeapon.RemoveMod(BattleRifle_ModBase2)
;	CurrentWeapon.RemoveMod(BattleRifle_FireModeSemi)
;	CurrentWeapon.RemoveMod(BattleRifle_FireModeAuto)
;	
;	RegisterForRemoteEvent(PlayerRef, "OnItemUnequipped")
;EndFunction
