ScriptName CombatFatigueSpell extends ActiveMagicEffect
CombatFatigueQuest Property myMod Auto
CombatFatigue_Config Property cfConfig Auto    
Actor Property ActorRef auto
float baseMoveSpeed
;float baseAttackSpeed    
bool bOk = false
float npcThreshold
float npcCripple

Event OnPlayerLoadGame()
    int current_crc = FNIS_aa.GetInstallationCRC()
    if ( current_crc == 0 )
        ; Installation Error: no AA generated by FNIS
    elseif ( current_crc != myMod.myModCRC )
        myMod.myModID = FNIS_aa.GetAAModID("cbf", "CombatFatigue", true)            ; true during test phase only
        myMod.my_mtidle_base = FNIS_aa.GetGroupBaseValue(myMod.myModID, FNIS_aa._mtidle(), "CombatFatigue", true)
        myMod.my_1hmidle_base = FNIS_aa.GetGroupBaseValue(myMod.myModID, FNIS_aa._1hmidle(), "CombatFatigue", true)
        myMod.my_1hmmt_base = FNIS_aa.GetGroupBaseValue(myMod.myModID, FNIS_aa._1hmmt(), "CombatFatigue", true)
        myMod.my_1hmblock_base = FNIS_aa.GetGroupBaseValue(myMod.myModID, FNIS_aa._1hmblock(), "CombatFatigue", true)
        myMod.my_2hmidle_base = FNIS_aa.GetGroupBaseValue(myMod.myModID, FNIS_aa._2hmidle(), "CombatFatigue", true)
        myMod.my_2hmmt_base = FNIS_aa.GetGroupBaseValue(myMod.myModID, FNIS_aa._2hmmt(), "CombatFatigue", true)
        myMod.my_mt_base = FNIS_aa.GetGroupBaseValue(myMod.myModID, FNIS_aa._mt(), "CombatFatigue", true)
        myMod.my_mtx_base = FNIS_aa.GetGroupBaseValue(myMod.myModID, FNIS_aa._mtx(), "CombatFatigue", true)
        myMod.my_mtturn_base = FNIS_aa.GetGroupBaseValue(myMod.myModID, FNIS_aa._mtturn(), "CombatFatigue", true)
        myMod.my_sneakidle_base = FNIS_aa.GetGroupBaseValue(myMod.myModID, FNIS_aa._sneakidle(), "CombatFatigue", true)
        myMod.my_sneakmt_base = FNIS_aa.GetGroupBaseValue(myMod.myModID, FNIS_aa._sneakmt(), "CombatFatigue", true)
        myMod.my_shout_base = FNIS_aa.GetGroupBaseValue(myMod.myModID, FNIS_aa._shout(), "CombatFatigue", true)
        myMod.my_sprint_base = FNIS_aa.GetGroupBaseValue(myMod.myModID, FNIS_aa._sprint(), "CombatFatigue", true)
        myMod.myModCRC = current_crc
    endif
endEvent

Event OnEffectStart(Actor akTarget, Actor akCaster)
    ActorRef = akTarget
    baseMoveSpeed = ActorRef.GetBaseActorValue("SpeedMult")
    If ActorRef != Game.GetPlayer()
        If cfConfig.npcRandomValue
            npcThreshold = Utility.RandomFloat(0.1,0.75)
            npcCripple = Utility.RandomFloat(50.0,100.0)
        Else
            npcThreshold = cfConfig.npcInjuryThreshold /100
            npcCripple = cfConfig.npcCrippleEffect
        endIf    
        GotoState("HealthyNPC")
    Else
        GotoState("HealthyPC")    
    endIf
endEvent    


float Function HealthRemaining()
    float healthPercent = ActorRef.GetBaseActorValue("Health")
    If healthPercent==0
        healthPercent = 0.0
    Else
        healthPercent = ActorRef.GetActorValue("Health") / healthPercent
    endIf
    
    return healthPercent
endFunction

Function LoadInjured()
    bOk = FNIS_aa.SetAnimGroup(ActorRef, "_mtidle", myMod.my_mtidle_base, 0, "CombatFatigue", true)
    bOk = FNIS_aa.SetAnimGroup(ActorRef, "_mt", myMod.my_mt_base, 0, "CombatFatigue", true)
    bOk = FNIS_aa.SetAnimGroup(ActorRef, "_mtx", myMod.my_mtx_base, 0, "CombatFatigue", true)
    bOk = FNIS_aa.SetAnimGroup(ActorRef, "_mtturn", myMod.my_mtturn_base, 0, "CombatFatigue", true)
    bOk = FNIS_aa.SetAnimGroup(ActorRef, "_1hmidle", myMod.my_1hmidle_base, 0, "CombatFatigue", true)
    bOk = FNIS_aa.SetAnimGroup(ActorRef, "_1hmmt", myMod.my_1hmmt_base, 0, "CombatFatigue", true)
    bOk = FNIS_aa.SetAnimGroup(ActorRef, "_1hmblock", myMod.my_1hmblock_base, 0, "CombatFatigue", true)
    bOk = FNIS_aa.SetAnimGroup(ActorRef, "_2hmidle", myMod.my_2hmidle_base, 0, "CombatFatigue", true)
    bOk = FNIS_aa.SetAnimGroup(ActorRef, "_2hmmt", myMod.my_2hmmt_base, 0, "CombatFatigue", true)
    bOk = FNIS_aa.SetAnimGroup(ActorRef, "_sneakidle", myMod.my_sneakidle_base, 0, "CombatFatigue", true)
    bOk = FNIS_aa.SetAnimGroup(ActorRef, "_sneakmt", myMod.my_sneakmt_base, 0, "CombatFatigue", true)
    bOk = FNIS_aa.SetAnimGroup(ActorRef, "_shout", myMod.my_shout_base, 0, "CombatFatigue", true)
    bOk = FNIS_aa.SetAnimGroup(ActorRef, "_sprint", myMod.my_sprint_base, 0, "CombatFatigue", true)
endFunction

Function LoadHealthy()    
    bOk = FNIS_aa.SetAnimGroup(ActorRef, "_mtidle", 0, 0, "CombatFatigue", true)
    bOk = FNIS_aa.SetAnimGroup(ActorRef, "_mt", 0, 0, "CombatFatigue", true)
    bOk = FNIS_aa.SetAnimGroup(ActorRef, "_mtx", 0, 0, "CombatFatigue", true)
    bOk = FNIS_aa.SetAnimGroup(ActorRef, "_mtturn", 0, 0, "CombatFatigue", true)
    bOk = FNIS_aa.SetAnimGroup(ActorRef, "_1hmidle", 0, 0, "CombatFatigue", true)
    bOk = FNIS_aa.SetAnimGroup(ActorRef, "_1hmmt", 0, 0, "CombatFatigue", true)
    bOk = FNIS_aa.SetAnimGroup(ActorRef, "_1hmblock", 0, 0, "CombatFatigue", true)
    bOk = FNIS_aa.SetAnimGroup(ActorRef, "_2hmidle", 0, 0, "CombatFatigue", true)
    bOk = FNIS_aa.SetAnimGroup(ActorRef, "_2hmmt", 0, 0, "CombatFatigue", true)
    bOk = FNIS_aa.SetAnimGroup(ActorRef, "_sneakidle", 0, 0, "CombatFatigue", true)
    bOk = FNIS_aa.SetAnimGroup(ActorRef, "_sneakmt", 0, 0, "CombatFatigue", true)
    bOk = FNIS_aa.SetAnimGroup(ActorRef, "_shout", 0, 0, "CombatFatigue", true)
    bOk = FNIS_aa.SetAnimGroup(ActorRef, "_sprint", 0, 0, "CombatFatigue", true)
endFunction
    
State HealthyPC
    Event OnBeginState()
        ActorRef.SetActorValue("SpeedMult", baseMoveSpeed)
        LoadHealthy()
    EndEvent 
 
    Event OnHit(ObjectReference akAggressor, Form akSource, Projectile akProjectile, bool abPowerAttack, bool abSneakAttack, bool abBashAttack, bool abHitBlocked)
        If (HealthRemaining() <= (cfConfig.injuryThreshold / 100) )
            GotoState("InjuredPC")
        endIf    
    EndEvent
    
endState

State InjuredPC
    Event OnBeginState()
        baseMoveSpeed = ActorRef.GetBaseActorValue("SpeedMult")
        LoadInjured()
        ;baseAttackSpeed = ActorRef.GetBaseActorValue("WeaponSpeedMult")
        ActorRef.SetActorValue("SpeedMult", cfConfig.crippleEffect)
        ;ActorRef.SetActorValue("WeaponSpeedMult", 90.0)
        RegisterForSingleUpdate(3.0)        
    EndEvent

    Event OnUpdate()
        If ( HealthRemaining() > (cfConfig.injuryThreshold /100))
            ;ActorRef.SetActorValue("WeaponSpeedMult", baseAttackSpeed) <<Breaks things
            GotoState("HealthyPC")
        Else
            RegisterForSingleUpdate(3.0)
        endIf  
    EndEvent 
    
endState

State HealthyNPC
    Event OnBeginState()
        ActorRef.SetActorValue("SpeedMult", baseMoveSpeed)
        LoadHealthy()       
    EndEvent 
 
    Event OnHit(ObjectReference akAggressor, Form akSource, Projectile akProjectile, bool abPowerAttack, bool abSneakAttack, bool abBashAttack, bool abHitBlocked)       
        If (HealthRemaining() <= npcThreshold )
            GotoState("InjuredNPC")
        endIf    
    EndEvent
    
endState

State InjuredNPC
    Event OnBeginState()
        baseMoveSpeed = ActorRef.GetBaseActorValue("SpeedMult")
        LoadInjured()
        
        ;baseAttackSpeed = ActorRef.GetBaseActorValue("WeaponSpeedMult")
        ActorRef.SetActorValue("SpeedMult", npcCripple)
        ;ActorRef.SetActorValue("WeaponSpeedMult", 90.0)
        RegisterForSingleUpdate(1.0)        
    EndEvent

    Event OnUpdate()
        If ( HealthRemaining() > npcThreshold)
            ;ActorRef.SetActorValue("WeaponSpeedMult", baseAttackSpeed) <<Breaks things
            GotoState("HealthyNPC")
        Else
            LoadInjured()
            RegisterForSingleUpdate(1.0)
        endIf  
    EndEvent 
    
endState        