ScriptName CombatFatigue_Config extends SKI_ConfigBase

float Property injuryThreshold Auto
float Property crippleEffect Auto
    
float Property npcInjuryThreshold Auto
float Property npcCrippleEffect Auto
bool Property npcRandomValue Auto    
    
int injurySelectOID_S
int crippleSelectOID_S

int npcRandomValueOID
int npcInjurySelectOID_S
int npcCrippleSelectOID_S
int npcFlag        

Event OnConfigInit()
    injuryThreshold = 50.0
    crippleEffect = 70.0
    
    npcRandomValue = false
    npcInjuryThreshold = 50.0
    npcCrippleEffect = 70.0
    npcFlag = OPTION_FLAG_NONE
endEvent

Event OnPageReset(String page)
    
    SetCursorFillMode(TOP_TO_BOTTOM)
    AddHeaderOption("Player Settings")    
    injurySelectOID_S = AddSliderOption("Injury Threshold", injuryThreshold, "{0}%")
    crippleSelectOID_S = AddSliderOption("Injury Speed Reduction", (100-crippleEffect), "{0}%")
    
    AddHeaderOption("NPC Settings")
    npcRandomValueOID = AddToggleOption("Randomize NPC Values", npcRandomValue)
    npcInjurySelectOID_S = AddSliderOption("Injury Threshold", npcInjuryThreshold, "{0}%", npcFlag)
    npcCrippleSelectOID_S = AddSliderOption("Injury Speed Reduction", (100-npcCrippleEffect), "{0}%", npcFlag)
    
endEvent

Event OnOptionSelect(int option)
    If (option == npcRandomValueOID)
        npcRandomValue = !npcRandomValue
        SetToggleOptionValue(npcRandomValueOID, npcRandomValue)
        If !npcRandomValue
            npcFlag = OPTION_FLAG_NONE
        Else
            npcFlag = OPTION_FLAG_DISABLED
        endIf
        ForcePageReset()
    endIf    
 endEvent
    
Event OnOptionSliderOpen(int option)
        If (option == injurySelectOID_S)
            SetSliderDialogStartValue(injuryThreshold)
            SetSliderDialogDefaultValue(50)
            SetSliderDialogRange(5.0, 75.0)
            SetSliderDialogInterval(1.0)
        ElseIf (option == crippleSelectOID_S)
            SetSliderDialogStartValue((100.0 - crippleEffect))
            SetSliderDialogDefaultValue(30)
            SetSliderDialogRange(0.0, 50.0)
            SetSliderDialogInterval(1.0)          
        ElseIf (option == npcInjurySelectOID_S)
            SetSliderDialogStartValue(npcInjuryThreshold)
            SetSliderDialogDefaultValue(50)
            SetSliderDialogRange(5.0, 75.0)
            SetSliderDialogInterval(1.0)
        ElseIf (option == npcCrippleSelectOID_S)
            SetSliderDialogStartValue((100.0 - npcCrippleEffect))
            SetSliderDialogDefaultValue(30)
            SetSliderDialogRange(0.0, 50.0)
            SetSliderDialogInterval(1.0)          
        endIf
endEvent
    
Event OnOptionSliderAccept(int option, float value)
    If (option == injurySelectOID_S)
        injuryThreshold = value
        SetSliderOptionValue(injurySelectOID_S, injuryThreshold, "{0}%")
    ElseIf (option == crippleSelectOID_S)
        crippleEffect = 100 - value
        SetSliderOptionValue(crippleSelectOID_S, value, "{0}%")
    ElseIf (option == npcInjurySelectOID_S)
        npcInjuryThreshold = value
        SetSliderOptionValue(npcInjurySelectOID_S, npcInjuryThreshold, "{0}%")
    ElseIf (option == npcCrippleSelectOID_S)
        npcCrippleEffect = 100 - value
        SetSliderOptionValue(npcCrippleSelectOID_S, value, "{0}%")
    endIf
endEvent    