Scriptname ArtyBinoculars:ArtyBinosControllerQuest extends Quest

; ------------------ Properties ---------------------------
Actor Property PlayerRef Auto Const
Keyword Property MinArtilleryStart Auto Const
MinArtilleryScript Property ArtilleryQuest Auto Const
Weapon Property Binos Auto Const
Sound Property RadioSwitch Auto Const
; GlobalVarible Property OldGunsQuestCompleted Auto Const Mandatory

; ------------------ Variables ---------------------------
bool Property bRadioOn = False Auto Hidden Conditional								; Get whether the player radio is on as a variable.
float Property fCurrentFrequency = 0.00 Auto Hidden Conditional							; Get the current Radio frequency as a variable.
int iTimerID_EndOfFireMsnCheck = 60 Const
int FirstInitialStartup = 0
int iQuestStage
bool bOldGunsQuestCompleted = False
bool bQuestFirstEverInitialise = True

; ------------------ Events -------------------------------

Event OnQuestInit()
	Quest Min03OldGuns = Game.GetFormFromFile(0x000AA778, "Fallout4.esm") as Quest

	If (bQuestFirstEverInitialise == True && Min03OldGuns.IsCompleted())
		PlayerRef.AddItem(Binos, 1)
		bQuestFirstEverInitialise = False
		bOldGunsQuestCompleted = True

	ElseIf (bOldGunsQuestCompleted == False)
		RegisterForPlayerTeleport()
	EndIf
EndEvent

Event OnPlayerTeleport()
	UnregisterForPlayerTeleport()

	Quest Min03OldGuns = Game.GetFormFromFile(0x000AA778, "Fallout4.esm") as Quest

	If (Min03OldGuns.IsCompleted())
		PlayerRef.AddItem(Binos, 1, abSilent = False)
		bOldGunsQuestCompleted = True
	Else
		RegisterForPlayerTeleport()
	EndIf

EndEvent

; ------------------ Setup Functions ---------------------------



; ------------------ Main Functions ----------------------------

Function CallArtillery(ObjectReference akTargetRef, Actor akActor)

	bRadioOn = Game.IsPlayerRadioOn()									; Get whether the player radio is on as a variable.
	fCurrentFrequency = Game.GetPlayerRadioFrequency()							; Get the current Radio frequency as a variable.
	
	Location TargetLocation = akTargetRef.GetCurrentLocation()				
	
	If (Game.IsPlayerListening(105.00))									; Check to see if the player's is already listening to radio freedom.
		Utility.WaitMenuMode(1)
		
	ElseIf (bRadioOn == False)										; Then check to see if the radio is on, if it is off then...
		Game.TurnPlayerRadioOn()									; Turn it on and set the frequency to radio freedom.
		Int iSoundID = RadioSwitch.Play(PlayerRef)
		Utility.WaitMenuMode(1)
		Game.SetPlayerRadioFrequency(105.00)
		Sound.StopInstance(iSoundID)

	ElseIf (bRadioOn == True && fCurrentFrequency != 105.00)						; Check to see if the Radio is on and the player is listening to something else
		Int iSoundID2 = RadioSwitch.Play(PlayerRef)
		Utility.WaitMenuMode(1)
		Game.SetPlayerRadioFrequency(105.00)								; If it wasn't then tune in.
		Sound.StopInstance(iSoundID2)
	EndIf
	
	MinArtilleryStart.SendStoryEvent(akLoc = TargetLocation, akRef1 = akTargetRef)
	Self.StartCheck()											; Start a timer to check for the end of the firemission.
EndFunction

Function StartCheck()
	StartTimer(30, iTimerID_EndOfFireMsnCheck)								; Start a 30 second timer with the ID '60' from variable EndOfFireMsnCheck.
EndFunction
 

Event OnTimer(int iTimer)
	If (iTimer == iTimerID_EndOfFireMsnCheck)                              						
  		If (ArtilleryQuest.GetCurrentStageID() == 500 || ArtilleryQuest.GetCurrentStageID() == 1000)          	; The artillery strike has entered the closedown stage.
   			If (bRadioOn == False)										; If the radio was off at the start of the quest turn it back off.
				Game.TurnPlayerRadioOn(False)
			ElseIf (bRadioOn == True && fCurrentFrequency != 105.00)					; If the radio was on but not tuned to Radio freedom tune back to the original station.
				Int iSoundID = RadioSwitch.Play(PlayerRef)
				Game.SetPlayerRadioFrequency(fCurrentFrequency)
				Utility.WaitMenuMode(1)
				Sound.StopInstance(iSoundID)

			ElseIf (bRadioOn == True && fCurrentFrequency == 105.00)					; If the radio was on and tuned to radio freedom before the fire mission do nothing.
				
			EndIf
		Else     												; Else countdown to check again.
			StartTimer(30, iTimerID_EndOfFireMsnCheck)
  		EndIf
	EndIf
EndEvent