/*
 * Decompiled with CFR 0.152.
 */
package com.megacrit.cardcrawl.helpers;

import com.badlogic.gdx.math.MathUtils;
import com.megacrit.cardcrawl.cards.AbstractCard;
import com.megacrit.cardcrawl.cards.colorless.Apotheosis;
import com.megacrit.cardcrawl.cards.colorless.BandageUp;
import com.megacrit.cardcrawl.cards.colorless.Bite;
import com.megacrit.cardcrawl.cards.colorless.Blind;
import com.megacrit.cardcrawl.cards.colorless.DarkShackles;
import com.megacrit.cardcrawl.cards.colorless.DeepBreath;
import com.megacrit.cardcrawl.cards.colorless.DramaticEntrance;
import com.megacrit.cardcrawl.cards.colorless.Enlightenment;
import com.megacrit.cardcrawl.cards.colorless.Finesse;
import com.megacrit.cardcrawl.cards.colorless.FlashOfSteel;
import com.megacrit.cardcrawl.cards.colorless.GoodInstincts;
import com.megacrit.cardcrawl.cards.colorless.JAX;
import com.megacrit.cardcrawl.cards.colorless.JackOfAllTrades;
import com.megacrit.cardcrawl.cards.colorless.Madness;
import com.megacrit.cardcrawl.cards.colorless.MasterOfStrategy;
import com.megacrit.cardcrawl.cards.colorless.MindBlast;
import com.megacrit.cardcrawl.cards.colorless.Panacea;
import com.megacrit.cardcrawl.cards.colorless.Panache;
import com.megacrit.cardcrawl.cards.colorless.Purity;
import com.megacrit.cardcrawl.cards.colorless.SadisticNature;
import com.megacrit.cardcrawl.cards.colorless.SecretTechnique;
import com.megacrit.cardcrawl.cards.colorless.SecretWeapon;
import com.megacrit.cardcrawl.cards.colorless.Shiv;
import com.megacrit.cardcrawl.cards.colorless.SwiftStrike;
import com.megacrit.cardcrawl.cards.colorless.ThinkingAhead;
import com.megacrit.cardcrawl.cards.colorless.Transmutation;
import com.megacrit.cardcrawl.cards.colorless.Trip;
import com.megacrit.cardcrawl.cards.curses.Clumsy;
import com.megacrit.cardcrawl.cards.curses.Decay;
import com.megacrit.cardcrawl.cards.curses.Doubt;
import com.megacrit.cardcrawl.cards.curses.Injury;
import com.megacrit.cardcrawl.cards.curses.Necronomicurse;
import com.megacrit.cardcrawl.cards.curses.Normality;
import com.megacrit.cardcrawl.cards.curses.Pain;
import com.megacrit.cardcrawl.cards.curses.Parasite;
import com.megacrit.cardcrawl.cards.curses.Regret;
import com.megacrit.cardcrawl.cards.curses.Writhe;
import com.megacrit.cardcrawl.cards.green.AThousandCuts;
import com.megacrit.cardcrawl.cards.green.Accuracy;
import com.megacrit.cardcrawl.cards.green.Acrobatics;
import com.megacrit.cardcrawl.cards.green.Adrenaline;
import com.megacrit.cardcrawl.cards.green.AfterImage;
import com.megacrit.cardcrawl.cards.green.Alchemize;
import com.megacrit.cardcrawl.cards.green.AllOutAttack;
import com.megacrit.cardcrawl.cards.green.Backflip;
import com.megacrit.cardcrawl.cards.green.Backstab;
import com.megacrit.cardcrawl.cards.green.Bane;
import com.megacrit.cardcrawl.cards.green.BladeDance;
import com.megacrit.cardcrawl.cards.green.Blur;
import com.megacrit.cardcrawl.cards.green.BouncingFlask;
import com.megacrit.cardcrawl.cards.green.BulletTime;
import com.megacrit.cardcrawl.cards.green.Burst;
import com.megacrit.cardcrawl.cards.green.CalculatedGamble;
import com.megacrit.cardcrawl.cards.green.Caltrops;
import com.megacrit.cardcrawl.cards.green.Catalyst;
import com.megacrit.cardcrawl.cards.green.Choke;
import com.megacrit.cardcrawl.cards.green.CloakAndDagger;
import com.megacrit.cardcrawl.cards.green.Concentrate;
import com.megacrit.cardcrawl.cards.green.CorpseExplosion;
import com.megacrit.cardcrawl.cards.green.CripplingPoison;
import com.megacrit.cardcrawl.cards.green.DaggerSpray;
import com.megacrit.cardcrawl.cards.green.DaggerThrow;
import com.megacrit.cardcrawl.cards.green.Dash;
import com.megacrit.cardcrawl.cards.green.DeadlyPoison;
import com.megacrit.cardcrawl.cards.green.Defend_Green;
import com.megacrit.cardcrawl.cards.green.Deflect;
import com.megacrit.cardcrawl.cards.green.DieDieDie;
import com.megacrit.cardcrawl.cards.green.Distraction;
import com.megacrit.cardcrawl.cards.green.DodgeAndRoll;
import com.megacrit.cardcrawl.cards.green.Doppelganger;
import com.megacrit.cardcrawl.cards.green.EndlessAgony;
import com.megacrit.cardcrawl.cards.green.Envenom;
import com.megacrit.cardcrawl.cards.green.EscapePlan;
import com.megacrit.cardcrawl.cards.green.Eviscerate;
import com.megacrit.cardcrawl.cards.green.Expertise;
import com.megacrit.cardcrawl.cards.green.Finisher;
import com.megacrit.cardcrawl.cards.green.Flechettes;
import com.megacrit.cardcrawl.cards.green.FlyingKnee;
import com.megacrit.cardcrawl.cards.green.Footwork;
import com.megacrit.cardcrawl.cards.green.GlassKnife;
import com.megacrit.cardcrawl.cards.green.GrandFinale;
import com.megacrit.cardcrawl.cards.green.HeelHook;
import com.megacrit.cardcrawl.cards.green.InfiniteBlades;
import com.megacrit.cardcrawl.cards.green.LegSweep;
import com.megacrit.cardcrawl.cards.green.Malaise;
import com.megacrit.cardcrawl.cards.green.MasterfulStab;
import com.megacrit.cardcrawl.cards.green.Neutralize;
import com.megacrit.cardcrawl.cards.green.Nightmare;
import com.megacrit.cardcrawl.cards.green.NoxiousFumes;
import com.megacrit.cardcrawl.cards.green.Outmaneuver;
import com.megacrit.cardcrawl.cards.green.PhantasmalKiller;
import com.megacrit.cardcrawl.cards.green.PiercingWail;
import com.megacrit.cardcrawl.cards.green.PoisonedStab;
import com.megacrit.cardcrawl.cards.green.Predator;
import com.megacrit.cardcrawl.cards.green.Prepared;
import com.megacrit.cardcrawl.cards.green.QuickSlash;
import com.megacrit.cardcrawl.cards.green.Reflex;
import com.megacrit.cardcrawl.cards.green.RiddleWithHoles;
import com.megacrit.cardcrawl.cards.green.Setup;
import com.megacrit.cardcrawl.cards.green.Skewer;
import com.megacrit.cardcrawl.cards.green.Slice;
import com.megacrit.cardcrawl.cards.green.StormOfSteel;
import com.megacrit.cardcrawl.cards.green.Strike_Green;
import com.megacrit.cardcrawl.cards.green.SuckerPunch;
import com.megacrit.cardcrawl.cards.green.Survivor;
import com.megacrit.cardcrawl.cards.green.Tactician;
import com.megacrit.cardcrawl.cards.green.Terror;
import com.megacrit.cardcrawl.cards.green.ToolsOfTheTrade;
import com.megacrit.cardcrawl.cards.green.UnderhandedStrike;
import com.megacrit.cardcrawl.cards.green.Unload;
import com.megacrit.cardcrawl.cards.green.WellLaidPlans;
import com.megacrit.cardcrawl.cards.green.WraithForm;
import com.megacrit.cardcrawl.cards.red.Anger;
import com.megacrit.cardcrawl.cards.red.Armaments;
import com.megacrit.cardcrawl.cards.red.Barricade;
import com.megacrit.cardcrawl.cards.red.Bash;
import com.megacrit.cardcrawl.cards.red.BattleTrance;
import com.megacrit.cardcrawl.cards.red.Berserk;
import com.megacrit.cardcrawl.cards.red.BloodForBlood;
import com.megacrit.cardcrawl.cards.red.Bloodletting;
import com.megacrit.cardcrawl.cards.red.Bludgeon;
import com.megacrit.cardcrawl.cards.red.BodySlam;
import com.megacrit.cardcrawl.cards.red.Brutality;
import com.megacrit.cardcrawl.cards.red.BurningPact;
import com.megacrit.cardcrawl.cards.red.Carnage;
import com.megacrit.cardcrawl.cards.red.Clash;
import com.megacrit.cardcrawl.cards.red.Cleave;
import com.megacrit.cardcrawl.cards.red.Clothesline;
import com.megacrit.cardcrawl.cards.red.Combust;
import com.megacrit.cardcrawl.cards.red.Corruption;
import com.megacrit.cardcrawl.cards.red.DarkEmbrace;
import com.megacrit.cardcrawl.cards.red.Defend_Red;
import com.megacrit.cardcrawl.cards.red.DemonForm;
import com.megacrit.cardcrawl.cards.red.Disarm;
import com.megacrit.cardcrawl.cards.red.DoubleTap;
import com.megacrit.cardcrawl.cards.red.Dropkick;
import com.megacrit.cardcrawl.cards.red.DualWield;
import com.megacrit.cardcrawl.cards.red.Entrench;
import com.megacrit.cardcrawl.cards.red.Evolve;
import com.megacrit.cardcrawl.cards.red.Exhume;
import com.megacrit.cardcrawl.cards.red.Feed;
import com.megacrit.cardcrawl.cards.red.FeelNoPain;
import com.megacrit.cardcrawl.cards.red.FiendFire;
import com.megacrit.cardcrawl.cards.red.FireBreathing;
import com.megacrit.cardcrawl.cards.red.FlameBarrier;
import com.megacrit.cardcrawl.cards.red.Flex;
import com.megacrit.cardcrawl.cards.red.GhostlyArmor;
import com.megacrit.cardcrawl.cards.red.Havoc;
import com.megacrit.cardcrawl.cards.red.Headbutt;
import com.megacrit.cardcrawl.cards.red.HeavyBlade;
import com.megacrit.cardcrawl.cards.red.Hemokinesis;
import com.megacrit.cardcrawl.cards.red.Immolate;
import com.megacrit.cardcrawl.cards.red.Impervious;
import com.megacrit.cardcrawl.cards.red.InfernalBlade;
import com.megacrit.cardcrawl.cards.red.Inflame;
import com.megacrit.cardcrawl.cards.red.Intimidate;
import com.megacrit.cardcrawl.cards.red.IronWave;
import com.megacrit.cardcrawl.cards.red.Juggernaut;
import com.megacrit.cardcrawl.cards.red.LimitBreak;
import com.megacrit.cardcrawl.cards.red.Metallicize;
import com.megacrit.cardcrawl.cards.red.Offering;
import com.megacrit.cardcrawl.cards.red.PerfectedStrike;
import com.megacrit.cardcrawl.cards.red.PommelStrike;
import com.megacrit.cardcrawl.cards.red.PowerThrough;
import com.megacrit.cardcrawl.cards.red.Pummel;
import com.megacrit.cardcrawl.cards.red.Rage;
import com.megacrit.cardcrawl.cards.red.Rampage;
import com.megacrit.cardcrawl.cards.red.Reaper;
import com.megacrit.cardcrawl.cards.red.RecklessCharge;
import com.megacrit.cardcrawl.cards.red.Rupture;
import com.megacrit.cardcrawl.cards.red.SearingBlow;
import com.megacrit.cardcrawl.cards.red.SecondWind;
import com.megacrit.cardcrawl.cards.red.SeeingRed;
import com.megacrit.cardcrawl.cards.red.Sentinel;
import com.megacrit.cardcrawl.cards.red.SeverSoul;
import com.megacrit.cardcrawl.cards.red.Shockwave;
import com.megacrit.cardcrawl.cards.red.ShrugItOff;
import com.megacrit.cardcrawl.cards.red.SpotWeakness;
import com.megacrit.cardcrawl.cards.red.Strike_Red;
import com.megacrit.cardcrawl.cards.red.SwordBoomerang;
import com.megacrit.cardcrawl.cards.red.ThunderClap;
import com.megacrit.cardcrawl.cards.red.TrueGrit;
import com.megacrit.cardcrawl.cards.red.TwinStrike;
import com.megacrit.cardcrawl.cards.red.Uppercut;
import com.megacrit.cardcrawl.cards.red.Warcry;
import com.megacrit.cardcrawl.cards.red.Whirlwind;
import com.megacrit.cardcrawl.cards.red.WildStrike;
import com.megacrit.cardcrawl.cards.status.Burn;
import com.megacrit.cardcrawl.cards.status.Dazed;
import com.megacrit.cardcrawl.cards.status.Wound;
import com.megacrit.cardcrawl.characters.AbstractPlayer;
import com.megacrit.cardcrawl.metrics.LeaderboardPoster;
import com.megacrit.cardcrawl.random.Random;
import com.megacrit.cardcrawl.unlock.UnlockTracker;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dakiler.slayhelper.Profile;
import org.dakiler.slayhelper.card.deathknight.Annihilation;
import org.dakiler.slayhelper.card.deathknight.BloodBoiling;
import org.dakiler.slayhelper.card.deathknight.BloodDiffer;
import org.dakiler.slayhelper.card.deathknight.BloodMask;
import org.dakiler.slayhelper.card.deathknight.BloodStrike;
import org.dakiler.slayhelper.card.deathknight.BodyStrike;
import org.dakiler.slayhelper.card.deathknight.BoneShield;
import org.dakiler.slayhelper.card.deathknight.CondemnStrike;
import org.dakiler.slayhelper.card.deathknight.CurseStrike;
import org.dakiler.slayhelper.card.deathknight.DKDefend;
import org.dakiler.slayhelper.card.deathknight.DeathShake;
import org.dakiler.slayhelper.card.deathknight.DeathStrike;
import org.dakiler.slayhelper.card.deathknight.DiseaseCloud;
import org.dakiler.slayhelper.card.deathknight.DiseaseStrike;
import org.dakiler.slayhelper.card.deathknight.EvilEager;
import org.dakiler.slayhelper.card.deathknight.EvilPower;
import org.dakiler.slayhelper.card.deathknight.EvilStrike;
import org.dakiler.slayhelper.card.deathknight.Execute;
import org.dakiler.slayhelper.card.deathknight.ForceDeflexion;
import org.dakiler.slayhelper.card.deathknight.FrozenChain;
import org.dakiler.slayhelper.card.deathknight.FrozenDeath;
import org.dakiler.slayhelper.card.deathknight.FrozenHeart;
import org.dakiler.slayhelper.card.deathknight.FrozenStrike;
import org.dakiler.slayhelper.card.deathknight.FrozenTouch;
import org.dakiler.slayhelper.card.deathknight.FrozenWill;
import org.dakiler.slayhelper.card.deathknight.GhostStrike;
import org.dakiler.slayhelper.card.deathknight.Hanging;
import org.dakiler.slayhelper.card.deathknight.HeartStrike;
import org.dakiler.slayhelper.card.deathknight.Infect;
import org.dakiler.slayhelper.card.deathknight.LichBody;
import org.dakiler.slayhelper.card.deathknight.LichkingWraith;
import org.dakiler.slayhelper.card.deathknight.NoLightShield;
import org.dakiler.slayhelper.card.deathknight.RuneBurn;
import org.dakiler.slayhelper.card.deathknight.RuneDefend;
import org.dakiler.slayhelper.card.deathknight.RuneDiffer;
import org.dakiler.slayhelper.card.deathknight.RuneExplode;
import org.dakiler.slayhelper.card.deathknight.RuneHeavyStrike;
import org.dakiler.slayhelper.card.deathknight.RuneInspire;
import org.dakiler.slayhelper.card.deathknight.RuneRecover;
import org.dakiler.slayhelper.card.deathknight.RuneRegen;
import org.dakiler.slayhelper.card.deathknight.RuneStorm;
import org.dakiler.slayhelper.card.deathknight.RuneStrike;
import org.dakiler.slayhelper.card.deathknight.SwordWave;
import org.dakiler.slayhelper.card.deathknight.UltimateCold;
import org.dakiler.slayhelper.card.deathknight.UndeadWill;
import org.dakiler.slayhelper.card.deathknight.VoidDefend;
import org.dakiler.slayhelper.card.deathknight.VoidStrike;
import org.dakiler.slayhelper.card.deathknight.WindStrike;
import org.dakiler.slayhelper.card.deathknight.WinterHorn;
import org.dakiler.slayhelper.card.deathknight.Withstand;

public class CardLibrary {
    private static final Logger logger = LogManager.getLogger((String)CardLibrary.class.getName());
    public static int totalCardCount = 0;
    public static HashMap<String, AbstractCard> cards = new HashMap();
    private static HashMap<String, AbstractCard> curses = new HashMap();
    public static int redCards = 0;
    public static int greenCards = 0;
    public static int blueCards = 0;
    public static int colorlessCards = 0;
    public static int curseCards = 0;
    public static int seenRedCards = 0;
    public static int seenGreenCards = 0;
    public static int seenBlueCards = 0;
    public static int seenColorlessCards = 0;
    public static int seenCurseCards = 0;

    public static void initialize() {
        long startTime = System.currentTimeMillis();
        CardLibrary.addRedCards();
        CardLibrary.addGreenCards();
        if (Profile.profile.enableCrowBot) {
            CardLibrary.addBlueCards();
        }
        CardLibrary.addColorlessCards();
        CardLibrary.addCurseCards();
        logger.info("Card load time: " + (System.currentTimeMillis() - startTime) + "ms with " + cards.size() + " cards");
        logger.info(String.valueOf(redCards) + "/75 (Red)");
        logger.info(String.valueOf(greenCards) + "/75 (Green)");
        logger.info(String.valueOf(blueCards) + "/75 (Blue)");
        logger.info(String.valueOf(colorlessCards) + "/20 (Colorless)");
        logger.info(String.valueOf(curseCards) + "/10 (Curse)");
        logger.info("3/3 (Status)");
    }

    private static void addRedCards() {
        CardLibrary.add((AbstractCard)new Anger());
        CardLibrary.add((AbstractCard)new Armaments());
        CardLibrary.add((AbstractCard)new Barricade());
        CardLibrary.add((AbstractCard)new Bash());
        CardLibrary.add((AbstractCard)new BattleTrance());
        CardLibrary.add((AbstractCard)new Berserk());
        CardLibrary.add((AbstractCard)new BloodForBlood());
        CardLibrary.add((AbstractCard)new Bloodletting());
        CardLibrary.add((AbstractCard)new Bludgeon());
        CardLibrary.add((AbstractCard)new BodySlam());
        CardLibrary.add((AbstractCard)new Brutality());
        CardLibrary.add((AbstractCard)new BurningPact());
        CardLibrary.add((AbstractCard)new Carnage());
        CardLibrary.add((AbstractCard)new Clash());
        CardLibrary.add((AbstractCard)new Cleave());
        CardLibrary.add((AbstractCard)new Clothesline());
        CardLibrary.add((AbstractCard)new Combust());
        CardLibrary.add((AbstractCard)new Corruption());
        CardLibrary.add((AbstractCard)new DarkEmbrace());
        CardLibrary.add((AbstractCard)new Defend_Red());
        CardLibrary.add((AbstractCard)new DemonForm());
        CardLibrary.add((AbstractCard)new Disarm());
        CardLibrary.add((AbstractCard)new DoubleTap());
        CardLibrary.add((AbstractCard)new Dropkick());
        CardLibrary.add((AbstractCard)new DualWield());
        CardLibrary.add((AbstractCard)new Entrench());
        CardLibrary.add((AbstractCard)new Evolve());
        CardLibrary.add((AbstractCard)new Exhume());
        CardLibrary.add((AbstractCard)new Feed());
        CardLibrary.add((AbstractCard)new FeelNoPain());
        CardLibrary.add((AbstractCard)new FiendFire());
        CardLibrary.add((AbstractCard)new FireBreathing());
        CardLibrary.add((AbstractCard)new FlameBarrier());
        CardLibrary.add((AbstractCard)new Flex());
        CardLibrary.add((AbstractCard)new GhostlyArmor());
        CardLibrary.add((AbstractCard)new Havoc());
        CardLibrary.add((AbstractCard)new Headbutt());
        CardLibrary.add((AbstractCard)new HeavyBlade());
        CardLibrary.add((AbstractCard)new Hemokinesis());
        CardLibrary.add((AbstractCard)new Immolate());
        CardLibrary.add((AbstractCard)new Impervious());
        CardLibrary.add((AbstractCard)new InfernalBlade());
        CardLibrary.add((AbstractCard)new Inflame());
        CardLibrary.add((AbstractCard)new Intimidate());
        CardLibrary.add((AbstractCard)new IronWave());
        CardLibrary.add((AbstractCard)new Juggernaut());
        CardLibrary.add((AbstractCard)new LimitBreak());
        CardLibrary.add((AbstractCard)new Metallicize());
        CardLibrary.add((AbstractCard)new Offering());
        CardLibrary.add((AbstractCard)new PerfectedStrike());
        CardLibrary.add((AbstractCard)new PommelStrike());
        CardLibrary.add((AbstractCard)new PowerThrough());
        CardLibrary.add((AbstractCard)new Pummel());
        CardLibrary.add((AbstractCard)new Rage());
        CardLibrary.add((AbstractCard)new Rampage());
        CardLibrary.add((AbstractCard)new Reaper());
        CardLibrary.add((AbstractCard)new RecklessCharge());
        CardLibrary.add((AbstractCard)new Rupture());
        CardLibrary.add((AbstractCard)new SearingBlow());
        CardLibrary.add((AbstractCard)new SecondWind());
        CardLibrary.add((AbstractCard)new SeeingRed());
        CardLibrary.add((AbstractCard)new Sentinel());
        CardLibrary.add((AbstractCard)new SeverSoul());
        CardLibrary.add((AbstractCard)new Shockwave());
        CardLibrary.add((AbstractCard)new ShrugItOff());
        CardLibrary.add((AbstractCard)new SpotWeakness());
        CardLibrary.add((AbstractCard)new Strike_Red());
        CardLibrary.add((AbstractCard)new SwordBoomerang());
        CardLibrary.add((AbstractCard)new ThunderClap());
        CardLibrary.add((AbstractCard)new TrueGrit());
        CardLibrary.add((AbstractCard)new TwinStrike());
        CardLibrary.add((AbstractCard)new Uppercut());
        CardLibrary.add((AbstractCard)new Warcry());
        CardLibrary.add((AbstractCard)new Whirlwind());
        CardLibrary.add((AbstractCard)new WildStrike());
    }

    private static void addGreenCards() {
        CardLibrary.add((AbstractCard)new Accuracy());
        CardLibrary.add((AbstractCard)new Acrobatics());
        CardLibrary.add((AbstractCard)new Adrenaline());
        CardLibrary.add((AbstractCard)new AfterImage());
        CardLibrary.add((AbstractCard)new Alchemize());
        CardLibrary.add((AbstractCard)new AllOutAttack());
        CardLibrary.add((AbstractCard)new AThousandCuts());
        CardLibrary.add((AbstractCard)new Backflip());
        CardLibrary.add((AbstractCard)new Backstab());
        CardLibrary.add((AbstractCard)new Bane());
        CardLibrary.add((AbstractCard)new BladeDance());
        CardLibrary.add((AbstractCard)new Blur());
        CardLibrary.add((AbstractCard)new BouncingFlask());
        CardLibrary.add((AbstractCard)new BulletTime());
        CardLibrary.add((AbstractCard)new Burst());
        CardLibrary.add((AbstractCard)new CalculatedGamble());
        CardLibrary.add((AbstractCard)new Caltrops());
        CardLibrary.add((AbstractCard)new Catalyst());
        CardLibrary.add((AbstractCard)new Choke());
        CardLibrary.add((AbstractCard)new CloakAndDagger());
        CardLibrary.add((AbstractCard)new Concentrate());
        CardLibrary.add((AbstractCard)new CorpseExplosion());
        CardLibrary.add((AbstractCard)new CripplingPoison());
        CardLibrary.add((AbstractCard)new DaggerSpray());
        CardLibrary.add((AbstractCard)new DaggerThrow());
        CardLibrary.add((AbstractCard)new Dash());
        CardLibrary.add((AbstractCard)new DeadlyPoison());
        CardLibrary.add((AbstractCard)new Defend_Green());
        CardLibrary.add((AbstractCard)new Deflect());
        CardLibrary.add((AbstractCard)new DieDieDie());
        CardLibrary.add((AbstractCard)new Distraction());
        CardLibrary.add((AbstractCard)new DodgeAndRoll());
        CardLibrary.add((AbstractCard)new Doppelganger());
        CardLibrary.add((AbstractCard)new EndlessAgony());
        CardLibrary.add((AbstractCard)new Envenom());
        CardLibrary.add((AbstractCard)new EscapePlan());
        CardLibrary.add((AbstractCard)new Eviscerate());
        CardLibrary.add((AbstractCard)new Expertise());
        CardLibrary.add((AbstractCard)new Finisher());
        CardLibrary.add((AbstractCard)new Flechettes());
        CardLibrary.add((AbstractCard)new FlyingKnee());
        CardLibrary.add((AbstractCard)new Footwork());
        CardLibrary.add((AbstractCard)new GlassKnife());
        CardLibrary.add((AbstractCard)new GrandFinale());
        CardLibrary.add((AbstractCard)new HeelHook());
        CardLibrary.add((AbstractCard)new InfiniteBlades());
        CardLibrary.add((AbstractCard)new LegSweep());
        CardLibrary.add((AbstractCard)new Malaise());
        CardLibrary.add((AbstractCard)new MasterfulStab());
        CardLibrary.add((AbstractCard)new Neutralize());
        CardLibrary.add((AbstractCard)new Nightmare());
        CardLibrary.add((AbstractCard)new NoxiousFumes());
        CardLibrary.add((AbstractCard)new Outmaneuver());
        CardLibrary.add((AbstractCard)new PhantasmalKiller());
        CardLibrary.add((AbstractCard)new PiercingWail());
        CardLibrary.add((AbstractCard)new PoisonedStab());
        CardLibrary.add((AbstractCard)new Predator());
        CardLibrary.add((AbstractCard)new Prepared());
        CardLibrary.add((AbstractCard)new QuickSlash());
        CardLibrary.add((AbstractCard)new Reflex());
        CardLibrary.add((AbstractCard)new RiddleWithHoles());
        CardLibrary.add((AbstractCard)new Setup());
        CardLibrary.add((AbstractCard)new Skewer());
        CardLibrary.add((AbstractCard)new Slice());
        CardLibrary.add((AbstractCard)new StormOfSteel());
        CardLibrary.add((AbstractCard)new Strike_Green());
        CardLibrary.add((AbstractCard)new SuckerPunch());
        CardLibrary.add((AbstractCard)new Survivor());
        CardLibrary.add((AbstractCard)new Tactician());
        CardLibrary.add((AbstractCard)new Terror());
        CardLibrary.add((AbstractCard)new ToolsOfTheTrade());
        CardLibrary.add((AbstractCard)new UnderhandedStrike());
        CardLibrary.add((AbstractCard)new Unload());
        CardLibrary.add((AbstractCard)new WellLaidPlans());
        CardLibrary.add((AbstractCard)new WraithForm());
    }

    private static void addBlueCards() {
        CardLibrary.add(new Annihilation());
        CardLibrary.add(new BloodStrike());
        CardLibrary.add(new DKDefend());
        CardLibrary.add(new CondemnStrike());
        CardLibrary.add(new CurseStrike());
        CardLibrary.add(new DeathStrike());
        CardLibrary.add(new DiseaseStrike());
        CardLibrary.add(new Execute());
        CardLibrary.add(new FrozenStrike());
        CardLibrary.add(new RuneStrike());
        CardLibrary.add(new UndeadWill());
        CardLibrary.add(new Withstand());
        CardLibrary.add(new RuneRegen());
        CardLibrary.add(new RuneDefend());
        CardLibrary.add(new DiseaseCloud());
        CardLibrary.add(new RuneStorm());
        CardLibrary.add(new RuneExplode());
        CardLibrary.add(new RuneRecover());
        CardLibrary.add(new RuneHeavyStrike());
        CardLibrary.add(new RuneBurn());
        CardLibrary.add(new HeartStrike());
        CardLibrary.add(new FrozenTouch());
        CardLibrary.add(new NoLightShield());
        CardLibrary.add(new BoneShield());
        CardLibrary.add(new LichkingWraith());
        CardLibrary.add(new EvilPower());
        CardLibrary.add(new EvilEager());
        CardLibrary.add(new WindStrike());
        CardLibrary.add(new EvilStrike());
        CardLibrary.add(new DeathShake());
        CardLibrary.add(new FrozenWill());
        CardLibrary.add(new ForceDeflexion());
        CardLibrary.add(new BloodDiffer());
        CardLibrary.add(new VoidDefend());
        CardLibrary.add(new VoidStrike());
        CardLibrary.add(new BloodMask());
        CardLibrary.add(new FrozenHeart());
        CardLibrary.add(new UltimateCold());
        CardLibrary.add(new WinterHorn());
        CardLibrary.add(new RuneInspire());
        CardLibrary.add(new LichBody());
        CardLibrary.add(new BodyStrike());
        CardLibrary.add(new RuneDiffer());
        CardLibrary.add(new SwordWave());
        CardLibrary.add(new FrozenChain());
        CardLibrary.add(new Infect());
        CardLibrary.add(new Hanging());
        CardLibrary.add(new FrozenDeath());
        CardLibrary.add(new BloodBoiling());
        CardLibrary.add(new GhostStrike());
    }

    private static void addColorlessCards() {
        CardLibrary.add((AbstractCard)new Apotheosis());
        CardLibrary.add((AbstractCard)new BandageUp());
        CardLibrary.add((AbstractCard)new Bite());
        CardLibrary.add((AbstractCard)new Blind());
        CardLibrary.add((AbstractCard)new DarkShackles());
        CardLibrary.add((AbstractCard)new DeepBreath());
        CardLibrary.add((AbstractCard)new DramaticEntrance());
        CardLibrary.add((AbstractCard)new Enlightenment());
        CardLibrary.add((AbstractCard)new Finesse());
        CardLibrary.add((AbstractCard)new FlashOfSteel());
        CardLibrary.add((AbstractCard)new GoodInstincts());
        CardLibrary.add((AbstractCard)new JackOfAllTrades());
        CardLibrary.add((AbstractCard)new JAX());
        CardLibrary.add((AbstractCard)new Madness());
        CardLibrary.add((AbstractCard)new MasterOfStrategy());
        CardLibrary.add((AbstractCard)new MindBlast());
        CardLibrary.add((AbstractCard)new Panacea());
        CardLibrary.add((AbstractCard)new Panache());
        CardLibrary.add((AbstractCard)new Purity());
        CardLibrary.add((AbstractCard)new SadisticNature());
        CardLibrary.add((AbstractCard)new SecretTechnique());
        CardLibrary.add((AbstractCard)new SecretWeapon());
        CardLibrary.add((AbstractCard)new Shiv());
        CardLibrary.add((AbstractCard)new SwiftStrike());
        CardLibrary.add((AbstractCard)new ThinkingAhead());
        CardLibrary.add((AbstractCard)new Transmutation());
        CardLibrary.add((AbstractCard)new Trip());
    }

    private static void addCurseCards() {
        CardLibrary.add((AbstractCard)new Clumsy());
        CardLibrary.add((AbstractCard)new Decay());
        CardLibrary.add((AbstractCard)new Doubt());
        CardLibrary.add((AbstractCard)new Injury());
        CardLibrary.add((AbstractCard)new Necronomicurse());
        CardLibrary.add((AbstractCard)new Normality());
        CardLibrary.add((AbstractCard)new Pain());
        CardLibrary.add((AbstractCard)new Parasite());
        CardLibrary.add((AbstractCard)new Regret());
        CardLibrary.add((AbstractCard)new Writhe());
    }

    private static void removeNonFinalizedCards() {
        ArrayList<String> toRemove = new ArrayList<String>();
        for (Map.Entry<String, AbstractCard> entry : cards.entrySet()) {
            if (entry.getValue().assetURL != null) continue;
            toRemove.add(entry.getKey());
        }
        for (String string : toRemove) {
            logger.info("Removing Card " + string + " for trailer build.");
            cards.remove(string);
        }
        toRemove.clear();
        for (Map.Entry<String, Object> entry : curses.entrySet()) {
            if (((AbstractCard)entry.getValue()).assetURL != null) continue;
            toRemove.add(entry.getKey());
        }
        for (String string : toRemove) {
            logger.info("Removing Curse " + string + " for trailer build.");
            curses.remove(string);
        }
    }

    public static void unlockAndSeeAllCards() {
        for (String string : UnlockTracker.lockedCards) {
            UnlockTracker.hardUnlockOverride((String)string);
        }
        for (Map.Entry entry : cards.entrySet()) {
            if (((AbstractCard)entry.getValue()).rarity == AbstractCard.CardRarity.BASIC || UnlockTracker.isCardSeen((String)((String)entry.getKey()))) continue;
            UnlockTracker.markCardAsSeen((String)((String)entry.getKey()));
        }
        for (Map.Entry entry : curses.entrySet()) {
            if (UnlockTracker.isCardSeen((String)((String)entry.getKey()))) continue;
            UnlockTracker.markCardAsSeen((String)((String)entry.getKey()));
        }
    }

    public static void add(AbstractCard card) {
        switch (card.color) {
            case RED: {
                ++redCards;
                if (!UnlockTracker.isCardSeen((String)card.cardID)) break;
                ++seenRedCards;
                break;
            }
            case GREEN: {
                ++greenCards;
                if (!UnlockTracker.isCardSeen((String)card.cardID)) break;
                ++seenGreenCards;
                break;
            }
            case BLUE: {
                ++blueCards;
                if (!UnlockTracker.isCardSeen((String)card.cardID)) break;
                ++seenBlueCards;
                break;
            }
            case COLORLESS: {
                ++colorlessCards;
                if (!UnlockTracker.isCardSeen((String)card.cardID)) break;
                ++seenColorlessCards;
                break;
            }
            case CURSE: {
                ++curseCards;
                if (UnlockTracker.isCardSeen((String)card.cardID)) {
                    ++seenCurseCards;
                }
                curses.put(card.cardID, card);
            }
        }
        if (!UnlockTracker.isCardSeen((String)card.cardID)) {
            card.isSeen = false;
        }
        cards.put(card.cardID, card);
        card.initializeDescription();
        if (card.color != AbstractCard.CardColor.BLUE) {
            ++totalCardCount;
        }
    }

    public static AbstractCard getCopy(String key, int upgradeTime) {
        AbstractCard source = CardLibrary.getCard(key);
        AbstractCard retVal = null;
        retVal = source == null ? CardLibrary.getCard("Madness").makeCopy() : CardLibrary.getCard(key).makeCopy();
        int i = 0;
        while (i < upgradeTime) {
            retVal.upgrade();
            ++i;
        }
        return retVal;
    }

    public static AbstractCard getCopy(String key) {
        return CardLibrary.getCard(key).makeCopy();
    }

    public static AbstractCard getCard(AbstractPlayer.PlayerClass plyrClass, String key) {
        return cards.get(key);
    }

    public static AbstractCard getCard(String key) {
        return cards.get(key);
    }

    public static AbstractCard getCurse(int pool) {
        if (pool < 1 || pool > 2) {
            logger.info("INCORRECT POOL FOR GET CURSE");
        }
        ArrayList<String> tmp = new ArrayList<String>();
        for (Map.Entry<String, AbstractCard> c : curses.entrySet()) {
            if (c.getValue().pool != pool) continue;
            tmp.add(c.getKey());
        }
        return cards.get(tmp.get(MathUtils.random((int)0, (int)(tmp.size() - 1))));
    }

    public static AbstractCard getCurse(AbstractCard prohibitedCard, Random rng) {
        ArrayList<String> tmp = new ArrayList<String>();
        for (Map.Entry<String, AbstractCard> c : curses.entrySet()) {
            if (Objects.equals(c.getValue().cardID, prohibitedCard.cardID) || Objects.equals(c.getValue().cardID, "Necronomicurse")) continue;
            tmp.add(c.getKey());
        }
        return cards.get(tmp.get(rng.random(0, tmp.size() - 1)));
    }

    public static AbstractCard getCurse(AbstractCard prohibitedCard) {
        return CardLibrary.getCurse(prohibitedCard, new Random());
    }

    public static void uploadCardData() {
        ArrayList<String> data = new ArrayList<String>();
        for (Map.Entry<String, AbstractCard> c : cards.entrySet()) {
            data.add(c.getValue().debugDetailedCardDataString());
            AbstractCard c2 = c.getValue().makeCopy();
            if (!c2.canUpgrade()) continue;
            c2.upgrade();
            data.add(c2.debugDetailedCardDataString());
        }
        LeaderboardPoster poster = new LeaderboardPoster();
        poster.setValues(LeaderboardPoster.LeaderboardDataType.CARD_DATA, "", AbstractCard.debugDetailedCardDataHeader(), data, false);
        Thread t = new Thread((Runnable)poster);
        t.run();
    }

    public static ArrayList<AbstractCard> getAllCards() {
        ArrayList<AbstractCard> retVal = new ArrayList<AbstractCard>();
        for (Map.Entry<String, AbstractCard> c : cards.entrySet()) {
            retVal.add(c.getValue());
        }
        return retVal;
    }

    public static ArrayList<AbstractCard> getCardList(LibraryType type) {
        ArrayList<AbstractCard> retVal = new ArrayList<AbstractCard>();
        switch (type) {
            case COLORLESS: {
                for (Map.Entry<String, AbstractCard> c : cards.entrySet()) {
                    if (c.getValue().color != AbstractCard.CardColor.COLORLESS) continue;
                    retVal.add(c.getValue());
                }
                break;
            }
            case CURSE: {
                for (Map.Entry<String, AbstractCard> c : cards.entrySet()) {
                    if (c.getValue().color != AbstractCard.CardColor.CURSE) continue;
                    retVal.add(c.getValue());
                }
                break;
            }
            case RED: {
                for (Map.Entry<String, AbstractCard> c : cards.entrySet()) {
                    if (c.getValue().color != AbstractCard.CardColor.RED) continue;
                    retVal.add(c.getValue());
                }
                break;
            }
            case GREEN: {
                for (Map.Entry<String, AbstractCard> c : cards.entrySet()) {
                    if (c.getValue().color != AbstractCard.CardColor.GREEN) continue;
                    retVal.add(c.getValue());
                }
                break;
            }
            case BLUE: {
                for (Map.Entry<String, AbstractCard> c : cards.entrySet()) {
                    if (c.getValue().color != AbstractCard.CardColor.BLUE) continue;
                    retVal.add(c.getValue());
                }
                break;
            }
            case STATUS: {
                retVal.add((AbstractCard)new Wound());
                retVal.add((AbstractCard)new Burn());
                retVal.add((AbstractCard)new Dazed());
            }
        }
        return retVal;
    }

    public static enum LibraryType {
        RED,
        GREEN,
        BLUE,
        CURSE,
        STATUS,
        COLORLESS;

    }
}

