/*
 * Decompiled with CFR 0.152.
 */
package com.megacrit.cardcrawl.helpers;

import com.megacrit.cardcrawl.characters.AbstractPlayer;
import com.megacrit.cardcrawl.core.Settings;
import com.megacrit.cardcrawl.dungeons.AbstractDungeon;
import com.megacrit.cardcrawl.metrics.LeaderboardPoster;
import com.megacrit.cardcrawl.relics.AbstractRelic;
import com.megacrit.cardcrawl.relics.Anchor;
import com.megacrit.cardcrawl.relics.AncientTeaSet;
import com.megacrit.cardcrawl.relics.ArtOfWar;
import com.megacrit.cardcrawl.relics.Astrolabe;
import com.megacrit.cardcrawl.relics.BagOfMarbles;
import com.megacrit.cardcrawl.relics.BagOfPreparation;
import com.megacrit.cardcrawl.relics.BirdFacedUrn;
import com.megacrit.cardcrawl.relics.BlackBlood;
import com.megacrit.cardcrawl.relics.BlackStar;
import com.megacrit.cardcrawl.relics.BloodVial;
import com.megacrit.cardcrawl.relics.BloodyIdol;
import com.megacrit.cardcrawl.relics.BlueCandle;
import com.megacrit.cardcrawl.relics.BottledFlame;
import com.megacrit.cardcrawl.relics.BottledLightning;
import com.megacrit.cardcrawl.relics.BottledTornado;
import com.megacrit.cardcrawl.relics.BronzeScales;
import com.megacrit.cardcrawl.relics.BurningBlood;
import com.megacrit.cardcrawl.relics.Calipers;
import com.megacrit.cardcrawl.relics.CallingBell;
import com.megacrit.cardcrawl.relics.Cauldron;
import com.megacrit.cardcrawl.relics.CentennialPuzzle;
import com.megacrit.cardcrawl.relics.ChampionsBelt;
import com.megacrit.cardcrawl.relics.CharonsAshes;
import com.megacrit.cardcrawl.relics.Circlet;
import com.megacrit.cardcrawl.relics.Courier;
import com.megacrit.cardcrawl.relics.CursedKey;
import com.megacrit.cardcrawl.relics.DarkstonePeriapt;
import com.megacrit.cardcrawl.relics.DeadBranch;
import com.megacrit.cardcrawl.relics.Dodecahedron;
import com.megacrit.cardcrawl.relics.DreamCatcher;
import com.megacrit.cardcrawl.relics.DuVuDoll;
import com.megacrit.cardcrawl.relics.Ectoplasm;
import com.megacrit.cardcrawl.relics.Enchiridion;
import com.megacrit.cardcrawl.relics.EternalFeather;
import com.megacrit.cardcrawl.relics.FrozenEgg2;
import com.megacrit.cardcrawl.relics.FrozenEye;
import com.megacrit.cardcrawl.relics.GamblingChip;
import com.megacrit.cardcrawl.relics.Ginger;
import com.megacrit.cardcrawl.relics.Girya;
import com.megacrit.cardcrawl.relics.GoldenIdol;
import com.megacrit.cardcrawl.relics.GremlinHorn;
import com.megacrit.cardcrawl.relics.HappyFlower;
import com.megacrit.cardcrawl.relics.IceCream;
import com.megacrit.cardcrawl.relics.JuzuBracelet;
import com.megacrit.cardcrawl.relics.Kunai;
import com.megacrit.cardcrawl.relics.Lantern;
import com.megacrit.cardcrawl.relics.LetterOpener;
import com.megacrit.cardcrawl.relics.LizardTail;
import com.megacrit.cardcrawl.relics.MagicFlower;
import com.megacrit.cardcrawl.relics.Mango;
import com.megacrit.cardcrawl.relics.MarkOfPain;
import com.megacrit.cardcrawl.relics.Matryoshka;
import com.megacrit.cardcrawl.relics.MeatOnTheBone;
import com.megacrit.cardcrawl.relics.MedicalKit;
import com.megacrit.cardcrawl.relics.MembershipCard;
import com.megacrit.cardcrawl.relics.MercuryHourglass;
import com.megacrit.cardcrawl.relics.MoltenEgg2;
import com.megacrit.cardcrawl.relics.MummifiedHand;
import com.megacrit.cardcrawl.relics.Necronomicon;
import com.megacrit.cardcrawl.relics.NeowsLament;
import com.megacrit.cardcrawl.relics.NilrysCodex;
import com.megacrit.cardcrawl.relics.NinjaScroll;
import com.megacrit.cardcrawl.relics.NlothsGift;
import com.megacrit.cardcrawl.relics.OddMushroom;
import com.megacrit.cardcrawl.relics.OddlySmoothStone;
import com.megacrit.cardcrawl.relics.OldCoin;
import com.megacrit.cardcrawl.relics.Omamori;
import com.megacrit.cardcrawl.relics.Orichalcum;
import com.megacrit.cardcrawl.relics.OrnamentalFan;
import com.megacrit.cardcrawl.relics.Orrery;
import com.megacrit.cardcrawl.relics.PandorasBox;
import com.megacrit.cardcrawl.relics.Pantograph;
import com.megacrit.cardcrawl.relics.PaperCrane;
import com.megacrit.cardcrawl.relics.PaperFrog;
import com.megacrit.cardcrawl.relics.PeacePipe;
import com.megacrit.cardcrawl.relics.Pear;
import com.megacrit.cardcrawl.relics.PenNib;
import com.megacrit.cardcrawl.relics.PhilosopherStone;
import com.megacrit.cardcrawl.relics.PrayerWheel;
import com.megacrit.cardcrawl.relics.QuestionCard;
import com.megacrit.cardcrawl.relics.RedMask;
import com.megacrit.cardcrawl.relics.RedSkull;
import com.megacrit.cardcrawl.relics.RegalPillow;
import com.megacrit.cardcrawl.relics.RunicCube;
import com.megacrit.cardcrawl.relics.RunicDome;
import com.megacrit.cardcrawl.relics.RunicPyramid;
import com.megacrit.cardcrawl.relics.SelfFormingClay;
import com.megacrit.cardcrawl.relics.Shovel;
import com.megacrit.cardcrawl.relics.Shuriken;
import com.megacrit.cardcrawl.relics.SingingBowl;
import com.megacrit.cardcrawl.relics.SmilingMask;
import com.megacrit.cardcrawl.relics.SnakeRing;
import com.megacrit.cardcrawl.relics.SneckoEye;
import com.megacrit.cardcrawl.relics.SneckoSkull;
import com.megacrit.cardcrawl.relics.Sozu;
import com.megacrit.cardcrawl.relics.SpiritPoop;
import com.megacrit.cardcrawl.relics.StrangeSpoon;
import com.megacrit.cardcrawl.relics.Strawberry;
import com.megacrit.cardcrawl.relics.Sundial;
import com.megacrit.cardcrawl.relics.TheSpecimen;
import com.megacrit.cardcrawl.relics.ThreadAndNeedle;
import com.megacrit.cardcrawl.relics.Tingsha;
import com.megacrit.cardcrawl.relics.TinyChest;
import com.megacrit.cardcrawl.relics.TinyHouse;
import com.megacrit.cardcrawl.relics.Toolbox;
import com.megacrit.cardcrawl.relics.Torii;
import com.megacrit.cardcrawl.relics.ToughBandages;
import com.megacrit.cardcrawl.relics.ToxicEgg2;
import com.megacrit.cardcrawl.relics.ToyOrnithopter;
import com.megacrit.cardcrawl.relics.UnceasingTop;
import com.megacrit.cardcrawl.relics.Vajra;
import com.megacrit.cardcrawl.relics.VelvetChoker;
import com.megacrit.cardcrawl.relics.Waffle;
import com.megacrit.cardcrawl.relics.WarPaint;
import com.megacrit.cardcrawl.relics.Whetstone;
import com.megacrit.cardcrawl.relics.WhiteBeast;
import com.megacrit.cardcrawl.relics.deprecated.DerpRock;
import com.megacrit.cardcrawl.unlock.UnlockTracker;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dakiler.slayhelper.relics.BadgeBless;
import org.dakiler.slayhelper.relics.BadgeWrath;
import org.dakiler.slayhelper.relics.BloodRealm;
import org.dakiler.slayhelper.relics.BrokenMantle;
import org.dakiler.slayhelper.relics.BrokenWatch;
import org.dakiler.slayhelper.relics.BurningIcecream;
import org.dakiler.slayhelper.relics.EvilBlood;
import org.dakiler.slayhelper.relics.EvilRealm;
import org.dakiler.slayhelper.relics.HatTrick;
import org.dakiler.slayhelper.relics.HeavyShield;
import org.dakiler.slayhelper.relics.IceRealm;
import org.dakiler.slayhelper.relics.OldTorch;
import org.dakiler.slayhelper.relics.Pill;
import org.dakiler.slayhelper.relics.RuneSword;
import org.dakiler.slayhelper.relics.SaveLoadDisk;
import org.dakiler.slayhelper.relics.Scar;
import org.dakiler.slayhelper.relics.SmileMask;
import org.dakiler.slayhelper.relics.SoftArmor;
import org.dakiler.slayhelper.relics.VoidPower;

public class RelicLibrary {
    private static final Logger logger = LogManager.getLogger((String)RelicLibrary.class.getName());
    public static int totalRelicCount = 0;
    public static int seenRelics = 0;
    private static HashMap<String, AbstractRelic> sharedRelics = new HashMap();
    private static HashMap<String, AbstractRelic> redRelics = new HashMap();
    private static HashMap<String, AbstractRelic> greenRelics = new HashMap();
    private static HashMap<String, AbstractRelic> blueRelics = new HashMap();
    public static ArrayList<AbstractRelic> starterList = new ArrayList();
    public static ArrayList<AbstractRelic> commonList = new ArrayList();
    public static ArrayList<AbstractRelic> uncommonList = new ArrayList();
    public static ArrayList<AbstractRelic> rareList = new ArrayList();
    public static ArrayList<AbstractRelic> bossList = new ArrayList();
    public static ArrayList<AbstractRelic> specialList = new ArrayList();
    public static ArrayList<AbstractRelic> shopList = new ArrayList();
    public static ArrayList<AbstractRelic> redList = new ArrayList();
    public static ArrayList<AbstractRelic> greenList = new ArrayList();
    public static ArrayList<AbstractRelic> blueList = new ArrayList();

    public static void initialize() {
        long startTime = System.currentTimeMillis();
        RelicLibrary.add((AbstractRelic)new Anchor());
        RelicLibrary.add((AbstractRelic)new ArtOfWar());
        RelicLibrary.add((AbstractRelic)new Astrolabe());
        RelicLibrary.add((AbstractRelic)new BagOfMarbles());
        RelicLibrary.add((AbstractRelic)new BagOfPreparation());
        RelicLibrary.add((AbstractRelic)new BirdFacedUrn());
        RelicLibrary.add((AbstractRelic)new BlackStar());
        RelicLibrary.add((AbstractRelic)new BloodVial());
        RelicLibrary.add((AbstractRelic)new BloodyIdol());
        RelicLibrary.add((AbstractRelic)new BlueCandle());
        RelicLibrary.add((AbstractRelic)new BottledFlame());
        RelicLibrary.add((AbstractRelic)new BottledLightning());
        RelicLibrary.add((AbstractRelic)new BottledTornado());
        RelicLibrary.add((AbstractRelic)new BronzeScales());
        RelicLibrary.add((AbstractRelic)new Calipers());
        RelicLibrary.add((AbstractRelic)new CallingBell());
        RelicLibrary.add((AbstractRelic)new Cauldron());
        RelicLibrary.add((AbstractRelic)new CentennialPuzzle());
        RelicLibrary.add((AbstractRelic)new Courier());
        RelicLibrary.add((AbstractRelic)new CursedKey(null));
        RelicLibrary.add((AbstractRelic)new DarkstonePeriapt());
        RelicLibrary.add((AbstractRelic)new DeadBranch());
        RelicLibrary.add((AbstractRelic)new Dodecahedron(null));
        RelicLibrary.add((AbstractRelic)new DreamCatcher());
        RelicLibrary.add(new DuVuDoll());
        RelicLibrary.add((AbstractRelic)new Ectoplasm());
        RelicLibrary.add((AbstractRelic)new Enchiridion());
        RelicLibrary.add((AbstractRelic)new EternalFeather());
        RelicLibrary.add((AbstractRelic)new FrozenEgg2());
        RelicLibrary.add((AbstractRelic)new FrozenEye());
        RelicLibrary.add((AbstractRelic)new GamblingChip());
        RelicLibrary.add((AbstractRelic)new Ginger());
        RelicLibrary.add((AbstractRelic)new Girya());
        RelicLibrary.add((AbstractRelic)new GoldenIdol());
        RelicLibrary.add((AbstractRelic)new GremlinHorn(null));
        RelicLibrary.add((AbstractRelic)new HappyFlower());
        RelicLibrary.add((AbstractRelic)new IceCream());
        RelicLibrary.add((AbstractRelic)new JuzuBracelet());
        RelicLibrary.add((AbstractRelic)new Kunai());
        RelicLibrary.add((AbstractRelic)new Lantern());
        RelicLibrary.add((AbstractRelic)new LetterOpener());
        RelicLibrary.add((AbstractRelic)new LizardTail());
        RelicLibrary.add((AbstractRelic)new Mango());
        RelicLibrary.add((AbstractRelic)new Matryoshka());
        RelicLibrary.add((AbstractRelic)new MeatOnTheBone());
        RelicLibrary.add((AbstractRelic)new MedicalKit());
        RelicLibrary.add((AbstractRelic)new MembershipCard());
        RelicLibrary.add((AbstractRelic)new MercuryHourglass());
        RelicLibrary.add((AbstractRelic)new MoltenEgg2());
        RelicLibrary.add((AbstractRelic)new MummifiedHand());
        RelicLibrary.add((AbstractRelic)new NeowsLament());
        RelicLibrary.add((AbstractRelic)new Necronomicon());
        RelicLibrary.add((AbstractRelic)new NilrysCodex());
        RelicLibrary.add((AbstractRelic)new NlothsGift());
        RelicLibrary.add((AbstractRelic)new OddlySmoothStone());
        RelicLibrary.add((AbstractRelic)new OddMushroom());
        RelicLibrary.add((AbstractRelic)new OldCoin());
        RelicLibrary.add((AbstractRelic)new Omamori());
        RelicLibrary.add((AbstractRelic)new Orichalcum());
        RelicLibrary.add((AbstractRelic)new OrnamentalFan());
        RelicLibrary.add((AbstractRelic)new Orrery());
        RelicLibrary.add((AbstractRelic)new PandorasBox());
        RelicLibrary.add((AbstractRelic)new Pantograph());
        RelicLibrary.add((AbstractRelic)new PeacePipe());
        RelicLibrary.add((AbstractRelic)new Pear());
        RelicLibrary.add((AbstractRelic)new PenNib());
        RelicLibrary.add((AbstractRelic)new PhilosopherStone());
        RelicLibrary.add((AbstractRelic)new PrayerWheel());
        RelicLibrary.add((AbstractRelic)new QuestionCard());
        RelicLibrary.add((AbstractRelic)new RedMask());
        RelicLibrary.add((AbstractRelic)new RegalPillow());
        RelicLibrary.add((AbstractRelic)new RunicDome(null));
        RelicLibrary.add((AbstractRelic)new RunicPyramid());
        RelicLibrary.add((AbstractRelic)new Shovel());
        RelicLibrary.add((AbstractRelic)new Shuriken());
        RelicLibrary.add((AbstractRelic)new SingingBowl());
        RelicLibrary.add((AbstractRelic)new SmilingMask());
        RelicLibrary.add((AbstractRelic)new SneckoEye());
        RelicLibrary.add((AbstractRelic)new Sozu());
        RelicLibrary.add((AbstractRelic)new SpiritPoop());
        RelicLibrary.add((AbstractRelic)new StrangeSpoon());
        RelicLibrary.add((AbstractRelic)new Strawberry());
        RelicLibrary.add((AbstractRelic)new Sundial());
        RelicLibrary.add((AbstractRelic)new AncientTeaSet());
        RelicLibrary.add((AbstractRelic)new ThreadAndNeedle());
        RelicLibrary.add((AbstractRelic)new TinyChest());
        RelicLibrary.add((AbstractRelic)new TinyHouse());
        RelicLibrary.add((AbstractRelic)new Toolbox());
        RelicLibrary.add((AbstractRelic)new Torii());
        RelicLibrary.add((AbstractRelic)new ToxicEgg2());
        RelicLibrary.add((AbstractRelic)new ToyOrnithopter());
        RelicLibrary.add((AbstractRelic)new UnceasingTop());
        RelicLibrary.add((AbstractRelic)new Vajra());
        RelicLibrary.add((AbstractRelic)new VelvetChoker());
        RelicLibrary.add((AbstractRelic)new Waffle());
        RelicLibrary.add((AbstractRelic)new WarPaint());
        RelicLibrary.add((AbstractRelic)new Whetstone());
        RelicLibrary.add((AbstractRelic)new WhiteBeast());
        RelicLibrary.addGreen((AbstractRelic)new NinjaScroll());
        RelicLibrary.addGreen((AbstractRelic)new PaperCrane());
        RelicLibrary.addGreen((AbstractRelic)new SnakeRing());
        RelicLibrary.addGreen((AbstractRelic)new SneckoSkull());
        RelicLibrary.addGreen((AbstractRelic)new TheSpecimen());
        RelicLibrary.addGreen((AbstractRelic)new Tingsha());
        RelicLibrary.addGreen((AbstractRelic)new ToughBandages());
        RelicLibrary.addRed((AbstractRelic)new BlackBlood());
        RelicLibrary.addRed((AbstractRelic)new BurningBlood());
        RelicLibrary.addRed((AbstractRelic)new ChampionsBelt());
        RelicLibrary.addRed((AbstractRelic)new CharonsAshes());
        RelicLibrary.addRed((AbstractRelic)new MagicFlower());
        RelicLibrary.addRed((AbstractRelic)new MarkOfPain());
        RelicLibrary.addRed((AbstractRelic)new PaperFrog());
        RelicLibrary.addRed((AbstractRelic)new RedSkull());
        RelicLibrary.addRed((AbstractRelic)new RunicCube());
        RelicLibrary.addRed((AbstractRelic)new SelfFormingClay());
        if (Settings.isDev) {
            RelicLibrary.addBlue((AbstractRelic)new DerpRock());
        }
        RelicLibrary.add(new BadgeBless());
        RelicLibrary.add(new BadgeWrath());
        RelicLibrary.add(new EvilBlood());
        RelicLibrary.add(new HatTrick());
        RelicLibrary.add(new HeavyShield());
        RelicLibrary.add(new OldTorch());
        RelicLibrary.add(new Pill());
        RelicLibrary.add(new SaveLoadDisk());
        RelicLibrary.add(new SmileMask());
        RelicLibrary.add(new SoftArmor());
        RelicLibrary.add(new VoidPower());
        RelicLibrary.addGreen(new BrokenMantle());
        RelicLibrary.addRed(new BrokenWatch());
        RelicLibrary.addRed(new Scar());
        RelicLibrary.add(new BurningIcecream());
        RelicLibrary.addBlue(new RuneSword());
        RelicLibrary.addBlue(new BloodRealm());
        RelicLibrary.addBlue(new IceRealm());
        RelicLibrary.addBlue(new EvilRealm());
        logger.info("Relic load time: " + (System.currentTimeMillis() - startTime) + "ms");
        RelicLibrary.sortLists();
        RelicLibrary.printRelicCount();
    }

    private static void sortLists() {
        Collections.sort(starterList);
        Collections.sort(commonList);
        Collections.sort(uncommonList);
        Collections.sort(rareList);
        Collections.sort(bossList);
        Collections.sort(specialList);
        Collections.sort(shopList);
        logger.info(starterList);
        logger.info(commonList);
        logger.info(uncommonList);
        logger.info(rareList);
        logger.info(bossList);
    }

    private static void printRelicCount() {
        int common = 0;
        int uncommon = 0;
        int rare = 0;
        int boss = 0;
        int shop = 0;
        int other = 0;
        for (Map.Entry<String, AbstractRelic> r : sharedRelics.entrySet()) {
            switch (r.getValue().tier) {
                case COMMON: {
                    ++common;
                    break;
                }
                case UNCOMMON: {
                    ++uncommon;
                    break;
                }
                case RARE: {
                    ++rare;
                    break;
                }
                case BOSS: {
                    ++boss;
                    break;
                }
                case SHOP: {
                    ++shop;
                    break;
                }
                default: {
                    ++other;
                }
            }
        }
        logger.info(String.valueOf(common) + "/25 (Common)");
        logger.info(String.valueOf(uncommon) + "/25 (Uncommon)");
        logger.info(String.valueOf(rare) + "/20 (Rare)");
        logger.info(String.valueOf(boss) + "/20 (Boss)");
        logger.info(String.valueOf(shop) + "/5 (Shop)");
        logger.info(String.valueOf(other) + "/? (Other)");
        logger.info(String.valueOf(redRelics.size()) + "/8 (Red)");
        logger.info(String.valueOf(greenRelics.size()) + "/8 (Green)");
        logger.info(String.valueOf(blueRelics.size()) + "/8 (Blue)");
    }

    public static void add(AbstractRelic relic) {
        if (UnlockTracker.isRelicSeen((String)relic.relicId)) {
            ++seenRelics;
        }
        relic.isSeen = UnlockTracker.isRelicSeen((String)relic.relicId);
        sharedRelics.put(relic.relicId, relic);
        RelicLibrary.addToTierList(relic);
        ++totalRelicCount;
    }

    public static void addRed(AbstractRelic relic) {
        if (UnlockTracker.isRelicSeen((String)relic.relicId)) {
            ++seenRelics;
        }
        relic.isSeen = UnlockTracker.isRelicSeen((String)relic.relicId);
        redRelics.put(relic.relicId, relic);
        RelicLibrary.addToTierList(relic);
        redList.add(relic);
        ++totalRelicCount;
    }

    public static void addGreen(AbstractRelic relic) {
        if (UnlockTracker.isRelicSeen((String)relic.relicId)) {
            ++seenRelics;
        }
        relic.isSeen = UnlockTracker.isRelicSeen((String)relic.relicId);
        greenRelics.put(relic.relicId, relic);
        RelicLibrary.addToTierList(relic);
        greenList.add(relic);
        ++totalRelicCount;
    }

    public static void addBlue(AbstractRelic relic) {
        if (UnlockTracker.isRelicSeen((String)relic.relicId)) {
            ++seenRelics;
        }
        relic.isSeen = UnlockTracker.isRelicSeen((String)relic.relicId);
        blueRelics.put(relic.relicId, relic);
        RelicLibrary.addToTierList(relic);
        blueList.add(relic);
        ++totalRelicCount;
    }

    public static void addToTierList(AbstractRelic relic) {
        switch (relic.tier) {
            case STARTER: {
                starterList.add(relic);
                break;
            }
            case COMMON: {
                commonList.add(relic);
                break;
            }
            case UNCOMMON: {
                uncommonList.add(relic);
                break;
            }
            case RARE: {
                rareList.add(relic);
                break;
            }
            case SHOP: {
                shopList.add(relic);
                break;
            }
            case SPECIAL: {
                specialList.add(relic);
                break;
            }
            case BOSS: {
                bossList.add(relic);
                break;
            }
            case DEPRECATED: {
                logger.info(String.valueOf(relic.relicId) + " is deprecated.");
                break;
            }
            default: {
                logger.info(String.valueOf(relic.relicId) + " is undefined tier.");
            }
        }
    }

    public static AbstractRelic getRelic(String key) {
        if (sharedRelics.containsKey(key)) {
            return sharedRelics.get(key);
        }
        if (redRelics.containsKey(key)) {
            return redRelics.get(key);
        }
        if (greenRelics.containsKey(key)) {
            return greenRelics.get(key);
        }
        if (blueRelics.containsKey(key)) {
            return blueRelics.get(key);
        }
        return new Circlet();
    }

    public static void populateRelicPool(ArrayList<String> pool, AbstractRelic.RelicTier tier, AbstractPlayer.PlayerClass c) {
        for (Map.Entry<String, AbstractRelic> r : sharedRelics.entrySet()) {
            if (r.getValue().tier != tier || UnlockTracker.isRelicLocked((String)r.getKey()) && !Settings.isDailyRun) continue;
            pool.add(r.getKey());
        }
        switch (c) {
            case IRONCLAD: {
                for (Map.Entry<String, AbstractRelic> r : redRelics.entrySet()) {
                    if (r.getValue().tier != tier || UnlockTracker.isRelicLocked((String)r.getKey()) && !Settings.isDailyRun) continue;
                    pool.add(r.getKey());
                }
                break;
            }
            case THE_SILENT: {
                for (Map.Entry<String, AbstractRelic> r : greenRelics.entrySet()) {
                    if (r.getValue().tier != tier || UnlockTracker.isRelicLocked((String)r.getKey()) && !Settings.isDailyRun) continue;
                    pool.add(r.getKey());
                }
                break;
            }
            case CROWBOT: {
                for (Map.Entry<String, AbstractRelic> r : blueRelics.entrySet()) {
                    if (r.getValue().tier != tier || UnlockTracker.isRelicLocked((String)r.getKey()) && !Settings.isDailyRun) continue;
                    pool.add(r.getKey());
                }
                break;
            }
        }
    }

    public static void addSharedRelics(ArrayList<AbstractRelic> relicPool) {
        logger.info("[RELIC] Adding " + sharedRelics.size() + " shared relics...");
        for (Map.Entry<String, AbstractRelic> r : sharedRelics.entrySet()) {
            relicPool.add(r.getValue());
        }
    }

    public static void addClassSpecificRelics(ArrayList<AbstractRelic> relicPool) {
        switch (AbstractDungeon.player.chosenClass) {
            case IRONCLAD: {
                logger.info("[RELIC] Adding " + redRelics.size() + " red relics...");
                for (Map.Entry<String, AbstractRelic> r : redRelics.entrySet()) {
                    relicPool.add(r.getValue());
                }
                break;
            }
            case THE_SILENT: {
                logger.info("[RELIC] Adding " + greenRelics.size() + " red relics...");
                for (Map.Entry<String, AbstractRelic> r : greenRelics.entrySet()) {
                    relicPool.add(r.getValue());
                }
                break;
            }
            case CROWBOT: {
                logger.info("[RELIC] Adding " + blueRelics.size() + " red relics...");
                for (Map.Entry<String, AbstractRelic> r : blueRelics.entrySet()) {
                    relicPool.add(r.getValue());
                }
                break;
            }
        }
    }

    public static void uploadRelicData() {
        ArrayList<String> data = new ArrayList<String>();
        for (Map.Entry<String, AbstractRelic> r : sharedRelics.entrySet()) {
            data.add(r.getValue().debugDetailedRelicData("All"));
        }
        for (Map.Entry<String, AbstractRelic> r : redRelics.entrySet()) {
            data.add(r.getValue().debugDetailedRelicData("Red"));
        }
        for (Map.Entry<String, AbstractRelic> r : greenRelics.entrySet()) {
            data.add(r.getValue().debugDetailedRelicData("Green"));
        }
        for (Map.Entry<String, AbstractRelic> r : blueRelics.entrySet()) {
            data.add(r.getValue().debugDetailedRelicData("Blue"));
        }
        LeaderboardPoster poster = new LeaderboardPoster();
        poster.setValues(LeaderboardPoster.LeaderboardDataType.RELIC_DATA, "", AbstractRelic.debugDetailedRelicDataHeader(), data, false);
        Thread t = new Thread((Runnable)poster);
        t.run();
    }

    public static ArrayList<AbstractRelic> sortByName(ArrayList<AbstractRelic> group, boolean ascending) {
        ArrayList<AbstractRelic> tmp = new ArrayList<AbstractRelic>();
        for (AbstractRelic r : group) {
            int addIndex = 0;
            for (AbstractRelic r2 : tmp) {
                if (!ascending ? r.name.compareTo(r2.name) < 0 : r.name.compareTo(r2.name) > 0) break;
                ++addIndex;
            }
            tmp.add(addIndex, r);
        }
        return tmp;
    }

    public static ArrayList<AbstractRelic> sortByStatus(ArrayList<AbstractRelic> group, boolean ascending) {
        ArrayList<AbstractRelic> tmp = new ArrayList<AbstractRelic>();
        for (AbstractRelic r : group) {
            int addIndex = 0;
            for (AbstractRelic r2 : tmp) {
                String b;
                String a;
                if (!ascending ? (a = UnlockTracker.isRelicLocked((String)r.relicId) ? "LOCKED" : (UnlockTracker.isRelicSeen((String)r.relicId) ? "UNSEEN" : "SEEN")).compareTo(b = UnlockTracker.isRelicLocked((String)r2.relicId) ? "LOCKED" : (UnlockTracker.isRelicSeen((String)r2.relicId) ? "UNSEEN" : "SEEN")) > 0 : (a = UnlockTracker.isRelicLocked((String)r.relicId) ? "LOCKED" : (UnlockTracker.isRelicSeen((String)r.relicId) ? "UNSEEN" : "SEEN")).compareTo(b = UnlockTracker.isRelicLocked((String)r2.relicId) ? "LOCKED" : (UnlockTracker.isRelicSeen((String)r2.relicId) ? "UNSEEN" : "SEEN")) < 0) break;
                ++addIndex;
            }
            tmp.add(addIndex, r);
        }
        return tmp;
    }

    public static void unlockAndSeeAllRelics() {
        for (String string : UnlockTracker.lockedRelics) {
            UnlockTracker.hardUnlockOverride((String)string);
        }
        for (Map.Entry entry : sharedRelics.entrySet()) {
            UnlockTracker.markRelicAsSeen((String)((String)entry.getKey()));
        }
        for (Map.Entry entry : redRelics.entrySet()) {
            UnlockTracker.markRelicAsSeen((String)((String)entry.getKey()));
        }
        for (Map.Entry entry : greenRelics.entrySet()) {
            UnlockTracker.markRelicAsSeen((String)((String)entry.getKey()));
        }
        for (Map.Entry entry : blueRelics.entrySet()) {
            UnlockTracker.markRelicAsSeen((String)((String)entry.getKey()));
        }
    }
}

