/*
 * Decompiled with CFR 0.152.
 */
package com.megacrit.cardcrawl.relics;

import com.megacrit.cardcrawl.actions.AbstractGameAction;
import com.megacrit.cardcrawl.actions.common.ApplyPowerAction;
import com.megacrit.cardcrawl.actions.common.RelicAboveCreatureAction;
import com.megacrit.cardcrawl.cards.AbstractCard;
import com.megacrit.cardcrawl.core.AbstractCreature;
import com.megacrit.cardcrawl.dungeons.AbstractDungeon;
import com.megacrit.cardcrawl.helpers.PowerTip;
import com.megacrit.cardcrawl.powers.AbstractPower;
import com.megacrit.cardcrawl.powers.StrengthPower;
import com.megacrit.cardcrawl.relics.AbstractRelic;

public class DuVuDoll
extends AbstractRelic {
    public static final String ID = "Du-Vu Doll";
    private static final int AMT = 1;

    public DuVuDoll() {
        super(ID, "duvuDoll.png", AbstractRelic.RelicTier.RARE, AbstractRelic.LandingSound.MAGICAL);
    }

    public String getUpdatedDescription() {
        return String.valueOf(this.DESCRIPTIONS[0]) + 1 + this.DESCRIPTIONS[1];
    }

    public void setCounter(int c) {
        this.counter = c;
        this.description = this.counter == 0 ? String.valueOf(this.DESCRIPTIONS[0]) + 1 + this.DESCRIPTIONS[1] + this.DESCRIPTIONS[2] : String.valueOf(this.DESCRIPTIONS[0]) + 1 + this.DESCRIPTIONS[1] + this.DESCRIPTIONS[3] + this.counter + this.DESCRIPTIONS[4];
        this.tips.clear();
        this.tips.add(new PowerTip(this.name, this.description));
        this.initializeTips();
    }

    public void onMasterDeckChange() {
        this.counter = 0;
        for (AbstractCard c : AbstractDungeon.player.masterDeck.group) {
            if (c.type != AbstractCard.CardType.CURSE) continue;
            ++this.counter;
        }
        this.description = this.counter == 0 ? String.valueOf(this.DESCRIPTIONS[0]) + 1 + this.DESCRIPTIONS[1] + this.DESCRIPTIONS[2] : String.valueOf(this.DESCRIPTIONS[0]) + 1 + this.DESCRIPTIONS[1] + this.DESCRIPTIONS[3] + this.counter + this.DESCRIPTIONS[4];
        this.tips.clear();
        this.tips.add(new PowerTip(this.name, this.description));
        this.initializeTips();
    }

    public void onEquip() {
        this.counter = 0;
        for (AbstractCard c : AbstractDungeon.player.masterDeck.group) {
            if (c.type != AbstractCard.CardType.CURSE) continue;
            ++this.counter;
        }
        this.description = this.counter == 0 ? String.valueOf(this.DESCRIPTIONS[0]) + 1 + this.DESCRIPTIONS[1] + this.DESCRIPTIONS[2] : String.valueOf(this.DESCRIPTIONS[0]) + 1 + this.DESCRIPTIONS[1] + this.DESCRIPTIONS[3] + this.counter + this.DESCRIPTIONS[4];
        this.tips.clear();
        this.tips.add(new PowerTip(this.name, this.description));
        this.initializeTips();
    }

    public void atBattleStart() {
        this.counter = 0;
        for (AbstractCard c : AbstractDungeon.player.masterDeck.group) {
            if (c.type != AbstractCard.CardType.CURSE) continue;
            ++this.counter;
        }
        this.description = this.counter == 0 ? String.valueOf(this.DESCRIPTIONS[0]) + 1 + this.DESCRIPTIONS[1] + this.DESCRIPTIONS[2] : String.valueOf(this.DESCRIPTIONS[0]) + 1 + this.DESCRIPTIONS[1] + this.DESCRIPTIONS[3] + this.counter + this.DESCRIPTIONS[4];
        this.tips.clear();
        this.tips.add(new PowerTip(this.name, this.description));
        this.initializeTips();
        if (this.counter != 0) {
            this.flash();
            AbstractDungeon.actionManager.addToTop((AbstractGameAction)new ApplyPowerAction((AbstractCreature)AbstractDungeon.player, (AbstractCreature)AbstractDungeon.player, (AbstractPower)new StrengthPower((AbstractCreature)AbstractDungeon.player, this.counter), this.counter));
            AbstractDungeon.actionManager.addToTop((AbstractGameAction)new RelicAboveCreatureAction((AbstractCreature)AbstractDungeon.player, (AbstractRelic)this));
        }
    }

    public AbstractRelic makeCopy() {
        return new DuVuDoll();
    }
}

