/*
 * Decompiled with CFR 0.152.
 */
package com.megacrit.cardcrawl.screens.charSelect;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.megacrit.cardcrawl.characters.AbstractPlayer;
import com.megacrit.cardcrawl.core.CardCrawlGame;
import com.megacrit.cardcrawl.core.Settings;
import com.megacrit.cardcrawl.daily.DailyMods;
import com.megacrit.cardcrawl.dungeons.AbstractDungeon;
import com.megacrit.cardcrawl.helpers.FontHelper;
import com.megacrit.cardcrawl.helpers.Hitbox;
import com.megacrit.cardcrawl.helpers.ImageMaster;
import com.megacrit.cardcrawl.helpers.InputHelper;
import com.megacrit.cardcrawl.helpers.MathHelper;
import com.megacrit.cardcrawl.helpers.TipHelper;
import com.megacrit.cardcrawl.localization.UIStrings;
import com.megacrit.cardcrawl.metrics.LeaderboardPoster;
import com.megacrit.cardcrawl.screens.charSelect.CharacterOption;
import com.megacrit.cardcrawl.screens.mainMenu.MainMenuScreen;
import com.megacrit.cardcrawl.screens.mainMenu.MenuCancelButton;
import com.megacrit.cardcrawl.screens.options.OptionsPanel;
import com.megacrit.cardcrawl.ui.buttons.ConfirmButton;
import com.megacrit.cardcrawl.unlock.UnlockTracker;
import java.util.ArrayList;
import java.util.Random;
import org.dakiler.slayhelper.Profile;
import org.dakiler.slayhelper.character.AddonCharacter;
import org.dakiler.slayhelper.character.AddonCharacterManager;

public class CharacterSelectScreen {
    private static final UIStrings uiStrings = CardCrawlGame.languagePack.getUIString("CharacterSelectScreen");
    public static final String[] TEXT = CharacterSelectScreen.uiStrings.TEXT;
    private static final UIStrings uiStrings2 = CardCrawlGame.languagePack.getUIString("AscensionModeDescriptions");
    public static final String[] A_TEXT = CharacterSelectScreen.uiStrings2.TEXT;
    private static float ASC_LEFT_W;
    private static float ASC_RIGHT_W;
    private static final String CHOOSE_CHAR_MSG;
    public ConfirmButton confirmButton = new ConfirmButton(TEXT[1]);
    public MenuCancelButton cancelButton = new MenuCancelButton();
    private ArrayList<CharacterOption> options = new ArrayList();
    private boolean anySelected = false;
    public Texture bgCharImg = null;
    private Color bgCharColor = new Color(1.0f, 1.0f, 1.0f, 0.0f);
    private static final float BG_Y_OFFSET_TARGET;
    private float bg_y_offset = BG_Y_OFFSET_TARGET / 2.0f;
    public boolean isAscensionMode = false;
    private boolean isAscensionModeUnlocked = false;
    private Hitbox ascensionModeHb;
    private Hitbox ascLeftHb;
    private Hitbox ascRightHb;
    public int ascensionLevel = 0;
    public String ascLevelInfoString = "";

    static {
        CHOOSE_CHAR_MSG = TEXT[0];
        BG_Y_OFFSET_TARGET = 100.0f * Settings.scale;
    }

    public void initialize() {
        Settings.UPLOAD_DATA = false;
        Profile.shadowIndex = 0;
        this.options.add(new CharacterOption(TEXT[2], AbstractPlayer.PlayerClass.IRONCLAD, "ironcladButton.png", "ironcladPortrait.jpg"));
        ArrayList<AddonCharacter> ironcladList = AddonCharacterManager.getIroncladList();
        int i = 0;
        while (i < ironcladList.size()) {
            AddonCharacter ac = ironcladList.get(i);
            this.options.add(new CharacterOption(ac.getName(), AbstractPlayer.PlayerClass.IRONCLAD, "ironcladButton.png", ac.getPortrait(), i + 1));
            ++i;
        }
        AddonCharacter dk = AddonCharacterManager.getCrowbot(1);
        this.options.add(new CharacterOption(dk.getName(), AbstractPlayer.PlayerClass.CROWBOT, "crowbotButton.png", dk.getPortrait(), 1));
        dk = AddonCharacterManager.getCrowbot(2);
        this.options.add(new CharacterOption(dk.getName(), AbstractPlayer.PlayerClass.CROWBOT, "crowbotButton.png", dk.getPortrait(), 2));
        if (!UnlockTracker.isCharacterLocked((String)"The Silent")) {
            this.options.add(new CharacterOption(TEXT[3], AbstractPlayer.PlayerClass.THE_SILENT, "silentButton.png", "silentPortrait.jpg"));
        } else {
            this.options.add(new CharacterOption(AbstractPlayer.PlayerClass.THE_SILENT));
        }
        ArrayList<AddonCharacter> thesilentList = AddonCharacterManager.getTheSilentList();
        int i2 = 0;
        while (i2 < thesilentList.size()) {
            AddonCharacter ac = thesilentList.get(i2);
            this.options.add(new CharacterOption(ac.getName(), AbstractPlayer.PlayerClass.THE_SILENT, "silentButton.png", ac.getPortrait(), i2 + 1));
            ++i2;
        }
        dk = AddonCharacterManager.getCrowbot(3);
        this.options.add(new CharacterOption(dk.getName(), AbstractPlayer.PlayerClass.CROWBOT, "crowbotButton.png", dk.getPortrait(), 3));
        this.positionButtons();
        this.isAscensionModeUnlocked = UnlockTracker.isAscensionModeUnlocked();
        if (this.isAscensionModeUnlocked) {
            this.isAscensionMode = OptionsPanel.gamePref.getBoolean("Ascension Mode Default", false);
            ASC_LEFT_W = FontHelper.getSmartWidth((BitmapFont)FontHelper.cardTitleFont_N, (String)TEXT[6], (float)9999.0f, (float)0.0f);
            ASC_RIGHT_W = FontHelper.getSmartWidth((BitmapFont)FontHelper.cardTitleFont_N, (String)(String.valueOf(TEXT[7]) + "22"), (float)9999.0f, (float)0.0f);
            this.ascensionModeHb = new Hitbox(ASC_LEFT_W + 100.0f * Settings.scale, 80.0f * Settings.scale);
            this.ascensionModeHb.move((float)Settings.WIDTH / 2.0f - ASC_LEFT_W / 2.0f - 50.0f * Settings.scale, 70.0f * Settings.scale);
            this.ascLeftHb = new Hitbox(70, 70);
            this.ascRightHb = new Hitbox(70, 70);
            this.ascLeftHb.move((float)Settings.WIDTH / 2.0f + 100.0f * Settings.scale - ASC_RIGHT_W * 0.5f, 70.0f * Settings.scale);
            this.ascRightHb.move((float)Settings.WIDTH / 2.0f + 100.0f * Settings.scale + ASC_RIGHT_W * 1.5f, 70.0f * Settings.scale);
        }
    }

    private void positionButtons() {
        float X = 160.0f;
        float Y = 160.0f;
        int count = this.options.size();
        float offsetX = (float)Settings.WIDTH / 2.0f - 2.0f * X * Settings.scale;
        int i = 0;
        while (i < count) {
            int x = i % 6;
            int y = i / 6;
            this.options.get(i).move(offsetX + (float)x * X * Settings.scale, (float)(y + 1) * Y * Settings.scale);
            ++i;
        }
    }

    public void open() {
        Profile.shadowIndex = 0;
        this.cancelButton.show(TEXT[5]);
        CardCrawlGame.mainMenuScreen.screen = MainMenuScreen.CurScreen.CHAR_SELECT;
    }

    public void update() {
        if (this.ascLeftHb != null) {
            this.ascLeftHb.move((float)Settings.WIDTH / 2.0f + 100.0f * Settings.scale - ASC_RIGHT_W * 0.25f, 70.0f * Settings.scale);
            this.ascRightHb.move((float)Settings.WIDTH / 2.0f + 100.0f * Settings.scale + ASC_RIGHT_W * 1.25f, 70.0f * Settings.scale);
        }
        this.anySelected = false;
        for (CharacterOption o : this.options) {
            o.update();
            if (!o.selected) continue;
            this.anySelected = true;
        }
        this.updateButtons();
        if (InputHelper.justReleasedClickLeft && !this.anySelected) {
            this.confirmButton.isDisabled = true;
            this.confirmButton.hide();
        }
        if (this.anySelected) {
            this.bgCharColor.a = MathHelper.fadeLerpSnap((float)this.bgCharColor.a, (float)1.0f);
            this.bg_y_offset = MathHelper.fadeLerpSnap((float)this.bg_y_offset, (float)(-BG_Y_OFFSET_TARGET / 2.0f));
        } else {
            this.bgCharColor.a = MathHelper.fadeLerpSnap((float)this.bgCharColor.a, (float)0.0f);
        }
        this.updateAscensionToggle();
    }

    private void updateAscensionToggle() {
        if (this.isAscensionModeUnlocked) {
            if (this.anySelected) {
                this.ascensionModeHb.update();
                this.ascRightHb.update();
                this.ascLeftHb.update();
            }
            if (InputHelper.justClickedLeft) {
                if (this.ascensionModeHb.hovered) {
                    this.ascensionModeHb.clickStarted = true;
                } else if (this.ascRightHb.hovered) {
                    this.ascRightHb.clickStarted = true;
                } else if (this.ascLeftHb.hovered) {
                    this.ascLeftHb.clickStarted = true;
                }
            }
            if (this.ascensionModeHb.clicked) {
                this.ascensionModeHb.clicked = false;
                this.isAscensionMode = !this.isAscensionMode;
                OptionsPanel.gamePref.putBoolean("Ascension Mode Default", this.isAscensionMode);
                OptionsPanel.gamePref.flush();
            }
            if (this.ascLeftHb.clicked) {
                this.ascLeftHb.clicked = false;
                for (CharacterOption o : this.options) {
                    if (!o.selected) continue;
                    o.decrementAscensionLevel(this.ascensionLevel - 1);
                    break;
                }
            }
            if (this.ascRightHb.clicked) {
                this.ascRightHb.clicked = false;
                for (CharacterOption o : this.options) {
                    if (!o.selected) continue;
                    o.incrementAscensionLevel(this.ascensionLevel + 1);
                    break;
                }
            }
        }
    }

    public void justSelected() {
        this.bg_y_offset = BG_Y_OFFSET_TARGET / 2.0f;
    }

    public void updateButtons() {
        this.cancelButton.update();
        this.confirmButton.update();
        if (this.cancelButton.hb.clicked || InputHelper.pressedEscape) {
            InputHelper.pressedEscape = false;
            this.cancelButton.hb.clicked = false;
            this.cancelButton.hide();
            CardCrawlGame.mainMenuScreen.panelScreen.refresh();
            for (CharacterOption o : this.options) {
                o.selected = false;
            }
            this.bgCharColor.a = 0.0f;
            this.anySelected = false;
        }
        if (this.confirmButton.hb.clicked) {
            this.confirmButton.hb.clicked = false;
            this.confirmButton.isDisabled = true;
            this.confirmButton.hide();
            CardCrawlGame.mainMenuScreen.isFadingOut = true;
            CardCrawlGame.mainMenuScreen.fadeOutMusic();
            Settings.seed = new Random().nextLong();
            Settings.isDailyRun = false;
            Settings.isTrial = false;
            AbstractDungeon.isAscensionMode = this.isAscensionMode;
            AbstractDungeon.ascensionLevel = this.isAscensionMode ? this.ascensionLevel : 0;
            DailyMods.setModsFalse();
            AbstractDungeon.generateSeeds();
            this.confirmButton.hb.clicked = false;
            this.confirmButton.hide();
            if (Settings.isDemo || Settings.isPublisherBuild) {
                LeaderboardPoster poster = new LeaderboardPoster();
                poster.setValues(LeaderboardPoster.LeaderboardDataType.DEMO_EMBARK, null, null, null, false);
                Thread t = new Thread((Runnable)poster);
                t.run();
            }
        }
    }

    public void render(SpriteBatch sb) {
        sb.setColor(this.bgCharColor);
        if (this.bgCharImg != null) {
            if (Settings.isSixteenByTen) {
                sb.draw(this.bgCharImg, (float)Settings.WIDTH / 2.0f - 960.0f, (float)Settings.HEIGHT / 2.0f - 600.0f, 960.0f, 600.0f, 1920.0f, 1200.0f, Settings.scale, Settings.scale, 0.0f, 0, 0, 1920, 1200, false, false);
            } else {
                sb.draw(this.bgCharImg, (float)Settings.WIDTH / 2.0f - 960.0f, (float)Settings.HEIGHT / 2.0f - 600.0f + this.bg_y_offset, 960.0f, 600.0f, 1920.0f, 1200.0f, Settings.scale, Settings.scale, 0.0f, 0, 0, 1920, 1200, false, false);
            }
        }
        this.cancelButton.render(sb);
        this.confirmButton.render(sb);
        this.renderAscensionMode(sb);
        boolean anythingSelected = false;
        for (CharacterOption o : this.options) {
            if (o.selected) {
                anythingSelected = true;
            }
            o.render(sb);
        }
        if (!anythingSelected) {
            FontHelper.renderFontCentered((SpriteBatch)sb, (BitmapFont)FontHelper.bannerFont, (String)CHOOSE_CHAR_MSG, (float)((float)Settings.WIDTH / 2.0f), (float)(340.0f * Settings.scale), (Color)Settings.CREAM_COLOR);
        }
    }

    private void renderAscensionMode(SpriteBatch sb) {
        if (!this.anySelected) {
            return;
        }
        if (this.isAscensionModeUnlocked) {
            sb.setColor(Color.WHITE);
            sb.draw(ImageMaster.OPTION_TOGGLE, (float)Settings.WIDTH / 2.0f - ASC_LEFT_W - 16.0f - 30.0f * Settings.scale, 70.0f * Settings.scale - 16.0f, 16.0f, 16.0f, 32.0f, 32.0f, Settings.scale, Settings.scale, 0.0f, 0, 0, 32, 32, false, false);
            if (this.ascensionModeHb.hovered) {
                FontHelper.renderFontCentered((SpriteBatch)sb, (BitmapFont)FontHelper.cardTitleFont_N, (String)TEXT[6], (float)((float)Settings.WIDTH / 2.0f - ASC_LEFT_W / 2.0f), (float)(70.0f * Settings.scale), (Color)Settings.GREEN_TEXT_COLOR);
                TipHelper.renderGenericTip((float)((float)InputHelper.mX - 140.0f * Settings.scale), (float)((float)InputHelper.mY + 340.0f * Settings.scale), (String)TEXT[8], (String)TEXT[9]);
            } else {
                FontHelper.renderFontCentered((SpriteBatch)sb, (BitmapFont)FontHelper.cardTitleFont_N, (String)TEXT[6], (float)((float)Settings.WIDTH / 2.0f - ASC_LEFT_W / 2.0f), (float)(70.0f * Settings.scale), (Color)Settings.GOLD_COLOR);
            }
            FontHelper.renderFontCentered((SpriteBatch)sb, (BitmapFont)FontHelper.cardTitleFont_N, (String)(String.valueOf(TEXT[7]) + this.ascensionLevel), (float)((float)Settings.WIDTH / 2.0f + ASC_RIGHT_W / 2.0f + 100.0f * Settings.scale), (float)(70.0f * Settings.scale), (Color)Settings.BLUE_TEXT_COLOR);
            if (this.isAscensionMode) {
                sb.setColor(Color.WHITE);
                sb.draw(ImageMaster.OPTION_TOGGLE_ON, (float)Settings.WIDTH / 2.0f - ASC_LEFT_W - 16.0f - 30.0f * Settings.scale, 70.0f * Settings.scale - 16.0f, 16.0f, 16.0f, 32.0f, 32.0f, Settings.scale, Settings.scale, 0.0f, 0, 0, 32, 32, false, false);
                FontHelper.renderFontCentered((SpriteBatch)sb, (BitmapFont)FontHelper.cardDescFont_N, (String)this.ascLevelInfoString, (float)((float)Settings.WIDTH / 2.0f), (float)(35.0f * Settings.scale), (Color)Settings.CREAM_COLOR);
            }
            if (this.ascLeftHb.hovered) {
                sb.setColor(Color.WHITE);
            } else {
                sb.setColor(Color.LIGHT_GRAY);
            }
            sb.draw(ImageMaster.CF_LEFT_ARROW, this.ascLeftHb.cX - 24.0f, this.ascLeftHb.cY - 24.0f, 24.0f, 24.0f, 48.0f, 48.0f, Settings.scale, Settings.scale, 0.0f, 0, 0, 48, 48, false, false);
            if (this.ascRightHb.hovered) {
                sb.setColor(Color.WHITE);
            } else {
                sb.setColor(Color.LIGHT_GRAY);
            }
            sb.draw(ImageMaster.CF_RIGHT_ARROW, this.ascRightHb.cX - 24.0f, this.ascRightHb.cY - 24.0f, 24.0f, 24.0f, 48.0f, 48.0f, Settings.scale, Settings.scale, 0.0f, 0, 0, 48, 48, false, false);
            this.ascensionModeHb.render(sb);
            this.ascLeftHb.render(sb);
            this.ascRightHb.render(sb);
        }
    }

    public void deselectOtherOptions(CharacterOption characterOption) {
        for (CharacterOption o : this.options) {
            if (o == characterOption) continue;
            o.selected = false;
        }
    }
}

