/*
 * Decompiled with CFR 0.152.
 */
package com.megacrit.cardcrawl.screens.options;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.megacrit.cardcrawl.core.CardCrawlGame;
import com.megacrit.cardcrawl.core.Settings;
import com.megacrit.cardcrawl.dungeons.AbstractDungeon;
import com.megacrit.cardcrawl.helpers.FontHelper;
import com.megacrit.cardcrawl.helpers.Hitbox;
import com.megacrit.cardcrawl.helpers.ImageMaster;
import com.megacrit.cardcrawl.helpers.InputHelper;
import com.megacrit.cardcrawl.helpers.MathHelper;
import com.megacrit.cardcrawl.helpers.TipTracker;
import com.megacrit.cardcrawl.localization.UIStrings;
import com.megacrit.cardcrawl.screens.DeathScreen;

public class ConfirmPopup {
    private static final UIStrings uiStrings = CardCrawlGame.languagePack.getUIString("ConfirmPopup");
    public static final String[] TEXT = ConfirmPopup.uiStrings.TEXT;
    public String title;
    public String desc;
    public ConfirmType type;
    public Hitbox yesHb;
    public Hitbox noHb;
    private static final int CONFIRM_W = 360;
    private static final int CONFIRM_H = 414;
    private static final int YES_W = 173;
    private static final int NO_W = 161;
    private static final int BUTTON_H = 74;
    private Color screenColor = new Color(0.0f, 0.0f, 0.0f, 0.0f);
    private Color uiColor = new Color(1.0f, 1.0f, 1.0f, 0.0f);
    private float targetAlpha = 0.0f;
    private float targetAlpha2 = 0.0f;
    public boolean shown = false;
    private static final float SCREEN_DARKNESS = 0.75f;

    public ConfirmPopup(String title, String desc, ConfirmType type) {
        this.type = type;
        this.title = title;
        this.desc = desc;
        this.yesHb = new Hitbox(160.0f * Settings.scale, 70.0f * Settings.scale);
        this.noHb = new Hitbox(160.0f * Settings.scale, 70.0f * Settings.scale);
        this.yesHb.move(860.0f * Settings.scale, Settings.OPTION_Y - 118.0f * Settings.scale);
        this.noHb.move(1062.0f * Settings.scale, Settings.OPTION_Y - 118.0f * Settings.scale);
    }

    public void show() {
        if (!this.shown) {
            this.shown = true;
            this.targetAlpha = 0.75f;
            this.targetAlpha2 = 1.0f;
        }
    }

    public void hide() {
        if (this.shown) {
            this.shown = false;
            this.targetAlpha = 0.0f;
            this.targetAlpha2 = 0.0f;
            if (AbstractDungeon.overlayMenu != null) {
                AbstractDungeon.overlayMenu.cancelButton.show(TEXT[0]);
            }
        }
    }

    public void update() {
        if (this.shown) {
            this.updateYes();
            this.updateNo();
        }
        this.screenColor.a = MathHelper.fadeLerpSnap((float)this.screenColor.a, (float)this.targetAlpha);
        this.uiColor.a = MathHelper.fadeLerpSnap((float)this.uiColor.a, (float)this.targetAlpha2);
    }

    private void updateYes() {
        this.yesHb.update();
        if (this.yesHb.justHovered) {
            CardCrawlGame.sound.play("UI_HOVER");
        }
        if (InputHelper.justClickedLeft && this.yesHb.hovered) {
            CardCrawlGame.sound.play("UI_CLICK_1");
            this.yesHb.clickStarted = true;
        }
        if (this.yesHb.clicked) {
            this.yesHb.clicked = false;
            this.effect();
        }
    }

    private void effect() {
        switch (this.type) {
            case EXIT: {
                CardCrawlGame.music.dispose();
                this.hide();
                AbstractDungeon.closeCurrentScreen();
                CardCrawlGame.startOver();
                break;
            }
            case ABANDON: {
                this.hide();
                AbstractDungeon.closeCurrentScreen();
                AbstractDungeon.player.isDead = true;
                AbstractDungeon.deathScreen = new DeathScreen(AbstractDungeon.getMonsters());
                break;
            }
            case DELETE_SAVE: {
                this.hide();
                CardCrawlGame.sound.play("ATTACK_HEAVY", 0.2f);
                CardCrawlGame.sound.play("SLIME_ATTACK_2");
                break;
            }
            case SKIP_FTUE: {
                TipTracker.neverShowAgain((String)"NO_FTUE");
                this.hide();
            }
        }
    }

    private void updateNo() {
        this.noHb.update();
        if (this.noHb.justHovered) {
            CardCrawlGame.sound.play("UI_HOVER");
        }
        if (InputHelper.justClickedLeft && this.noHb.hovered) {
            CardCrawlGame.sound.play("UI_CLICK_1");
            this.noHb.clickStarted = true;
        }
        if (this.noHb.clicked) {
            this.noHb.clicked = false;
            if (this.type == ConfirmType.DELETE_SAVE) {
                CardCrawlGame.cancelButton.show(TEXT[1]);
            } else if (this.type == ConfirmType.SKIP_FTUE) {
                TipTracker.disableAllFtues();
            }
            this.hide();
        }
    }

    public void render(SpriteBatch sb) {
        sb.setColor(this.screenColor);
        sb.draw(ImageMaster.WHITE_SQUARE_IMG, 0.0f, 0.0f, (float)Settings.WIDTH, (float)Settings.HEIGHT);
        sb.setColor(this.uiColor);
        sb.draw(ImageMaster.OPTION_CONFIRM, (float)Settings.WIDTH / 2.0f - 180.0f, Settings.OPTION_Y - 207.0f, 180.0f, 207.0f, 360.0f, 414.0f, Settings.scale, Settings.scale, 0.0f, 0, 0, 360, 414, false, false);
        Color c = Settings.GOLD_COLOR.cpy();
        c.a = this.uiColor.a;
        FontHelper.renderFontCentered((SpriteBatch)sb, (BitmapFont)FontHelper.buttonLabelFont, (String)this.title, (float)((float)Settings.WIDTH / 2.0f), (float)(Settings.OPTION_Y + 126.0f * Settings.scale), (Color)c);
        sb.draw(ImageMaster.OPTION_YES, (float)Settings.WIDTH / 2.0f - 86.5f - 100.0f * Settings.scale, Settings.OPTION_Y - 37.0f - 120.0f * Settings.scale, 86.5f, 37.0f, 173.0f, 74.0f, Settings.scale, Settings.scale, 0.0f, 0, 0, 173, 74, false, false);
        if (this.yesHb.hovered) {
            sb.setColor(new Color(1.0f, 1.0f, 1.0f, this.uiColor.a * 0.25f));
            sb.setBlendFunction(770, 1);
            sb.draw(ImageMaster.OPTION_YES, (float)Settings.WIDTH / 2.0f - 86.5f - 100.0f * Settings.scale, Settings.OPTION_Y - 37.0f - 120.0f * Settings.scale, 86.5f, 37.0f, 173.0f, 74.0f, Settings.scale, Settings.scale, 0.0f, 0, 0, 173, 74, false, false);
            sb.setBlendFunction(770, 771);
            sb.setColor(this.uiColor);
            FontHelper.renderFontCentered((SpriteBatch)sb, (BitmapFont)FontHelper.cardTitleFont_N, (String)TEXT[2], (float)((float)Settings.WIDTH / 2.0f - 110.0f * Settings.scale), (float)(Settings.OPTION_Y - 118.0f * Settings.scale), (Color)this.uiColor, (float)1.0f);
        } else {
            FontHelper.renderFontCentered((SpriteBatch)sb, (BitmapFont)FontHelper.cardTitleFont_N, (String)TEXT[2], (float)((float)Settings.WIDTH / 2.0f - 110.0f * Settings.scale), (float)(Settings.OPTION_Y - 118.0f * Settings.scale), (Color)c, (float)1.0f);
        }
        sb.draw(ImageMaster.OPTION_NO, (float)Settings.WIDTH / 2.0f - 80.5f + 106.0f * Settings.scale, Settings.OPTION_Y - 37.0f - 120.0f * Settings.scale, 80.5f, 37.0f, 161.0f, 74.0f, Settings.scale, Settings.scale, 0.0f, 0, 0, 161, 74, false, false);
        if (this.noHb.hovered) {
            sb.setColor(new Color(1.0f, 1.0f, 1.0f, this.uiColor.a * 0.25f));
            sb.setBlendFunction(770, 1);
            sb.draw(ImageMaster.OPTION_NO, (float)Settings.WIDTH / 2.0f - 80.5f + 106.0f * Settings.scale, Settings.OPTION_Y - 37.0f - 120.0f * Settings.scale, 80.5f, 37.0f, 161.0f, 74.0f, Settings.scale, Settings.scale, 0.0f, 0, 0, 161, 74, false, false);
            sb.setBlendFunction(770, 771);
            sb.setColor(this.uiColor);
            FontHelper.renderFontCentered((SpriteBatch)sb, (BitmapFont)FontHelper.cardTitleFont_N, (String)TEXT[3], (float)((float)Settings.WIDTH / 2.0f + 110.0f * Settings.scale), (float)(Settings.OPTION_Y - 118.0f * Settings.scale), (Color)this.uiColor, (float)1.0f);
        } else {
            FontHelper.renderFontCentered((SpriteBatch)sb, (BitmapFont)FontHelper.cardTitleFont_N, (String)TEXT[3], (float)((float)Settings.WIDTH / 2.0f + 110.0f * Settings.scale), (float)(Settings.OPTION_Y - 118.0f * Settings.scale), (Color)c, (float)1.0f);
        }
        c = Settings.CREAM_COLOR.cpy();
        c.a = this.uiColor.a;
        FontHelper.renderWrappedText((SpriteBatch)sb, (BitmapFont)FontHelper.tipBodyFont, (String)this.desc, (float)((float)Settings.WIDTH / 2.0f), (float)(Settings.OPTION_Y + 20.0f * Settings.scale), (float)(240.0f * Settings.scale), (Color)c, (float)1.0f);
        this.yesHb.render(sb);
        this.noHb.render(sb);
    }

    public static enum ConfirmType {
        EXIT,
        ABANDON,
        DELETE_SAVE,
        SKIP_FTUE;

    }
}

