/*
 * Decompiled with CFR 0.152.
 */
package org.dakiler.slayhelper.relics;

import com.megacrit.cardcrawl.actions.AbstractGameAction;
import com.megacrit.cardcrawl.actions.common.RelicAboveCreatureAction;
import com.megacrit.cardcrawl.core.AbstractCreature;
import com.megacrit.cardcrawl.dungeons.AbstractDungeon;
import com.megacrit.cardcrawl.relics.AbstractRelic;

public class RuneSword
extends AbstractRelic {
    public static final String ID = "Rune Sword";
    public static final int MAX = 100;
    private final int INITIAL_MAX = 6;
    private final int INITIAL_REGEN = 2;
    private int max = 0;
    private int regen = 0;

    public RuneSword() {
        super(ID, "rune_sword.png", AbstractRelic.RelicTier.STARTER, AbstractRelic.LandingSound.HEAVY);
    }

    public String getUpdatedDescription() {
        return this.DESCRIPTIONS[0];
    }

    public void atBattleStart() {
        this.flash();
        this.max = 6;
        this.regen = 2;
        this.counter = 0;
    }

    public void atTurnStart() {
        this.plusRune(this.regen);
    }

    public void plusRune(int amount) {
        this.flash();
        AbstractDungeon.actionManager.addToTop((AbstractGameAction)new RelicAboveCreatureAction((AbstractCreature)AbstractDungeon.player, (AbstractRelic)this));
        this.counter += amount;
        if (this.counter > this.max) {
            this.counter = this.max;
        }
    }

    public void plusMax(int amount) {
        this.flash();
        this.max += amount;
    }

    public void useRune(int amount) {
        if (amount <= 0) {
            return;
        }
        if (amount > this.counter) {
            amount = this.counter;
        }
        this.flash();
        this.counter -= amount;
    }

    public AbstractRelic makeCopy() {
        return new RuneSword();
    }
}

