/*
 * Decompiled with CFR 0.152.
 */
package org.dakiler.slayhelper.tool;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;

public class RelicTextMergeTool {
    private static final String ENCODING = "UTF-8";

    public static void main(String[] args) throws Exception {
        File baseFolder = new File("localization");
        File[] subFolders = baseFolder.listFiles(new DirFilter());
        String insertText = RelicTextMergeTool.loadInsertText();
        if (insertText == null) {
            System.out.println("Abort Merge...");
            return;
        }
        System.out.println(insertText);
        System.out.println("==========");
        File[] fileArray = subFolders;
        int n = subFolders.length;
        int n2 = 0;
        while (n2 < n) {
            File subFolder = fileArray[n2];
            String folderName = subFolder.getName();
            if (!folderName.equals("zhs")) {
                File targetFile = new File(subFolder, "relics.json");
                System.out.println(targetFile.getAbsolutePath());
                String content = RelicTextMergeTool.load(targetFile);
                int index1 = content.indexOf("Anchor");
                int index2 = content.lastIndexOf("\n", index1);
                String leftContent = content.substring(index2 + 1);
                String totalContent = String.valueOf(insertText) + "\n" + leftContent;
                RelicTextMergeTool.save(targetFile, totalContent);
            }
            ++n2;
        }
    }

    private static String loadInsertText() throws Exception {
        String content = RelicTextMergeTool.load(new File("localization/zhs/relics.json"));
        int index1 = content.indexOf("Anchor");
        if (index1 < 0) {
            return null;
        }
        int index2 = content.lastIndexOf("\n", index1);
        if (index2 < 0) {
            return null;
        }
        return content.substring(0, index2);
    }

    public static String load(File file) throws Exception {
        FileInputStream fis = new FileInputStream(file);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buffer = new byte[2048];
        int number = -1;
        while ((number = fis.read(buffer)) >= 0) {
            baos.write(buffer, 0, number);
        }
        fis.close();
        return baos.toString(ENCODING);
    }

    public static void save(File file, String content) throws Exception {
        FileOutputStream fos = new FileOutputStream(file);
        fos.write(content.getBytes(ENCODING));
        fos.flush();
        fos.close();
    }

    private static class DirFilter
    implements FileFilter {
        private DirFilter() {
        }

        @Override
        public boolean accept(File file) {
            return file.isDirectory();
        }
    }
}

