
local MakePlayerCharacter = require "prefabs/player_common"


local assets = {
    Asset("SCRIPT", "scripts/prefabs/player_common.lua"),
	    Asset( "ANIM", "anim/kako.zip" ),
        Asset( "ANIM", "anim/ghost_kako_build.zip" ),
	Asset( "ANIM", "anim/maozi.zip"),
	
	Asset( "ANIM", "anim/black.zip"),
	Asset( "ANIM", "anim/swap_black.zip"),

}
local prefabs = {"maozi"}

-- Custom starting items
local start_inv = {
	    "maozi", 
		"black",
}

-- When the character is revived from human
local function onbecamehuman(inst)
	-- Set speed when reviving from ghost (optional)
	inst.components.locomotor:SetExternalSpeedMultiplier(inst, "kako_speed_mod", 1)
end

local function onbecameghost(inst)
	-- Remove speed modifier when becoming a ghost
   inst.components.locomotor:RemoveExternalSpeedMultiplier(inst, "kako_speed_mod")
end

-- When loading or spawning the character
local function onload(inst)
    inst:ListenForEvent("ms_respawnedfromghost", onbecamehuman)
    inst:ListenForEvent("ms_becameghost", onbecameghost)

    if inst:HasTag("playerghost") then
        onbecameghost(inst)
    else
        onbecamehuman(inst)
    end
end

local function WatchSeason(inst, season)
	if season == "winter" then
        inst.components.temperature.inherentinsulation = inst.components.temperature.inherentinsulation + 960 --Default is 0, increase for add resistance
	else
		inst.components.temperature.inherentinsulation = inst.components.temperature.inherentinsulation - 0 --Remove the bonus if not winter
    end
end

-- This initializes for both the server and client. Tags can be added here.
local common_postinit = function(inst) 
	-- Minimap icon
	inst.MiniMapEntity:SetIcon( "kako.tex" )
end

-- This initializes for the server only. Components are added here.
local master_postinit = function(inst)
	-- choose which sounds this character will play
	inst.soundsname = "kako"
	
	-- Uncomment if "wathgrithr"(Wigfrid) or "webber" voice is used
    --inst.talker_path_override = "dontstarve_DLC001/characters/"
	
	-- Stats	
	inst.components.health:SetMaxHealth(300)
	inst.components.hunger:SetMax(150)
	inst.components.sanity:SetMax(150)
	
	-- Movement Speed
	inst.components.locomotor.walkspeed = ( TUNING.WILSON_WALK_SPEED * 1.2 )
	inst.components.locomotor.runspeed = ( TUNING.WILSON_RUN_SPEED * 1.4 )
	
	-- Damage multiplier (optional)
    inst.components.combat.damagemultiplier = 1
	
	-- Hunger rate (optional)
	inst.components.hunger.hungerrate = 1.4 * TUNING.WILSON_HUNGER_RATE
	
	-- Sanity loss rate (day, dusk, night)
	inst.components.sanity.night_drain_mult = -1
	inst.components.sanity.dapperness = -TUNING.DAPPERNESS_SMALL
	
	inst.OnLoad = onload
    inst.OnNewSpawn = onload
	
	-- Animals dont need to cook
	inst.components.eater:SetCanEatRaw()
	
	-- Floof shall keep thee warm
	inst:WatchWorldState("season", WatchSeason )
end

return MakePlayerCharacter("kako", prefabs, assets, common_postinit, master_postinit, start_inv)
