require "prefabutil"
require "scheduler"
require "simutil"
require "behaviours/doaction"

local assets =
{
	Asset("ANIM", "anim/VacuumChest.zip"),
	Asset("ATLAS", "images/inventoryimages/vacuum_chest.xml"),
	Asset("IMAGE", "images/inventoryimages/vacuum_chest.tex")

}


local function onopen(inst) 
	inst.AnimState:PlayAnimation("open") 
	inst.SoundEmitter:PlaySound("dontstarve/wilson/chest_open")		
end 

local function onclose(inst) 
	inst.AnimState:PlayAnimation("close") 
	inst.SoundEmitter:PlaySound("dontstarve/wilson/chest_close")		
end 

local function onhammered(inst, worker)
	inst.components.lootdropper:DropLoot()
	inst.components.container:DropEverything()
	SpawnPrefab("collapse_small").Transform:SetPosition(inst.Transform:GetWorldPosition())
	inst.SoundEmitter:PlaySound("dontstarve/common/destroy_wood")
	
	inst:Remove()
end

local function onhit(inst, worker)
	inst.AnimState:PlayAnimation("hit")
	inst.components.container:DropEverything()
	inst.AnimState:PushAnimation("closed", false)
	inst.components.container:Close()
end


local function onbuilt(inst)
	inst.AnimState:PlayAnimation("place")
	inst.AnimState:PushAnimation("closed", false)
end



local slotpos = {}

for y = 2, 0, -1 do
	for x = 0, 2 do
		table.insert(slotpos, Vector3(80*x-80*2+80, 80*y-80*2+80,0))
	end
end

local function fn(Sim)
	-- body
	local inst = CreateEntity()

	inst:AddTag("structure")

	inst.entity:AddTransform()
	inst.entity:AddAnimState()
	inst.entity:AddSoundEmitter()

	local minimap = inst.entity:AddMiniMapEntity()
	minimap:SetIcon("vacuum_chest.tex")

	inst.AnimState:SetBank("chest")
	inst.AnimState:SetBuild("VacuumChest")
	inst.AnimState:PlayAnimation("closed")

	inst:AddComponent("inspectable")
	inst:AddComponent("container")
	inst.components.container:SetNumSlots(#slotpos)

	inst.components.container.onopenfn = onopen
	inst.components.container.onclosefn = onclose
		
	inst.components.container.widgetslotpos = slotpos
	inst.components.container.widgetanimbank = "ui_chest_3x3"
	inst.components.container.widgetanimbuild = "ui_chest_3x3"
	inst.components.container.widgetpos = Vector3(0,200,0)
	inst.components.container.side_align_tip = 160

	inst:AddComponent("lootdropper")
	inst:AddComponent("workable")
	inst.components.workable:SetWorkAction(ACTIONS.HAMMER)
	inst.components.workable:SetWorkLeft(2)
	inst.components.workable:SetOnFinishCallback(onhammered)
	inst.components.workable:SetOnWorkCallback(onhit) 
		
	inst:ListenForEvent( "onbuilt", onbuilt)
	MakeSnowCovered(inst, .01)	

	local function suckit(item)   --吸取
		inst.AnimState:PlayAnimation("hit")
		inst.SoundEmitter:PlaySound("dontstarve/wilson/chest_open")
		inst.components.container:GiveItem(item)
	end


	local function vacuum(inst)
		local x,y,z = inst.Transform:GetWorldPosition()
		local SEARCH_RADIUS = TUNING.SEARCH_RADIUS--搜索半径

		local item = FindEntity(inst, SEARCH_RADIUS, function(item) 
			local check = item.components.inventoryitem and item.components.inventoryitem.canbepickedup and item.components.inventoryitem.cangoincontainer
			return check
			end)

		if item then
			if not inst.components.container:IsFull() then
			-- container is not full, it can pick up the item
				suckit(item)
			return

			elseif item.components.stackable then
			-- if the inventory is full, but the item stacks, and exists in the container, and the stack is not full
			local stack = inst.components.container:FindItem(function(i) return (i.prefab == item.prefab and not i.components.stackable:IsFull()) end)
			
				if stack then
					suckit(item)
					return
				end
			end
		end
	end

	inst:DoPeriodicTask(0.5, vacuum)


	return inst
end

return Prefab( "common/vacuum_chest", fn, assets), 
		MakePlacer("common/vacuum_chest_placer", "chest", "VacuumChest", "closed")
