

local require = GLOBAL.require
require "prefabutil"
local cooking = require "cooking"
local PredictedProducts
local DisplayIndexForRecipes
Assets = {
	Asset("ATLAS", "images/ui_cookpot_1x5.xml")

}
--most of the cooking.lua functions are local.
--inorder to avoid overriding the file therfore 
--probably conflict any possible cooking mod which may do the same
--those functions will be computed here when predicting
local aliases=
{
	cookedsmallmeat = "smallmeat_cooked",
	cookedmonstermeat = "monstermeat_cooked",
	cookedmeat = "meat_cooked"
}

local null_ingredient = {tags={}}
local function GetIngredientData(prefabname)
	local name = aliases.prefabname or prefabname

	return cooking.ingredients[name] or null_ingredient
end


local function GetIngredientValues(prefablist)
	local prefabs = {}
	local tags = {}
	for k,v in pairs(prefablist) do
		local name = aliases[v] or v
		prefabs[name] = prefabs[name] and prefabs[name] + 1 or 1
		local data = GetIngredientData(name)

		if data then

			for kk, vv in pairs(data.tags) do

				tags[kk] = tags[kk] and tags[kk] + vv or vv
			end
		end
	end

	return {tags = tags, names = prefabs}
end


local function GetCandidateRecipes(cooker, ingdata)
	
	local recipes = cooking.recipes["cookpot"] or {}
	local candidates = {}

	--find all potentially valid recipes
	for k,v in pairs(recipes) do
		if v.test(cooker, ingdata.names, ingdata.tags) then
			table.insert(candidates, v)
		end
	end
	table.sort( candidates, function(a,b) return (a.priority or 0) > (b.priority or 0) end )
	if #candidates > 0 then
		--find the set of highest priority recipes
		local top_candidates = {}
		local idx = 1
		local val = candidates[1].priority or 0

		for k,v in ipairs(candidates) do
			if k > 1 and (v.priority or 0) < val then
				break
			end
			table.insert(top_candidates, v)
		end
		return top_candidates
	end

	return candidates
end

--original mod functions start here
function PredictRecipes(cooker,names)		
	local ingdata = GetIngredientValues(names)
	local candidates = GetCandidateRecipes(cooker, ingdata)
	table.sort( candidates, function(a,b) return (a.weight or 1) > (b.weight or 1) end )
	return candidates
end

local function PredictMany(prefab)
	local ings = {}	
	for k,v in pairs (prefab.components.container.slots) do
		table.insert(ings, v.prefab)
	end
	local results=PredictRecipes(prefab,ings)
	return results
end			


local function getWeightPercent(Recipes, index)
	local total=0
	for k,v in pairs(Recipes) do
		total = total + (v.weight or 1)
	end
	local fraction=(Recipes[index].weight or 1)/total
	local Perc=fraction*100
	return Perc
end

function getSpoilage(prefab)
	local spoilage_total = 0
	local spoilage_n = 0
	for k,v in pairs (prefab.components.container.slots) do
		if  v.components and v.components.perishable then
		spoilage_n = spoilage_n + 1
		spoilage_total = spoilage_total + v.components.perishable:GetPercent()
		end
	end	
	local spoilage = 1
	if spoilage_total > 0 then
		spoilage = spoilage_total / spoilage_n
		spoilage = 1 - (1 - spoilage)*.5
	end
	return spoilage
end

local function button2click(prefab)
	PredictedProducts=PredictMany(prefab)
	if DisplayIndexForRecipes and PredictedProducts[DisplayIndexForRecipes+1] then
		DisplayIndexForRecipes=DisplayIndexForRecipes+1
	else 
		DisplayIndexForRecipes=1
	end 
	
	local loot=GLOBAL.SpawnPrefab(PredictedProducts[DisplayIndexForRecipes].name)
	if loot and loot.components.perishable then
		loot.components.perishable:SetPercent(getSpoilage(prefab))
	end	
		--local chance=getWeightPercent(PredictedProducts,DisplayIndexForRecipes)
		--loot.components.stackable:SetStackSize(chance.."%")
		loot.components.inventoryitem:OnPutInInventory(prefab)
		prefab:PushEvent("prediction", {item = loot})	
end

local function SmarterCookpotInit(prefab)
	
 slotpos = {}
	for y = 0, 3 do		
	table.insert(slotpos, GLOBAL.Vector3(-55, -y*75 + 180+256 ,0)) 
	end
utilslotpos = {}	
	table.insert(utilslotpos, GLOBAL.Vector3(-55, 136 ,0)) 
	
	prefab.components.container.widgetslotpos = slotpos
    	prefab.components.container.widgetutilslotpos=utilslotpos
	
	local widgetbuttoninfo = {
	text = "Cook",
	position = GLOBAL.Vector3(-55, -235+256, 0),
	fn = function(prefab)
		prefab.components.stewer:StartCooking()	
	end,
	
	validfn = function(prefab)
		return prefab.components.stewer:CanCook()
	end,
}
local widgetbuttoninfo2 = {
	text = "Predict!",
	position = GLOBAL.Vector3(-55, -180+256, 0),
	fn = function(prefab)
		button2click(prefab)
	end,
	
	validfn = function(prefab)
		return prefab.components.stewer:CanCook()
	end,
} 
    prefab.components.container.widgetbgatlas = "images/ui_cookpot_1x5.xml"
    prefab.components.container.widgetbgimage = "ui_cookpot_1x5.tex"
    prefab.components.container.widgetbuttoninfo = widgetbuttoninfo
    prefab.components.container.widgetbuttoninfo2 = widgetbuttoninfo2
end


AddPrefabPostInit("cookpot", SmarterCookpotInit)

