require "class"
local InvSlot = require "widgets/invslot"
local UtilSlot = require "widgets/utilslot"--mod
local Widget = require "widgets/widget"
local Text = require "widgets/text"
local UIAnim = require "widgets/uianim"
local ImageButton = require "widgets/imagebutton"
local ItemTile = require "widgets/itemtile"

local DOUBLECLICKTIME = .33

local ContainerWidget = Class(Widget, function(self, owner)
    Widget._ctor(self, "Container")
    local scale = .6
    self:SetScale(scale,scale,scale)
    self.open = false
    self.inv = {}
    self.utilslots={}
    self.owner = owner
    self:SetPosition(0, 0, 0)
    self.slotsperrow = 3
   
    self.bganim = self:AddChild(UIAnim())
	self.bgimage = self:AddChild(Image())
    self.isopen = false
end)

function ContainerWidget:Open(container, doer)
    self:Close()
	self:StartUpdating()
	
	if container.components.container.widgetbgatlas and container.components.container.widgetbgimage then
		self.bgimage:SetTexture( container.components.container.widgetbgatlas, container.components.container.widgetbgimage )
	end
    
    if container.components.container.widgetanimbank then
		self.bganim:GetAnimState():SetBank(container.components.container.widgetanimbank)
	end
    
    if container.components.container.widgetanimbuild then
		self.bganim:GetAnimState():SetBuild(container.components.container.widgetanimbuild)
    end
    
    
    if container.components.container.widgetpos then
		local pos =(TheInput:ControllerAttached() and container.components.container.widgetpos_controller) and container.components.container.widgetpos_controller or container.components.container.widgetpos
		self:SetPosition(pos)
	end
	
	if container.components.container.widgetbuttoninfo and not TheInput:ControllerAttached() then
		self.button = self:AddChild(ImageButton("images/ui.xml", "button_small.tex", "button_small_over.tex", "button_small_disabled.tex"))
	    self.button:SetPosition(container.components.container.widgetbuttoninfo.position)
	    self.button:SetText(container.components.container.widgetbuttoninfo.text)
	    self.button:SetOnClick( function() container.components.container.widgetbuttoninfo.fn(container, doer) end )
	    self.button:SetFont(BUTTONFONT)
	    self.button:SetTextSize(35)
	    self.button.text:SetVAlign(ANCHOR_MIDDLE)
	    self.button.text:SetColour(0,0,0,1)
	    
		if container.components.container.widgetbuttoninfo.validfn then
			if container.components.container.widgetbuttoninfo.validfn(container, doer) then
				self.button:Enable()
			else
				self.button:Disable()
			end
		end
	end
	
	if container.components.container.widgetbuttoninfo2 and not TheInput:ControllerAttached() then
		self.button2 = self:AddChild(ImageButton("images/ui.xml", "button_small.tex", "button_small_over.tex", "button_small_disabled.tex"))
	    self.button2:SetPosition(container.components.container.widgetbuttoninfo2.position)
	    self.button2:SetText(container.components.container.widgetbuttoninfo2.text)
	    self.button2:SetOnClick( function() container.components.container.widgetbuttoninfo2.fn(container, doer) end )
	    self.button2:SetFont(BUTTONFONT)
	    self.button2:SetTextSize(35)
	    self.button2.text:SetVAlign(ANCHOR_MIDDLE)
	    self.button2.text:SetColour(0,0,0,1)
	    
		if container.components.container.widgetbuttoninfo2.validfn then
			if container.components.container.widgetbuttoninfo2.validfn(container, doer) then
				self.button2:Enable()
			else
				self.button2:Disable()
			end
		end
	end
    self.isopen = true
    self:Show()
    
	if self.bgimage.texture then
		self.bgimage:Show()
	else
		self.bganim:GetAnimState():PlayAnimation("open")
	end
	    
    self.onitemlosefn = function(inst, data) self:OnItemLose(data) end
    self.inst:ListenForEvent("itemlose", self.onitemlosefn, container)

    self.onitemgetfn = function(inst, data) self:OnItemGet(data) end
    self.inst:ListenForEvent("itemget", self.onitemgetfn, container)
    --mod
    self.onpredictionfn = function(inst, data) self:OnPrediction(data) end
    self.inst:ListenForEvent("prediction", self.onpredictionfn, container)
		
    
	local num_slots = math.min( container.components.container:GetNumSlots(), #container.components.container.widgetslotpos)
	
	local n = 1
	for k,v in ipairs(container.components.container.widgetslotpos) do
	
		local slot = InvSlot(n,"images/hud.xml", "inv_slot.tex", self.owner, container.components.container)
		self.inv[n] = self:AddChild(slot)

		slot:SetPosition(v)

		if not container.components.container.side_widget and container.components.container.side_align_tip then
			slot.side_align_tip = container.components.container.side_align_tip - v.x
		end
		
		local obj = container.components.container:GetItemInSlot(n)
		if obj then
			local tile = ItemTile(obj)
			slot:SetTile(tile)
		end
		
		n = n + 1
	end
    self.container = container
    
end    

function ContainerWidget:OnItemGet(data)
    	if data.slot and self.inv[data.slot] then
		local tile = ItemTile(data.item)
        self.inv[data.slot]:SetTile(tile)
        tile:Hide()

        if data.src_pos then	
			local dest_pos = self.inv[data.slot]:GetWorldPosition()
			local inventoryitem = data.item.components.inventoryitem
			local im = Image(inventoryitem:GetAtlas(), inventoryitem:GetImage())
			im:MoveTo(data.src_pos, dest_pos, .3, function() tile:Show() im:Kill() end)
        else
			
			tile:Show() 
			--tile:ScaleTo(2, 1, .25)
        end
	end
	
	if self.button and self.container and self.container.components.container.widgetbuttoninfo and self.container.components.container.widgetbuttoninfo.validfn then
		if self.container.components.container.widgetbuttoninfo.validfn(self.container) then
			self.button:Enable()
		else
			self.button:Disable()
		end
	end
	if self.button2 and self.container and self.container.components.container.widgetbuttoninfo2 and self.container.components.container.widgetbuttoninfo2.validfn then
		if self.container.components.container.widgetbuttoninfo2.validfn(self.container) then
			self.button2:Enable()
		else
			self.button2:Disable()
		end
	end
end



function ContainerWidget:OnPrediction(data)--mod
	if self.owner and self.container and self.container.components and self.container.components.container then
		--delete the current util slot to avoid stacking
		if self.utilslots[1] then
			self:RemoveChild(self.utilslots[1])
		end
		self.utilslots={}
		--create slot
		local slot = UtilSlot(1,"images/hud.xml", "inv_slot.tex", self.owner, self.container.components.container)
		local tile = ItemTile(data.item)
		--place item in slot
		slot:SetTile(tile)
		--add slot to the crock pot for users to see
		self:AddChild(slot)
		--remember slots for later deleting or more sophisticated unimplemented use
		table.insert(self.utilslots,slot)
		--give location
		slot:SetPosition(self.container.components.container.widgetutilslotpos[1])

		if not self.container.components.container.side_widget and self.container.components.container.side_align_tip then
			slot.side_align_tip = self.container.components.container.side_align_tip - self.container.components.container.widgetutilslotpos[1].x
		end
	end
		
end

function ContainerWidget:OnUpdate(dt)
	if self.isopen and self.owner and self.container then
		
		if not (self.container.components.inventoryitem and self.container.components.inventoryitem:IsHeldBy(self.owner)) then
			local distsq = self.owner:GetDistanceSqToInst(self.container)
			if distsq > 3*3 then
				self:Close()
			end
		end
	end
	
	--return self.should_close_widget ~= true
end

function ContainerWidget:OnItemLose(data)--mod
	local tileslot = self.inv[data.slot]
	if tileslot then
		tileslot:SetTile(nil)
	end
	--remove utility slots, as they are now irrelevent
	for k,v in pairs(self.utilslots) do
			self:RemoveChild(v)
			v:Kill()
		end
	    	self.utilslots={}
	
	if self.container and self.button and self.container.components.container.widgetbuttoninfo and self.container.components.container.widgetbuttoninfo.validfn then
		if self.container.components.container.widgetbuttoninfo.validfn(self.container) then
			self.button:Enable()
		else
			self.button:Disable()
		end
	end
	if self.button2 and self.container and self.container.components.container.widgetbuttoninfo2 and self.container.components.container.widgetbuttoninfo2.validfn then
		if self.container.components.container.widgetbuttoninfo2.validfn(self.container) then
			self.button2:Enable()
		else
			self.button2:Disable()
		end
	end
	
end


function ContainerWidget:Close()
    if self.isopen then
		self:StopUpdating()

		if self.button then
			self.button:Kill()
			self.button = nil
		end
		if self.button2 then
			self.button2:Kill()
			self.button2 = nil
		end
		if self.container then
			self.container.components.container:Close()
			--self.inst:RemoveAllEventCallbacks()
			if self.onitemlosefn then
				self.inst:RemoveEventCallback("itemlose", self.onitemlosefn, self.container)
				self.onitemlosefn = nil
			end
			if self.onitemgetfn then
				self.inst:RemoveEventCallback("itemget", self.onitemgetfn, self.container)
				self.onitemgetfn = nil
			end
		end
		
	    
		for k,v in pairs(self.inv) do
			self:RemoveChild(v)
			v:Kill()
		end
		--mod
		for k,v in pairs(self.utilslots) do
			self:RemoveChild(v)
			v:Kill()
		end
	    	self.utilslots={}
		--end mod
		self.container = nil
		self.inv = {}
		if self.bgimage.texture then
			self.bgimage:Hide()
		else
			self.bganim:GetAnimState():PlayAnimation("close")
		end
		
		self.isopen = false
		
	    self.inst:DoTaskInTime(.3, function()self.should_close_widget = true  end)
		
	end
    --self:Hide()

end

return ContainerWidget
