--
-- SteeringAnimationNodes
-- Implements steeringAnimationNodes from fs13 Vehicle class
--
-- @author  Stefan Geiger
-- @date  08/04/07
--
-- Copyright (C) GIANTS Software GmbH, Confidential, All Rights Reserved.

SteeringAnimationNodes = {};

function SteeringAnimationNodes.prerequisitesPresent(specializations)
    return true;
end

function SteeringAnimationNodes:load(savegame)
    self.isSelectable = true;
	self.steeringAnimationNodes = {};
	self.steeringAnimationTime = 0;
	local i=0;
	while true do
		local baseName = string.format("vehicle.steeringAnimationNodes.animationNode(%d)", i);
		if not hasXMLProperty(self.xmlFile, baseName) then
			break;
		end;
		local animationNode = {};
		local wheelIndex = getXMLInt(self.xmlFile, baseName.."#wheelIndex");
		animationNode.wheel = self.wheels[wheelIndex+1];
		animationNode.wheelMinRot = animationNode.wheel.rotMin;
		animationNode.wheelMaxRot = animationNode.wheel.rotMax;
		if animationNode.wheel.rotMin == 0 then
			animationNode.wheelMinRot = animationNode.wheel.steeringAxleRotMin;
			animationNode.wheelMaxRot = animationNode.wheel.steeringAxleRotMax;
		end;
		animationNode.node = Utils.indexToObject(self.components, getXMLString(self.xmlFile, baseName.."#index"));
		animationNode.minXRot = math.rad(Utils.getNoNil(getXMLFloat(self.xmlFile, baseName.."#minXRot"), 0));
		animationNode.maxXRot = math.rad(Utils.getNoNil(getXMLFloat(self.xmlFile, baseName.."#maxXRot"), 0));
	
		table.insert(self.steeringAnimationNodes, animationNode);
		i = i + 1;
	end;
end

function SteeringAnimationNodes:delete()
end

function SteeringAnimationNodes:mouseEvent(posX, posY, isDown, isUp, button)
end

function SteeringAnimationNodes:keyEvent(unicode, sym, modifier, isDown)
end

function SteeringAnimationNodes:update(dt)
	if self.isActive then
		self.steeringAnimationTime = self.time + 2000;
	end;

	if self.steeringAnimationTime > self.time then
		for _,animationNode in pairs(self.steeringAnimationNodes) do
			local rotation = animationNode.wheelMaxRot;
			local animRotation = animationNode.maxXRot;
			if animationNode.wheel.steeringAngle <= 0 then
				rotation = animationNode.wheelMinRot;
				animRotation = animationNode.minXRot;
			end;
			local percent = 0;
			if rotation ~= 0 then
				percent = math.abs(animationNode.wheel.steeringAngle / rotation);
			end;
	
			setRotation(animationNode.node, 0, animRotation * percent, 0);
		end;
		for i, part in ipairs(self.movingParts) do
			Cylindered.updateMovingPart(self, part, false);		
		end;
	end;
end

function SteeringAnimationNodes:updateTick(dt)
end

function SteeringAnimationNodes:draw()
end