local require = GLOBAL.require
local SpawnPrefab = GLOBAL.SpawnPrefab

local RECIPETABS = GLOBAL.RECIPETABS
local Recipe = GLOBAL.Recipe
local Ingredient = GLOBAL.Ingredient
local ACTIONS = GLOBAL.ACTIONS
TECH = GLOBAL.TECH









PrefabFiles = {

	"webbert",
        "cavespidershell",
        "guardiancrest",
        "balltracker",
        "spiderball",
        "redball",
        "blueball",
        "greenball",
        "purpleball",
        "mightyball",
        "trickball",
        "buckyball",
        "eggslayer",
        "redcap",
        "greencap",
        "bluecap",
}

Assets = {
    Asset( "IMAGE", "images/saveslot_portraits/webbert.tex" ),
    Asset( "IMAGE", "images/selectscreen_portraits/webbert.tex" ),
    Asset( "IMAGE", "images/selectscreen_portraits/webbert_silho.tex" ),
    Asset( "IMAGE", "bigportraits/webbert.tex" ),

Asset("ANIM", "anim/cavespidershell.zip"),
Asset("IMAGE", "images/inventoryimages/cavespidershell.tex"),
Asset("ATLAS", "images/inventoryimages/cavespidershell.xml"),


Asset("ANIM", "anim/guardiancrest.zip"),
Asset("IMAGE", "images/inventoryimages/guardiancrest.tex"),
Asset("ATLAS", "images/inventoryimages/guardiancrest.xml"),


Asset("ANIM", "anim/balltracker.zip"),
Asset("ANIM", "anim/swap_balltracker.zip"),
Asset("IMAGE", "images/inventoryimages/balltracker.tex"),
Asset("ATLAS", "images/inventoryimages/balltracker.xml"),
	

Asset("ANIM", "anim/spiderball.zip"),
Asset("IMAGE", "images/inventoryimages/spiderball.tex"),
Asset("ATLAS", "images/inventoryimages/spiderball.xml"),


Asset("ANIM", "anim/redball.zip"),
Asset("IMAGE", "images/inventoryimages/redball.tex"),
Asset("ATLAS", "images/inventoryimages/redball.xml"),


Asset("ANIM", "anim/blueball.zip"),
Asset("IMAGE", "images/inventoryimages/blueball.tex"),
Asset("ATLAS", "images/inventoryimages/blueball.xml"),


Asset("ANIM", "anim/greenball.zip"),
Asset("IMAGE", "images/inventoryimages/greenball.tex"),
Asset("ATLAS", "images/inventoryimages/greenball.xml"),


Asset("ANIM", "anim/purpleball.zip"),
Asset("IMAGE", "images/inventoryimages/purpleball.tex"),
Asset("ATLAS", "images/inventoryimages/purpleball.xml"),


Asset("ANIM", "anim/mightyball.zip"),
Asset("IMAGE", "images/inventoryimages/mightyball.tex"),
Asset("ATLAS", "images/inventoryimages/mightyball.xml"),


Asset("ANIM", "anim/trickball.zip"),
Asset("IMAGE", "images/inventoryimages/trickball.tex"),
Asset("ATLAS", "images/inventoryimages/trickball.xml"),




Asset("ANIM", "anim/buckyball.zip"),
Asset("IMAGE", "images/inventoryimages/buckyball.tex"),
Asset("ATLAS", "images/inventoryimages/buckyball.xml"),



Asset("ANIM", "anim/eggslayer.zip"),
Asset("ANIM", "anim/swap_eggslayer.zip"),
Asset("IMAGE", "images/inventoryimages/eggslayer.tex"),
Asset("ATLAS", "images/inventoryimages/eggslayer.xml"),






Asset("ANIM", "anim/redcap.zip"),
Asset("IMAGE", "images/inventoryimages/redcap.tex"),
Asset("ATLAS", "images/inventoryimages/redcap.xml"),


Asset("ANIM", "anim/greencap.zip"),
Asset("IMAGE", "images/inventoryimages/greencap.tex"),
Asset("ATLAS", "images/inventoryimages/greencap.xml"),


Asset("ANIM", "anim/bluecap.zip"),
Asset("IMAGE", "images/inventoryimages/bluecap.tex"),
Asset("ATLAS", "images/inventoryimages/bluecap.xml"),








	Asset( "ATLAS", "images/saveslot_portraits/webbert.xml" ),
    Asset( "ATLAS", "images/selectscreen_portraits/webbert.xml" ),
    Asset( "ATLAS", "images/selectscreen_portraits/webbert_silho.xml" ),
    Asset( "ATLAS", "bigportraits/webbert.xml" ),

Asset( "IMAGE", "minimap/webbert.tex" ),
    Asset( "ATLAS", "minimap/webbert.xml" ),
}















local STRINGS = GLOBAL.STRINGS

STRINGS.NAMES.CAVESPIDERSHELL = "Cave Spider Shell"
STRINGS.RECIPE_DESC.CAVESPIDERSHELL = "Hard to crash."
STRINGS.CHARACTERS.GENERIC.DESCRIBE.CAVESPIDERSHELL = "Webber will envy me."

STRINGS.NAMES.GUARDIANCREST = "Crest of Guardian"
STRINGS.RECIPE_DESC.GUARDIANCREST = "Feel the power of army!"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.GUARDIANCREST = "Feel the power of gurdian!"

STRINGS.NAMES.BALLTRACKER = "Ball Tracker"
STRINGS.RECIPE_DESC.BALLTRACKER = "Better not to eat trick balls."
STRINGS.CHARACTERS.GENERIC.DESCRIBE.BALLTRACKER = "I got you!"

STRINGS.NAMES.SPIDERBALL = "Ball"
STRINGS.RECIPE_DESC.SPIDERBALL = "Chewable little thing!"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.SPIDERBALL = "Chew chew."

STRINGS.NAMES.REDBALL = "Red Ball"
STRINGS.RECIPE_DESC.REDBALL = "Warming up during extreme cold weather."
STRINGS.CHARACTERS.GENERIC.DESCRIBE.REDBALL = "So hot! Sooo sweat!"

STRINGS.NAMES.BLUEBALL = "Blue Ball"
STRINGS.RECIPE_DESC.BLUEBALL = "Be a cool spider!"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.BLUEBALL = "Pretty cool, huh?"

STRINGS.NAMES.GREENBALL = "Green Ball"
STRINGS.RECIPE_DESC.GREENBALL = "Wake up Mr!"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.GREENBALL = "I do not want to eat that."

STRINGS.NAMES.PURPLEBALL = "Purple Ball"
STRINGS.RECIPE_DESC.PURPLEBALL = "Take this sanity aura."
STRINGS.CHARACTERS.GENERIC.DESCRIBE.PURPLEBALL = "Oh, my brain is awakening."

STRINGS.NAMES.MIGHTYBALL = "Mighty Super Ball"
STRINGS.RECIPE_DESC.MIGHTYBALL = "Beyond compare."
STRINGS.CHARACTERS.GENERIC.DESCRIBE.MIGHTYBALL = "Who made this? It's me!"

STRINGS.NAMES.TRICKBALL = "Ball"
STRINGS.RECIPE_DESC.TRICKBALL = "Deadly magic tricks!"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.TRICKBALL = "Chew chew."


STRINGS.NAMES.BUCKYBALL = "Bucky Ball"
STRINGS.RECIPE_DESC.BUCKYBALL = "Contain your excitement!"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.BUCKYBALL = "Who is Buckminster Fuller?"


STRINGS.NAMES.EGGSLAYER = "Spidey Slayer"
STRINGS.RECIPE_DESC.EGGSLAYER = "Reinforcement!"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.EGGSLAYER = "Help me warriors!"


STRINGS.NAMES.ORANGEGEM = "Orange Gem"
STRINGS.RECIPE_DESC.ORANGEGEM = "A gem for the lazy."


STRINGS.NAMES.GREENGEM = "Green Gem"
STRINGS.RECIPE_DESC.GREENGEM = "It's feel like to build something."


STRINGS.NAMES.YELLOWGEM = "Yellow Gem"
STRINGS.RECIPE_DESC.YELLOWGEM = "The mighty color came from the sun."


STRINGS.NAMES.MINOTAURHORN = "Guardian's Horn"
STRINGS.RECIPE_DESC.MINOTAURHORN = "It's a real! Not a fake!"





STRINGS.NAMES.REDCAP = "Red Spores"
STRINGS.RECIPE_DESC.REDCAP = "Extremely dangerous spores."
STRINGS.CHARACTERS.GENERIC.DESCRIBE.REDCAP = "I don't want to eat these mushrooms."

STRINGS.NAMES.GREENCAP = "Green Spores"
STRINGS.RECIPE_DESC.GREENCAP = "Not always make a problem."
STRINGS.CHARACTERS.GENERIC.DESCRIBE.GREENCAP = "Is this a log?"

STRINGS.NAMES.BLUECAP = "Blue Spores"
STRINGS.RECIPE_DESC.BLUECAP = "The mushroom of the night."
STRINGS.CHARACTERS.GENERIC.DESCRIBE.BLUECAP = "Grow grow little mushroom."










STRINGS.CHARACTERS.WEBBERT =require "speech_webbert"




















function silkman(webbert)


	

        local cavespidershell = GLOBAL.Recipe( "cavespidershell", {webweb, Ingredient("rocks", 5),Ingredient("spidergland", 3), Ingredient("ash", 2) }, RECIPETABS.WAR, {SCIENCE=0})
	cavespidershell.atlas = "images/inventoryimages/cavespidershell.xml"

        local balltracker = GLOBAL.Recipe( "balltracker", {webweb, Ingredient("twigs", 1), Ingredient("nightmarefuel", 1), Ingredient("silk", 3) }, RECIPETABS.MAGIC, {MAGIC=1})
	balltracker.atlas = "images/inventoryimages/balltracker.xml"

        local spiderball = GLOBAL.Recipe( "spiderball", {webweb, Ingredient("silk", 1) }, RECIPETABS.LIGHT, {SCIENCE=0})
	spiderball.atlas = "images/inventoryimages/spiderball.xml"

        local redball = GLOBAL.Recipe( "redball", {webweb, Ingredient("silk", 1), Ingredient("redgem", 1) }, RECIPETABS.LIGHT, {SCIENCE=0})
	redball.atlas = "images/inventoryimages/redball.xml"

        local blueball = GLOBAL.Recipe( "blueball", {webweb, Ingredient("silk", 1), Ingredient("bluegem", 1) }, RECIPETABS.LIGHT, {SCIENCE=0})
	blueball.atlas = "images/inventoryimages/blueball.xml"

        local greenball = GLOBAL.Recipe( "greenball", {webweb, Ingredient("silk", 1), Ingredient("green_cap_cooked", 1) }, RECIPETABS.LIGHT, {SCIENCE=0})
	greenball.atlas = "images/inventoryimages/greenball.xml"

        local purpleball = GLOBAL.Recipe( "purpleball", {webweb, Ingredient("silk", 1), Ingredient("purplegem", 1) }, RECIPETABS.LIGHT, {SCIENCE=0})
	purpleball.atlas = "images/inventoryimages/purpleball.xml"

        local mightyball = GLOBAL.Recipe( "mightyball", {webweb, Ingredient("silk", 1), Ingredient("yellowgem", 1), Ingredient("minotaurhorn", 1) }, RECIPETABS.LIGHT, {SCIENCE=0})
	mightyball.atlas = "images/inventoryimages/mightyball.xml"

        local trickball = GLOBAL.Recipe( "trickball", {webweb, Ingredient("silk", 1), Ingredient("red_cap", 1) }, RECIPETABS.LIGHT, {SCIENCE=0})
	trickball.atlas = "images/inventoryimages/trickball.xml"



        local buckyball = GLOBAL.Recipe( "buckyball", {webweb, Ingredient("silk", 1), Ingredient("charcoal", 1), Ingredient("nightmarefuel", 1) }, RECIPETABS.LIGHT, {MAGIC=1})
	buckyball.atlas = "images/inventoryimages/buckyball.xml"

        local eggslayer = GLOBAL.Recipe( "eggslayer", {webweb, Ingredient("spidereggsack", 1), Ingredient("flint", 1), Ingredient("monstermeat", 1) }, RECIPETABS.WAR, {SCIENCE=0})
	eggslayer.atlas = "images/inventoryimages/eggslayer.xml"










        local orangegem = GLOBAL.Recipe( "orangegem", {webweb, Ingredient("purplegem", 1), Ingredient("redgem", 1) }, RECIPETABS.REFINE, {MAGIC=1})

        local greengem = GLOBAL.Recipe( "greengem", {webweb, Ingredient("purplegem", 1), Ingredient("bluegem", 1) }, RECIPETABS.REFINE, {MAGIC=1})

        local yellowgem = GLOBAL.Recipe( "yellowgem", {webweb, Ingredient("orangegem", 1), Ingredient("greengem", 1) }, RECIPETABS.REFINE, {MAGIC=1})

        local minotaurhorn = GLOBAL.Recipe( "minotaurhorn", {webweb, Ingredient("horn", 1), Ingredient("cookedmonstermeat", 1), Ingredient("nightmarefuel", 1) }, RECIPETABS.REFINE, {MAGIC=1})
 







        local redcap = GLOBAL.Recipe( "redcap", {webweb, Ingredient("red_cap", 1), Ingredient("log", 1), Ingredient("spoiled_food", 1) }, RECIPETABS.FARM, {SCIENCE=0})
	redcap.atlas = "images/inventoryimages/redcap.xml"

        local greencap = GLOBAL.Recipe( "greencap", {webweb, Ingredient("green_cap", 1), Ingredient("log", 1), Ingredient("spoiled_food", 1) }, RECIPETABS.FARM, {SCIENCE=0})
	greencap.atlas = "images/inventoryimages/greencap.xml"

        local bluecap = GLOBAL.Recipe( "bluecap", {webweb, Ingredient("blue_cap", 1), Ingredient("log", 1), Ingredient("spoiled_food", 1) }, RECIPETABS.FARM, {SCIENCE=0})
	bluecap.atlas = "images/inventoryimages/bluecap.xml"



end

AddSimPostInit(function(inst)
        if inst.prefab == "webbert" then
                silkman(inst)
        end
end)
























AddMinimapAtlas("minimap/webbert.xml")

AddModCharacter("webbert")

