local assets=
{
	Asset("ANIM", "anim/bluecap.zip"),
  Asset("ATLAS", "images/inventoryimages/bluecap.xml"),
  Asset("IMAGE", "images/inventoryimages/bluecap.tex")
}


local function OnDropped(inst)

end

local function OnPickup(inst)

end




local function CanDeploy(inst)
    return true
end

local function OnDeploy(inst, pt) 
    local blue_mushroom = SpawnPrefab("blue_mushroom")
    if blue_mushroom then
        blue_mushroom:PushEvent("")
        blue_mushroom.Transform:SetPosition(pt:Get())
        inst.components.stackable:Get():Remove()
    end
end




local function fn()
	local inst = CreateEntity()

	inst.entity:AddTransform()
	inst.entity:AddAnimState()
    inst.entity:AddLight()


    MakeInventoryPhysics(inst)


    inst.AnimState:SetBank("bulb")
    inst.AnimState:SetBuild("bluecap")
    inst.AnimState:PlayAnimation("idle")





    inst:AddComponent("stackable")
	inst.components.stackable.maxsize = TUNING.STACK_SIZE_SMALLITEM


    inst:AddComponent("tradable")
    inst:AddComponent("inspectable")

    

    inst:AddComponent("fuel")
    inst.components.fuel.fuelvalue = TUNING.MED_FUEL



    inst:AddComponent("inventoryitem")
    inst.components.inventoryitem.atlasname = "images/inventoryimages/bluecap.xml"


 


    inst.components.inventoryitem:SetOnDroppedFn(OnDropped)
    inst.components.inventoryitem:SetOnPickupFn(OnPickup)





    inst:AddComponent("deployable")
    inst.components.deployable.ondeploy = OnDeploy







	return inst
end
	

return Prefab( "common/inventory/bluecap", fn, assets ),
    MakePlacer("common/butterfly_placer", "blue_mushroom", "blue_mushroom", "f1")

