local assets=
{
	Asset("ANIM", "anim/buckyball.zip"),
  Asset("ATLAS", "images/inventoryimages/buckyball.xml"),
  Asset("IMAGE", "images/inventoryimages/buckyball.tex")
}


local function OnDropped(inst)
    inst.Light:Enable(true)
end

local function OnPickup(inst)
    inst.Light:Enable(false)
end



local function onopen(inst)
    inst.SoundEmitter:PlaySound("dontstarve/common/butterfly_trap")

end 

local function onclose(inst) 
    inst.SoundEmitter:PlaySound("dontstarve/common/butterfly_trap")
end 






local slotpos = {}

for y = 2, 0, -1 do
	for x = 0, 2 do
		table.insert(slotpos, Vector3(80*x-80*2+80, 80*y-80*2+80,0))
	end
end





local function fn()
	local inst = CreateEntity()

	inst.entity:AddTransform()
	inst.entity:AddAnimState()
	inst.entity:AddSoundEmitter()
    inst.entity:AddLight()


    MakeInventoryPhysics(inst)

    inst.AnimState:SetBank("bulb")
    inst.AnimState:SetBuild("buckyball")
    inst.AnimState:PlayAnimation("idle")
    
    inst.AnimState:SetBloomEffectHandle( "shaders/anim.ksh" )

    local light = inst.entity:AddLight()
    light:SetFalloff(0.7)
    light:SetIntensity(.5)
    light:SetRadius(1.0)
    light:SetColour(255/255, 000/255, 255/255)
    light:Enable(true)





    inst:AddComponent("tradable")
    inst:AddComponent("inspectable")

    
    inst:AddComponent("fuel")
    inst.components.fuel.fuelvalue = TUNING.TINY_FUEL


    inst:AddComponent("inventoryitem")
    inst.components.inventoryitem.atlasname = "images/inventoryimages/buckyball.xml"



    inst.components.inventoryitem:SetOnDroppedFn(OnDropped)
    inst.components.inventoryitem:SetOnPickupFn(OnPickup)



		inst:AddComponent("container")
		inst.components.container:SetNumSlots(#slotpos)
		
		inst.components.container.onopenfn = onopen
		inst.components.container.onclosefn = onclose
		
		inst.components.container.widgetslotpos = slotpos
		inst.components.container.widgetanimbank = "ui_chest_3x3"
		inst.components.container.widgetanimbuild = "ui_chest_3x3"
		inst.components.container.widgetpos = Vector3(0,200,0)
		inst.components.container.side_align_tip = 160




	return inst
end
	

return Prefab( "common/inventory/buckyball", fn, assets ) 


