local assets=
{
	Asset("ANIM", "anim/greenball.zip"),
  Asset("ATLAS", "images/inventoryimages/greenball.xml"),
  Asset("IMAGE", "images/inventoryimages/greenball.tex")
}





local function fn()
	local inst = CreateEntity()

	inst.entity:AddTransform()
	inst.entity:AddAnimState()


    MakeInventoryPhysics(inst)

    inst.AnimState:SetBank("bulb")
    inst.AnimState:SetBuild("greenball")
    inst.AnimState:PlayAnimation("idle")



    inst:AddComponent("stackable")
	inst.components.stackable.maxsize = TUNING.STACK_SIZE_SMALLITEM



    inst:AddComponent("tradable")
    inst:AddComponent("inspectable")

    
    MakeSmallPropagator(inst) 


        inst:AddComponent("inventoryitem")
    inst.components.inventoryitem.atlasname = "images/inventoryimages/greenball.xml"


    inst:AddComponent("edible")
    inst.components.edible.healthvalue = -15
    inst.components.edible.hungervalue = 0
    inst.components.edible.sanityvalue = 100
  






    local light = inst.entity:AddLight()
    light:SetFalloff(0.7)
    light:SetIntensity(.5)
    light:SetRadius(1.0)
    light:SetColour(000/255, 255/255, 000/255)
    light:Enable(true)
    inst.AnimState:SetBloomEffectHandle( "shaders/anim.ksh" )
    inst.components.inventoryitem:SetOnDroppedFn(function() inst.Light:Enable(true) end)
    inst.components.inventoryitem:SetOnPickupFn(function() inst.Light:Enable(false) end)









    inst:AddComponent("fuel")
    inst.components.fuel.fuelvalue = TUNING.TINY_FUEL






	return inst
end
	

return Prefab( "common/inventory/greenball", fn, assets ) 


