local assets=
{
	Asset("ANIM", "anim/greencap.zip"),
  Asset("ATLAS", "images/inventoryimages/greencap.xml"),
  Asset("IMAGE", "images/inventoryimages/greencap.tex")
}


local function OnDropped(inst)

end

local function OnPickup(inst)

end




local function CanDeploy(inst)
    return true
end

local function OnDeploy(inst, pt) 
    local green_mushroom = SpawnPrefab("green_mushroom")
    if green_mushroom then
        green_mushroom:PushEvent("")
        green_mushroom.Transform:SetPosition(pt:Get())
        inst.components.stackable:Get():Remove()
    end
end




local function fn()
	local inst = CreateEntity()

	inst.entity:AddTransform()
	inst.entity:AddAnimState()
    inst.entity:AddLight()


    MakeInventoryPhysics(inst)


    inst.AnimState:SetBank("bulb")
    inst.AnimState:SetBuild("greencap")
    inst.AnimState:PlayAnimation("idle")





    inst:AddComponent("stackable")
	inst.components.stackable.maxsize = TUNING.STACK_SIZE_SMALLITEM


    inst:AddComponent("tradable")
    inst:AddComponent("inspectable")

    

    inst:AddComponent("fuel")
    inst.components.fuel.fuelvalue = TUNING.MED_FUEL



    inst:AddComponent("inventoryitem")
    inst.components.inventoryitem.atlasname = "images/inventoryimages/greencap.xml"

 


    inst.components.inventoryitem:SetOnDroppedFn(OnDropped)
    inst.components.inventoryitem:SetOnPickupFn(OnPickup)





    inst:AddComponent("deployable")
    inst.components.deployable.ondeploy = OnDeploy







	return inst
end
	

return Prefab( "common/inventory/greencap", fn, assets ),
    MakePlacer("common/butterfly_placer", "green_mushroom", "green_mushroom", "f1")

