

local assets = {  
  Asset("ANIM", "anim/guardiancrest.zip"),
  
   Asset("IMAGE", "images/inventoryimages/guardiancrest.tex"),   
   Asset("ATLAS", "images/inventoryimages/guardiancrest.xml"),	
	
	}






local function onequip(inst, owner)

        owner.AnimState:OverrideSymbol("swap_hat", "guardiancrest", "swap_hat")
        owner.AnimState:Show("HAT")
        owner.AnimState:Show("HAT_HAIR")
        owner.AnimState:Hide("HAIR_NOHAT")
        owner.AnimState:Hide("HAIR")
        
        if owner:HasTag("player") then
			owner.AnimState:Hide("HEAD")
			owner.AnimState:Show("HEAD_HAIR")
		end

        if inst.components.fueled then
            inst.components.fueled:StartConsuming()        
        end


    
    end
	
local function onunequip(inst, owner) 
        owner.AnimState:Hide("HAT")
        owner.AnimState:Hide("HAT_HAIR")
        owner.AnimState:Show("HAIR_NOHAT")
        owner.AnimState:Show("HAIR")


		if owner:HasTag("player") then
	        owner.AnimState:Show("HEAD")
			owner.AnimState:Hide("HEAD_HAIR")
		end

end


























local function spider_disable(inst)
        if inst.updatetask then
            inst.updatetask:Cancel()
            inst.updatetask = nil
        end
        local owner = inst.components.inventoryitem and inst.components.inventoryitem.owner
        if owner and owner.components.leader then
            
            if not owner:HasTag("spiderwhisperer") then --Webber has to stay a monster.
                owner:RemoveTag("monster")

                for k,v in pairs(owner.components.leader.followers) do
                    if k:HasTag("spider") and k.components.combat then
                        k.components.combat:SuggestTarget(owner)
                    end
                end
                owner.components.leader:RemoveFollowersByTag("spider")
            else
                owner.components.leader:RemoveFollowersByTag("spider", function(follower)
                    if follower and follower.components.follower then
                        if follower.components.follower:GetLoyaltyPercent() > 0 then
                            return false
                        else
                            return true
                        end
                    end
                end)
            end

        end
    end
    local function spider_update(inst)
        local owner = inst.components.inventoryitem and inst.components.inventoryitem.owner
        if owner and owner.components.leader then
            owner.components.leader:RemoveFollowersByTag("pig")
            local x,y,z = owner.Transform:GetWorldPosition()
            local ents = TheSim:FindEntities(x,y,z, TUNING.SPIDERHAT_RANGE, {"spider"})
            for k,v in pairs(ents) do
                if v.components.follower and not v.components.follower.leader and not owner.components.leader:IsFollower(v) and owner.components.leader.numfollowers < 50 then
                    owner.components.leader:AddFollower(v)
                end
            end
        end
    end
    local function spider_enable(inst)
        local owner = inst.components.inventoryitem and inst.components.inventoryitem.owner
        if owner and owner.components.leader then
            owner.components.leader:RemoveFollowersByTag("pig")
            owner:AddTag("monster")
        end
        inst.updatetask = inst:DoPeriodicTask(0.5, spider_update, 1)
    end
    local function spider_equip(inst, owner)
        onequip(inst, owner)
        spider_enable(inst)
    end
    local function spider_unequip(inst, owner)
        onunequip(inst, owner)
        spider_disable(inst)
    end

   











local function fn()
	local inst = CreateEntity()
	local trans = inst.entity:AddTransform()
	local anim = inst.entity:AddAnimState()
    
	local minimap = inst.entity:AddMiniMapEntity()
    minimap:SetIcon( "guardiancrest.tex" )
	
	MakeInventoryPhysics(inst)
    
	inst:AddTag("guardiancrest")

	anim:SetBank("strawhat")
    anim:SetBuild("guardiancrest")
    anim:PlayAnimation("anim")
	  
	inst:AddComponent("inspectable")
   
    inst:AddComponent("inventoryitem")
	inst.components.inventoryitem.atlasname = "images/inventoryimages/guardiancrest.xml"

    inst:AddComponent("tradable")

    inst:AddComponent("equippable")
    inst.components.equippable.equipslot = EQUIPSLOTS.HEAD

	
	
    inst.components.equippable:SetOnEquip( onequip )
    inst.components.equippable:SetOnUnequip( onunequip )
 

















        inst.components.equippable.dapperness = -TUNING.DAPPERNESS_SMALL*2
        inst.components.inventoryitem:SetOnDroppedFn( spider_disable )
        inst.components.equippable:SetOnEquip( spider_equip )
        inst.components.equippable:SetOnUnequip( spider_unequip )
        inst.components.equippable.walkspeedmult = TUNING.CANE_SPEED_MULT





    return inst
end




   

























return Prefab( "common/inventory/guardiancrest", fn, assets)