local assets=
{
	Asset("ANIM", "anim/mightyball.zip"),
  Asset("ATLAS", "images/inventoryimages/mightyball.xml"),
  Asset("IMAGE", "images/inventoryimages/mightyball.tex")
}











local heats = { 30, 70, 120, 180, 220 }
local function GetHeatFn(inst)
	return 40
end








local function OnActivate(inst)
    inst.components.burnable:Ignite()
    inst:RemoveTag("CLICK")
end


local function onignite(inst)
    if not inst.components.cooker then
        inst:AddComponent("cooker")
    end
end

local function onextinguish(inst)
    if inst.components.cooker then
        inst:RemoveComponent("cooker")
    end
    if inst.components.fueled then
        inst.components.fueled:InitializeFuelLevel(0)
    end
end












local function fn()
	local inst = CreateEntity()

	inst.entity:AddTransform()
	inst.entity:AddAnimState()


    MakeInventoryPhysics(inst)

    inst.AnimState:SetBank("bulb")
    inst.AnimState:SetBuild("mightyball")
    inst.AnimState:PlayAnimation("idle")



    inst:AddComponent("stackable")
	inst.components.stackable.maxsize = TUNING.STACK_SIZE_SMALLITEM



    inst:AddComponent("tradable")
    inst:AddComponent("inspectable")

    
    MakeSmallPropagator(inst) 


        inst:AddComponent("inventoryitem")
    inst.components.inventoryitem.atlasname = "images/inventoryimages/mightyball.xml"


    inst:AddComponent("edible")
    inst.components.edible.healthvalue = 100
    inst.components.edible.hungervalue = 0
  






    local light = inst.entity:AddLight()
    light:SetFalloff(0.7)
    light:SetIntensity(.5)
    light:SetRadius(12.0)
    light:SetColour(255/255, 255/255, 000/255)
    light:Enable(true)
    inst.AnimState:SetBloomEffectHandle( "shaders/anim.ksh" )
    inst.components.inventoryitem:SetOnDroppedFn(function() inst.Light:Enable(true) end)
    inst.components.inventoryitem:SetOnPickupFn(function() inst.Light:Enable(false) end)









    inst:AddComponent("heater")
    inst.components.heater.heatfn = GetHeatFn






    inst:AddComponent("fuel")
    inst.components.fuel.fuelvalue = TUNING.TINY_FUEL







    inst:AddComponent("sanityaura")
    inst.components.sanityaura.aura = TUNING.SANITYAURA_HUGE










	return inst
end
	

return Prefab( "common/inventory/mightyball", fn, assets ) 


