local assets=
{
	Asset("ANIM", "anim/redball.zip"),
  Asset("ATLAS", "images/inventoryimages/redball.xml"),
  Asset("IMAGE", "images/inventoryimages/redball.tex")
}







local heats = { 30, 70, 120, 180, 220 }
local function GetHeatFn(inst)
	return 70
end









local function fn()
	local inst = CreateEntity()

	inst.entity:AddTransform()
	inst.entity:AddAnimState()


    MakeInventoryPhysics(inst)

    inst.AnimState:SetBank("bulb")
    inst.AnimState:SetBuild("redball")
    inst.AnimState:PlayAnimation("idle")



    inst:AddComponent("stackable")
	inst.components.stackable.maxsize = TUNING.STACK_SIZE_SMALLITEM



    inst:AddComponent("tradable")
    inst:AddComponent("inspectable")

    

    MakeSmallPropagator(inst) 


        inst:AddComponent("inventoryitem")
    inst.components.inventoryitem.atlasname = "images/inventoryimages/redball.xml"


    inst:AddComponent("edible")
    inst.components.edible.healthvalue = 0
    inst.components.edible.hungervalue = 30
    inst.components.edible.sanityvalue = 0
  












    local light = inst.entity:AddLight()
    light:SetFalloff(0.7)
    light:SetIntensity(.5)
    light:SetRadius(1.0)
    light:SetColour(255/255, 000/255, 000/255)
    light:Enable(true)
    inst.AnimState:SetBloomEffectHandle( "shaders/anim.ksh" )
    inst.components.inventoryitem:SetOnDroppedFn(function() inst.Light:Enable(true) end)
    inst.components.inventoryitem:SetOnPickupFn(function() inst.Light:Enable(false) end)












    inst:AddComponent("heater")
    inst.components.heater.heatfn = GetHeatFn




    inst:AddComponent("fuel")
    inst.components.fuel.fuelvalue = TUNING.TINY_FUEL




	return inst
end
	

return Prefab( "common/inventory/redball", fn, assets ) 


