local assets=
{
	Asset("ANIM", "anim/redcap.zip"),
  Asset("ATLAS", "images/inventoryimages/redcap.xml"),
  Asset("IMAGE", "images/inventoryimages/redcap.tex")
}


local function OnDropped(inst)

end

local function OnPickup(inst)

end




local function CanDeploy(inst)
    return true
end

local function OnDeploy(inst, pt) 
    local red_mushroom = SpawnPrefab("red_mushroom")
    if red_mushroom then
        red_mushroom:PushEvent("")
        red_mushroom.Transform:SetPosition(pt:Get())
        inst.components.stackable:Get():Remove()
    end
end




local function fn()
	local inst = CreateEntity()

	inst.entity:AddTransform()
	inst.entity:AddAnimState()
    inst.entity:AddLight()

    MakeInventoryPhysics(inst)


    inst.AnimState:SetBank("bulb")
    inst.AnimState:SetBuild("redcap")
    inst.AnimState:PlayAnimation("idle")






    inst:AddComponent("stackable")
	inst.components.stackable.maxsize = TUNING.STACK_SIZE_SMALLITEM


    inst:AddComponent("tradable")
    inst:AddComponent("inspectable")

    

    inst:AddComponent("fuel")
    inst.components.fuel.fuelvalue = TUNING.MED_FUEL



    inst:AddComponent("inventoryitem")
    inst.components.inventoryitem.atlasname = "images/inventoryimages/redcap.xml"



    inst.components.inventoryitem:SetOnDroppedFn(OnDropped)
    inst.components.inventoryitem:SetOnPickupFn(OnPickup)





    inst:AddComponent("deployable")
    inst.components.deployable.ondeploy = OnDeploy







	return inst
end
	

return Prefab( "common/inventory/redcap", fn, assets ),
    MakePlacer("common/butterfly_placer", "red_mushroom", "red_mushroom", "f1")

