local assets=
{
	Asset("ANIM", "anim/spiderball.zip"),
  Asset("ATLAS", "images/inventoryimages/spiderball.xml"),
  Asset("IMAGE", "images/inventoryimages/spiderball.tex")
}





local function fn()
	local inst = CreateEntity()

	inst.entity:AddTransform()
	inst.entity:AddAnimState()


    MakeInventoryPhysics(inst)

    inst.AnimState:SetBank("bulb")
    inst.AnimState:SetBuild("spiderball")
    inst.AnimState:PlayAnimation("idle")



    inst:AddComponent("stackable")
	inst.components.stackable.maxsize = TUNING.STACK_SIZE_SMALLITEM



    inst:AddComponent("tradable")
    inst:AddComponent("inspectable")




        inst:AddComponent("inventoryitem")
    inst.components.inventoryitem.atlasname = "images/inventoryimages/spiderball.xml"


    inst:AddComponent("edible")
    inst.components.edible.healthvalue = TUNING.HEALING_TINY
    inst.components.edible.hungervalue = 0
  






    local light = inst.entity:AddLight()
    light:SetFalloff(0.7)
    light:SetIntensity(.5)
    light:SetRadius(1.0)
    light:SetColour(255/255, 255/255, 255/255)
    light:Enable(true)
    inst.AnimState:SetBloomEffectHandle( "shaders/anim.ksh" )
    inst.components.inventoryitem:SetOnDroppedFn(function() inst.Light:Enable(true) end)
    inst.components.inventoryitem:SetOnPickupFn(function() inst.Light:Enable(false) end)









    inst:AddComponent("fuel")
    inst.components.fuel.fuelvalue = TUNING.TINY_FUEL






	return inst
end
	

return Prefab( "common/inventory/spiderball", fn, assets ) 


