local assets=
{
	Asset("ANIM", "anim/trickball.zip"),
  Asset("ATLAS", "images/inventoryimages/trickball.xml"),
  Asset("IMAGE", "images/inventoryimages/trickball.tex")
}





local function fn()
	local inst = CreateEntity()

	inst.entity:AddTransform()
	inst.entity:AddAnimState()


    MakeInventoryPhysics(inst)

    inst.AnimState:SetBank("bulb")
    inst.AnimState:SetBuild("trickball")
    inst.AnimState:PlayAnimation("idle")



    inst:AddComponent("stackable")
	inst.components.stackable.maxsize = TUNING.STACK_SIZE_SMALLITEM



    inst:AddComponent("tradable")
    inst:AddComponent("inspectable")

    
    MakeSmallPropagator(inst) 


        inst:AddComponent("inventoryitem")
    inst.components.inventoryitem.atlasname = "images/inventoryimages/trickball.xml"


    inst:AddComponent("edible")
    inst.components.edible.healthvalue = -300
    inst.components.edible.hungervalue = 0
   







    local light = inst.entity:AddLight()
    light:SetFalloff(0.7)
    light:SetIntensity(.5)
    light:SetRadius(1.0)
    light:SetColour(237/255, 237/255, 209/255)
    light:Enable(true)
    inst.AnimState:SetBloomEffectHandle( "shaders/anim.ksh" )
    inst.components.inventoryitem:SetOnDroppedFn(function() inst.Light:Enable(true) end)
    inst.components.inventoryitem:SetOnPickupFn(function() inst.Light:Enable(false) end)









    inst:AddComponent("fuel")
    inst.components.fuel.fuelvalue = TUNING.TINY_FUEL






	return inst
end
	

return Prefab( "common/inventory/trickball", fn, assets ) 


