
local MakePlayerCharacter = require "prefabs/player_common"


local assets = 
{
    
	Asset("SOUND", "sound/webber.fsb"),
	Asset("ANIM", "anim/beard_silk.zip"),

		-- Don't forget to include your character's custom assets!
    Asset( "ANIM", "anim/webbert.zip" ),
}
local prefabs = 
{
	"silk"
}

local start_inv = 
{
        "guardiancrest",
        "cavespidershell",
        "purpleball",
        "buckyball",
        "eggslayer",
        "spidereggsack",
        "spidereggsack",

}

local fn = function(inst)
	
	-- choose which sounds this character will play
	inst.soundsname = "webber"

	-- a minimap icon must be specified
	inst.MiniMapEntity:SetIcon( "webbert.png" )

	-- todo: Add an example special power here.
	inst.talker_path_override = "dontstarve_DLC001/characters/"

	inst:AddTag("spiderwhisperer")
	inst:AddTag("monster")
	inst.components.locomotor.triggerscreep = false

	inst.components.eater.monsterimmune = true

	inst.components.health:SetMaxHealth(150)
	inst.components.hunger:SetMax(180)
	inst.components.sanity:SetMax(100)

	local nest_recipe = Recipe("spidereggsack", {Ingredient("silk", 12), Ingredient("spidergland", 6), Ingredient("papyrus", 6)}, RECIPETABS.TOWN, TECH.NONE)
	nest_recipe.sortkey = 1
	STRINGS.RECIPE_DESC.SPIDEREGGSACK = "Get a little help from your friends."








		TUNING.SANITY_NIGHT_LIGHT = 0/60
		TUNING.SANITY_NIGHT_MID = 0/60
                TUNING.SANITY_NIGHT_DARK = 0/60
		TUNING.SANITY_DAY_GAIN = -6/60





        



    inst:AddComponent("beard")
    inst.components.beard.insulation_factor = TUNING.WEBBER_BEARD_INSULATION_FACTOR
    inst.components.beard.onreset = function()
        inst.AnimState:ClearOverrideSymbol("beard")
    end
    inst.components.beard.prize = "silk"

    
	local beard_days = {3, 6, 9}
	local beard_bits = {1, 3, 6}
    
    inst.components.beard:AddCallback(beard_days[1], function()
        inst.AnimState:OverrideSymbol("beard", "beard_silk", "beardsilk_short")
        inst.components.beard.bits = beard_bits[1]
    end)
    
    inst.components.beard:AddCallback(beard_days[2], function()
        inst.AnimState:OverrideSymbol("beard", "beard_silk", "beardsilk_medium")
        inst.components.beard.bits = beard_bits[2]
    end)
    
    inst.components.beard:AddCallback(beard_days[3], function()
        inst.AnimState:OverrideSymbol("beard", "beard_silk", "beardsilk_long")
        inst.components.beard.bits = beard_bits[3]
    end)
end


-- strings! Any "webbert" below would have to be replaced by the prefab name of your character.

-- First up, the character select screen lines 
-- note: these are lower-case character name
STRINGS.CHARACTER_TITLES.webbert = "The Unknown Species"
STRINGS.CHARACTER_NAMES.webbert = "test name"
STRINGS.CHARACTER_DESCRIPTIONS.webbert = "*Is only found in the great genealogy of spiders\n*Can do whatever spiders do\n*Is a master of making silk balls"
STRINGS.CHARACTER_QUOTES.webbert = "\"Overcoming is not enough. Enjoy this world!\""

-- You can also add any kind of custom dialogue that you would like. Don't forget to make
-- categores that don't exist yet using = {}
-- note: these are UPPER-CASE charcacter name
STRINGS.CHARACTERS.webbert = {}
STRINGS.CHARACTERS.webbert.DESCRIBE = {}
STRINGS.CHARACTERS.webbert.DESCRIBE.EVERGREEN = "Wow, so test."



return MakePlayerCharacter("webbert", prefabs, assets, fn, start_inv)
