// ==UserScript==
// @name         知乎免登录
// @namespace    https://www.zhihu.com/
// @version      0.6
// @description  去除烦人的登录提示
// @author       System
// @match        *://www.zhihu.com/*
// @run-at         document-start
// @connect        api.zhihu.com
// @grant          GM_xmlhttpRequest
// ==/UserScript==


(function() {
    'use strict';
    //登录弹窗屏蔽功能
    {
    let login_flag=false;
    document.querySelector('body').addEventListener('DOMNodeInserted',function(e){
        if(!login_flag&&e.target.getElementsByClassName&&e.target.getElementsByClassName('signFlowModal').length!==0){
            e.target.getElementsByClassName('Modal-backdrop')[0].click();
        }else login_flag=false;
    });
    window.addEventListener('DOMContentLoaded',e=>{
        const button=document.querySelector('button.AppHeader-login');
        if(button)
            button.addEventListener('click',e=>login_flag=true);
    });

    }//END

    //简单模板渲染器
    function render(temp, data) {
        const get = value => value.split('.').reduce((prev, cur) => prev ? prev[cur.trim()] : null, data);
        return temp.replace(/{%\s*if\s+(.*?)%}([\s\S]*?){%\s*fi\s*%}/gm, (match, v1, v2) => get(v1) ? v2 : "")
            .replace(/{{\s*(.+?)\s*}}/g, (match, value) => get(value));
    }

    //主页推荐内容显示
    {

    const body_html=`
        <style>
        .u-safeAreaInset-top {
            height: constant(safe-area-inset-top) !important;
            height: env(safe-area-inset-top) !important;

        }

        .u-safeAreaInset-bottom {
            height: constant(safe-area-inset-bottom) !important;
            height: env(safe-area-inset-bottom) !important;

        }

        .Card {
            margin-bottom: 10px;
            background: #fff;
            overflow: hidden;
            border-radius: 2px;
            -webkit-box-shadow: 0 1px 3px rgba(26, 26, 26, .1);
            box-shadow: 0 1px 3px rgba(26, 26, 26, .1);
            -webkit-box-sizing: border-box;
            box-sizing: border-box;
        }

        .AnswerCard {
            -webkit-transition: -webkit-box-shadow .3s;
            transition: -webkit-box-shadow .3s;
            transition: box-shadow .3s;
            transition: box-shadow .3s, -webkit-box-shadow .3s;
        }

        .QuestionAnswer-content {
            padding: 16px 20px;
        }
    </style>
    <style>
        .InfoItem {
            padding: 15px 0 14px;
            margin: 0 15px;
            border-bottom: .5px solid #d3d3d3
        }

        .InfoItemHead {
            font-weight: 600;
            font-size: 17px;
            color: #1a1a1a;
            line-height: 22px
        }

        .InfoItemContent {
            display: -ms-flexbox;
            display: flex;
            padding-top: 11px;
            -ms-flex-align: center;
            align-items: center;
            width: 100%
        }

        .InfoItenDirection {
            -ms-flex-direction: column;
            flex-direction: column
        }

        .InfoItemDes {
            flex: 1;
            position: relative;
            -webkit-line-clamp: 3;
            height: 63px;
            padding-right: 15px
        }

        .InfoItemDes,
        .InfoItemDes-circle {
            font-size: 15px;
            overflow: hidden;
            font-weight: 400;
            text-overflow: ellipsis;
            display: -webkit-box;
            line-height: 21px;
            letter-spacing: normal;
            color: #444;
            margin-right: 4px 15px;
            -webkit-box-orient: vertical
        }

        .EllTwo,
        .InfoItemDes-circle {
            -webkit-line-clamp: 2
        }

        .EllTwo {
            overflow: hidden;
            -webkit-box-orient: vertical;
            text-overflow: ellipsis;
            display: -webkit-box
        }

        .InfoItemImg-s {
            width: 112px;
            height: 74px;
            border-radius: 5px;
            background: #ccc
        }

        .InfoItemImg {
            position: relative;
            width: 100%;
            height: 144px;
            border-radius: 5px;
            overflow: hidden
        }

        .InfoItemImg-l {
            background: #ccc;
            position: absolute
        }

        .InfoItemFooter {
            font-size: 14px;
            color: #999;
            padding-top: 9px
        }

        .InfoItemAnswer,
        .InfoItemPoint {
            padding-right: 5px
        }

        .InfoItemPoint {
            padding-left: 5px
        }

        .InfoItemVideo {
            width: 100%;
            height: 194px;
            position: relative;
            display: -ms-flexbox;
            display: flex;
            -ms-flex-pack: center;
            justify-content: center;
            -ms-flex-align: center;
            align-items: center;
            overflow: hidden;
            margin: 10px 0 5px;
            border-radius: 5px;
            background: #ccc
        }

        .InfoItemVideo .VideoCard {
            width: 100%;
            height: 100%;
            overflow: hidden;
            z-index: 10;
            border: none;
            box-shadow: none
        }
    </style>
    <style>
        main {
            width: 1000px;
            margin: 0 auto;
        }

        .MwebVideo {
            border: none;
            height: 100%;
            width: 100%;
        }

        .icon-refresh {
            width: 45px;
            height: 45px;
            position: fixed;
            right: 15px;
            bottom: 120px;
            cursor: pointer;
        }
        .Header-tab {
            z-index: 10;
            box-shadow: 0 1px 5px 0 rgba(0,0,0,.1);
            background-color: #fcfcfc;
            overflow-x: scroll;
            white-space: nowrap;
            text-align: center;
        }
        .Header-item {
            display: inline-block;
            width: 58px;
            height: 24px;
            border-radius: 12px;
            background-color: #fff;
            border: .5px solid #ebebeb;
            text-align: center;
            margin: 10px 5px 15px;
            color: #999;
            font-size: 14px;
            line-height: 24px;
            cursor: pointer;
        }
        .active {color: #444;font-weight: 600;}

        .HotList-item {
            display: -webkit-box;
            display: -ms-flexbox;
            display: flex;
            padding: 12px 16px;
            font-size: 14px
        }

        .HotList-item:not(:first-child) {
            border: none;
            border-top: .5px solid #d3d3d3
        }

        .HotList-itemPre {
            -ms-flex-direction: column;
            flex-direction: column;
            -webkit-box-align: center;
            -ms-flex-align: center;
            align-items: center
        }

        .HotList-itemBody,.HotList-itemPre {
            display: -webkit-box;
            display: -ms-flexbox;
            display: flex;
            -webkit-box-orient: vertical;
            -webkit-box-direction: normal
        }

        .HotList-itemBody {
            -webkit-box-flex: 1;
            -ms-flex: 1 1;
            flex: 1 1;
            -ms-flex-direction: column;
            flex-direction: column;
            overflow: hidden;
            margin: 0 8px
        }

        .HotList-itemIndex {
            line-height: 24px;
            font-size: 18px;
            color: #c2a469;
            font-weight: 600;
            font-synthesis: style
        }
        .HotList-itemTitle {
            font-size: 16px;
            line-height: 24px;
            max-height: 72px;
            font-weight: 600;
            font-synthesis: style;
            margin-bottom: 4px;
            display: -webkit-box;
            text-overflow: ellipsis;
            overflow: hidden;
            -webkit-line-clamp: 3;
            -webkit-box-orient: vertical;
        }
        .HotList-itemMetrics {
            display: -webkit-box;
            display: -ms-flexbox;
            display: flex;
            -webkit-box-align: center;
            -ms-flex-align: center;
            align-items: center;
            color: #999;
        }
        .HotList-itemImgContainer {
            position: relative;
            display: -webkit-box;
            display: -ms-flexbox;
            display: flex;
            -webkit-box-align: center;
            -ms-flex-align: center;
            align-items: center;
        }
        .HotList-itemImgContainer img,.HotList-itemImgContainer span {
            border-radius: 5px;
            width: 150px;
            height: 100px;
            -o-object-fit: cover;
            object-fit: cover
        }
        .HotList-item:nth-child(1) .HotList-itemIndex,.HotList-item:nth-child(2) .HotList-itemIndex,.HotList-item:nth-child(3) .HotList-itemIndex,.HotList-itemIndexHot{
            color: #f1403c;
        }
        .HotList-itemExcerpt {
            overflow: hidden;
            text-overflow: ellipsis;
            color: #444;
            display: -webkit-box;
            -webkit-box-orient: vertical;
            -webkit-line-clamp: 6;
        }
    </style>
    <div>
        <div class="LoadingBar"></div>
        <div>
            <header role="banner" class="Sticky AppHeader" data-za-module="TopNavBar">
                <div class="AppHeader-inner"><a href="//www.zhihu.com" aria-label="知乎"><svg viewBox="0 0 200 91"
                            fill="#0084FF" width="64" height="30">
                            <path
                                d="M53.29 80.035l7.32.002 2.41 8.24 13.128-8.24h15.477v-67.98H53.29v67.978zm7.79-60.598h22.756v53.22h-8.73l-8.718 5.473-1.587-5.46-3.72-.012v-53.22zM46.818 43.162h-16.35c.545-8.467.687-16.12.687-22.955h15.987s.615-7.05-2.68-6.97H16.807c1.09-4.1 2.46-8.332 4.1-12.708 0 0-7.523 0-10.085 6.74-1.06 2.78-4.128 13.48-9.592 24.41 1.84-.2 7.927-.37 11.512-6.94.66-1.84.785-2.08 1.605-4.54h9.02c0 3.28-.374 20.9-.526 22.95H6.51c-3.67 0-4.863 7.38-4.863 7.38H22.14C20.765 66.11 13.385 79.24 0 89.62c6.403 1.828 12.784-.29 15.937-3.094 0 0 7.182-6.53 11.12-21.64L43.92 85.18s2.473-8.402-.388-12.496c-2.37-2.788-8.768-10.33-11.496-13.064l-4.57 3.627c1.363-4.368 2.183-8.61 2.46-12.71H49.19s-.027-7.38-2.372-7.38zm128.752-.502c6.51-8.013 14.054-18.302 14.054-18.302s-5.827-4.625-8.556-1.27c-1.874 2.548-11.51 15.063-11.51 15.063l6.012 4.51zm-46.903-18.462c-2.814-2.577-8.096.667-8.096.667s12.35 17.2 12.85 17.953l6.08-4.29s-8.02-11.752-10.83-14.33zM199.99 46.5c-6.18 0-40.908.292-40.953.292v-31.56c1.503 0 3.882-.124 7.14-.376 12.773-.753 21.914-1.25 27.427-1.504 0 0 3.817-8.496-.185-10.45-.96-.37-7.24 1.43-7.24 1.43s-51.63 5.153-72.61 5.64c.5 2.756 2.38 5.336 4.93 6.11 4.16 1.087 7.09.53 15.36.277 7.76-.5 13.65-.76 17.66-.76v31.19h-41.71s.88 6.97 7.97 7.14h33.73v22.16c0 4.364-3.498 6.87-7.65 6.6-4.4.034-8.15-.36-13.027-.566.623 1.24 1.977 4.496 6.035 6.824 3.087 1.502 5.054 2.053 8.13 2.053 9.237 0 14.27-5.4 14.027-14.16V53.93h38.235c3.026 0 2.72-7.432 2.72-7.432z"
                                fill-rule="evenodd"></path>
                        </svg></a>
                    <ul role="navigation" class="Tabs AppHeader-Tabs">
                        <li role="tab" class="Tabs-item AppHeader-Tab Tabs-item--noMeta"><a
                                class="Tabs-link AppHeader-TabsLink is-active" href="//www.zhihu.com/"
                                data-za-not-track-link="true">首页</a></li>
                        <li role="tab" class="Tabs-item AppHeader-Tab Tabs-item--noMeta"><a
                                class="Tabs-link AppHeader-TabsLink" href="//www.zhihu.com/explore"
                                data-za-not-track-link="true">发现</a></li>
                        <li role="tab" class="Tabs-item AppHeader-Tab Tabs-item--noMeta"><a
                                class="Tabs-link AppHeader-TabsLink" href="//www.zhihu.com/question/waiting"
                                data-za-not-track-link="true">等你来答</a></li>
                    </ul>

                    <div class="SearchBar" role="search" data-za-module="PresetWordItem">
                        <div class="SearchBar-toolWrapper">
                            <form class="SearchBar-tool" method="get" action="/search" @submit.native.prevent>
                                <div>
                                    <div class="Popover">
                                        <label class="SearchBar-input Input-wrapper Input-wrapper--grey">
                                            <input type="search" name="q" maxLength="100" value="" autoComplete="off"
                                                role="combobox" aria-expanded="false" aria-autocomplete="list"
                                                aria-activedescendant="null--1" id="null-toggle"
                                                aria-haspopup="true" aria-owns="null-content" class="Input"
                                                placeholder="搜索内容" />
                                            <input type="text" name="type" value="content" hidden>
                                            <button aria-label="搜索" type="submit" class="Button SearchBar-searchButton Button--primary">
                                                <span style="display:inline-flex;align-items:center">​
                                                    <svg class="Zi Zi--Search SearchBar-searchIcon" fill="currentColor" viewBox="0 0 24 24" width="18" height="18">
                                                        <path d="M17.068 15.58a8.377 8.377 0 0 0 1.774-5.159 8.421 8.421 0 1 0-8.42 8.421 8.38 8.38 0 0 0 5.158-1.774l3.879 3.88c.957.573 2.131-.464 1.488-1.49l-3.879-3.878zm-6.647 1.157a6.323 6.323 0 0 1-6.316-6.316 6.323 6.323 0 0 1 6.316-6.316 6.323 6.323 0 0 1 6.316 6.316 6.323 6.323 0 0 1-6.316 6.316z" fill-rule="evenodd"></path>
                                                    </svg>
                                                </span>
                                            </button>
                                        </label>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                    <div class="AppHeader-userInfo">
                        <div class="AppHeader-profile">
                            <div><button type="button"
                                    class="Button AppHeader-login Button--blue">登录</button><button type="button"
                                    class="Button Button--primary Button--blue">加入知乎</button></div>
                        </div>
                    </div>
                </div>
                <div></div>
            </header>
        </div>
        <main role="main" class="App-main">
            <div class="HeaderContainer">
                <div class="HeaderTopColor"></div>
                <div id="Header-tab" class="Header-tab">
                <div class="Header-item active" data-channel="热榜" data-id="rebang">热榜</div>
                <div class="Header-item" data-channel="推荐" data-id="tuijian">推荐</div>
                    <div class="Header-item" data-channel="生活" data-id="shenghuo">生活</div>
                    <div class="Header-item" data-channel="教育" data-id="jiaoyu">教育</div>
                    <div class="Header-item" data-channel="娱乐" data-id="yule">娱乐</div>
                    <div class="Header-item" data-channel="汽车" data-id="qiche">汽车</div>
                    <div class="Header-item" data-channel="金融" data-id="jinrong">金融</div>
                    <div class="Header-item" data-channel="职场" data-id="zhichang">职场</div>
                    <div class="Header-item" data-channel="科技" data-id="keji">科技</div>
                    <div class="Header-item" data-channel="体育" data-id="tiyu">体育</div>
                </div>
            </div>
            <div class="Card AnswersNavWrapper">
                <div class="ListShortcut">
                    <div class="List Profile-answers" id="Profile-answers" data-zop-feedlistfather="1">
                        <div class="List-header">
                            <div class="List-headerOptions">
                            </div>
                        </div>
                        <div class="scroll">

                        </div>
                    </div>
                </div>
            </div>
        </main>
        <img class="icon-refresh"
            src="data:image/png;base64,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"
            alt="刷新">
        <div data-zop-usertoken="{}"></div>
    </div>`;
    const InfoItem = `
        <div class="Card AnswerCard QuestionAnswer-content">
            <a class="InfoItemHead EllTwo" target="_blank" href="{{target_url}}">{{title}}</a>
            {%if has_video %}
            <div class="InfoItemVideo">
                <iframe src="{{video_field.url}}" class="MwebVideo"></iframe>
            </div>
            {%fi%}
            <div class="InfoItemContent">
                <div class="InfoItemDes-circle">{{summary}}</div>
                {%if has_image %}<img src="{{image_field.url}}" alt="" class="InfoItemImg-s">{%fi%}
            </div>
            <div class="InfoItemFooter">
                <span class="InfoItemAnswer">{{author}}</span>的回答
                <span>
                    <span class="InfoItemPoint">·</span>
                    <span class="InfoItemAnswer">{{related.upvote_count}}</span>赞同
                </span>
            </div>
        </div>
    `;
    const Hotitem= `
    <div class="HotList-item" data-za-detail-view-path-module="FeedItem">
        <div class="HotList-itemPre">
            <div class="HotList-itemIndex">{{index}}</div>
            <div class="HotList-itemLabel" style="color: rgb(241, 64, 60);">
            </div>
        </div>
        <div class="HotList-itemBody">
            <a class="HotList-itemTitle" target="_blank" href="https://www.zhihu.com/question/{{target.id}}">{{target.title}}</a>
            <div class="HotList-itemExcerpt">{{target.excerpt}}</div>
            <div class="HotList-itemMetrics">{{detail_text}}</div>
        </div>
        <div class="HotList-itemImgContainer">
            <img src="{{children.0.thumbnail}}"
                alt="{{target.title}}">
        </div>
    </div>
    `;

    if(location.href.endsWith("://www.zhihu.com/")||location.href.includes("://www.zhihu.com/signin")){
        try {document.body.innerHTML=body_html;} catch (error) {}
        window.addEventListener('DOMContentLoaded', () => {
            document.body.innerHTML=body_html;

            let is_end = false, update = 0, category=document.querySelector('div.Header-item.active').dataset.id,loading=false;
            const target = document.querySelector('div.scroll');
            const pad=(num, n)=> (Array(n).join(0) + num).slice(-n);
            function load(reload) {
                update = new Date().getTime();
                loading=true;
                const xhr = new XMLHttpRequest();
                if(category=='rebang'){
                    xhr.open('GET', 'https://www.zhihu.com/api/v3/feed/topstory/hot-lists/total?limit=50&desktop=true');
                    xhr.addEventListener('load', function () {
                        const data = JSON.parse(this.response);
                        is_end = data.paging.is_end;
                        const parser = new DOMParser();
                        data.data.map((val,i)=>(val.index=pad(i+1,2),val)).map((val) => render(Hotitem, val)).forEach((val) => {
                            const doc = parser.parseFromString(val, 'text/html');
                            target.append(doc.body.children[0]);
                        });
                        loading=false;
                    });

                }else{
                    xhr.open('GET', 'https://www.zhihu.com/api/v4//mweb-feed/content/list?category='+category+'&reload='+((is_end||reload)?'true':'false')+'&utm_source=&count=8');
                    xhr.addEventListener('load', function () {
                        const data = JSON.parse(this.response);
                        is_end = data.paging.is_end;
                        const parser = new DOMParser();
                        data.data.map((val) => render(InfoItem, val)).forEach((val) => {
                            const doc = parser.parseFromString(val, 'text/html');
                            target.append(doc.body.children[0]);
                        });
                        loading=false;

                    });
                }
                xhr.send();
            }
            const scroll = () => {
                if (is_end || loading||new Date().getTime() - update < 100||target.scrollHeight - window.scrollY > 1000 )
                    return;
                load();
            }
            window.addEventListener('scroll', scroll);
            const reload=() => {
                [...target.children].forEach(e => e.remove());
                load(true);
            }

            const click=function(e){

                const active=document.querySelector('div.Header-item.active');
                const id=this.dataset.id;
                if(id!=category)
                {
                    active.classList.remove('active');
                    this.classList.add('active');
                    category=id;
                    reload(true);
                }
            }
            document.querySelectorAll('div.Header-item').forEach(e=>e.addEventListener('click',click));
            document.querySelector('img.icon-refresh').addEventListener('click', reload);
            scroll();

        });
    }
    }//END


    //隐私保护用户信息显示
    {
    const list_item_temp=`
    <div class="List-item" tabindex="0">
        <div class="ContentItem AnswerItem"
            data-zop="{&quot;authorName&quot;:&quot;{{object.author.name}}&quot;,&quot;itemId&quot;:{{object.id}},&quot;title&quot;:&quot;{{object.question.name}}&quot;,&quot;type&quot;:&quot;answer&quot;}"
            name="{{object.id}}" itemprop="zhihu:answer" itemtype="http://schema.org/Answer" itemscope=""
            data-za-detail-view-path-module="AnswerItem">
            <h2 class="ContentItem-title">
                <div itemprop="zhihu:question" itemtype="http://schema.org/Question" itemscope="">
                    <meta itemprop="url" content="https://www.zhihu.com/question/{{object.question.id}}">
                    <meta itemprop="name" content="{{object.question.name}}">
                    <a target="_blank" data-za-detail-view-element_name="Title" href="//www.zhihu.com/question/{{object.question.id}}/answer/{{object.id}}">
                        {{object.question.name}}
                    </a>
                </div>
            </h2>
            <div class="ContentItem-meta">
                <div class="AuthorInfo AnswerItem-authorInfo" itemprop="author" itemscope=""
                    itemtype="http://schema.org/Person">
                    <meta itemprop="name" content="{{object.author.name}}">
                    <meta itemprop="image" content="{{object.author.avatar_url}}">
                    <meta itemprop="url" content="https://www.zhihu.com/people/{{object.author.url_token}}">
                    <meta itemprop="zhihu:followerCount"><span class="UserLink AuthorInfo-avatarWrapper">
                        <div class="Popover">
                            <div id="Popover47-toggle" aria-haspopup="true" aria-expanded="false"
                                aria-owns="Popover47-content"><a class="UserLink-link"
                                    data-za-detail-view-element_name="User" target="_blank"
                                    href="//www.zhihu.com/people/{{object.author.url_token}}"><img class="Avatar AuthorInfo-avatar"
                                        width="38" height="38"
                                        src="{{object.author.avatar_url}}"
                                        srcset="{{object.author.avatar_url}}"
                                        alt="{{object.author.name}}"></a></div>
                        </div>
                    </span>
                    <div class="AuthorInfo-content">
                        <div class="AuthorInfo-head"><span class="UserLink AuthorInfo-name">
                                <div class="Popover">
                                    <div id="Popover48-toggle" aria-haspopup="true" aria-expanded="false"
                                        aria-owns="Popover48-content"><a class="UserLink-link"
                                            data-za-detail-view-element_name="User" target="_blank"
                                            href="//www.zhihu.com/people/{{object.author.url_token}}">{{object.author.name}}</a></div>
                                </div>
                            </span></div>
                        <div class="AuthorInfo-detail">
                            <div class="AuthorInfo-badge">
                                <div class="ztext AuthorInfo-badgeText">orz</div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <meta itemprop="image" content="">
            <meta itemprop="upvoteCount" content="0">
            <meta itemprop="url" content="https://www.zhihu.com/question/{{object.question.id}}/answer/{{object.id}}">
            <meta itemprop="dateCreated" content="0">
            <meta itemprop="dateModified" content="0">
            <meta itemprop="commentCount" content="0">
            <div class="RichContent">
                <div class="RichContent-inner"><span class="RichText ztext CopyrightRichText-richText"
                        itemprop="text">{{object.content}}</span></div>
                <div class="ContentItem-actions"><span><button aria-label="赞同 0 " type="button"
                            class="Button VoteButton VoteButton--up"><span
                                style="display: inline-flex; align-items: center;">&#8203;<svg
                                    class="Zi Zi--TriangleUp VoteButton-TriangleUp" fill="currentColor" viewBox="0 0 24 24"
                                    width="10" height="10">
                                    <path
                                        d="M2 18.242c0-.326.088-.532.237-.896l7.98-13.203C10.572 3.57 11.086 3 12 3c.915 0 1.429.571 1.784 1.143l7.98 13.203c.15.364.236.57.236.896 0 1.386-.875 1.9-1.955 1.9H3.955c-1.08 0-1.955-.517-1.955-1.9z"
                                        fill-rule="evenodd"></path>
                                </svg></span>赞同 {{object.voteup_count}}</button><button aria-label="反对" type="button"
                            class="Button VoteButton VoteButton--down"><span
                                style="display: inline-flex; align-items: center;">&#8203;<svg class="Zi Zi--TriangleDown"
                                    fill="currentColor" viewBox="0 0 24 24" width="10" height="10">
                                    <path
                                        d="M20.044 3H3.956C2.876 3 2 3.517 2 4.9c0 .326.087.533.236.896L10.216 19c.355.571.87 1.143 1.784 1.143s1.429-.572 1.784-1.143l7.98-13.204c.149-.363.236-.57.236-.896 0-1.386-.876-1.9-1.956-1.9z"
                                        fill-rule="evenodd"></path>
                                </svg></span></button></span><button type="button"
                        class="Button ContentItem-action Button--plain Button--withIcon Button--withLabel"><span
                            style="display: inline-flex; align-items: center;">&#8203;<svg class="Zi Zi--Comment Button-zi"
                                fill="currentColor" viewBox="0 0 24 24" width="1.2em" height="1.2em">
                                <path
                                    d="M10.241 19.313a.97.97 0 0 0-.77.2 7.908 7.908 0 0 1-3.772 1.482.409.409 0 0 1-.38-.637 5.825 5.825 0 0 0 1.11-2.237.605.605 0 0 0-.227-.59A7.935 7.935 0 0 1 3 11.25C3 6.7 7.03 3 12 3s9 3.7 9 8.25-4.373 9.108-10.759 8.063z"
                                    fill-rule="evenodd"></path>
                            </svg></span>{{object.comment_count}} 条评论</button>
                    <div class="Popover ShareMenu ContentItem-action">
                        <div class="ShareMenu-toggler" id="Popover49-toggle" aria-haspopup="true" aria-expanded="false"
                            aria-owns="Popover49-content"><button type="button"
                                class="Button Button--plain Button--withIcon Button--withLabel"><span
                                    style="display: inline-flex; align-items: center;">&#8203;<svg
                                        class="Zi Zi--Share Button-zi" fill="currentColor" viewBox="0 0 24 24" width="1.2em"
                                        height="1.2em">
                                        <path
                                            d="M2.931 7.89c-1.067.24-1.275 1.669-.318 2.207l5.277 2.908 8.168-4.776c.25-.127.477.198.273.39L9.05 14.66l.927 5.953c.18 1.084 1.593 1.376 2.182.456l9.644-15.242c.584-.892-.212-2.029-1.234-1.796L2.93 7.89z"
                                            fill-rule="evenodd"></path>
                                    </svg></span>分享</button></div>
                    </div><button type="button"
                        class="Button ContentItem-action Button--plain Button--withIcon Button--withLabel"><span
                            style="display: inline-flex; align-items: center;">&#8203;<svg class="Zi Zi--Star Button-zi"
                                fill="currentColor" viewBox="0 0 24 24" width="1.2em" height="1.2em">
                                <path
                                    d="M5.515 19.64l.918-5.355-3.89-3.792c-.926-.902-.639-1.784.64-1.97L8.56 7.74l2.404-4.871c.572-1.16 1.5-1.16 2.072 0L15.44 7.74l5.377.782c1.28.186 1.566 1.068.64 1.97l-3.89 3.793.918 5.354c.219 1.274-.532 1.82-1.676 1.218L12 18.33l-4.808 2.528c-1.145.602-1.896.056-1.677-1.218z"
                                    fill-rule="evenodd"></path>
                            </svg></span>收藏</button><button type="button"
                        class="Button ContentItem-action Button--plain Button--withIcon Button--withLabel"><span
                            style="display: inline-flex; align-items: center;">&#8203;<svg class="Zi Zi--Heart Button-zi"
                                fill="currentColor" viewBox="0 0 24 24" width="1.2em" height="1.2em">
                                <path
                                    d="M2 8.437C2 5.505 4.294 3.094 7.207 3 9.243 3 11.092 4.19 12 6c.823-1.758 2.649-3 4.651-3C19.545 3 22 5.507 22 8.432 22 16.24 13.842 21 12 21 10.158 21 2 16.24 2 8.437z"
                                    fill-rule="evenodd"></path>
                            </svg></span>喜欢</button>
                </div>
            </div>
        </div>
    </div>
    `;

    const list_temp=`
    <div class="ListShortcut">
        <div class="List Profile-answers" id="Profile-answers" data-zop-feedlistfather="1">
            <div class="List-header">
                <h4 class="List-headerText"><span>他的回答</span></h4>
                <div class="List-headerOptions">
                    <div class="Popover"><button role="combobox" aria-expanded="false" id="Popover46-toggle"
                            aria-haspopup="true" aria-owns="Popover46-content" type="button"
                            class="Button InputLike InputButton Select-button Select-plainButton Button--plain">按时间排序<svg
                                class="Zi Zi--Select Select-arrow" fill="currentColor" viewBox="0 0 24 24" width="24"
                                height="24">
                                <path
                                    d="M12 16.183l2.716-2.966a.757.757 0 0 1 1.064.001.738.738 0 0 1 0 1.052l-3.247 3.512a.758.758 0 0 1-1.064 0L8.22 14.27a.738.738 0 0 1 0-1.052.758.758 0 0 1 1.063 0L12 16.183zm0-9.365L9.284 9.782a.758.758 0 0 1-1.064 0 .738.738 0 0 1 0-1.052l3.248-3.512a.758.758 0 0 1 1.065 0L15.78 8.73a.738.738 0 0 1 0 1.052.757.757 0 0 1-1.063.001L12 6.818z"
                                    fill-rule="evenodd"></path>
                            </svg></button></div>
                </div>
            </div>
            <div class="scroll">
            </div>
        </div>
    </div>
    `;


    const match=/people\/(\S+)/.exec(location.href);
    if(match&&match.length){
        const userid=match[1];
        let is_end=false,next=null,loading=false,update=0,hashid=0;
        window.addEventListener('DOMContentLoaded', () => {
            const div=document.querySelector('div.ProfileMainPrivacy-mainContentWrapper');
            if(!div)
                return;
            div.className="";
            div.innerHTML=list_temp;
            const target=document.querySelector('div.scroll');
            const load=(hash)=>{
                hashid=hash||hashid;
                if(!hashid)
                    return;
                loading=true;
                update=new Date().getTime();
                GM_xmlhttpRequest({
                    method: 'GET',
                    url: next||'https://api.zhihu.com/search_v3?correction=1&excerpt_len=150&q=%E7%9A%84%20&restricted_field=member_hash_id&restricted_scene=member&t=general&restricted_value='+hashid,
                    timeout: 5000,
                    onload: function(xhr) {
                        const parser=new DOMParser();
                        console.log(xhr);
                        const data=JSON.parse(xhr.responseText);
                        is_end=data.paging.is_end;
                        next=data.paging.next;
                        data.data.map((val)=>render(list_item_temp,val)).forEach(val=>{
                            const dom=parser.parseFromString(val,'text/html');
                            dom.querySelectorAll('.origin_image').forEach((val)=>val.src=val.dataset.original);
                            [].forEach.call(dom.body.children,e=>target.append(e));
                        });
                        loading=false;
                    }
                });
            };

            window.addEventListener('scroll', () => {
                if (is_end || loading||new Date().getTime() - update < 100||target.scrollHeight - window.scrollY > 1000 )
                    return;
                load();
            });

            if(userid.length==32)
                load(userid);
            else{
                GM_xmlhttpRequest({
                    method: 'GET',
                    url: 'https://www.zhihu.com/api/v4/members/'+userid,
                    timeout: 5000,
                    onload: xhr=>load(JSON.parse(xhr.responseText).id)
                });
            }
        });

    };

    const modify=(val)=>{
        if(!val)
            return;
        const div=val.querySelector('span.UserLink.AuthorInfo-name');
        if(div.children.length)
            return;
        if(!val.dataset.zaExtraModule){
            val.dataset.retry=(parseInt(val.dataset.retry)||0)+1;
            if(val.dataset.retry<10)
                setTimeout(modify.bind(this,val),500);
            return;
        }
        const author_member_hash_id=JSON.parse(val.dataset.zaExtraModule).card.content.author_member_hash_id;
        if(author_member_hash_id!='0')
            div.innerHTML="<a target=\"_blank\" href=https://www.zhihu.com/people/"+author_member_hash_id+">知乎用户</a>";

    };
    window.addEventListener('load',e=>{
        document.querySelectorAll('div.ContentItem.AnswerItem').forEach(modify);
        const div=document.querySelector('div.List');
        if(div)
            div.addEventListener('DOMNodeInserted',e=>e.target.querySelectorAll('div.ContentItem.AnswerItem').forEach(modify));
    });
    }//END

})();
