local UIAnim = require "widgets/uianim"
local Text = require "widgets/text"
local Widget = require "widgets/widget"
local Image = require "widgets/image"
local ImageButton = require "widgets/imagebutton"
local AnimButton = require "widgets/animbutton"
local HoverText = require "widgets/hoverer"
require "AllAchiv/allachivbalance"

local uiachievement = Class(Widget, function(self, owner)
	Widget._ctor(self, "uiachievement")
	self.owner = owner
	self.allachiv = self:AddChild(Widget("allachiv"))
	self.allachiv:SetPosition(0, 40, 0)
	self.allachiv:Hide()

	self.allcoin = self:AddChild(Widget("allcoin"))
	self.allcoin:SetPosition(0, 40, 0)
	self.allcoin:Hide()

	self.bigtitle = self:AddChild(Image("images/hud/bigtitle_cn.xml", "bigtitle_cn.tex"))
	self.bigtitle:SetPosition(0, 0, 0)
	self.bigtitle:SetTint(1,1,1,0.95)
	self.bigtitle:SetScale(.9,.9,1)
	self.bigtitle:MoveToFront()
	self.bigtitle:Hide()

	self.coinamount = self:AddChild(Text(NEWFONT_OUTLINE, 40, self.owner.currentcoinamount:value()))
	self.coinamount:SetPosition(85, -20, 0)
	self.coinamount:Hide()

	self.mainbutton = self:AddChild(Widget("mainbutton"))
	self.mainbutton:SetPosition(-1000, 150, 0)
	self.mainbutton:SetScale(1.2,1.2,1)

	self.mainbutton.checkbuttonglow = self.mainbutton:AddChild(Image("images/button/checkbuttonglow.xml", "checkbuttonglow.tex"))
    self.mainbutton.checkbuttonglow:SetClickable(false)
    self.mainbutton.checkbuttonglow:Hide()

    self.mainbutton.checkbutton = self.mainbutton:AddChild(ImageButton("images/button/checkbutton.xml", "checkbutton.tex"))
    self.mainbutton.checkbutton:MoveToFront()
    self.mainbutton.checkbutton:SetHoverText("查看成就")

	self.mainbutton.checkbutton:SetOnGainFocus(function() self.mainbutton.checkbuttonglow:Show() end)
	self.mainbutton.checkbutton:SetOnLoseFocus(function() self.mainbutton.checkbuttonglow:Hide() end)
	self.mainbutton.checkbutton:SetOnClick(function()
		if self.allachiv.shown then
			self.allachiv:Hide()
			self.bigtitle:Hide()
			self.coinamount:Hide()
			self.infobutton:Hide()
		else
			self.allachiv:Show()
			self.bigtitle:Show()
			self.coinamount:Show()
			self.infobutton:Show()
			self.allcoin:Hide()
		end
		self.maxnumpage = math.ceil(#self.achivlist/14)
		if self.numpage == 1 then
			self.infobutton.last:SetTextures("images/button/last_dact.xml", "last_dact.tex")
		else
			self.infobutton.last:SetTextures("images/button/last_act.xml", "last_act.tex")
		end
		if self.numpage >= self.maxnumpage then
			self.infobutton.next:SetTextures("images/button/next_dact.xml", "next_dact.tex")
		else
			self.infobutton.next:SetTextures("images/button/next_act.xml", "next_act.tex")
		end
	end)

	self.mainbutton.coinbuttonglow = self.mainbutton:AddChild(Image("images/button/coinbuttonglow.xml", "coinbuttonglow.tex"))
    self.mainbutton.coinbuttonglow:SetClickable(false)
    self.mainbutton.coinbuttonglow:Hide()
    self.mainbutton.coinbuttonglow:SetPosition(55, -5, 0)
    self.mainbutton.coinbuttonglow:SetScale(.9,.9,1)

    self.mainbutton.coinbutton = self.mainbutton:AddChild(ImageButton("images/button/coinbutton.xml", "coinbutton.tex"))
    self.mainbutton.coinbutton:MoveToFront()
    self.mainbutton.coinbutton:SetPosition(55, -5, 0)
    self.mainbutton.coinbutton:SetScale(.9,.9,1)
    self.mainbutton.coinbutton:SetHoverText("交换奖励")

	self.mainbutton.coinbutton:SetOnGainFocus(function() self.mainbutton.coinbuttonglow:Show() end)
	self.mainbutton.coinbutton:SetOnLoseFocus(function() self.mainbutton.coinbuttonglow:Hide() end)
	self.mainbutton.coinbutton:SetOnClick(function()
		if self.allcoin.shown then
			self.allcoin:Hide()
			self.bigtitle:Hide()
			self.coinamount:Hide()
			self.infobutton:Hide()
		else
			self.allcoin:Show()
			self.bigtitle:Show()
			self.coinamount:Show()
			self.infobutton:Show()
			self.allachiv:Hide()
		end
		self.infobutton.last:SetTextures("images/button/last_dact.xml", "last_dact.tex")
		self.infobutton.next:SetTextures("images/button/next_dact.xml", "next_dact.tex")
	end)

	self.infobutton = self:AddChild(Widget("infobutton"))
	self.infobutton:SetPosition(240, -450, 0)
	self.infobutton:Hide()

	self.infobutton.info = self.infobutton:AddChild(Image("images/button/info.xml", "info.tex"))
	self.infobutton.info:Hide()

	self.infobutton.question = self.infobutton:AddChild(ImageButton("images/button/infobutton.xml", "infobutton.tex"))
	self.infobutton.question:SetPosition(40, -370, 0)
	self.infobutton.question:SetOnClick(function()
		if self.infobutton.info.shown then
			self.infobutton.info:Hide()
		else
			self.infobutton.info:Show()
		end
	end)

	self.infobutton.last = self.infobutton:AddChild(ImageButton("images/button/last_dact.xml", "last_dact.tex"))
	self.infobutton.last:SetPosition(98, -370, 0)
	self.infobutton.last:SetOnClick(function()
		if self.numpage > 1 and self.allachiv.shown then
			self.numpage = self.numpage - 1
			self:build()
			self.infobutton.next:SetTextures("images/button/next_act.xml", "next_act.tex")
		end
		if self.numpage == 1 then
			self.infobutton.last:SetTextures("images/button/last_dact.xml", "last_dact.tex")
		end
	end)

	self.infobutton.next = self.infobutton:AddChild(ImageButton("images/button/next_act.xml", "next_act.tex"))
	self.infobutton.next:SetPosition(161, -370, 0)
	self.infobutton.next:SetOnClick(function()
		if self.numpage < self.maxnumpage and self.allachiv.shown then
			self.numpage = self.numpage + 1
			self:build()
			self.infobutton.last:SetTextures("images/button/last_act.xml", "last_act.tex")
		end
		if self.numpage == self.maxnumpage then
			self.infobutton.next:SetTextures("images/button/next_dact.xml", "next_dact.tex")
		end
	end)

	self.infobutton.close = self.infobutton:AddChild(ImageButton("images/button/close.xml", "close.tex"))
	self.infobutton.close:SetPosition(220, -370, 0)
	self.infobutton.close:SetOnClick(function()
		self.allachiv:Hide()
		self.allcoin:Hide()
		self.bigtitle:Hide()
		self.coinamount:Hide()
		self.infobutton:Hide()
	end)

	self.inst:DoTaskInTime(.2, function()
		self.numpage = 1
		self:loadlist()
		self:loadcoinlist()
		self.maxnumpage = math.ceil(#self.achivlist/14)
		self.achivlistbg = {}
		self.achivlisttile = {}
		self.coinlistbutton = {}
		self:build()
		self:coinbuild()
		self:StartUpdating()
	end)
end)

function uiachievement:OnUpdate(dt)
	self.coinamount:SetString(self.owner.currentcoinamount:value())

	self:loadlist()
	for i = 1+14*(self.numpage-1), math.min(#self.achivlist, 14*(1+self.numpage-1)) do
		local check = "dact"
    	if self.achivlist[i].check == 1 then check = "act" end
		self.achivlistbg[i]:SetTexture("images/hud/achivbg_"..check..".xml", "achivbg_"..check..".tex")

    	self.achivlisttile[i]:SetTexture("images/hud/achivtile_"..check.."_"..TUNING.AllAchivLan.."_"..self.achivlist[i].name..".xml", "achivtile_"..check.."_"..TUNING.AllAchivLan.."_"..self.achivlist[i].name..".tex")
    	if allachiv_eventdata[self.achivlist[i].name] ~= nil and self.achivlist[i].name ~= "king" and self.achivlist[i].name ~= "all" then
    		self.achivlisttile[i]:SetHoverText("已完成："..self.achivlist[i].current.."/"..allachiv_eventdata[self.achivlist[i].name])
    	else
    		self.achivlisttile[i]:SetHoverText("已完成："..self.achivlist[i].check.."/1")
    	end
    	if self.achivlist[i].name == "king" then
    		self.achivlisttile[i]:SetHoverText("已完成：春(鹿角鹅)"..self.achivlist[i].current1.."  夏(龙蝇)"..self.achivlist[i].current2.."  秋(熊灌)"..self.achivlist[i].current3.."  冬(独眼巨鹿)"..self.achivlist[i].current4)
    	end
    	if self.achivlist[i].name == "all" then
    		self.achivlisttile[i]:SetHoverText("已完成："..self.achivlist[i].current.."/"..(#self.achivlist-1))
    	end
	end

	self:loadcoinlist()
	for i = 1+28*(self.numpage-1), math.min(#self.coinlist, 28*(1+self.numpage-1)) do
		self.coinlistbutton[i]:SetHoverText("已获得：x"..self.coinlist[i].current)
	end
end

function uiachievement:build()
	self.allachiv:KillAllChildren()
	local x = 240
	local y = -97.5
	for i = 1+14*(self.numpage-1), math.min(#self.achivlist, 14*(1+self.numpage-1)) do
		if math.ceil(i/2) ~= i/2 then x = -240 else x = 240 end
		if math.ceil(i/2) ~= i/2 then y = y-97.5 end

		local check = "dact"
    	if self.achivlist[i].check == 1 then check = "act" end
		self.achivlistbg[i] = self.allachiv:AddChild(Image("images/hud/achivbg_"..check..".xml", "achivbg_"..check..".tex"))
		self.achivlistbg[i]:SetPosition(x, y, 0)
    	self.achivlistbg[i]:SetTint(1,1,1,0.95)

    	self.achivlisttile[i] = self.allachiv:AddChild(Image("images/hud/achivtile_"..check.."_"..TUNING.AllAchivLan.."_"..self.achivlist[i].name..".xml", "achivtile_"..check.."_"..TUNING.AllAchivLan.."_"..self.achivlist[i].name..".tex"))
		self.achivlisttile[i]:SetPosition(x, y, 0)
    	self.achivlisttile[i]:SetTint(1,1,1,0.95)
    	if allachiv_eventdata[self.achivlist[i].name] ~= nil and self.achivlist[i].name ~= "king" and self.achivlist[i].name ~= "all" then
    		self.achivlisttile[i]:SetHoverText("已完成："..self.achivlist[i].current.."/"..allachiv_eventdata[self.achivlist[i].name])
    	else
    		self.achivlisttile[i]:SetHoverText("已完成："..self.achivlist[i].check.."/1")
    	end
    	if self.achivlist[i].name == "king" then
    		self.achivlisttile[i]:SetHoverText("已完成：春(鹿角鹅):"..self.achivlist[i].current1.." 夏(龙蝇):"..self.achivlist[i].current2.." 秋(熊灌):"..self.achivlist[i].current3.." 冬(独眼巨鹿):"..self.achivlist[i].current4)
    	end
    	if self.achivlist[i].name == "all" then
    		self.achivlisttile[i]:SetHoverText("已完成："..self.achivlist[i].current.."/"..(#self.achivlist-1))
    	end
	end
end

function uiachievement:coinbuild()
	self.allcoin:KillAllChildren()
	local x = -360
	local y = -192.5
	for i = 1+28*(self.numpage-1), math.min(#self.coinlist, 28*(1+self.numpage-1)) do
		if math.ceil(i/4) ~= math.ceil((i-1)/4) then x = -360 else x = x + 360*2/3 end
		y = -192.5-96*(math.ceil(i/4)-1)

		self.coinlistbutton[i] = self.allcoin:AddChild(ImageButton("images/coin/"..self.coinlist[i].name..".xml", self.coinlist[i].name..".tex"))
		self.coinlistbutton[i]:SetPosition(x, y, 0)
    	self.coinlistbutton[i]:SetImageNormalColour(1,1,1,0.95)
    	self.coinlistbutton[i]:SetOnClick(function()
    		SendModRPCToServer(MOD_RPC["DST综合成就系统"][self.coinlist[i].name])
		end)
		self.coinlistbutton[i]:SetNormalScale(1,1,1)
    	self.coinlistbutton[i]:SetFocusScale(1.02,1.02,1)
		self.coinlistbutton[i]:SetHoverText("已获得：x"..self.coinlist[i].current)
	end
end

function uiachievement:loadlist()
	self.achivlist = {
		{
			name = "intogame",
			check = self.owner.checkintogame:value(),
			current = nil,
		},
		{
			name = "firsteat",
			check = self.owner.checkfirsteat:value(),
			current = nil,
		},
		{
			name = "supereat",
			check = self.owner.checksupereat:value(),
			current = self.owner.currenteatamount:value(),
		},
		{
			name = "danding",
			check = self.owner.checkdanding:value(),
			current = self.owner.currenteatmonsterlasagna:value(),
		},
		{
			name = "messiah",
			check = self.owner.checkmessiah:value(),
			current = self.owner.currentrespawnamount:value(),
		},
		{
			name = "walkalot",
			check = self.owner.checkwalkalot:value(),
			current = self.owner.currentwalktime:value(),
		},
		{
			name = "stopalot",
			check = self.owner.checkstopalot:value(),
			current = self.owner.currentstoptime:value(),
		},
		{
			name = "tooyoung",
			check = self.owner.checktooyoung:value(),
			current = nil,
		},
		{
			name = "evil",
			check = self.owner.checkevil:value(),
			current = self.owner.currentevilamount:value(),
		},
		{
			name = "snake",
			check = self.owner.checksnake:value(),
			current = self.owner.currentsnakeamount:value(),
		},
		{
			name = "deathalot",
			check = self.owner.checkdeathalot:value(),
			current = self.owner.currentdeathamouth:value(),
		},
		{
			name = "nosanity",
			check = self.owner.checknosanity:value(),
			current = self.owner.currentnosanitytime:value(),
		},
		{
			name = "sick",
			check = self.owner.checksick:value(),
			current = nil,
		},
		{
			name = "coldblood",
			check = self.owner.checkcoldblood:value(),
			current = nil,
		},
		{
			name = "burn",
			check = self.owner.checkburn:value(),
			current = nil,
		},
		{
			name = "freeze",
			check = self.owner.checkfreeze:value(),
			current = nil,
		},
		{
			name = "goodman",
			check = self.owner.checkgoodman:value(),
			current = self.owner.currentfriendpig:value(),
		},
		{
			name = "brother",
			check = self.owner.checkbrother:value(),
			current = self.owner.currentfriendbunny:value(),
		},
		{
			name = "fishmaster",
			check = self.owner.checkfishmaster:value(),
			current = self.owner.currentfishamount:value(),
		},
		{
			name = "pickmaster",
			check = self.owner.checkpickmaster:value(),
			current = self.owner.currentpickamount:value(),
		},
		{
			name = "chopmaster",
			check = self.owner.checkchopmaster:value(),
			current = self.owner.currentchopamount:value(),
		},
		{
			name = "cookmaster",
			check = self.owner.checkcookmaster:value(),
			current = self.owner.currentcookamount:value(),
		},
		{
			name = "buildmaster",
			check = self.owner.checkbuildmaster:value(),
			current = self.owner.currentbuildamount:value(),
		},
		{
			name = "longage",
			check = self.owner.checklongage:value(),
			current = self.owner.currentage:value(),
		},
		{
			name = "noob",
			check = self.owner.checknoob:value(),
			current = nil,
		},
		{
			name = "luck",
			check = self.owner.checkluck:value(),
			current = nil,
		},
		{
			name = "black",
			check = self.owner.checkblack:value(),
			current = nil,
		},
		{
			name = "tank",
			check = self.owner.checktank:value(),
			current = self.owner.currentattackeddamage:value(),
		},
		{
			name = "angry",
			check = self.owner.checkangry:value(),
			current = self.owner.currentonhitdamage:value(),
		},
		{
			name = "icebody",
			check = self.owner.checkicebody:value(),
			current = self.owner.currenticetime:value(),
		},
		{
			name = "firebody",
			check = self.owner.checkfirebody:value(),
			current = self.owner.currentfiretime:value(),
		},
		{
			name = "moistbody",
			check = self.owner.checkmoistbody:value(),
			current = self.owner.currentmoisttime:value(),
		},
		{
			name = "rigid",
			check = self.owner.checkrigid:value(),
			current = nil,
		},
		{
			name = "ancient",
			check = self.owner.checkancient:value(),
			current = nil,
		},
		{
			name = "queen",
			check = self.owner.checkqueen:value(),
			current = nil,
		},
		{
			name = "king",
			check = self.owner.checkking:value(),
			current1 = self.owner.checkbossspring:value(),
			current2 = self.owner.checkbossdragonfly:value(),
			current3 = self.owner.checkbossautumn:value(),
			current4 = self.owner.checkbosswinter:value(),
		},
		{
			name = "all",
			check = self.owner.checkall:value(),
			current = 0,
		},
	}

	local achivvalue = 0
	for i=1, #self.achivlist do
		if self.achivlist[i].name ~= "all" then
			achivvalue = achivvalue + self.achivlist[i].check
		else
			self.achivlist[i].current = achivvalue
		end
	end
end

function uiachievement:loadcoinlist()
	self.coinlist = {
		{
			name = "hungerup",
			current = self.owner.currenthungerup:value(),
		},
		{
			name = "sanityup",
			current = self.owner.currentsanityup:value(),
		},
		{
			name = "healthup",
			current = self.owner.currenthealthup:value(),
		},
		{
			name = "hungerrateup",
			current = self.owner.currenthungerrateup:value(),
		},
		{
			name = "healthregen",
			current = self.owner.currenthealthregen:value(),
		},
		{
			name = "sanityregen",
			current = self.owner.currentsanityregen:value(),
		},
		{
			name = "speedup",
			current = self.owner.currentspeedup:value(),
		},
		{
			name = "damageup",
			current = self.owner.currentdamageup:value(),
		},
		{
			name = "absorbup",
			current = self.owner.currentabsorbup:value(),
		},
		{
			name = "crit",
			current = self.owner.currentcrit:value(),
		},
		{
			name = "fireflylight",
			current = self.owner.currentfireflylight:value(),
		},
		{
			name = "nomoist",
			current = self.owner.currentnomoist:value(),
		},
		{
			name = "doubledrop",
			current = self.owner.currentdoubledrop:value(),
		},
		{
			name = "goodman",
			current = self.owner.currentgoodman:value(),
		},
		{
			name = "fishmaster",
			current = self.owner.currentfishmaster:value(),
		},
		{
			name = "pickmaster",
			current = self.owner.currentpickmaster:value(),
		},
		{
			name = "chopmaster",
			current = self.owner.currentchopmaster:value(),
		},
		{
			name = "cookmaster",
			current = self.owner.currentcookmaster:value(),
		},
		{
			name = "buildmaster",
			current = self.owner.currentbuildmaster:value(),
		},
		{
			name = "refresh",
			current = self.owner.currentrefresh:value(),
		},
		{
			name = "icebody",
			current = self.owner.currenticebody:value(),
		},
		{
			name = "firebody",
			current = self.owner.currentfirebody:value(),
		},
		{
			name = "supply",
			current = self.owner.currentsupply:value(),
		},
	}
end

return uiachievement