/*
 * Decompiled with CFR 0.152.
 */
package data.hullmods;

import com.fs.starfarer.api.combat.BaseHullMod;
import com.fs.starfarer.api.combat.ShieldAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import org.lazywizard.lazylib.MathUtils;

public class NeutrinoBroadsideShield
extends BaseHullMod {
    private final int ARC_EXPAND_TO = 75;

    public void advanceInCombat(ShipAPI ship, float amount) {
        if (ship.getOriginalOwner() == -1) {
            return;
        }
        ShieldAPI shield = ship.getShield();
        if (shield != null && shield.isOn()) {
            float arcToExpand = 75.0f - ship.getHullSpec().getShieldSpec().getArc();
            float deg = Math.abs(MathUtils.getShortestRotation((float)ship.getFacing(), (float)ship.getShield().getFacing()));
            float arc = deg > 90.0f ? (165.0f - deg) / 60.0f : (deg - 15.0f) / 60.0f;
            arc = Math.max(0.0f, Math.min(1.0f, arc));
            arc *= arcToExpand;
            shield.setArc(arc += ship.getHullSpec().getShieldSpec().getArc());
        }
    }

    public boolean isApplicableToShip(ShipAPI ship) {
        return ship.getHullSpec().getHullId().startsWith("neutrino_") && ship.getShield() != null && ship.getShield().getType() == ShieldAPI.ShieldType.OMNI && (ship.getHullSize() == ShipAPI.HullSize.CAPITAL_SHIP || ship.getHullSize() == ShipAPI.HullSize.CRUISER);
    }

    public String getDescriptionParam(int index, ShipAPI.HullSize hullSize) {
        if (index == 0) {
            return "75";
        }
        return null;
    }
}

