/*
 * Decompiled with CFR 0.152.
 */
package data.hullmods;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.combat.ArmorGridAPI;
import com.fs.starfarer.api.combat.BaseHullMod;
import com.fs.starfarer.api.combat.CombatEngineAPI;
import com.fs.starfarer.api.combat.CombatEntityAPI;
import com.fs.starfarer.api.combat.DamageType;
import com.fs.starfarer.api.combat.MutableShipStatsAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.combat.ShipwideAIFlags;
import com.fs.starfarer.api.util.IntervalUtil;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.combat.CombatEngine;
import com.fs.starfarer.combat.entities.Ship;
import data.scripts.plugins.Neutrino_LocalData;
import java.awt.Color;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lazywizard.lazylib.CollisionUtils;
import org.lazywizard.lazylib.MathUtils;
import org.lazywizard.lazylib.combat.entities.AnchoredEntity;
import org.lwjgl.util.vector.Vector2f;

public class NeutrinoNeutroniumPlating
extends BaseHullMod {
    private static final String KEY = "Neutrino_LocalData";
    public static final float ARMOR_DAMAGE_REDUCTION_PERCENT = -5.0f;
    public static final float POWER_ARMOR_ACTIVE_THRESHOLD = 0.3f;
    public static final float ARMOR_RESTORE_DELAY = 2.0f;
    public static final float ARMOR_RESTORE_BREAK_THRESHOLD = 20.0f;
    public static final float HULL_DAMAGE_TAKEN_MULT_WHILE_ACTIVE = 0.1f;
    public static final float ENGINE_AND_WEAPON_DAMAGE_TAKEN_MULT_WHILE_ACTIVE = 0.75f;
    public static final float EMP_DAMAGE_TAKEN_MULT = 0.75f;
    public static final float CORONA_EFFECT_REDUCTION = 0.2f;
    public static final float VENTING_MULT = 0.5f;
    public static final float LOW_CR_THRESHOLD = 0.4f;
    private static final Color Color1 = new Color(150, 200, 100, 50);
    private static final Color Color2 = new Color(150, 150, 150, 50);
    private static final Color Color3 = new Color(200, 200, 200, 50);
    private static final Map<ShipAPI.HullSize, Float> POWER_ARMOR_BONUS_PERCENT = new HashMap<ShipAPI.HullSize, Float>();
    private static final Map<ShipAPI.HullSize, Float> POWER_ARMOR_BONUS_MULT = new HashMap<ShipAPI.HullSize, Float>();
    private static final Map<ShipAPI.HullSize, Float> POWER_ARMOR_FULL_RESTORE_TIME = new HashMap<ShipAPI.HullSize, Float>();
    private String id;
    private float extraArmor = 0.0f;
    private static final float ACR_VFX_THRESHOLD = 0.7f;
    private final float overloadWhenCollapse = 2.0f;

    public final void refleshArmorDamageDecal(ShipAPI ship) throws NoSuchMethodException {
        Ship s = (Ship)ship;
        s.syncWithArmorGridState();
        s.syncWeaponDecalsWithArmorDamage();
    }

    public final PowerAromr powerArmorAdvance(ShipAPI ship, Map<ShipAPI, PowerAromr> powerAromrState, float amount) {
        PowerAromr powerAromr = powerAromrState.get(ship);
        if (powerAromr == null) {
            powerAromr = new PowerAromr(ship);
            powerAromrState.put(ship, powerAromr);
            return powerAromr;
        }
        if (powerAromr.justPaused) {
            ArmorGridAPI armorGrid = ship.getArmorGrid();
            powerAromr.powerArmorPerCell = powerAromr.active ? powerAromr.maxPowerArmorPerCell * powerAromr.extarArmor / powerAromr.maxExtarArmor : 0.0f;
            for (int i = 0; i < powerAromr.x; ++i) {
                for (int j = 0; j < powerAromr.y; ++j) {
                    armorGrid.setArmorValue(i, j, Math.min(powerAromr.maxArmorPerCell, Math.max(0.0f, powerAromr.armorValueWithoutPlating[i][j] + powerAromr.powerArmorPerCell)));
                }
            }
            powerAromr.justPaused = false;
            return powerAromr;
        }
        ArmorGridAPI armorGrid = powerAromr.ship.getArmorGrid();
        if (powerAromr.active) {
            int j;
            int i;
            powerAromr.reflashInterval.advance(amount);
            powerAromr.justRestore = false;
            if (ship.getFluxTracker().isOverloaded() && ship.getFluxTracker().getOverloadTimeRemaining() > 1.0f) {
                powerAromr.extarArmor = 0.0f;
                powerAromr.active = false;
                powerAromr.justDown = true;
                powerAromr.powerArmorPerCell = 0.0f;
                for (int i2 = 0; i2 < powerAromr.x; ++i2) {
                    for (int j2 = 0; j2 < powerAromr.y; ++j2) {
                        armorGrid.setArmorValue(i2, j2, Math.min(powerAromr.maxArmorPerCell, Math.max(0.0f, powerAromr.armorValueWithoutPlating[i2][j2])));
                    }
                }
                this.unapplyBuffs(ship);
                powerAromrState.put(ship, powerAromr);
                powerAromr.overloadColorChangeTimer = 2.0f;
                return powerAromr;
            }
            float damageOnArmor = 0.0f;
            for (i = 0; i < powerAromr.x; ++i) {
                for (j = 0; j < powerAromr.y; ++j) {
                    float damageOnThisCell = powerAromr.armorValueWithoutPlating[i][j] + powerAromr.powerArmorPerCell - armorGrid.getArmorValue(i, j);
                    if (damageOnThisCell < 0.0f) {
                        powerAromr.armorValueWithoutPlating[i][j] = Math.min(powerAromr.maxArmorPerCell - powerAromr.maxPowerArmorPerCell, powerAromr.armorValueWithoutPlating[i][j] - damageOnThisCell);
                        continue;
                    }
                    if (!(damageOnThisCell > 0.0f)) continue;
                    damageOnArmor += damageOnThisCell;
                }
            }
            if (powerAromr.ship.getHitpoints() < powerAromr.hullPointAtLastFrame) {
                damageOnArmor += (powerAromr.hullPointAtLastFrame - powerAromr.ship.getHitpoints()) * 9.0f;
            }
            if (damageOnArmor > 0.0f) {
                powerAromr.extarArmor -= damageOnArmor;
                powerAromr.hullPointAtLastFrame = powerAromr.ship.getHitpoints();
                powerAromr.atFullStrength = false;
                if (powerAromr.extarArmor <= 0.0f) {
                    powerAromr.extarArmor = 0.0f;
                    powerAromr.active = false;
                    powerAromr.justDown = true;
                }
                if (damageOnArmor > 20.0f * POWER_ARMOR_BONUS_MULT.get(ship.getHullSize()).floatValue() * amount) {
                    powerAromr.sinceLastDamage = 0.0f;
                    powerAromr.shouldRegan = false;
                }
            } else {
                if (powerAromr.atFullStrength) {
                    if (powerAromr.justFull) {
                        powerAromr.justFull = false;
                        powerAromrState.put(ship, powerAromr);
                    }
                    return powerAromr;
                }
                powerAromr.sinceLastDamage += amount;
                boolean bl = powerAromr.shouldRegan = powerAromr.sinceLastDamage > 2.0f && !powerAromr.atFullStrength;
            }
            if (powerAromr.justDown) {
                powerAromr.powerArmorPerCell = 0.0f;
                for (i = 0; i < powerAromr.x; ++i) {
                    for (j = 0; j < powerAromr.y; ++j) {
                        armorGrid.setArmorValue(i, j, Math.min(powerAromr.maxArmorPerCell, Math.max(0.0f, powerAromr.armorValueWithoutPlating[i][j])));
                    }
                }
                ship.getFluxTracker().beginOverloadWithTotalBaseDuration(2.0f);
                powerAromr.overloadColorChangeTimer = 2.0f;
            } else {
                if (powerAromr.shouldRegan) {
                    powerAromr.extarArmor += powerAromr.extarArmorRegenPerSec * amount;
                    if (powerAromr.extarArmor > powerAromr.maxExtarArmor) {
                        powerAromr.extarArmor = powerAromr.maxExtarArmor;
                        powerAromr.justFull = true;
                        powerAromr.atFullStrength = true;
                    }
                }
                powerAromr.powerArmorPerCell = powerAromr.maxPowerArmorPerCell * powerAromr.extarArmor / powerAromr.maxExtarArmor;
                for (i = 0; i < powerAromr.x; ++i) {
                    for (j = 0; j < powerAromr.y; ++j) {
                        armorGrid.setArmorValue(i, j, Math.min(powerAromr.maxArmorPerCell, Math.max(0.0f, powerAromr.armorValueWithoutPlating[i][j] + powerAromr.powerArmorPerCell)));
                    }
                }
            }
            this.applyPowerAromrBuffs(ship, powerAromr);
            powerAromrState.put(ship, powerAromr);
            return powerAromr;
        }
        powerAromr.justDown = false;
        powerAromr.extarArmor = ship.getFluxTracker().isOverloaded() ? 0.0f : (powerAromr.extarArmor += powerAromr.extarArmorRegenPerSec * amount);
        if (powerAromr.extarArmor >= powerAromr.resetThreshold) {
            powerAromr.justRestore = true;
            powerAromr.active = true;
            powerAromr.powerArmorPerCell = powerAromr.maxPowerArmorPerCell * powerAromr.extarArmor / powerAromr.maxExtarArmor;
            powerAromr.hullPointAtLastFrame = powerAromr.ship.getHitpoints();
            for (int i = 0; i < powerAromr.x; ++i) {
                for (int j = 0; j < powerAromr.y; ++j) {
                    powerAromr.armorValueWithoutPlating[i][j] = Math.min(armorGrid.getArmorValue(i, j), powerAromr.maxArmorPerCell - powerAromr.maxPowerArmorPerCell);
                    armorGrid.setArmorValue(i, j, Math.min(powerAromr.maxArmorPerCell, Math.max(0.0f, powerAromr.armorValueWithoutPlating[i][j]) + powerAromr.powerArmorPerCell));
                }
            }
            powerAromr.shouldRegan = true;
        }
        this.unapplyBuffs(ship);
        powerAromrState.put(ship, powerAromr);
        return powerAromr;
    }

    public final void applyPowerAromrBuffs(ShipAPI ship, PowerAromr powerAromr) {
        MutableShipStatsAPI stats = ship.getMutableStats();
        float mult = Math.min(ship.getCurrentCR() / 0.4f, 1.0f);
        if (ship.getFluxTracker().isVenting()) {
            mult *= 0.5f;
        } else if (ship.isPhased()) {
            mult = 100.0f;
        }
        stats.getEffectiveArmorBonus().modifyFlat(this.id, mult * powerAromr.extarArmor);
        stats.getHullDamageTakenMult().modifyMult(this.id, 0.1f);
        stats.getWeaponDamageTakenMult().modifyMult(this.id, 0.75f);
        stats.getEngineDamageTakenMult().modifyMult(this.id, 0.75f);
        stats.getEmpDamageTakenMult().modifyMult(this.id, 0.75f);
    }

    public final void unapplyBuffs(ShipAPI ship) {
        MutableShipStatsAPI stats = ship.getMutableStats();
        stats.getEffectiveArmorBonus().unmodify();
        stats.getHullDamageTakenMult().unmodify();
        stats.getWeaponDamageTakenMult().unmodify();
        stats.getEngineDamageTakenMult().unmodify();
        stats.getEmpDamageTakenMult().unmodify();
    }

    private Vector2f[] spawnRandomEMPArcOnShip(ShipAPI ship, String impactSoundId, float thickness, Color fringe, Color core) {
        float radius = ship.getCollisionRadius();
        Vector2f p1 = new Vector2f();
        for (int i = 0; !(i >= 25 || p1 != null && CollisionUtils.isPointWithinBounds((Vector2f)p1, (CombatEntityAPI)ship)); ++i) {
            p1 = MathUtils.getRandomPointInCircle((Vector2f)ship.getLocation(), (float)radius);
            if (i != 24) continue;
            return null;
        }
        AnchoredEntity arcFrom = new AnchoredEntity((CombatEntityAPI)ship, p1);
        Vector2f p2 = new Vector2f();
        for (int i = 0; !(i >= 25 || p2 != null && CollisionUtils.isPointWithinBounds((Vector2f)p2, (CombatEntityAPI)ship)); ++i) {
            p2 = MathUtils.getRandomPointInCircle((Vector2f)ship.getLocation(), (float)radius);
            if (i != 24) continue;
            return null;
        }
        AnchoredEntity arcTo = new AnchoredEntity((CombatEntityAPI)ship, p2);
        Global.getCombatEngine().spawnEmpArc(ship, arcFrom.getLocation(), (CombatEntityAPI)arcFrom, (CombatEntityAPI)arcTo, DamageType.OTHER, 0.0f, 0.0f, radius, impactSoundId, thickness, fringe, core);
        return new Vector2f[]{p1, p2};
    }

    private void changeOverloadColor(float amount, PowerAromr powerAromr) {
        if (powerAromr.overloadColorChangeTimer > 0.0f) {
            powerAromr.ship.setOverloadColor(Misc.interpolateColor((Color)Color1, (Color)Color.white, (float)(powerAromr.overloadColorChangeTimer / 2.0f)));
            powerAromr.overloadColorChangeTimer -= amount;
        } else {
            powerAromr.overloadColorChangeTimer = 0.0f;
            powerAromr.ship.resetOverloadColor();
        }
    }

    public void applyEffectsBeforeShipCreation(ShipAPI.HullSize hullSize, MutableShipStatsAPI stats, String id) {
        stats.getDynamic().getStat("corona_resistance").modifyMult(id, 0.2f);
        stats.getArmorDamageTakenMult().modifyPercent(id, -5.0f);
        stats.getEffectiveArmorBonus().modifyPercent(id, POWER_ARMOR_BONUS_PERCENT.get(hullSize).floatValue());
        stats.getHullDamageTakenMult().modifyMult(id, 0.1f);
        this.id = id;
    }

    public void applyEffectsAfterShipCreation(ShipAPI ship, String id) {
        this.extraArmor = ship.getArmorGrid().getArmorRating() * POWER_ARMOR_BONUS_PERCENT.get(ship.getHullSize()).floatValue() * POWER_ARMOR_BONUS_MULT.get(ship.getHullSize()).floatValue() * 0.01f;
    }

    public void advanceInCombat(ShipAPI ship, float amount) {
        if (ship.getOriginalOwner() == -1) {
            return;
        }
        CombatEngineAPI engine = Global.getCombatEngine();
        Neutrino_LocalData.LocalData localData = (Neutrino_LocalData.LocalData)Global.getCombatEngine().getCustomData().get(KEY);
        Map<ShipAPI, PowerAromr> powerAromrState = localData.powerAromrState;
        if (!ship.isAlive()) {
            if (powerAromrState.get(ship) != null) {
                this.powerArmorAdvance(ship, powerAromrState, POWER_ARMOR_FULL_RESTORE_TIME.get(ship.getHullSize()).floatValue());
                this.unapplyBuffs(ship);
                powerAromrState.remove(ship);
            }
            return;
        }
        if (powerAromrState.get(ship) == null) {
            this.powerArmorAdvance(ship, powerAromrState, amount);
        }
        if (ship.isPhased()) {
            if (powerAromrState.get(ship) != null) {
                this.applyPowerAromrBuffs(ship, powerAromrState.get(ship));
            }
            return;
        }
        if (((CombatEngine)engine).isCombatOver()) {
            if (powerAromrState.get(ship) != null) {
                this.powerArmorAdvance(ship, powerAromrState, POWER_ARMOR_FULL_RESTORE_TIME.get(ship.getHullSize()).floatValue());
                powerAromrState.remove(ship);
            }
            return;
        }
        PowerAromr powerAromr = this.powerArmorAdvance(ship, powerAromrState, amount);
        if (ship.getTravelDrive().isActive()) {
            this.powerArmorAdvance(ship, powerAromrState, POWER_ARMOR_FULL_RESTORE_TIME.get(ship.getHullSize()).floatValue());
        }
        if (powerAromr.active) {
            if (powerAromr.atFullStrength) {
                if (powerAromr.justFull) {
                    ship.setJitter((Object)ship, Color2, 0.25f, 5, 0.0f);
                    ship.setJitterUnder((Object)ship, Color2, 0.25f, 15, 2.0f, 5.0f);
                }
                ship.setJitter((Object)ship, Color2, 0.25f, 3, 0.0f);
                ship.setJitterUnder((Object)ship, Color2, 0.25f, 15, 2.0f, 5.0f);
            } else if (powerAromr.sinceLastDamage < 2.0f) {
                if ((double)powerAromr.sinceLastDamage < 0.1) {
                    ship.setJitter((Object)ship, Color3, 0.25f, 3, 0.0f);
                    ship.setJitterUnder((Object)ship, Color3, 0.25f, 15, 1.0f, 2.0f);
                } else {
                    float radio = powerAromr.sinceLastDamage / 2.0f;
                    ship.setJitter((Object)ship, Misc.interpolateColor((Color)Color1, (Color)Color3, (float)radio), 0.25f, 3, 0.0f);
                    ship.setJitterUnder((Object)ship, Misc.interpolateColor((Color)Color1, (Color)Color3, (float)radio), 0.25f, 15, 1.0f, 2.0f);
                }
            } else if (powerAromr.justRestore) {
                ship.setJitter((Object)ship, Color3, 0.25f, 3, 0.0f);
                ship.setJitterUnder((Object)ship, Color3, 0.25f, 15, 2.0f, 5.0f);
                Global.getSoundPlayer().playSound("neut_gravityplateactivate", 1.0f, 1.0f, ship.getLocation(), new Vector2f(0.0f, 0.0f));
            } else if (powerAromr.shouldRegan) {
                ship.setJitter((Object)ship, Color2, 0.25f, 5, 0.0f);
                ship.setJitterUnder((Object)ship, Color2, 0.25f, 20, 2.0f, 5.0f);
                ship.getMutableStats().getPeakCRDuration().modifyFlat(this.id, ship.getMutableStats().getPeakCRDuration().getFlatBonus(this.id) == null ? -amount : ship.getMutableStats().getPeakCRDuration().getFlatBonus(this.id).getValue() - amount);
            } else {
                ship.setJitter((Object)ship, Color2, 0.25f, 5, 0.0f);
                ship.setJitterUnder((Object)ship, Color2, 0.25f, 20, 2.0f, 5.0f);
            }
            if (powerAromr.reflashInterval.intervalElapsed()) {
                float aromrRadio = powerAromr.extarArmor / powerAromr.maxExtarArmor;
                try {
                    this.refleshArmorDamageDecal(ship);
                }
                catch (NoSuchMethodException ex) {
                    Logger.getLogger(NeutrinoNeutroniumPlating.class.getName()).log(Level.SEVERE, null, ex);
                }
                if (aromrRadio < 0.7f) {
                    int i = 0;
                    while ((float)i < POWER_ARMOR_BONUS_MULT.get(ship.getHullSize()).floatValue()) {
                        if (Math.random() > (double)(aromrRadio + 0.2f)) {
                            this.spawnRandomEMPArcOnShip(ship, null, 4.0f - aromrRadio * 5.0f, new Color(0, 0, 0, 0), Color1);
                        }
                        ++i;
                    }
                }
            }
        } else {
            if (ship.getAIFlags() != null) {
                ship.getAIFlags().setFlag(ShipwideAIFlags.AIFlags.BACK_OFF);
                ship.getAIFlags().setFlag(ShipwideAIFlags.AIFlags.NEEDS_HELP);
            }
            if (powerAromr.justDown) {
                Global.getSoundPlayer().playSound("neut_gravityplatebreak", 1.0f, 1.0f, ship.getLocation(), new Vector2f(0.0f, 0.0f));
                ship.setJitter((Object)ship, Color3, 0.2f, 12, 10.0f);
                int i = 0;
                while ((float)i < POWER_ARMOR_BONUS_MULT.get(ship.getHullSize()).floatValue() * 2.0f) {
                    this.spawnRandomEMPArcOnShip(ship, null, 15.0f, Color2, Color3);
                    ++i;
                }
            } else {
                ship.setJitter((Object)ship, new Color(0.0f, 0.0f, 0.0f, 0.0f), 0.2f, 1, 0.0f);
            }
        }
        this.changeOverloadColor(amount, powerAromr);
        localData.powerAromrState.putAll(powerAromrState);
    }

    public boolean isApplicableToShip(ShipAPI ship) {
        return ship.getHullSpec().getHullId().startsWith("neutrino_");
    }

    public String getDescriptionParam(int index, ShipAPI.HullSize hullSize) {
        if (index == 0) {
            return "" + POWER_ARMOR_BONUS_PERCENT.get(ShipAPI.HullSize.FRIGATE).intValue() + "/" + POWER_ARMOR_BONUS_PERCENT.get(ShipAPI.HullSize.DESTROYER).intValue() + "/" + POWER_ARMOR_BONUS_PERCENT.get(ShipAPI.HullSize.CRUISER).intValue() + "/" + POWER_ARMOR_BONUS_PERCENT.get(ShipAPI.HullSize.CAPITAL_SHIP).intValue();
        }
        if (index == 1) {
            return "5%";
        }
        if (index == 2) {
            return "" + (int)this.extraArmor;
        }
        if (index == 3) {
            return "25%";
        }
        if (index == 4) {
            return "90%";
        }
        if (index == 5) {
            return "75%";
        }
        if (index == 6) {
            return "2";
        }
        if (index == 7) {
            return "" + POWER_ARMOR_FULL_RESTORE_TIME.get(ShipAPI.HullSize.FRIGATE).intValue() + "/" + POWER_ARMOR_FULL_RESTORE_TIME.get(ShipAPI.HullSize.DESTROYER).intValue() + "/" + POWER_ARMOR_FULL_RESTORE_TIME.get(ShipAPI.HullSize.CRUISER).intValue() + "/" + POWER_ARMOR_FULL_RESTORE_TIME.get(ShipAPI.HullSize.CAPITAL_SHIP).intValue();
        }
        if (index == 8) {
            return "75%";
        }
        if (index == 9) {
            return "50";
        }
        return null;
    }

    static {
        POWER_ARMOR_BONUS_PERCENT.put(ShipAPI.HullSize.FIGHTER, Float.valueOf(50.0f));
        POWER_ARMOR_BONUS_PERCENT.put(ShipAPI.HullSize.FRIGATE, Float.valueOf(40.0f));
        POWER_ARMOR_BONUS_PERCENT.put(ShipAPI.HullSize.DESTROYER, Float.valueOf(35.0f));
        POWER_ARMOR_BONUS_PERCENT.put(ShipAPI.HullSize.CRUISER, Float.valueOf(32.5f));
        POWER_ARMOR_BONUS_PERCENT.put(ShipAPI.HullSize.CAPITAL_SHIP, Float.valueOf(30.0f));
        POWER_ARMOR_BONUS_MULT.put(ShipAPI.HullSize.FIGHTER, Float.valueOf(4.0f));
        POWER_ARMOR_BONUS_MULT.put(ShipAPI.HullSize.FRIGATE, Float.valueOf(4.0f));
        POWER_ARMOR_BONUS_MULT.put(ShipAPI.HullSize.DESTROYER, Float.valueOf(4.5f));
        POWER_ARMOR_BONUS_MULT.put(ShipAPI.HullSize.CRUISER, Float.valueOf(5.0f));
        POWER_ARMOR_BONUS_MULT.put(ShipAPI.HullSize.CAPITAL_SHIP, Float.valueOf(6.0f));
        POWER_ARMOR_FULL_RESTORE_TIME.put(ShipAPI.HullSize.FIGHTER, Float.valueOf(45.0f));
        POWER_ARMOR_FULL_RESTORE_TIME.put(ShipAPI.HullSize.FRIGATE, Float.valueOf(60.0f));
        POWER_ARMOR_FULL_RESTORE_TIME.put(ShipAPI.HullSize.DESTROYER, Float.valueOf(90.0f));
        POWER_ARMOR_FULL_RESTORE_TIME.put(ShipAPI.HullSize.CRUISER, Float.valueOf(105.0f));
        POWER_ARMOR_FULL_RESTORE_TIME.put(ShipAPI.HullSize.CAPITAL_SHIP, Float.valueOf(120.0f));
    }

    public static class PowerAromr {
        public final int x;
        public final int y;
        public float[][] armorValueWithoutPlating;
        public final float maxExtarArmor;
        public final float extarArmorRegenPerSec;
        public final float resetThreshold;
        public final float maxArmorPerCell;
        public final float maxPowerArmorPerCell;
        public float extarArmor;
        public float powerArmorPerCell;
        public float hullPointAtLastFrame;
        public float sinceLastDamage;
        public float overloadColorChangeTimer;
        public boolean active;
        public boolean atFullStrength;
        public boolean shouldRegan;
        public boolean justFull;
        public boolean justDown;
        public boolean justRestore;
        public boolean justPaused;
        public final ShipAPI ship;
        public final IntervalUtil reflashInterval = new IntervalUtil(0.2f, 1.0f);

        public PowerAromr(ShipAPI ship) {
            this.ship = ship;
            ArmorGridAPI armorGrid = ship.getArmorGrid();
            this.overloadColorChangeTimer = 0.0f;
            this.atFullStrength = true;
            this.active = true;
            this.justPaused = false;
            this.justRestore = false;
            this.justDown = false;
            this.justFull = false;
            this.shouldRegan = false;
            this.x = armorGrid.getGrid().length;
            this.y = armorGrid.getGrid()[0].length;
            this.maxArmorPerCell = armorGrid.getMaxArmorInCell();
            this.extarArmor = this.maxExtarArmor = ((Float)POWER_ARMOR_BONUS_PERCENT.get(ship.getHullSize())).floatValue() * 0.01f * armorGrid.getArmorRating() * ((Float)POWER_ARMOR_BONUS_MULT.get(ship.getHullSize())).floatValue();
            this.powerArmorPerCell = this.maxPowerArmorPerCell = ((Float)POWER_ARMOR_BONUS_PERCENT.get(ship.getHullSize())).floatValue() * 0.01f * armorGrid.getMaxArmorInCell();
            this.hullPointAtLastFrame = ship.getHitpoints();
            this.extarArmorRegenPerSec = this.maxExtarArmor / ((Float)POWER_ARMOR_FULL_RESTORE_TIME.get(ship.getHullSize())).floatValue();
            this.resetThreshold = this.maxExtarArmor * 0.3f;
            this.armorValueWithoutPlating = new float[this.x][this.y];
            for (int i = 0; i < this.x; ++i) {
                for (int j = 0; j < this.y; ++j) {
                    this.armorValueWithoutPlating[i][j] = Math.min(armorGrid.getArmorValue(i, j), Math.max(0.0f, this.maxArmorPerCell - this.maxPowerArmorPerCell));
                }
            }
        }
    }
}

