/*
 * Decompiled with CFR 0.152.
 */
package data.hullmods;

import com.fs.starfarer.api.combat.BaseHullMod;
import com.fs.starfarer.api.combat.MutableShipStatsAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import data.scripts.NCModPlugin;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class NeutrinoOmegaUpgrade
extends BaseHullMod {
    private static final Set<String> BLOCKED_HULLMODS = new HashSet<String>();
    private static final Map<ShipAPI.HullSize, Float> WEAPON_RANGE_BONUS;
    private static final Map<ShipAPI.HullSize, Float> WEAPON_RANGE_BONUS_SSP;
    private static final Map<ShipAPI.HullSize, Float> ARMOR_BONUS;
    public static final float HULL_BONUS = -25.0f;
    public static final float SHIELD_UPKEEP_BONUS = 50.0f;

    public void applyEffectsBeforeShipCreation(ShipAPI.HullSize hullSize, MutableShipStatsAPI stats, String id) {
        stats.getAutofireAimAccuracy().modifyFlat(id, 60.0f);
        if (NCModPlugin.SSPExists) {
            stats.getBallisticWeaponRangeBonus().modifyPercent(id, WEAPON_RANGE_BONUS_SSP.get(hullSize).floatValue());
            stats.getEnergyWeaponRangeBonus().modifyPercent(id, WEAPON_RANGE_BONUS_SSP.get(hullSize).floatValue());
        } else {
            stats.getBallisticWeaponRangeBonus().modifyPercent(id, WEAPON_RANGE_BONUS.get(hullSize).floatValue());
            stats.getEnergyWeaponRangeBonus().modifyPercent(id, WEAPON_RANGE_BONUS.get(hullSize).floatValue());
        }
        stats.getArmorBonus().modifyFlat(id, ARMOR_BONUS.get(hullSize).floatValue());
        stats.getHullBonus().modifyPercent(id, -25.0f);
        stats.getShieldUpkeepMult().modifyMult(id, 1.5f);
    }

    public String getDescriptionParam(int index, ShipAPI.HullSize hullSize) {
        if (index == 0) {
            return "" + WEAPON_RANGE_BONUS.get(ShipAPI.HullSize.FRIGATE).intValue();
        }
        if (index == 1) {
            return "" + WEAPON_RANGE_BONUS.get(ShipAPI.HullSize.DESTROYER).intValue();
        }
        if (index == 2) {
            return "" + WEAPON_RANGE_BONUS.get(ShipAPI.HullSize.CRUISER).intValue();
        }
        if (index == 3) {
            return "" + WEAPON_RANGE_BONUS.get(ShipAPI.HullSize.CAPITAL_SHIP).intValue();
        }
        if (index == 4) {
            return "" + ARMOR_BONUS.get(ShipAPI.HullSize.FRIGATE).intValue();
        }
        if (index == 5) {
            return "" + ARMOR_BONUS.get(ShipAPI.HullSize.DESTROYER).intValue();
        }
        if (index == 6) {
            return "" + ARMOR_BONUS.get(ShipAPI.HullSize.CRUISER).intValue();
        }
        if (index == 7) {
            return "" + ARMOR_BONUS.get(ShipAPI.HullSize.CAPITAL_SHIP).intValue();
        }
        if (index == 8) {
            return "25%";
        }
        if (index == 9) {
            return "50%";
        }
        return null;
    }

    public void applyEffectsAfterShipCreation(ShipAPI ship, String id) {
        if (ship.getOriginalOwner() == -1) {
            for (String tmp : BLOCKED_HULLMODS) {
                if (!ship.getVariant().getHullMods().contains(tmp)) continue;
                ship.getVariant().removeMod(tmp);
            }
        }
    }

    public boolean isApplicableToShip(ShipAPI ship) {
        return ship.getHullSpec().getHullId().startsWith("neutrino_") && !ship.getVariant().getHullMods().contains("dedicated_targeting_core") && !ship.getVariant().getHullMods().contains("targetingunit") && !ship.getVariant().getHullMods().contains("advancedcore");
    }

    public String getUnapplicableReason(ShipAPI ship) {
        if (!ship.getHullSpec().getHullId().startsWith("neutrino_")) {
            return "Can only be installed on Neutrino ships";
        }
        if (ship.getVariant().getHullMods().contains("dedicated_targeting_core")) {
            return "Incompatible with Dedicated Targeting Core";
        }
        if (ship.getVariant().getHullMods().contains("targetingunit")) {
            return "Incompatible with Integrated Targeting Unit";
        }
        if (ship.getVariant().getHullMods().contains("advancedcore")) {
            return "Incompatible with Advanced Targeting Core";
        }
        return null;
    }

    static {
        BLOCKED_HULLMODS.add("targetingunit");
        BLOCKED_HULLMODS.add("dedicated_targeting_core");
        WEAPON_RANGE_BONUS = new HashMap<ShipAPI.HullSize, Float>();
        WEAPON_RANGE_BONUS.put(ShipAPI.HullSize.FIGHTER, Float.valueOf(0.0f));
        WEAPON_RANGE_BONUS.put(ShipAPI.HullSize.FRIGATE, Float.valueOf(5.0f));
        WEAPON_RANGE_BONUS.put(ShipAPI.HullSize.DESTROYER, Float.valueOf(15.0f));
        WEAPON_RANGE_BONUS.put(ShipAPI.HullSize.CRUISER, Float.valueOf(30.0f));
        WEAPON_RANGE_BONUS.put(ShipAPI.HullSize.CAPITAL_SHIP, Float.valueOf(45.0f));
        WEAPON_RANGE_BONUS_SSP = new HashMap<ShipAPI.HullSize, Float>();
        WEAPON_RANGE_BONUS_SSP.put(ShipAPI.HullSize.FIGHTER, Float.valueOf(0.0f));
        WEAPON_RANGE_BONUS_SSP.put(ShipAPI.HullSize.FRIGATE, Float.valueOf(15.0f));
        WEAPON_RANGE_BONUS_SSP.put(ShipAPI.HullSize.DESTROYER, Float.valueOf(15.0f));
        WEAPON_RANGE_BONUS_SSP.put(ShipAPI.HullSize.CRUISER, Float.valueOf(15.0f));
        WEAPON_RANGE_BONUS_SSP.put(ShipAPI.HullSize.CAPITAL_SHIP, Float.valueOf(15.0f));
        ARMOR_BONUS = new HashMap<ShipAPI.HullSize, Float>();
        ARMOR_BONUS.put(ShipAPI.HullSize.FRIGATE, Float.valueOf(50.0f));
        ARMOR_BONUS.put(ShipAPI.HullSize.DESTROYER, Float.valueOf(100.0f));
        ARMOR_BONUS.put(ShipAPI.HullSize.CRUISER, Float.valueOf(150.0f));
        ARMOR_BONUS.put(ShipAPI.HullSize.CAPITAL_SHIP, Float.valueOf(200.0f));
    }
}

