/*
 * Decompiled with CFR 0.152.
 */
package data.hullmods;

import com.fs.starfarer.api.combat.BaseHullMod;
import com.fs.starfarer.api.combat.BoundsAPI;
import com.fs.starfarer.api.combat.MissileRenderDataAPI;
import com.fs.starfarer.api.combat.MutableShipStatsAPI;
import com.fs.starfarer.api.combat.MutableStat;
import com.fs.starfarer.api.combat.ShieldAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.combat.WeaponAPI;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.lazywizard.lazylib.FastTrig;
import org.lazywizard.lazylib.MathUtils;
import org.lwjgl.util.vector.Vector2f;

public class NeutrinoSigmaUpgrade
extends BaseHullMod {
    private static final Set<String> BLOCKED_HULLMODS = new HashSet<String>();
    private static final Map<String, Float> factors;
    public static final float SHIELD_ARC_BONUS = 45.0f;
    public static final float SHIELD_BONUS_UNFOLD = 300.0f;
    public static final float GUIDANCE_IMPROVEMENT = 0.5f;
    public static final float AUTOFIRE_AIM_ACCURACY = 40.0f;
    public static final float WEAPON_HEALTH_BONUS = 25.0f;
    public static final float VENT_RATE_BONUS = 0.75f;
    public static final float DISSIPATION_PER_VENT = 12.0f;
    public static final float FLUX_PER_CAPACITOR = 160.0f;

    public void applyEffectsBeforeShipCreation(ShipAPI.HullSize hullSize, MutableShipStatsAPI stats, String id) {
        stats.getMissileGuidance().modifyFlat(id, 0.5f);
        stats.getMissileMaxSpeedBonus().modifyPercent(id, 5.0f);
        stats.getMissileAccelerationBonus().modifyPercent(id, 25.0f);
        stats.getMissileMaxTurnRateBonus().modifyPercent(id, 10.0f);
        stats.getMissileTurnAccelerationBonus().modifyPercent(id, 25.0f);
        if (hullSize == ShipAPI.HullSize.DEFAULT || hullSize == ShipAPI.HullSize.FIGHTER) {
            stats.getAutofireAimAccuracy().modifyPercent(id, 100.0f);
            stats.getWeaponTurnRateBonus().modifyFlat(id, 2.0f);
        } else {
            stats.getAutofireAimAccuracy().modifyPercent(id, 40.0f);
        }
        stats.getWeaponHealthBonus().modifyPercent(id, 25.0f);
        stats.getShieldUnfoldRateMult().modifyPercent(id, 300.0f);
        stats.getShieldTurnRateMult().modifyMult(id, 0.5f);
        stats.getVentRateMult().modifyMult(id, 0.75f);
        MutableStat capacity = stats.getFluxCapacity();
        if (capacity.getFlatStatMod("flux_capacitors") != null) {
            float capacitors = capacity.getFlatStatMod("flux_capacitors").getValue() / 200.0f;
            capacity.modifyFlat(id, capacitors * -40.0f);
        } else {
            capacity.unmodify(id);
        }
        MutableStat vent = stats.getFluxDissipation();
        if (vent.getFlatStatMod("flux_vents") != null) {
            float vents = vent.getFlatStatMod("flux_vents").getValue() / 10.0f;
            vent.modifyFlat(id, vents * 2.0f);
        } else {
            vent.unmodify(id);
        }
        if (hullSize == ShipAPI.HullSize.FIGHTER || hullSize == ShipAPI.HullSize.DEFAULT) {
            stats.getWeaponDamageTakenMult().modifyMult(id, 0.0f);
        }
    }

    public String getDescriptionParam(int index, ShipAPI.HullSize hullSize) {
        if (index == 0) {
            return String.valueOf(45.0f);
        }
        if (index == 1) {
            return String.valueOf(25.0f);
        }
        if (index == 2) {
            return String.valueOf(75);
        }
        return null;
    }

    public void applyEffectsAfterShipCreation(ShipAPI ship, String id) {
        for (String tmp : BLOCKED_HULLMODS) {
            if (!ship.getVariant().getHullMods().contains(tmp)) continue;
            ship.getVariant().removeMod(tmp);
        }
        MutableShipStatsAPI stats = ship.getMutableStats();
        MutableStat capacity = stats.getFluxCapacity();
        if (capacity.getFlatStatMod("flux_capacitors") != null) {
            float capacitors = capacity.getFlatStatMod("flux_capacitors").getValue() / 200.0f;
            capacity.modifyFlat(id, capacitors * -40.0f);
        } else {
            capacity.unmodify(id);
        }
        MutableStat vent = stats.getFluxDissipation();
        if (vent.getFlatStatMod("flux_vents") != null) {
            float vents = vent.getFlatStatMod("flux_vents").getValue() / 10.0f;
            vent.modifyFlat(id, vents * 2.0f);
        } else {
            vent.unmodify(id);
        }
        List weapons = ship.getAllWeapons();
        for (WeaponAPI weapon : weapons) {
            List missilerenders = weapon.getMissileRenderData();
            if (missilerenders == null || !weapon.getSlot().isHidden()) continue;
            for (MissileRenderDataAPI missilereander : missilerenders) {
                missilereander.getSprite().setWidth(0.0f);
            }
        }
    }

    public void advanceInCombat(ShipAPI ship, float amount) {
        if (ship.getOriginalOwner() == -1) {
            return;
        }
        ShieldAPI shield = ship.getShield();
        if (shield != null && shield.isOn()) {
            float radians = (float)Math.toRadians(MathUtils.getShortestRotation((float)ship.getFacing(), (float)ship.getShield().getFacing()));
            float a = ship.getHullSpec().getShieldSpec().getRadius();
            float b = NeutrinoSigmaUpgrade.getFactor(ship);
            float c = (float)FastTrig.cos((double)radians) * (a - b);
            float d = (float)FastTrig.sin((double)radians) * (a - b);
            d += ship.getHullSpec().getShieldSpec().getCenterY();
            shield.setCenter(c += ship.getHullSpec().getShieldSpec().getCenterX(), -(d *= 0.2f));
            shield.setRadius(b);
            float arc = ship.getHullSpec().getShieldSpec().getArc();
            shield.setArc(arc *= a / b);
        }
    }

    public boolean isApplicableToShip(ShipAPI ship) {
        return ship.getHullSpec().getHullId().startsWith("neutrino_");
    }

    private static float getFactor(ShipAPI ship) {
        String hullID = ship.getHullSpec().getHullId();
        if (factors.containsKey(hullID)) {
            return factors.get(hullID).floatValue();
        }
        ShieldAPI shield = ship.getShield();
        float a = ship.getHullSpec().getShieldSpec().getRadius();
        if (shield == null || a == 0.0f) {
            return 0.0f;
        }
        float b = 0.0f;
        List segmentsToCheck = ship.getExactBounds().getSegments();
        Vector2f loc = ship.getLocation();
        float facing = ship.getFacing();
        ship.getExactBounds().update(new Vector2f(-ship.getHullSpec().getShieldSpec().getCenterX(), -ship.getHullSpec().getShieldSpec().getCenterY()), 0.0f);
        for (int i = 0; i < segmentsToCheck.size(); ++i) {
            BoundsAPI.SegmentAPI segment = (BoundsAPI.SegmentAPI)segmentsToCheck.get(i);
            float x = segment.getP1().x;
            float y = segment.getP1().y;
            float tmp = Math.abs(x) == a ? 0.0f : y * y / (1.0f - x * x / (a * a));
            float f = b = tmp > b ? tmp : b;
            if (i != segmentsToCheck.size() - 1) continue;
            x = segment.getP2().x;
            y = segment.getP2().y;
            tmp = Math.abs(x) == a ? 0.0f : y * y / (1.0f - x * x / (a * a));
            b = tmp > b ? tmp : b;
        }
        ship.getExactBounds().update(loc, facing);
        float factor = (float)Math.sqrt(b);
        if (factor < a * 0.618f) {
            factor = a * 0.618f;
        }
        factors.put(hullID, Float.valueOf(factor += (float)ship.getHullSize().ordinal() * 4.0f));
        return factor;
    }

    static {
        BLOCKED_HULLMODS.add("extendedshieldemitter");
        BLOCKED_HULLMODS.add("frontemitter");
        BLOCKED_HULLMODS.add("frontshield");
        factors = new HashMap<String, Float>(100);
    }
}

