/*
 * Decompiled with CFR 0.152.
 */
package data.missions;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.FactionAPI;
import com.fs.starfarer.api.fleet.FleetGoal;
import com.fs.starfarer.api.fleet.FleetMemberAPI;
import com.fs.starfarer.api.fleet.FleetMemberType;
import com.fs.starfarer.api.impl.campaign.fleets.FleetFactoryV2;
import com.fs.starfarer.api.impl.campaign.fleets.FleetParams;
import com.fs.starfarer.api.mission.FleetSide;
import com.fs.starfarer.api.mission.MissionDefinitionAPI;
import com.fs.starfarer.api.mission.MissionDefinitionPlugin;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import org.lazywizard.lazylib.MathUtils;
import org.lwjgl.util.vector.Vector2f;

public class BaseRandomNeutrinoMissionDefinition
implements MissionDefinitionPlugin {
    private static final String[] OBJECTIVE_TYPES = new String[]{"sensor_array", "nav_buoy", "comm_relay"};
    private static final Map<String, Float> QUALITY_FACTORS = new HashMap<String, Float>(10);
    private FactionAPI enemy;
    private boolean flagshipChosen = false;
    private FactionAPI player;
    private final Random rand = new Random();
    private boolean fullRandom = false;

    public void defineMission(MissionDefinitionAPI api) {
        if (this.player == null || this.enemy == null) {
            this.chooseFactions(null, null, this.fullRandom, 0);
        }
        api.initFleet(FleetSide.PLAYER, "", FleetGoal.ATTACK, false, 5);
        api.initFleet(FleetSide.ENEMY, "", FleetGoal.ATTACK, true, 5);
        api.setFleetTagline(FleetSide.PLAYER, this.player.getDisplayNameLong() + " forces");
        api.setFleetTagline(FleetSide.ENEMY, this.enemy.getDisplayNameLong() + " forces");
        int size = MathUtils.getRandomNumberInRange((int)1, (int)3);
        int playerFP = this.generateFleet(this.player, api, FleetSide.PLAYER, size, QUALITY_FACTORS.get(this.player.getId()) == null ? this.rand.nextFloat() : QUALITY_FACTORS.get(this.player.getId()).floatValue());
        int enemyFP = this.generateFleet(this.enemy, api, FleetSide.ENEMY, size, QUALITY_FACTORS.get(this.enemy.getId()) == null ? this.rand.nextFloat() : QUALITY_FACTORS.get(this.enemy.getId()).floatValue());
        float width = 13000.0f + 13000.0f * (float)(size / 200);
        float height = 13000.0f + 13000.0f * (float)(size / 200);
        api.initMap(-width / 2.0f, width / 2.0f, -height / 2.0f, height / 2.0f);
        float minX = -width / 2.0f;
        float minY = -height / 2.0f;
        int objectiveCount = (int)Math.floor((float)size / 35.0f);
        while (objectiveCount > 0) {
            String type = OBJECTIVE_TYPES[this.rand.nextInt(3)];
            if (objectiveCount == 1) {
                api.addObjective(0.0f, 0.0f, type);
                --objectiveCount;
                continue;
            }
            float theta = (float)(Math.random() * Math.PI);
            double radius = Math.min(width, height);
            radius = radius * 0.1 + radius * 0.3 * Math.random();
            int x = (int)(Math.cos(theta) * radius);
            int y = (int)(Math.sin(theta) * radius);
            api.addObjective((float)x, (float)(-y), type);
            api.addObjective((float)(-x), (float)y, type);
            objectiveCount -= 2;
        }
        api.addBriefingItem(this.player.getDisplayName() + "  (" + playerFP + ")   vs.  " + this.enemy.getDisplayName() + "  (" + enemyFP + ")");
        float nebulaChance = MathUtils.getRandomNumberInRange((int)0, (int)100);
        if (nebulaChance < 50.0f) {
            float nebulaCount = 10.0f + (float)Math.random() * 30.0f;
            float nebulaSize = (float)Math.random();
            int i = 0;
            while ((float)i < nebulaCount) {
                float x = (float)Math.random() * width - width / 2.0f;
                float y = (float)Math.random() * height - height / 2.0f;
                float nebulaRadius = (400.0f + (float)Math.random() * 1600.0f) * nebulaSize;
                api.addNebula(x, y, nebulaRadius);
                ++i;
            }
            api.addBriefingItem("Nebulosity:  " + (int)(nebulaCount * nebulaSize / 40.0f * 100.0f) + "%");
        } else {
            api.addBriefingItem("Nebulosity: N/A");
        }
        float asteroidChance = MathUtils.getRandomNumberInRange((int)0, (int)100);
        if (asteroidChance < 50.0f) {
            int minAsteroidSpeed = MathUtils.getRandomNumberInRange((int)15, (int)50);
            int asteroidCount = size + (int)((double)(size * 4) * Math.pow(Math.random(), 2.0));
            api.addAsteroidField(minX + width * 0.5f, minY + height * 0.5f, (float)(this.rand.nextInt(90) - 45 + this.rand.nextInt() % 2 * 180), (float)(100 + (int)(Math.random() * (double)height / 2.0)), (float)minAsteroidSpeed, (float)minAsteroidSpeed * 1.1f, asteroidCount);
            api.addBriefingItem("Asteroid Density:  " + (int)((float)asteroidCount / 1000.0f * 100.0f) + "%");
            api.addBriefingItem("Asteroid Speed:  " + minAsteroidSpeed);
        } else {
            api.addBriefingItem("Asteroid Density: N/A");
            api.addBriefingItem("Asteroid Speed: N/A");
        }
    }

    protected boolean chooseFactions(String playerFactionId, String enemyFactionId, boolean fullRandom, int i) {
        return this.chooseFactions(playerFactionId, enemyFactionId, fullRandom, i, i);
    }

    protected boolean chooseFactions(String playerFactionId, String enemyFactionId, boolean fullRandom, int i, int j) {
        this.player = Global.getSector().getFaction(playerFactionId);
        this.enemy = Global.getSector().getFaction(enemyFactionId);
        this.fullRandom = fullRandom;
        boolean outOfBorder = false;
        ArrayList<FactionAPI> acceptableFactions = new ArrayList<FactionAPI>(40);
        if (!fullRandom) {
            acceptableFactions.add(Global.getSector().getFaction("sindrian_diktat"));
            acceptableFactions.add(Global.getSector().getFaction("hegemony"));
            acceptableFactions.add(Global.getSector().getFaction("independent"));
            acceptableFactions.add(Global.getSector().getFaction("luddic_church"));
            acceptableFactions.add(Global.getSector().getFaction("luddic_path"));
            acceptableFactions.add(Global.getSector().getFaction("pirates"));
            acceptableFactions.add(Global.getSector().getFaction("tritachyon"));
            acceptableFactions.add(Global.getSector().getFaction("persean"));
        } else {
            acceptableFactions.addAll(Global.getSector().getAllFactions());
            for (FactionAPI faction : Global.getSector().getAllFactions()) {
                if (faction.isShowInIntelTab() && !faction.isPlayerFaction()) continue;
                acceptableFactions.remove(faction);
            }
        }
        if (i > acceptableFactions.size()) {
            i = 0;
            outOfBorder = true;
        }
        if (j > acceptableFactions.size()) {
            j = 0;
            outOfBorder = true;
        }
        this.player = this.player != null ? this.player : (FactionAPI)acceptableFactions.get(i);
        acceptableFactions.remove(this.player);
        this.enemy = this.enemy != null ? this.enemy : (FactionAPI)acceptableFactions.get(j);
        return outOfBorder;
    }

    int generateFleet(FactionAPI faction, MissionDefinitionAPI api, FleetSide side, int size, float qf) {
        float combat = 0.0f;
        float tanker = 0.0f;
        float freighter = 0.0f;
        String fleetType = "patrolSmall";
        switch (size) {
            case 1: {
                combat = Math.round(8.0f + (float)Math.random() * 2.0f);
                fleetType = "patrolSmall";
                break;
            }
            case 2: {
                combat = Math.round(21.0f + (float)Math.random() * 3.0f);
                fleetType = "patrolMedium";
                break;
            }
            case 3: {
                combat = Math.round(35.0f + (float)Math.random() * 5.0f);
                fleetType = "patrolLarge";
                tanker = 2.0f;
                freighter = 2.0f;
                break;
            }
        }
        CampaignFleetAPI fleet = FleetFactoryV2.createFleet((FleetParams)new FleetParams(new Vector2f(), null, faction.getId(), null, fleetType, combat *= 1.25f, freighter, tanker, 0.0f, 0.0f, 0.0f, 0.0f, qf, -1.0f, 1.0f, 0));
        if (fleet.getMembersWithFightersCopy().isEmpty()) {
            return 0;
        }
        for (FleetMemberAPI m : fleet.getMembersWithFightersCopy()) {
            String variant = m.getVariant().getHullVariantId();
            if (m.getType() == FleetMemberType.FIGHTER_WING) continue;
            api.addToFleet(side, variant, FleetMemberType.SHIP, m.getShipName(), fleet.getFlagship() == m);
        }
        return fleet.getFleetPoints();
    }

    static {
        QUALITY_FACTORS.put("neutrinocorp", Float.valueOf(0.85f));
        QUALITY_FACTORS.put("sindrian_diktat", Float.valueOf(0.5f));
        QUALITY_FACTORS.put("hegemony", Float.valueOf(0.5f));
        QUALITY_FACTORS.put("independent", Float.valueOf(0.5f));
        QUALITY_FACTORS.put("luddic_church", Float.valueOf(0.25f));
        QUALITY_FACTORS.put("luddic_path", Float.valueOf(0.0f));
        QUALITY_FACTORS.put("pirates", Float.valueOf(0.0f));
        QUALITY_FACTORS.put("tritachyon", Float.valueOf(0.85f));
        QUALITY_FACTORS.put("persean", Float.valueOf(0.5f));
    }
}

