/*
 * Decompiled with CFR 0.152.
 */
package data.missions.neutrino_stophammertime;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.FactionAPI;
import com.fs.starfarer.api.fleet.FleetGoal;
import com.fs.starfarer.api.fleet.FleetMemberAPI;
import com.fs.starfarer.api.fleet.FleetMemberType;
import com.fs.starfarer.api.impl.campaign.fleets.FleetFactoryV2;
import com.fs.starfarer.api.impl.campaign.fleets.FleetParams;
import com.fs.starfarer.api.mission.FleetSide;
import com.fs.starfarer.api.mission.MissionDefinitionAPI;
import com.fs.starfarer.api.mission.MissionDefinitionPlugin;
import java.util.ArrayList;
import java.util.Random;
import org.lwjgl.util.vector.Vector2f;

public class MissionDefinition
implements MissionDefinitionPlugin {
    public void defineMission(MissionDefinitionAPI api) {
        api.initFleet(FleetSide.PLAYER, "CNC", FleetGoal.ATTACK, false);
        api.initFleet(FleetSide.ENEMY, "HSS", FleetGoal.ATTACK, true);
        api.setFleetTagline(FleetSide.PLAYER, "Runaway Experimental Autonomous Ship");
        api.setFleetTagline(FleetSide.ENEMY, "Unlucky Fleet");
        api.addBriefingItem("You will prove them all wrong, you will prove you are useful! You'll show them!");
        api.addBriefingItem("Take the hint, your ship looks like a hammer, use it as such.");
        api.addBriefingItem("Use your shield and tractor beam together to inflict damage while receiving next to none.");
        api.addBriefingItem("CNC McHammer must survive");
        api.addToFleet(FleetSide.PLAYER, "neutrino_hammer_standard", FleetMemberType.SHIP, "CNC McHammer", true);
        api.defeatOnShipLoss("CNC McHammer");
        ArrayList<FactionAPI> acceptableFactions = new ArrayList<FactionAPI>();
        acceptableFactions.add(Global.getSector().getFaction("sindrian_diktat"));
        acceptableFactions.add(Global.getSector().getFaction("hegemony"));
        acceptableFactions.add(Global.getSector().getFaction("independent"));
        acceptableFactions.add(Global.getSector().getFaction("luddic_church"));
        acceptableFactions.add(Global.getSector().getFaction("luddic_path"));
        acceptableFactions.add(Global.getSector().getFaction("pirates"));
        acceptableFactions.add(Global.getSector().getFaction("tritachyon"));
        acceptableFactions.add(Global.getSector().getFaction("persean"));
        Random r = new Random();
        String factionID = ((FactionAPI)acceptableFactions.get(r.nextInt(acceptableFactions.size()))).getId();
        CampaignFleetAPI fleet = FleetFactoryV2.createFleet((FleetParams)new FleetParams(new Vector2f(), null, factionID, null, "patrolLarge", 35.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, -1.0f, 1.0f, 0));
        for (FleetMemberAPI m : fleet.getMembersWithFightersCopy()) {
            String variant = m.getVariant().getHullVariantId();
            if (m.getType() == FleetMemberType.FIGHTER_WING) continue;
            api.addToFleet(FleetSide.ENEMY, variant, FleetMemberType.SHIP, m.getShipName(), fleet.getFlagship() == m);
        }
        float width = 7000.0f;
        float height = 5000.0f;
        api.initMap(-width / 2.0f, width / 2.0f, -height / 2.0f, height / 2.0f);
        float minX = -width / 2.0f;
        float minY = -height / 2.0f;
        for (int i = 0; i < 7; ++i) {
            float x = (float)Math.random() * width - width / 2.0f;
            float y = (float)Math.random() * height - height / 2.0f;
            float radius = 100.0f + (float)Math.random() * 800.0f;
            api.addNebula(x, y, radius);
        }
        api.addObjective(minX + width * 0.7f, minY + height * 0.25f, "sensor_array");
        api.addObjective(minX + width * 0.8f, minY + height * 0.75f, "nav_buoy");
        api.addObjective(minX + width * 0.2f, minY + height * 0.25f, "nav_buoy");
    }
}

