/*
 * Decompiled with CFR 0.152.
 */
package data.scripts.AILib;

import com.fs.starfarer.api.combat.CombatEntityAPI;
import com.fs.starfarer.api.combat.MissileAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.combat.ShipCommand;
import org.lazywizard.lazylib.MathUtils;
import org.lazywizard.lazylib.VectorUtils;
import org.lwjgl.util.vector.ReadableVector2f;
import org.lwjgl.util.vector.Vector2f;

public class BaseManeuverModule {
    private final CombatEntityAPI entity;
    private final float StrafeAccMod;
    private final Vector2f zero = new Vector2f(0.0f, 0.0f);
    public final float angleError = 0.1f;
    public final float speedError = 0.1f;
    public final float locError = 0.1f;

    public BaseManeuverModule(ShipAPI ship) {
        this.entity = ship;
        this.StrafeAccMod = ship.isFighter() ? 0.75f : (ship.isFrigate() ? 1.0f : (ship.isDestroyer() ? 0.75f : (ship.isCruiser() ? 0.5f : (ship.isCapital() ? 0.25f : 1.0f))));
    }

    public BaseManeuverModule(MissileAPI missile) {
        this.entity = missile;
        this.StrafeAccMod = 1.0f;
    }

    private void giveCommand(ShipCommand Command, Vector2f point, int weaponGroup) {
        if (this.entity instanceof ShipAPI) {
            ((ShipAPI)this.entity).giveCommand(Command, (Object)point, weaponGroup);
        }
        if (this.entity instanceof MissileAPI) {
            ((MissileAPI)this.entity).giveCommand(Command);
        }
    }

    private void giveCommand(ShipCommand Command) {
        if (this.entity instanceof ShipAPI) {
            ((ShipAPI)this.entity).giveCommand(Command, null, 0);
        }
        if (this.entity instanceof MissileAPI) {
            ((MissileAPI)this.entity).giveCommand(Command);
        }
    }

    private boolean inErrorMargin(float toTest, float error) {
        return toTest >= -error && toTest <= error;
    }

    public float getMaxSpeed() {
        if (this.entity instanceof ShipAPI) {
            return ((ShipAPI)this.entity).getMutableStats().getMaxSpeed().getModifiedValue();
        }
        if (this.entity instanceof MissileAPI) {
            ((MissileAPI)this.entity).getMaxSpeed();
        }
        return 0.0f;
    }

    public float getMaxTurnRate() {
        if (this.entity instanceof ShipAPI) {
            return ((ShipAPI)this.entity).getMutableStats().getMaxTurnRate().getModifiedValue();
        }
        if (this.entity instanceof MissileAPI) {
            ((MissileAPI)this.entity).getMaxTurnRate();
        }
        return 0.0f;
    }

    public float getAcceleration() {
        if (this.entity instanceof ShipAPI) {
            return ((ShipAPI)this.entity).getMutableStats().getAcceleration().getModifiedValue();
        }
        if (this.entity instanceof MissileAPI) {
            ((MissileAPI)this.entity).getAcceleration();
        }
        return 0.0f;
    }

    public float getStrafeAcceleration() {
        return this.getAcceleration() * this.StrafeAccMod;
    }

    public float getTurnAcceleration() {
        if (this.entity instanceof ShipAPI) {
            return ((ShipAPI)this.entity).getMutableStats().getTurnAcceleration().getModifiedValue();
        }
        if (this.entity instanceof MissileAPI) {
            ((MissileAPI)this.entity).getTurnAcceleration();
        }
        return 0.0f;
    }

    public void turnLeft() {
        this.giveCommand(ShipCommand.TURN_LEFT);
    }

    public void turnRight() {
        this.giveCommand(ShipCommand.TURN_RIGHT);
    }

    public void accelerate() {
        this.giveCommand(ShipCommand.ACCELERATE);
    }

    public void deccelerate() {
        this.giveCommand(ShipCommand.DECELERATE);
    }

    public void accelerateBack() {
        this.giveCommand(ShipCommand.ACCELERATE_BACKWARDS);
    }

    public void strafeLeft() {
        this.giveCommand(ShipCommand.STRAFE_LEFT);
    }

    public void strafeRight() {
        this.giveCommand(ShipCommand.STRAFE_RIGHT);
    }

    private float getIntegralArea(float from, float to, float slope) {
        return (to + from) * 0.5f * ((to - from) / slope);
    }

    private float getOverTurnAndDirToChangeTurnRateTo(float targetTrunRate) {
        targetTrunRate = targetTrunRate > this.getMaxTurnRate() ? this.getMaxTurnRate() : targetTrunRate;
        return this.getMaxTurnRate() == 0.0f || this.getTurnAcceleration() == 0.0f ? Float.MAX_VALUE : this.getIntegralArea(this.entity.getAngularVelocity(), targetTrunRate, this.getTurnAcceleration());
    }

    public CombatEntityAPI getEntity() {
        return this.entity;
    }

    public void faceTo(float faceTo, float targetTrunRate) {
        float diff = MathUtils.getShortestRotation((float)this.entity.getFacing(), (float)faceTo);
        if (!this.inErrorMargin(diff -= this.getOverTurnAndDirToChangeTurnRateTo(targetTrunRate), 0.1f)) {
            if (diff < 0.0f) {
                this.giveCommand(ShipCommand.TURN_RIGHT);
            } else if (diff > 0.0f) {
                this.giveCommand(ShipCommand.TURN_LEFT);
            }
        }
    }

    public void faceTo(float faceTo) {
        this.faceTo(faceTo, 0.0f);
    }

    public void faceTo(Vector2f faceToV2f, Vector2f targetVel) {
        float targetTrunRate;
        Vector2f relativeLoc = Vector2f.sub((Vector2f)this.entity.getLocation(), (Vector2f)faceToV2f, null);
        float faceTo = VectorUtils.getFacing((Vector2f)relativeLoc);
        if (targetVel == null) {
            targetTrunRate = 0.0f;
        } else {
            Vector2f relativeVel = Vector2f.sub((Vector2f)targetVel, (Vector2f)this.entity.getVelocity(), null);
            targetTrunRate = VectorUtils.getAngle((Vector2f)relativeLoc, (Vector2f)Vector2f.add((Vector2f)relativeLoc, (Vector2f)relativeVel, null));
        }
        this.faceTo(faceTo, targetTrunRate);
    }

    public void matchVelTo(Vector2f targetVel, boolean canAccBackward) {
        Vector2f velDiff = Vector2f.sub((Vector2f)targetVel, (Vector2f)this.entity.getVelocity(), null);
        VectorUtils.rotate((Vector2f)velDiff, (float)(-this.entity.getFacing()), (Vector2f)velDiff);
        if (!this.inErrorMargin(velDiff.x, 0.1f)) {
            if (velDiff.x < 0.0f) {
                if (canAccBackward) {
                    this.giveCommand(ShipCommand.ACCELERATE_BACKWARDS);
                } else {
                    this.giveCommand(ShipCommand.DECELERATE);
                }
            } else if (velDiff.x > 0.0f) {
                this.giveCommand(ShipCommand.ACCELERATE);
            }
        }
        if (!this.inErrorMargin(velDiff.y, 0.1f)) {
            if (velDiff.y < 0.0f) {
                this.giveCommand(ShipCommand.STRAFE_LEFT);
            } else if (velDiff.y > 0.0f) {
                this.giveCommand(ShipCommand.STRAFE_RIGHT);
            }
        }
    }

    public void strafeToLoc(Vector2f targetLoc, Vector2f targetVel, boolean canAccBackward) {
        Vector2f velDiff = Vector2f.sub((Vector2f)targetVel, (Vector2f)this.entity.getVelocity(), null);
        VectorUtils.rotate((Vector2f)velDiff, (float)(-this.entity.getFacing()), (Vector2f)velDiff);
        Vector2f currVel = new Vector2f((ReadableVector2f)this.entity.getVelocity());
        VectorUtils.rotate((Vector2f)currVel, (float)(-this.entity.getFacing()), (Vector2f)currVel);
        Vector2f locDiff = Vector2f.sub((Vector2f)targetLoc, (Vector2f)this.entity.getLocation(), null);
        VectorUtils.rotate((Vector2f)locDiff, (float)(-this.entity.getFacing()), (Vector2f)locDiff);
        if (Math.abs(this.getIntegralArea(currVel.x, currVel.x + velDiff.x, this.getAcceleration())) >= Math.abs(locDiff.x)) {
            if (!this.inErrorMargin(velDiff.x, 0.1f)) {
                if (velDiff.x < 0.0f) {
                    if (canAccBackward) {
                        this.giveCommand(ShipCommand.ACCELERATE_BACKWARDS);
                    } else {
                        this.giveCommand(ShipCommand.DECELERATE);
                    }
                } else if (velDiff.x > 0.0f) {
                    this.giveCommand(ShipCommand.ACCELERATE);
                }
            }
        } else if (!this.inErrorMargin(locDiff.x, 0.1f)) {
            if (locDiff.x < 0.0f) {
                if (canAccBackward) {
                    this.giveCommand(ShipCommand.ACCELERATE_BACKWARDS);
                } else {
                    this.giveCommand(ShipCommand.DECELERATE);
                }
            } else if (locDiff.x > 0.0f) {
                this.giveCommand(ShipCommand.ACCELERATE);
            }
        }
        if (Math.abs(this.getIntegralArea(currVel.y, currVel.y + velDiff.y, this.getAcceleration())) >= Math.abs(locDiff.y)) {
            if (!this.inErrorMargin(velDiff.y, 0.1f)) {
                if (velDiff.y < 0.0f) {
                    this.giveCommand(ShipCommand.STRAFE_LEFT);
                } else if (velDiff.y > 0.0f) {
                    this.giveCommand(ShipCommand.STRAFE_RIGHT);
                }
            }
        } else if (!this.inErrorMargin(locDiff.y, 0.1f)) {
            if (locDiff.y < 0.0f) {
                this.giveCommand(ShipCommand.STRAFE_LEFT);
            } else if (locDiff.y > 0.0f) {
                this.giveCommand(ShipCommand.STRAFE_RIGHT);
            }
        }
    }

    public void strafeToLoc(Vector2f targetLoc, Vector2f targetVel) {
        this.strafeToLoc(targetLoc, targetVel, false);
    }

    public void strafeToLoc(Vector2f targetLoc, boolean stopAtLoc) {
        if (stopAtLoc) {
            this.strafeToLoc(targetLoc, this.zero);
        } else {
            Vector2f locDiff = Vector2f.sub((Vector2f)targetLoc, (Vector2f)this.entity.getLocation(), null);
            VectorUtils.rotate((Vector2f)locDiff, (float)(-this.entity.getFacing()), (Vector2f)locDiff);
            if (locDiff.x < 0.0f) {
                this.giveCommand(ShipCommand.DECELERATE);
            } else if (locDiff.x > 0.0f) {
                this.giveCommand(ShipCommand.ACCELERATE);
            }
            if (locDiff.y < 0.0f) {
                this.giveCommand(ShipCommand.STRAFE_LEFT);
            } else if (locDiff.y > 0.0f) {
                this.giveCommand(ShipCommand.STRAFE_RIGHT);
            }
        }
    }

    public void strafeToLoc(Vector2f targetLoc) {
        this.strafeToLoc(targetLoc, false);
    }
}

