/*
 * Decompiled with CFR 0.152.
 */
package data.scripts.AILib;

import com.fs.starfarer.api.combat.CombatEntityAPI;
import com.fs.starfarer.api.combat.MissileAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.util.IntervalUtil;
import data.scripts.AILib.BaseManeuverModule;
import org.lazywizard.lazylib.combat.AIUtils;
import org.lwjgl.util.vector.Vector2f;

public class ManeuverModule {
    private final CombatEntityAPI entity;
    private final BaseManeuverModule m;
    private CombatEntityAPI target;
    private Vector2f targetLoc;
    private IntervalUtil interval;
    private ManeuverType maneuverType = null;
    private FacingType facingType = null;
    private float desireFacing = 0.0f;
    private float leadingFactor = 0.0f;

    public ManeuverModule(ShipAPI ship) {
        this.entity = ship;
        this.m = new BaseManeuverModule(ship);
        this.interval = new IntervalUtil(0.1f, 0.1f);
        this.interval.forceIntervalElapsed();
    }

    public ManeuverModule(MissileAPI missile) {
        this.entity = missile;
        this.m = new BaseManeuverModule(missile);
        this.interval = new IntervalUtil(0.1f, 0.1f);
        this.interval.forceIntervalElapsed();
    }

    public void setInterval(IntervalUtil interval) {
        this.interval = interval;
        interval.forceIntervalElapsed();
    }

    public ManeuverType getManeuverType() {
        return this.maneuverType;
    }

    public FacingType getFacingType() {
        return this.facingType;
    }

    public float getDesireFacing() {
        return this.desireFacing;
    }

    public void setDesireFacing(float desireFacing) {
        this.desireFacing = desireFacing;
    }

    public void interceptTarget(CombatEntityAPI target, float leadingFactor) {
        this.target = target;
        this.leadingFactor = leadingFactor;
        this.maneuverType = ManeuverType.INTERCEPT;
    }

    public Vector2f getInterceptPoint(CombatEntityAPI target, float leadingFactor) {
        return AIUtils.getBestInterceptPoint((Vector2f)this.entity.getLocation(), (float)this.m.getMaxSpeed(), (Vector2f)target.getLocation(), (Vector2f)target.getVelocity());
    }

    public void advance(float amount) {
    }

    public static enum FacingType {
        TO_TARGET,
        TO_LEADING,
        TO_GIVEN_FACING;

    }

    public static enum ManeuverType {
        CLOSE_IN,
        BACK_OFF,
        INTERCEPT,
        ORBIT;

    }
}

