/*
 * Decompiled with CFR 0.152.
 */
package data.scripts.AIs.Missiles;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.combat.CollisionClass;
import com.fs.starfarer.api.combat.CombatEngineAPI;
import com.fs.starfarer.api.combat.CombatEntityAPI;
import com.fs.starfarer.api.combat.DamageType;
import com.fs.starfarer.api.combat.GuidedMissileAI;
import com.fs.starfarer.api.combat.MissileAIPlugin;
import com.fs.starfarer.api.combat.MissileAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.combat.ShipCommand;
import com.fs.starfarer.api.util.IntervalUtil;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.combat.entities.Missile;
import java.awt.Color;
import java.util.Collections;
import java.util.List;
import org.lazywizard.lazylib.CollectionUtils;
import org.lazywizard.lazylib.MathUtils;
import org.lazywizard.lazylib.VectorUtils;
import org.lazywizard.lazylib.combat.AIUtils;
import org.lazywizard.lazylib.combat.CombatUtils;
import org.lazywizard.lazylib.combat.entities.AnchoredEntity;
import org.lwjgl.util.vector.ReadableVector2f;
import org.lwjgl.util.vector.Vector2f;

public final class Neutrino_AdvancedTorpedoAI
implements MissileAIPlugin,
GuidedMissileAI {
    private CombatEngineAPI engine;
    private final MissileAPI missile;
    private CombatEntityAPI target;
    private final Vector2f zero = new Vector2f(0.0f, 0.0f);
    private Vector2f evadingOffset = new Vector2f(0.0f, 0.0f);
    private Vector2f aimLeadOffset = new Vector2f(0.0f, 0.0f);
    private boolean chargeUp = false;
    private boolean shouldFire = false;
    private float chargeUoTimer = 0.0f;
    private final float flightSpeed;
    private final IntervalUtil OffsetsRCInterval;
    private final float guidefactor;
    private static final float damping = 0.1f;
    private float subLeadingMod = 0.0f;
    private float omniThrustTimer = 0.0f;
    private float overshootTimer = 0.0f;
    private boolean overshootFlag = false;
    private boolean launching = true;
    private boolean forceEvade = true;
    private Vector2f lead;
    private float dist;
    private final float minTimeToSplit = 1.5f;
    private final float maxArmedTime = 5.0f;
    private float fireTimeRandomer;
    private float fireTimer = this.fireTimeRandomer = 1.5f;
    private final IntervalUtil flashInterval = new IntervalUtil(0.1f, 0.1f);
    private final IntervalUtil firingCheckInterval = new IntervalUtil(0.05f, 0.1f);
    private final Color coler1 = new Color(86, 86, 255, 20);
    private final Color coler2 = new Color(0, 0, 255, 30);
    private final float closeRange = 700.0f;
    private final float chargeUpRange = 600.0f;
    private final float releaseRange = 500.0f;
    private final int backOffRange = 250;
    private float payloadSpeed = 400.0f;
    private final float minAimOffset = 35.0f;
    private final float leadingMod = 0.2f;
    private final int payload1 = 1;
    private final boolean FAF = true;
    private final IntervalUtil guidanceInterval = new IntervalUtil(0.1f, 0.1f);
    private float targetPhasedTimer = 0.0f;
    private final float targetPhasedDelay = 0.5f;
    private final float launchingFloatTime = 0.5f;
    private final float forceEvadeTime = 1.0f;
    private final float overshoot = 60.0f;
    private final float overshootLag = 1.0f;
    private boolean omniThrust = false;
    private final boolean alwaysAcc = false;
    private final float omniThrustAccLimit = 0.5f;
    private float omniThrustMaxSpeedLimit = 1.0f;

    public Neutrino_AdvancedTorpedoAI(MissileAPI missile, ShipAPI launchingShip) {
        this.missile = missile;
        missile.setEmpResistance(missile.getEmpResistance() + 1);
        this.flightSpeed = missile.getMaxSpeed();
        this.payloadSpeed = launchingShip.getMutableStats().getMissileMaxSpeedBonus().computeEffective(this.payloadSpeed);
        this.guidefactor = 1.0f + 0.5f * launchingShip.getMutableStats().getMissileGuidance().getModifiedValue();
        this.omniThrustMaxSpeedLimit = 1.0f - this.omniThrustMaxSpeedLimit;
        this.omniThrustMaxSpeedLimit *= this.flightSpeed;
        this.fireTimeRandomer *= 1.0f / launchingShip.getMutableStats().getMissileMaxSpeedBonus().computeEffective(1.0f);
        this.OffsetsRCInterval = new IntervalUtil(1.0f, 2.0f);
        if (missile.getSource().getVariant().getHullMods().contains("neutrino_sigmaupgrade")) {
            this.omniThrust = true;
        }
        this.OffsetsRCInterval.forceIntervalElapsed();
        this.guidanceInterval.forceIntervalElapsed();
        this.setTarget(this.assignCurrentTarget(missile));
        this.lead = new Vector2f();
        this.dist = Float.MAX_VALUE;
        this.overshootTimer = 1.0f;
    }

    public void advance(float amount) {
        boolean backOff;
        if (this.engine != Global.getCombatEngine()) {
            this.engine = Global.getCombatEngine();
        }
        if (Global.getCombatEngine().isPaused() || this.missile.isFading() || this.missile.isFizzling()) {
            return;
        }
        float elapsed = this.missile.getElapsed();
        this.launching = elapsed < 0.5f;
        boolean bl = this.forceEvade = elapsed < 1.0f;
        if (this.chargeUp) {
            this.releasingPayload(this.missile, amount);
        }
        this.shouldFire = false;
        this.targetPhasedTimer = this.target instanceof ShipAPI && ((ShipAPI)this.target).isPhased() ? (this.targetPhasedTimer += amount) : 0.0f;
        if (this.target == null || this.target instanceof ShipAPI && !((ShipAPI)this.target).isAlive() || this.missile.getOwner() == this.target.getOwner() || !Global.getCombatEngine().isEntityInPlay(this.target) || this.targetPhasedTimer > 0.5f) {
            this.setTarget(this.reAssignTarget(this.missile));
            this.overshootFlag = false;
            this.overshootTimer = 1.0f;
            this.OffsetsRCInterval.forceIntervalElapsed();
            this.guidanceInterval.forceIntervalElapsed();
            this.fireTimer = this.fireTimeRandomer;
            this.targetPhasedTimer = 0.0f;
            return;
        }
        Vector2f mLoc = this.missile.getLocation();
        Vector2f tLoc = this.target.getLocation();
        float mFacing = this.missile.getFacing();
        this.guidanceInterval.advance(amount);
        if (this.guidanceInterval.intervalElapsed() && tLoc != null) {
            this.OffsetsRCInterval.advance(amount);
            if (this.OffsetsRCInterval.intervalElapsed()) {
                this.evadingOffset = Vector2f.sub((Vector2f)mLoc, (Vector2f)tLoc, null);
                this.evadingOffset = new Vector2f(-this.evadingOffset.y, this.evadingOffset.x);
                this.aimLeadOffset = MathUtils.getRandomPointOnCircumference((Vector2f)this.zero, (float)35.0f);
                this.evadingOffset.scale(MathUtils.getRandomNumberInRange((float)-0.3f, (float)0.3f));
                if (this.overshootFlag) {
                    this.overshootTimer = 0.0f;
                }
                this.subLeadingMod = MathUtils.getRandomNumberInRange((float)(1.0f - 0.2f / this.guidefactor), (float)(1.0f + 0.2f / this.guidefactor));
            }
            Vector2f aimLead = AIUtils.getBestInterceptPoint((Vector2f)mLoc, (float)(this.payloadSpeed * this.subLeadingMod), (Vector2f)tLoc, (Vector2f)this.target.getVelocity());
            Vector2f flightLead = AIUtils.getBestInterceptPoint((Vector2f)mLoc, (float)(this.flightSpeed * this.subLeadingMod), (Vector2f)tLoc, (Vector2f)this.target.getVelocity());
            if (flightLead == null) {
                flightLead = new Vector2f((ReadableVector2f)tLoc);
            }
            if (aimLead == null) {
                aimLead = new Vector2f((ReadableVector2f)tLoc);
            }
            Vector2f.add((Vector2f)flightLead, (Vector2f)this.evadingOffset, (Vector2f)flightLead);
            Vector2f.add((Vector2f)aimLead, (Vector2f)this.aimLeadOffset, (Vector2f)aimLead);
            float aimDist = Misc.getDistance((Vector2f)mLoc, (Vector2f)aimLead);
            float guideMod = this.forceEvade ? 1.0f : Math.min(1.0f, Math.max(0.0f, (aimDist - 700.0f) * 0.002f));
            Vector2f diff = Vector2f.sub((Vector2f)flightLead, (Vector2f)aimLead, null);
            diff.scale(guideMod);
            this.lead = Vector2f.add((Vector2f)diff, (Vector2f)aimLead, (Vector2f)this.lead);
            this.dist = Math.min(aimDist, Misc.getDistance((Vector2f)mLoc, (Vector2f)tLoc) - Misc.getTargetingRadius((Vector2f)this.missile.getLocation(), (CombatEntityAPI)this.target, (boolean)(this.target.getShield() == null ? false : this.target.getShield().isWithinArc(this.missile.getLocation()))));
        }
        float aimAngle = this.lead == null ? 0.0f : MathUtils.getShortestRotation((float)mFacing, (float)VectorUtils.getAngle((Vector2f)mLoc, (Vector2f)this.lead));
        int Thrust = 0;
        int Turn = 0;
        int Strafe = 0;
        boolean bl2 = backOff = this.dist < 250.0f;
        if (aimAngle < 0.0f) {
            Turn = 1;
        }
        if (aimAngle > 0.0f) {
            Turn = -1;
        }
        if (Math.abs(aimAngle) < Math.abs(this.missile.getAngularVelocity()) * 0.1f) {
            this.missile.setAngularVelocity(aimAngle / 0.1f);
        }
        float MFlightAng = VectorUtils.getAngle((Vector2f)new Vector2f(), (Vector2f)this.missile.getVelocity());
        float MFlightCC = MathUtils.getShortestRotation((float)mFacing, (float)MFlightAng);
        if (Math.abs(aimAngle) < 5.0f) {
            if (MFlightCC < -20.0f) {
                Strafe = 1;
            }
            if (MFlightCC > 20.0f) {
                Strafe = -1;
            }
        }
        if (Math.abs(aimAngle) < 60.0f) {
            this.overshootTimer = 0.0f;
            this.overshootFlag = true;
        } else {
            this.overshootTimer += amount;
        }
        if (this.overshootTimer < 1.0f) {
            Thrust = 1;
        }
        if (backOff) {
            Thrust = -1;
        }
        if (this.omniThrust && !this.launching) {
            this.omniThrustTimer += 0.5f;
            if (this.omniThrustTimer >= 1.0f) {
                this.omniThrustTimer -= 1.0f;
                Vector2f absMVDev = Vector2f.sub((Vector2f)((Vector2f)VectorUtils.getDirectionalVector((Vector2f)mLoc, (Vector2f)this.lead).scale(this.flightSpeed)), (Vector2f)this.missile.getVelocity(), null);
                Vector2f relMVDev = VectorUtils.rotate((Vector2f)absMVDev, (float)(-mFacing), (Vector2f)new Vector2f());
                if (!backOff) {
                    if (relMVDev.x > 2.5f + this.omniThrustMaxSpeedLimit) {
                        Thrust = 1;
                    }
                    if (relMVDev.x < -(2.5f + this.omniThrustMaxSpeedLimit)) {
                        Thrust = -1;
                    }
                    if (relMVDev.y > 2.5f + this.omniThrustMaxSpeedLimit) {
                        Strafe = 1;
                    }
                    if (relMVDev.y < -(2.5f + this.omniThrustMaxSpeedLimit)) {
                        Strafe = -1;
                    }
                }
                if (backOff) {
                    if (relMVDev.x > 2.5f) {
                        Thrust = -1;
                    }
                    if (relMVDev.x < -2.5f) {
                        Thrust = 1;
                    }
                    if (relMVDev.y < 2.5f) {
                        Strafe = -1;
                    }
                    if (relMVDev.y > -2.5f) {
                        Strafe = 1;
                    }
                }
            }
        }
        if (Thrust == 1 && !this.launching) {
            this.missile.giveCommand(ShipCommand.ACCELERATE);
        }
        if (Thrust == -1 && !this.launching) {
            this.missile.giveCommand(ShipCommand.ACCELERATE_BACKWARDS);
        }
        if (Turn == 1) {
            this.missile.giveCommand(ShipCommand.TURN_RIGHT);
        }
        if (Turn == -1) {
            this.missile.giveCommand(ShipCommand.TURN_LEFT);
        }
        if (Strafe == 1 && !this.launching) {
            this.missile.giveCommand(ShipCommand.STRAFE_LEFT);
        }
        if (Strafe == -1 && !this.launching) {
            this.missile.giveCommand(ShipCommand.STRAFE_RIGHT);
        }
        float absFacingToLead = Math.abs(MathUtils.getShortestRotation((float)mFacing, (float)VectorUtils.getAngle((Vector2f)mLoc, (Vector2f)this.lead)));
        if (elapsed > 1.5f && absFacingToLead < 3.0f && (this.dist < 600.0f || MathUtils.getDistance((Vector2f)mLoc, (Vector2f)this.lead) < 600.0f)) {
            this.chargeUp = true;
            if (this.dist < 500.0f) {
                this.firingCheckInterval.advance(amount);
                if (this.firingCheckInterval.intervalElapsed()) {
                    this.fireTimer -= this.firingCheckInterval.getElapsed();
                    this.shouldFire = this.fireTimer < MathUtils.getRandomNumberInRange((float)0.0f, (float)this.fireTimeRandomer);
                }
            }
        }
    }

    public CombatEntityAPI assignCurrentTarget(MissileAPI missile) {
        ShipAPI source = missile.getSource();
        ShipAPI currentTarget = source.getShipTarget();
        if (currentTarget != null && currentTarget.isAlive() && currentTarget.getOwner() != missile.getOwner()) {
            return currentTarget;
        }
        List directTargets = CombatUtils.getShipsWithinRange((Vector2f)source.getMouseTarget(), (float)50.0f);
        if (!directTargets.isEmpty()) {
            Collections.sort(directTargets, new CollectionUtils.SortEntitiesByDistance(source.getMouseTarget()));
            for (ShipAPI tmp : directTargets) {
                if (!tmp.isAlive() || tmp.getOwner() == source.getOwner()) continue;
                return tmp;
            }
        }
        return null;
    }

    public CombatEntityAPI reAssignTarget(MissileAPI missile) {
        ShipAPI newtarget = null;
        ShipAPI source = missile.getSource();
        int side = source.getOwner();
        float searchRange = this.chargeUp ? missile.getMaxSpeed() * (5.0f - this.chargeUoTimer) : missile.getMaxSpeed() * 1.5f * (missile.getMaxFlightTime() - missile.getElapsed());
        float closestDistance = Float.MAX_VALUE;
        for (ShipAPI tmp : AIUtils.getNearbyEnemies((CombatEntityAPI)missile, (float)searchRange)) {
            float distance;
            float mod = 0.0f;
            if (!CombatUtils.isVisibleToSide((CombatEntityAPI)tmp, (int)side)) continue;
            if (tmp.isFighter()) {
                mod = searchRange;
            }
            if (tmp.isDrone() || tmp.getCollisionClass() == CollisionClass.NONE) {
                mod = 2.0f * searchRange;
            }
            if (!((distance = MathUtils.getDistance((CombatEntityAPI)tmp, (Vector2f)missile.getLocation()) + mod) < closestDistance)) continue;
            newtarget = tmp;
            closestDistance = distance;
        }
        if (newtarget == null && (newtarget = AIUtils.getNearestEnemy((CombatEntityAPI)missile)) != null && !CombatUtils.isVisibleToSide((CombatEntityAPI)newtarget, (int)side)) {
            newtarget = null;
        }
        return newtarget;
    }

    public void releasingPayload(MissileAPI missile, float amount) {
        Vector2f mLoc = missile.getLocation();
        ShipAPI mSource = missile.getSource();
        this.chargeUoTimer += amount;
        Global.getCombatEngine().getElapsedInLastFrame();
        Global.getCombatEngine().getCustomData();
        if (this.chargeUoTimer < 5.0f) {
            this.flashInterval.advance(amount);
            if (this.flashInterval.intervalElapsed()) {
                Vector2f randomPoint = MathUtils.getRandomPointOnCircumference((Vector2f)mLoc, (float)5.0f);
                AnchoredEntity anchor1 = new AnchoredEntity((CombatEntityAPI)missile, randomPoint);
                this.engine.spawnEmpArc(mSource, mLoc, (CombatEntityAPI)anchor1, (CombatEntityAPI)anchor1, DamageType.ENERGY, 0.0f, 0.0f, 50.0f, null, 2.0f, this.coler1, this.coler2);
            }
        } else {
            this.engine.applyDamage((CombatEntityAPI)missile, mLoc, missile.getHitpoints() * 4.0f, DamageType.FRAGMENTATION, 0.0f, false, false, (Object)mSource);
        }
        if (this.shouldFire) {
            Vector2f mVel = missile.getVelocity();
            float mFacing = missile.getFacing();
            for (int i = 0; i < 1; ++i) {
                float firingAng = mFacing;
                CombatEntityAPI tmp = this.engine.spawnProjectile(mSource, missile.getWeapon(), "neutrino_adv_torpedo_1", mLoc, firingAng, this.zero);
                Missile m = (Missile)tmp;
                m.advance(0.0f);
            }
            this.engine.spawnExplosion(mLoc, mVel, new Color(86, 86, 255, 100), 30.0f, 2.0f);
            Global.getSoundPlayer().playSound("neutrino_photon_firing", 0.8f, 0.7f, mLoc, this.zero);
            this.engine.spawnProjectile(mSource, missile.getWeapon(), "neutrino_adv_torpedo_4", mLoc, mFacing, mVel).setAngularVelocity((float)MathUtils.getRandomNumberInRange((int)-30, (int)30));
            this.engine.removeEntity((CombatEntityAPI)missile);
        }
    }

    public CombatEntityAPI getTarget() {
        return this.target;
    }

    public void setTarget(CombatEntityAPI target) {
        this.target = target;
    }
}

