/*
 * Decompiled with CFR 0.152.
 */
package data.scripts.AIs.Missiles;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.combat.CollisionClass;
import com.fs.starfarer.api.combat.CombatEngineAPI;
import com.fs.starfarer.api.combat.CombatEntityAPI;
import com.fs.starfarer.api.combat.GuidedMissileAI;
import com.fs.starfarer.api.combat.MissileAIPlugin;
import com.fs.starfarer.api.combat.MissileAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.combat.ShipCommand;
import com.fs.starfarer.api.util.IntervalUtil;
import java.util.Collections;
import java.util.List;
import org.lazywizard.lazylib.CollectionUtils;
import org.lazywizard.lazylib.MathUtils;
import org.lazywizard.lazylib.VectorUtils;
import org.lazywizard.lazylib.combat.AIUtils;
import org.lazywizard.lazylib.combat.CombatUtils;
import org.lwjgl.util.vector.Vector2f;

public final class Neutrino_JavelinTorpedoAI
implements MissileAIPlugin,
GuidedMissileAI {
    private CombatEngineAPI engine;
    private final MissileAPI missile;
    private CombatEntityAPI target;
    private Vector2f lead;
    private final Vector2f zero = new Vector2f(0.0f, 0.0f);
    private Vector2f evadingOffset = new Vector2f(0.0f, 0.0f);
    private Vector2f leadingOffset = new Vector2f(0.0f, 0.0f);
    private final float flightSpeed;
    private final IntervalUtil evadingInterval;
    private final float guidefactor;
    private float omniThrustTimer = 0.0f;
    private boolean acc;
    private float overshootTimer = 0.0f;
    private boolean overshootFlag = false;
    private float subLeadingMod = 0.0f;
    private final IntervalUtil guidanceInterval = new IntervalUtil(0.1f, 0.1f);
    private final int EMParcResistance = 3;
    private float targetPhasedTimer = 0.0f;
    private final float targetPhasedDelay = 0.5f;
    private final float bestLeadingRange = 700.0f;
    private final float overshoot = 30.0f;
    private final float overshootLag = 0.5f;
    private final float damping = 0.1f;
    private final boolean FAF = true;
    private boolean omniThrust = false;
    private final boolean alwaysAcc = false;
    private final float omniThrustAccLimit = 0.15f;
    private float omniThrustMaxSpeedLimit = 1.0f;
    private final float leadingMod = 0.8f;

    public Neutrino_JavelinTorpedoAI(MissileAPI missile, ShipAPI launchingShip) {
        this.missile = missile;
        this.flightSpeed = missile.getMaxSpeed();
        this.omniThrustMaxSpeedLimit = 1.0f - this.omniThrustMaxSpeedLimit;
        this.omniThrustMaxSpeedLimit *= this.flightSpeed;
        this.guidefactor = 1.0f + launchingShip.getMutableStats().getMissileGuidance().getModifiedValue();
        this.evadingInterval = new IntervalUtil(1.0f, 2.0f);
        this.setTarget(this.assignCurrentTarget(missile));
        this.evadingInterval.forceIntervalElapsed();
        this.guidanceInterval.forceIntervalElapsed();
        this.lead = new Vector2f();
        missile.setEmpResistance(3);
        this.overshootTimer = 0.5f;
    }

    public void advance(float amount) {
        float aimAngle;
        if (this.engine != Global.getCombatEngine()) {
            this.engine = Global.getCombatEngine();
        }
        if (Global.getCombatEngine().isPaused() || this.missile.isFading() || this.missile.isFizzling()) {
            return;
        }
        this.targetPhasedTimer = this.target != null && this.target.getCollisionClass() == CollisionClass.NONE ? (this.targetPhasedTimer += amount) : 0.0f;
        if (this.target == null || this.target instanceof ShipAPI && !((ShipAPI)this.target).isAlive() || this.target instanceof ShipAPI && ((ShipAPI)this.target).isDrone() || this.missile.getOwner() == this.target.getOwner() || !Global.getCombatEngine().isEntityInPlay(this.target) || this.targetPhasedTimer > 0.5f) {
            this.setTarget(this.reAssignTarget(this.missile));
            this.evadingInterval.forceIntervalElapsed();
            this.guidanceInterval.forceIntervalElapsed();
            this.overshootFlag = false;
            this.overshootTimer = 0.5f;
            this.targetPhasedTimer = 0.0f;
            return;
        }
        Vector2f mLoc = this.missile.getLocation();
        Vector2f tLoc = this.target.getLocation();
        float mFacing = this.missile.getFacing();
        this.guidanceInterval.advance(amount);
        if (this.guidanceInterval.intervalElapsed() && tLoc != null) {
            this.evadingInterval.advance(this.guidanceInterval.getElapsed());
            float dist = MathUtils.getDistance((CombatEntityAPI)this.missile, (CombatEntityAPI)this.target);
            if (this.evadingInterval.intervalElapsed()) {
                float targetR = this.target.getCollisionRadius();
                this.leadingOffset = MathUtils.getRandomPointOnCircumference((Vector2f)this.zero, (float)Math.max(0.25f * targetR, 1.0f));
                this.evadingOffset = Vector2f.sub((Vector2f)mLoc, (Vector2f)tLoc, null);
                this.evadingOffset = new Vector2f(-this.evadingOffset.y, this.evadingOffset.x);
                this.evadingOffset.scale(MathUtils.getRandomNumberInRange((float)-0.2f, (float)0.2f));
                if (this.overshootFlag) {
                    this.overshootTimer = -1.5f;
                }
                this.subLeadingMod = MathUtils.getRandomNumberInRange((float)0.8f, (float)1.2f);
            }
            this.lead = AIUtils.getBestInterceptPoint((Vector2f)mLoc, (float)(this.flightSpeed * this.subLeadingMod), (Vector2f)tLoc, (Vector2f)this.target.getVelocity());
            if (this.lead == null) {
                this.lead = Vector2f.add((Vector2f)this.zero, (Vector2f)tLoc, (Vector2f)this.lead);
            }
            float guideMod = Math.min(0.3f, this.guidefactor * 700.0f / (dist + 1.0f));
            Vector2f.sub((Vector2f)this.lead, (Vector2f)tLoc, (Vector2f)this.lead);
            this.lead.scale(guideMod);
            Vector2f.add((Vector2f)this.lead, (Vector2f)tLoc, (Vector2f)this.lead);
            if (dist >= 700.0f) {
                if (this.evadingOffset != null) {
                    Vector2f.add((Vector2f)this.lead, (Vector2f)this.evadingOffset, (Vector2f)this.lead);
                }
            } else if (this.leadingOffset != null) {
                Vector2f.add((Vector2f)this.lead, (Vector2f)this.leadingOffset, (Vector2f)this.lead);
            }
            if (dist > 50.0f) {
                this.missile.setArmingTime(0.2f);
            } else {
                this.missile.setArmingTime(0.0f);
            }
        }
        float f = aimAngle = this.lead == null ? 0.0f : MathUtils.getShortestRotation((float)mFacing, (float)VectorUtils.getAngle((Vector2f)mLoc, (Vector2f)this.lead));
        if (this.missile.getSource().getVariant().getHullMods().contains("neutrino_sigmaupgrade")) {
            this.omniThrust = true;
        }
        int Thrust = 0;
        int Turn = 0;
        int Strafe = 0;
        if (aimAngle < 0.0f) {
            Turn = 1;
        }
        if (aimAngle > 0.0f) {
            Turn = -1;
        }
        if (Math.abs(aimAngle) < Math.abs(this.missile.getAngularVelocity()) * 0.1f) {
            this.missile.setAngularVelocity(aimAngle / 0.1f);
        }
        float MFlightAng = VectorUtils.getAngle((Vector2f)new Vector2f(), (Vector2f)this.missile.getVelocity());
        float MFlightCC = MathUtils.getShortestRotation((float)mFacing, (float)MFlightAng);
        if (Math.abs(aimAngle) < 5.0f) {
            if (MFlightCC < -20.0f) {
                Strafe = 1;
            }
            if (MFlightCC > 20.0f) {
                Strafe = -1;
            }
        }
        if (Math.abs(aimAngle) < 30.0f) {
            this.overshootFlag = true;
            this.overshootTimer = 0.0f;
        }
        if (this.overshootFlag && Math.abs(aimAngle) > 90.0f) {
            this.overshootTimer = 0.0f;
            this.overshootFlag = false;
        } else {
            this.overshootTimer += amount;
        }
        if (this.overshootTimer < 0.5f) {
            Thrust = 1;
        }
        if (Math.abs(aimAngle) < 30.0f) {
            this.acc = true;
        }
        if (this.omniThrust) {
            this.omniThrustTimer += 0.15f;
            if (this.omniThrustTimer >= 1.0f) {
                this.omniThrustTimer -= 1.0f;
                Vector2f absMVDev = Vector2f.sub((Vector2f)((Vector2f)VectorUtils.getDirectionalVector((Vector2f)mLoc, (Vector2f)this.lead).scale(this.flightSpeed)), (Vector2f)this.missile.getVelocity(), null);
                Vector2f relMVDev = VectorUtils.rotate((Vector2f)absMVDev, (float)(-mFacing), (Vector2f)new Vector2f());
                if (relMVDev.x > 2.5f) {
                    Thrust = 1;
                }
                if (relMVDev.x < -(2.5f + this.omniThrustMaxSpeedLimit)) {
                    Thrust = -1;
                }
                if (relMVDev.y > 2.5f + this.omniThrustMaxSpeedLimit) {
                    Strafe = 1;
                }
                if (relMVDev.y < -(2.5f + this.omniThrustMaxSpeedLimit)) {
                    Strafe = -1;
                }
            }
        }
        if (this.acc && !this.omniThrust) {
            Thrust = 1;
        }
        if (Thrust == 1) {
            this.missile.giveCommand(ShipCommand.ACCELERATE);
        }
        if (Thrust == -1) {
            this.missile.giveCommand(ShipCommand.ACCELERATE_BACKWARDS);
        }
        if (Turn == 1) {
            this.missile.giveCommand(ShipCommand.TURN_RIGHT);
        }
        if (Turn == -1) {
            this.missile.giveCommand(ShipCommand.TURN_LEFT);
        }
        if (Strafe == 1) {
            this.missile.giveCommand(ShipCommand.STRAFE_LEFT);
        }
        if (Strafe == -1) {
            this.missile.giveCommand(ShipCommand.STRAFE_RIGHT);
        }
    }

    public CombatEntityAPI assignCurrentTarget(MissileAPI missile) {
        ShipAPI source = missile.getSource();
        ShipAPI currentTarget = source.getShipTarget();
        if (currentTarget != null && currentTarget.isAlive() && currentTarget.getOwner() != missile.getOwner()) {
            return currentTarget;
        }
        List directTargets = CombatUtils.getShipsWithinRange((Vector2f)source.getMouseTarget(), (float)50.0f);
        if (!directTargets.isEmpty()) {
            Collections.sort(directTargets, new CollectionUtils.SortEntitiesByDistance(source.getMouseTarget()));
            for (ShipAPI tmp : directTargets) {
                if (!tmp.isAlive() || tmp.getOwner() == source.getOwner()) continue;
                return tmp;
            }
        }
        return null;
    }

    public CombatEntityAPI reAssignTarget(MissileAPI missile) {
        ShipAPI newtarget = null;
        ShipAPI source = missile.getSource();
        int side = source.getOwner();
        float searchRange = missile.getMaxSpeed() * 2.0f * (missile.getMaxFlightTime() - missile.getElapsed());
        float closestDistance = Float.MAX_VALUE;
        for (ShipAPI tmp : AIUtils.getNearbyEnemies((CombatEntityAPI)missile, (float)searchRange)) {
            float distance;
            float mod = 0.0f;
            if (!CombatUtils.isVisibleToSide((CombatEntityAPI)tmp, (int)side)) continue;
            if (tmp.isFighter()) {
                mod = searchRange;
            }
            if (tmp.isDrone() || tmp.getCollisionClass() == CollisionClass.NONE) {
                mod = 2.0f * searchRange;
            }
            if (!((distance = MathUtils.getDistance((CombatEntityAPI)tmp, (Vector2f)missile.getLocation()) + mod) < closestDistance)) continue;
            newtarget = tmp;
            closestDistance = distance;
        }
        if (newtarget == null && (newtarget = AIUtils.getNearestEnemy((CombatEntityAPI)missile)) != null && !CombatUtils.isVisibleToSide((CombatEntityAPI)newtarget, (int)side)) {
            newtarget = null;
        }
        return newtarget;
    }

    public CombatEntityAPI getTarget() {
        return this.target;
    }

    public void setTarget(CombatEntityAPI target) {
        this.target = target;
    }
}

