/*
 * Decompiled with CFR 0.152.
 */
package data.scripts.AIs.Missiles;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.combat.CombatEngineAPI;
import com.fs.starfarer.api.combat.CombatEntityAPI;
import com.fs.starfarer.api.combat.GuidedMissileAI;
import com.fs.starfarer.api.combat.MissileAIPlugin;
import com.fs.starfarer.api.combat.MissileAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.combat.ShipCommand;
import com.fs.starfarer.api.util.IntervalUtil;
import java.util.Collections;
import java.util.List;
import org.lazywizard.lazylib.CollectionUtils;
import org.lazywizard.lazylib.MathUtils;
import org.lazywizard.lazylib.VectorUtils;
import org.lazywizard.lazylib.combat.AIUtils;
import org.lazywizard.lazylib.combat.CombatUtils;
import org.lwjgl.util.vector.Vector2f;

public final class Neutrino_SapperAI
implements MissileAIPlugin,
GuidedMissileAI {
    private CombatEngineAPI engine;
    private final MissileAPI missile;
    private CombatEntityAPI target;
    private Vector2f lead;
    private final Vector2f zero = new Vector2f(0.0f, 0.0f);
    private final float guidefactor = 0.7f;
    private final float flightSpeed;
    private final float overshoot = 45.0f;
    private final float searchCone = 25.0f;
    private final float damping = 0.1f;
    private final IntervalUtil guidanceInterval = new IntervalUtil(0.1f, 0.1f);
    private float targetPhasedTimer = 0.0f;
    private final float targetPhasedDelay = 0.5f;

    public Neutrino_SapperAI(MissileAPI missile, ShipAPI launchingShip) {
        this.missile = missile;
        this.flightSpeed = missile.getMaxSpeed();
        this.setTarget(this.assignCurrentTarget(missile));
        this.guidanceInterval.forceIntervalElapsed();
        missile.setEmpResistance(666);
        missile.setMass(0.0f);
    }

    public void advance(float amount) {
        float aimAngle;
        if (this.engine != Global.getCombatEngine()) {
            this.engine = Global.getCombatEngine();
        }
        if (Global.getCombatEngine().isPaused() || this.missile.isFading() || this.missile.isFizzling()) {
            return;
        }
        this.missile.giveCommand(ShipCommand.ACCELERATE);
        this.targetPhasedTimer = this.target instanceof ShipAPI && ((ShipAPI)this.target).isPhased() ? (this.targetPhasedTimer += amount) : 0.0f;
        if (this.target == null || this.missile.getOwner() == this.target.getOwner() || this.target instanceof ShipAPI && !((ShipAPI)this.target).isAlive() || !Global.getCombatEngine().isEntityInPlay(this.target) || this.targetPhasedTimer > 0.5f) {
            this.missile.setAngularVelocity(this.missile.getAngularVelocity() * 0.99f);
            this.target = null;
            return;
        }
        Vector2f mLoc = this.missile.getLocation();
        Vector2f tLoc = this.target.getLocation();
        this.guidanceInterval.advance(amount);
        if (this.guidanceInterval.intervalElapsed() && tLoc != null) {
            Vector2f leadingOffset;
            this.lead = AIUtils.getBestInterceptPoint((Vector2f)mLoc, (float)this.flightSpeed, (Vector2f)tLoc, (Vector2f)this.target.getVelocity());
            if (this.lead == null) {
                Vector2f.add((Vector2f)this.zero, (Vector2f)tLoc, (Vector2f)this.lead);
            }
            if ((leadingOffset = MathUtils.getRandomPointOnCircumference((Vector2f)this.zero, (float)Math.max(0.25f * this.target.getCollisionRadius(), 1.0f))) != null) {
                if (this.lead == null) {
                    return;
                }
                Vector2f.add((Vector2f)this.lead, (Vector2f)leadingOffset, (Vector2f)this.lead);
            }
            Vector2f.sub((Vector2f)this.lead, (Vector2f)tLoc, (Vector2f)this.lead);
            this.lead.scale(0.7f);
            Vector2f.add((Vector2f)this.lead, (Vector2f)tLoc, (Vector2f)this.lead);
        }
        float mFacing = this.missile.getFacing();
        float f = aimAngle = this.lead == null ? 0.0f : MathUtils.getShortestRotation((float)mFacing, (float)VectorUtils.getAngle((Vector2f)mLoc, (Vector2f)this.lead));
        if (aimAngle > 45.0f) {
            this.setTarget(null);
            return;
        }
        this.missile.giveCommand(aimAngle < 0.0f ? ShipCommand.TURN_RIGHT : ShipCommand.TURN_LEFT);
        float MFlightAng = VectorUtils.getAngle((Vector2f)new Vector2f(), (Vector2f)this.missile.getVelocity());
        float MFlightCC = MathUtils.getShortestRotation((float)mFacing, (float)MFlightAng);
        if (Math.abs(MFlightCC) > 10.0f) {
            this.missile.giveCommand(MFlightCC < 0.0f ? ShipCommand.STRAFE_LEFT : ShipCommand.STRAFE_RIGHT);
        }
        if (Math.abs(aimAngle) < Math.abs(this.missile.getAngularVelocity()) * 0.1f) {
            this.missile.setAngularVelocity(aimAngle / 0.1f);
        }
    }

    public CombatEntityAPI assignCurrentTarget(MissileAPI missile) {
        List targetsInArc;
        ShipAPI source = missile.getSource();
        ShipAPI currentTarget = source.getShipTarget();
        if (currentTarget != null && currentTarget.isAlive() && currentTarget.getOwner() != missile.getOwner()) {
            return currentTarget;
        }
        List directTargets = CombatUtils.getShipsWithinRange((Vector2f)source.getMouseTarget(), (float)50.0f);
        if (!directTargets.isEmpty()) {
            Collections.sort(directTargets, new CollectionUtils.SortEntitiesByDistance(source.getMouseTarget()));
            for (ShipAPI tmp : directTargets) {
                if (!tmp.isAlive() || tmp.getOwner() == source.getOwner()) continue;
                return tmp;
            }
        }
        if (!(targetsInArc = CombatUtils.getShipsWithinRange((Vector2f)missile.getLocation(), (float)(missile.getMaxFlightTime() * missile.getMaxFlightTime() * 4.0f))).isEmpty()) {
            Collections.sort(targetsInArc, new CollectionUtils.SortEntitiesByDistance(missile.getLocation()));
            for (ShipAPI tmp : targetsInArc) {
                if (!tmp.isAlive() || tmp.getOwner() == source.getOwner() || !(Math.abs(MathUtils.getShortestRotation((float)missile.getFacing(), (float)VectorUtils.getAngle((Vector2f)missile.getLocation(), (Vector2f)tmp.getLocation()))) < 25.0f)) continue;
                return tmp;
            }
        }
        return null;
    }

    public CombatEntityAPI getTarget() {
        return this.target;
    }

    public void setTarget(CombatEntityAPI target) {
        if (!(target instanceof MissileAPI) || !((MissileAPI)target).isFlare()) {
            this.target = target;
        }
    }
}

