/*
 * Decompiled with CFR 0.152.
 */
package data.scripts.AIs.Missiles;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.combat.CombatEngineAPI;
import com.fs.starfarer.api.combat.CombatEntityAPI;
import com.fs.starfarer.api.combat.DamageType;
import com.fs.starfarer.api.combat.DamagingProjectileAPI;
import com.fs.starfarer.api.combat.MissileAIPlugin;
import com.fs.starfarer.api.combat.MissileAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.util.IntervalUtil;
import com.fs.starfarer.combat.entities.Missile;
import data.scripts.plugins.Neutrino_LocalData;
import java.awt.Color;
import java.util.Set;
import org.lazywizard.lazylib.MathUtils;
import org.lazywizard.lazylib.combat.entities.AnchoredEntity;
import org.lwjgl.util.vector.ReadableVector2f;
import org.lwjgl.util.vector.Vector2f;

public final class Neutrino_UnstablePhotonAI
implements MissileAIPlugin {
    private CombatEngineAPI engine;
    private final MissileAPI missile;
    private static final String KEY = "Neutrino_LocalData";
    private boolean runOnce = true;
    private static final Vector2f zero = new Vector2f(0.0f, 0.0f);
    private final float flightSpeed;
    private final IntervalUtil flashInterval = new IntervalUtil(0.2f, 0.25f);
    private int flashSize = 4;
    private boolean flash = true;
    private boolean split = true;
    private String splitWeaponId = null;
    private String specId = null;
    private int payload = 0;
    private float splitDelay = 0.0f;
    private float splitArc = 0.0f;
    private int critCount = 0;
    private boolean isCrit = false;
    private Color color1;
    private Color color2;
    private float facing;
    private Vector2f vel;
    private int owner;
    private boolean flameOuted;

    public Neutrino_UnstablePhotonAI(MissileAPI missile, ShipAPI launchingShip) {
        this.missile = missile;
        this.flightSpeed = missile.getMaxSpeed();
        this.split = !this.isCrit;
        this.specId = missile.getProjectileSpecId();
        missile.setAngularVelocity(0.0f);
        switch (this.specId) {
            case "neutrino_unstable_photon": {
                this.splitWeaponId = "neutrino_unstable_photon1";
                this.payload = 5;
                this.splitDelay = MathUtils.getRandomNumberInRange((float)0.1f, (float)0.3f);
                this.splitArc = 8.0f;
                this.flash = true;
                this.flashSize = 6;
                this.color1 = new Color(227, 40, 26, 200);
                this.color2 = new Color(227, 40, 26, 200);
                break;
            }
            case "neutrino_split_photon1": {
                this.splitWeaponId = "neutrino_unstable_photon2";
                this.payload = 8;
                this.splitDelay = MathUtils.getRandomNumberInRange((float)0.1f, (float)0.3f);
                this.splitArc = 8.0f;
                this.flash = true;
                this.flashSize = 6;
                this.critCount = 2;
                this.color1 = new Color(227, 40, 26, 200);
                this.color2 = new Color(227, 40, 26, 200);
                break;
            }
            case "neutrino_split_photon2": {
                this.splitWeaponId = "neutrino_unstable_photon3";
                this.payload = 2;
                this.splitDelay = MathUtils.getRandomNumberInRange((float)0.1f, (float)0.3f);
                this.splitArc = 8.0f;
                this.flash = true;
                this.flashSize = 4;
                this.color1 = new Color(227, 40, 26, 200);
                this.color2 = new Color(227, 40, 26, 200);
                break;
            }
            case "neutrino_split_final": {
                this.split = false;
                this.flash = false;
                break;
            }
            case "neutrino_adv_torpedo_payload1": {
                this.splitWeaponId = "neutrino_adv_torpedo_2";
                this.payload = 6;
                this.splitDelay = MathUtils.getRandomNumberInRange((float)0.1f, (float)0.2f);
                this.splitArc = 8.0f;
                this.flash = true;
                this.flashSize = 5;
                this.critCount = 3;
                this.color1 = new Color(86, 86, 255, 20);
                this.color2 = new Color(0, 0, 255, 30);
                break;
            }
            case "neutrino_adv_torpedo_payload2": {
                this.splitWeaponId = "neutrino_adv_torpedo_3";
                this.payload = 5;
                this.splitDelay = MathUtils.getRandomNumberInRange((float)0.1f, (float)0.2f);
                this.splitArc = 8.0f;
                this.flash = true;
                this.flashSize = 4;
                this.color1 = new Color(86, 86, 255, 20);
                this.color2 = new Color(0, 0, 255, 30);
                break;
            }
            case "neutrino_adv_torpedo_payload3": {
                this.split = false;
                this.flash = false;
                break;
            }
        }
        this.flashInterval.forceIntervalElapsed();
        missile.setEmpResistance(666);
        missile.setMass(0.0f);
        this.facing = missile.getFacing();
        this.vel = new Vector2f((ReadableVector2f)missile.getVelocity());
        this.owner = missile.getOwner();
        this.flameOuted = missile.isFizzling();
    }

    public void advance(float amount) {
        if (this.engine != Global.getCombatEngine()) {
            this.engine = Global.getCombatEngine();
        }
        if (Global.getCombatEngine().isPaused()) {
            return;
        }
        if (this.runOnce) {
            Neutrino_LocalData.LocalData localData = (Neutrino_LocalData.LocalData)this.engine.getCustomData().get(KEY);
            Set<DamagingProjectileAPI> critSet = localData.critSet;
            this.isCrit = critSet.contains(this.missile);
        }
        if (this.isCrit) {
            this.split = false;
        }
        if (this.missile.getOwner() != this.owner) {
            this.owner = this.missile.getOwner();
            this.vel = new Vector2f((ReadableVector2f)this.missile.getVelocity());
        } else if (this.missile.isFizzling() != this.flameOuted) {
            this.flameOuted = this.missile.isFizzling();
            this.vel = new Vector2f((ReadableVector2f)this.missile.getVelocity());
        } else {
            this.missile.setAngularVelocity(0.0f);
            this.missile.getVelocity().set((ReadableVector2f)this.vel);
        }
        Vector2f mLoc = this.missile.getLocation();
        if (this.flash) {
            this.flashInterval.advance(amount);
            if (this.flashInterval.intervalElapsed()) {
                Vector2f randomPoint = MathUtils.getRandomPointOnCircumference((Vector2f)mLoc, (float)this.flashSize);
                AnchoredEntity anchor = new AnchoredEntity((CombatEntityAPI)this.missile, randomPoint);
                this.engine.spawnEmpArc(this.missile.getSource(), mLoc, (CombatEntityAPI)anchor, (CombatEntityAPI)anchor, DamageType.ENERGY, 0.0f, 0.0f, 50.0f, null, 2.0f, this.color1, this.color2);
            }
        }
        if (this.split && this.missile.getElapsed() > this.splitDelay) {
            this.releasingPayload(this.missile);
        }
        if (this.missile.getArmingTime() > 0.0f) {
            this.engine.applyDamage((CombatEntityAPI)this.missile, mLoc, 9999.0f, DamageType.FRAGMENTATION, 0.0f, true, true, (Object)this.missile);
        }
    }

    public void releasingPayload(MissileAPI missile) {
        Vector2f mLoc = missile.getLocation();
        ShipAPI mSource = missile.getSource();
        Vector2f mVel = missile.getVelocity();
        float mFacing = missile.getFacing();
        int j = 0;
        for (int i = 0; i < this.payload; ++i) {
            Vector2f random1 = MathUtils.getRandomPointOnCircumference((Vector2f)zero, (float)15.0f);
            float firingAng = MathUtils.clampAngle((float)(mFacing + MathUtils.getRandomNumberInRange((float)(-this.splitArc * 0.5f), (float)(this.splitArc * 0.5f))));
            Vector2f random2 = MathUtils.getPointOnCircumference((Vector2f)zero, (float)MathUtils.getRandomNumberInRange((float)(-this.flightSpeed * 0.2f), (float)(this.flightSpeed * 0.2f)), (float)firingAng);
            CombatEntityAPI entity = this.engine.spawnProjectile(mSource, missile.getWeapon(), this.splitWeaponId, Vector2f.add((Vector2f)mLoc, (Vector2f)random1, null), firingAng, random2);
            Missile m = (Missile)entity;
            m.advance(0.0f);
            if (j >= this.critCount) continue;
            ++j;
            Neutrino_LocalData.LocalData localData = (Neutrino_LocalData.LocalData)this.engine.getCustomData().get(KEY);
            Set<DamagingProjectileAPI> critSet = localData.critSet;
            critSet.add((DamagingProjectileAPI)((MissileAPI)entity));
        }
        this.engine.applyDamage((CombatEntityAPI)missile, mLoc, missile.getMaxHitpoints(), DamageType.OTHER, 0.0f, false, false, (Object)mSource);
    }
}

